
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional, List
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .reaction_count import TypeReactionCount
    from ...gadgets.byteutils import Reader


class StoryViews(TLObject, family='TypeStoryViews'):
    """
    Aggregated view and reaction information of a [story](https://core.telegram.org/api/stories).
    """

    _id = 0X8D595CD6
    _group_id = 0X60DA34B3

    def __init__(
        self,
        views_count: int,
        has_viewers: bool = False,
        forwards_count: Optional[int] = None,
        reactions: Optional[List['TypeReactionCount']] = None,
        reactions_count: Optional[int] = None,
        recent_viewers: Optional[List[int]] = None
    ):

        """
        Aggregated view and reaction information of a [story](https://core.telegram.org/api/stories).

        Args:
            views_count (int): View counter of the story
            has_viewers (bool, optional): If set, indicates that the viewers list is currently viewable, and was not yet deleted because the story has expired while the user didn't have a [Premium](https://core.telegram.org/api/premium) account.
            forwards_count (Optional[int], optional): Forward counter of the story
            reactions (Optional[List['TypeReactionCount']], optional): All reactions sent to this story
            reactions_count (Optional[int], optional): Number of reactions added to the story
            recent_viewers (Optional[List[int]], optional): User IDs of some recent viewers of the story
        """

        self.views_count = views_count
        self.has_viewers = has_viewers
        self.forwards_count = forwards_count
        self.reactions = reactions
        self.reactions_count = reactions_count
        self.recent_viewers = recent_viewers

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xd6\\Y\x8d' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.has_viewers, 1)
                writer.int(self.views_count)

                if flags(self.forwards_count, 2):
                    writer.int(self.forwards_count)

                if flags(self.reactions, 3):
                    writer.vector(
                        self.reactions,
                        lambda value: writer.object(
                            value,
                            group_id=0X21B32469
                        )
                    )

                if flags(self.reactions_count, 4):
                    writer.int(self.reactions_count)

                if flags(self.recent_viewers, 0):
                    writer.vector(
                        self.recent_viewers,
                        writer.long
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        views_count_ = reader.int()
        forwards_count_ = (
            reader.int()
            if flags(2) else None
        )

        reactions_ = (
            reader.vector(
                lambda: reader.object(
                    group_id=0X21B32469
                )
            )
            if flags(3) else None
        )

        reactions_count_ = (
            reader.int()
            if flags(4) else None
        )

        recent_viewers_ = (
            reader.vector(
                reader.long
            )
            if flags(0) else None
        )

        return cls(
            views_count=views_count_,
            has_viewers=flags(1),
            forwards_count=forwards_count_,
            reactions=reactions_,
            reactions_count=reactions_count_,
            recent_viewers=recent_viewers_
        )

TypeStoryViews = StoryViews