"""
    VRS API documentation

    Documentation on all available end points in the VRSAPI  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: api@factset.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401
from multiprocessing.pool import ApplyResult
import typing

from fds.sdk.Vermilion.api_client import ApiClient, Endpoint as _Endpoint
from fds.sdk.Vermilion.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from fds.sdk.Vermilion.exceptions import ApiException
from fds.sdk.Vermilion.model.error_list import ErrorList
from fds.sdk.Vermilion.model.report_generation_request_body import ReportGenerationRequestBody
from fds.sdk.Vermilion.model.report_instance_data import ReportInstanceData
from fds.sdk.Vermilion.model.report_instance_data_response import ReportInstanceDataResponse
from fds.sdk.Vermilion.model.report_instance_list import ReportInstanceList
from fds.sdk.Vermilion.model.report_instance_log_list import ReportInstanceLogList





class ReportInstanceApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        self.cancel_report_generation_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/v1/{tenant}/report-instances/{reportInstanceId}',
                'operation_id': 'cancel_report_generation',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'tenant',
                    'report_instance_id',
                ],
                'required': [
                    'tenant',
                    'report_instance_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'tenant':
                        (str,),
                    'report_instance_id':
                        (str,),
                },
                'attribute_map': {
                    'tenant': 'tenant',
                    'report_instance_id': 'reportInstanceId',
                },
                'location_map': {
                    'tenant': 'path',
                    'report_instance_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

        self.download_report_file_endpoint = _Endpoint(
            settings={
                'response_type': (
                  { 200: (file_type,), 400: (ErrorList,), 401: (ErrorList,), 403: (ErrorList,), 406: (ErrorList,),  },
                  None
                ),
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/v1/{tenant}/report-instances/{reportInstanceId}/results/{reportFileName}',
                'operation_id': 'download_report_file',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'tenant',
                    'report_instance_id',
                    'report_file_name',
                ],
                'required': [
                    'tenant',
                    'report_instance_id',
                    'report_file_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'tenant':
                        (str,),
                    'report_instance_id':
                        (str,),
                    'report_file_name':
                        (str,),
                },
                'attribute_map': {
                    'tenant': 'tenant',
                    'report_instance_id': 'reportInstanceId',
                    'report_file_name': 'reportFileName',
                },
                'location_map': {
                    'tenant': 'path',
                    'report_instance_id': 'path',
                    'report_file_name': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/pdf',
                    'application/vnd.openxmlformats-officedocument.presentationml.presentation',
                    'application/vnd.ms-powerpoint',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
                    'application/vnd.ms-excel',
                    'application/vnd.openxmlformats-officedocument.wordprocessingml.document',
                    'application/msword',
                    'application/postscript',
                    'text/csv',
                    'text/html',
                    'application/xml',
                    'application/zip',
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

        self.get_all_report_instances_endpoint = _Endpoint(
            settings={
                'response_type': (
                  { 200: (ReportInstanceList,), 401: (ErrorList,), 403: (ErrorList,), 406: (ErrorList,),  },
                  None
                ),
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/v1/{tenant}/report-instances',
                'operation_id': 'get_all_report_instances',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'tenant',
                    'report_definition_code',
                    'entity_codes',
                    'entity_keys',
                    'section_filter',
                    'output_format',
                    'sort',
                    'pagination_limit',
                    'pagination_offset',
                ],
                'required': [
                    'tenant',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'sort',
                ]
            },
            root_map={
                'validations': {
                    ('sort',): {

                        'max_items': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'tenant':
                        (str,),
                    'report_definition_code':
                        (str,),
                    'entity_codes':
                        (str,),
                    'entity_keys':
                        (str,),
                    'section_filter':
                        (str,),
                    'output_format':
                        (str,),
                    'sort':
                        ([str],),
                    'pagination_limit':
                        (int,),
                    'pagination_offset':
                        (int,),
                },
                'attribute_map': {
                    'tenant': 'tenant',
                    'report_definition_code': 'reportDefinitionCode',
                    'entity_codes': 'entityCodes',
                    'entity_keys': 'entityKeys',
                    'section_filter': 'sectionFilter',
                    'output_format': 'outputFormat',
                    'sort': '_sort',
                    'pagination_limit': '_paginationLimit',
                    'pagination_offset': '_paginationOffset',
                },
                'location_map': {
                    'tenant': 'path',
                    'report_definition_code': 'query',
                    'entity_codes': 'query',
                    'entity_keys': 'query',
                    'section_filter': 'query',
                    'output_format': 'query',
                    'sort': 'query',
                    'pagination_limit': 'query',
                    'pagination_offset': 'query',
                },
                'collection_format_map': {
                    'sort': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

        self.get_report_generation_logs_endpoint = _Endpoint(
            settings={
                'response_type': (
                  { 200: (ReportInstanceLogList,), 401: (ErrorList,), 403: (ErrorList,), 404: (ErrorList,), 406: (ErrorList,),  },
                  None
                ),
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/v1/{tenant}/report-instances/{reportInstanceId}/logs',
                'operation_id': 'get_report_generation_logs',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'tenant',
                    'report_instance_id',
                    'errors_only',
                    'sort',
                    'pagination_limit',
                    'pagination_offset',
                ],
                'required': [
                    'tenant',
                    'report_instance_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'sort',
                ]
            },
            root_map={
                'validations': {
                    ('sort',): {

                        'max_items': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'tenant':
                        (str,),
                    'report_instance_id':
                        (str,),
                    'errors_only':
                        (str,),
                    'sort':
                        ([str],),
                    'pagination_limit':
                        (int,),
                    'pagination_offset':
                        (int,),
                },
                'attribute_map': {
                    'tenant': 'tenant',
                    'report_instance_id': 'reportInstanceId',
                    'errors_only': 'errorsOnly',
                    'sort': '_sort',
                    'pagination_limit': '_paginationLimit',
                    'pagination_offset': '_paginationOffset',
                },
                'location_map': {
                    'tenant': 'path',
                    'report_instance_id': 'path',
                    'errors_only': 'query',
                    'sort': 'query',
                    'pagination_limit': 'query',
                    'pagination_offset': 'query',
                },
                'collection_format_map': {
                    'sort': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

        self.get_report_instance_by_id_endpoint = _Endpoint(
            settings={
                'response_type': (
                  { 200: (ReportInstanceData,), 400: (ErrorList,), 401: (ErrorList,), 403: (ErrorList,), 404: (ErrorList,), 406: (ErrorList,),  },
                  None
                ),
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/v1/{tenant}/report-instances/{reportInstanceId}',
                'operation_id': 'get_report_instance_by_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'report_instance_id',
                    'tenant',
                ],
                'required': [
                    'report_instance_id',
                    'tenant',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'report_instance_id':
                        (str,),
                    'tenant':
                        (str,),
                },
                'attribute_map': {
                    'report_instance_id': 'reportInstanceId',
                    'tenant': 'tenant',
                },
                'location_map': {
                    'report_instance_id': 'path',
                    'tenant': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

        self.start_report_generation_endpoint = _Endpoint(
            settings={
                'response_type': (
                  { 202: (ReportInstanceDataResponse,), 400: (ErrorList,), 401: (ErrorList,), 403: (ErrorList,), 404: (ErrorList,), 406: (ErrorList,),  },
                  None
                ),
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/v1/report-instances/generate',
                'operation_id': 'start_report_generation',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'report_generation_request_body',
                ],
                'required': [
                    'report_generation_request_body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'report_generation_request_body':
                        (ReportGenerationRequestBody,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'report_generation_request_body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )


    @staticmethod
    def apply_kwargs_defaults(kwargs, return_http_data_only, async_req):
        kwargs["async_req"] = async_req
        kwargs["_return_http_data_only"] = return_http_data_only
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")


    def cancel_report_generation(
        self,
        tenant,
        report_instance_id,
        **kwargs
    ) -> None:
        """Cancels a report generation  # noqa: E501

        Sends a request to cancel a report generation based on the report instance id passed  # noqa: E501
        This method makes a synchronous HTTP request. Returns the http data only

        Args:
            tenant (str): The code of the tenancy
            report_instance_id (str): The id of the report instance

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            None
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        kwargs['tenant'] = \
            tenant
        kwargs['report_instance_id'] = \
            report_instance_id
        return self.cancel_report_generation_endpoint.call_with_http_info(**kwargs)

    def cancel_report_generation_with_http_info(
        self,
        tenant,
        report_instance_id,
        **kwargs
    ) -> typing.Tuple[None, int, typing.MutableMapping]:
        """Cancels a report generation  # noqa: E501

        Sends a request to cancel a report generation based on the report instance id passed  # noqa: E501
        This method makes a synchronous HTTP request. Returns http data, http status and headers

        Args:
            tenant (str): The code of the tenancy
            report_instance_id (str): The id of the report instance

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            None
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        kwargs['tenant'] = \
            tenant
        kwargs['report_instance_id'] = \
            report_instance_id
        return self.cancel_report_generation_endpoint.call_with_http_info(**kwargs)

    def cancel_report_generation_async(
        self,
        tenant,
        report_instance_id,
        **kwargs
    ) -> "ApplyResult[None]":
        """Cancels a report generation  # noqa: E501

        Sends a request to cancel a report generation based on the report instance id passed  # noqa: E501
        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult

        Args:
            tenant (str): The code of the tenancy
            report_instance_id (str): The id of the report instance

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[None]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        kwargs['tenant'] = \
            tenant
        kwargs['report_instance_id'] = \
            report_instance_id
        return self.cancel_report_generation_endpoint.call_with_http_info(**kwargs)

    def cancel_report_generation_with_http_info_async(
        self,
        tenant,
        report_instance_id,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[None, int, typing.MutableMapping]]":
        """Cancels a report generation  # noqa: E501

        Sends a request to cancel a report generation based on the report instance id passed  # noqa: E501
        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult

        Args:
            tenant (str): The code of the tenancy
            report_instance_id (str): The id of the report instance

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(None, int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        kwargs['tenant'] = \
            tenant
        kwargs['report_instance_id'] = \
            report_instance_id
        return self.cancel_report_generation_endpoint.call_with_http_info(**kwargs)


    def download_report_file(
        self,
        tenant,
        report_instance_id,
        report_file_name,
        **kwargs
    ) -> file_type:
        """Gets the generated file  # noqa: E501

        Get the generated file for a report instance. Users can fetch the generated report once the generation is finished. The report instance id and the report file name are passed in as path paramters. The following mapping defines the respective Content-Type for the outputFormat defined during report generation. | outputFormat | Content-Type | | ---------------- | ------------| |WORD     | application/msword | |WORD2010 |   application/vnd.openxmlformats-officedocument.wordprocessingml.document| |EXCEL    |   application/vnd.ms-excel| |EXCEL2010|   application/vnd.openxmlformats-officedocument.spreadsheetml.sheet| |PPT      |   application/vnd.ms-powerpoint| |PPT2010  |   application/vnd.openxmlformats-officedocument.presentationml.presentation| |PDF      |   application/pdf| |CSV      |   text/csv| |XML      |   application/xml| |VXML     |   application/xml| |HTML     |   text/html| |PS       |   application/postscript|  # noqa: E501
        This method makes a synchronous HTTP request. Returns the http data only

        Args:
            tenant (str): The code of the tenancy
            report_instance_id (str): Used to validate that report file name belongs to the report instance passed
            report_file_name (str): The report file name that has to be retrieved. report file name. E.g: xyz.pdf

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            file_type
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        kwargs['tenant'] = \
            tenant
        kwargs['report_instance_id'] = \
            report_instance_id
        kwargs['report_file_name'] = \
            report_file_name
        return self.download_report_file_endpoint.call_with_http_info(**kwargs)

    def download_report_file_with_http_info(
        self,
        tenant,
        report_instance_id,
        report_file_name,
        **kwargs
    ) -> typing.Tuple[file_type, int, typing.MutableMapping]:
        """Gets the generated file  # noqa: E501

        Get the generated file for a report instance. Users can fetch the generated report once the generation is finished. The report instance id and the report file name are passed in as path paramters. The following mapping defines the respective Content-Type for the outputFormat defined during report generation. | outputFormat | Content-Type | | ---------------- | ------------| |WORD     | application/msword | |WORD2010 |   application/vnd.openxmlformats-officedocument.wordprocessingml.document| |EXCEL    |   application/vnd.ms-excel| |EXCEL2010|   application/vnd.openxmlformats-officedocument.spreadsheetml.sheet| |PPT      |   application/vnd.ms-powerpoint| |PPT2010  |   application/vnd.openxmlformats-officedocument.presentationml.presentation| |PDF      |   application/pdf| |CSV      |   text/csv| |XML      |   application/xml| |VXML     |   application/xml| |HTML     |   text/html| |PS       |   application/postscript|  # noqa: E501
        This method makes a synchronous HTTP request. Returns http data, http status and headers

        Args:
            tenant (str): The code of the tenancy
            report_instance_id (str): Used to validate that report file name belongs to the report instance passed
            report_file_name (str): The report file name that has to be retrieved. report file name. E.g: xyz.pdf

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            file_type
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        kwargs['tenant'] = \
            tenant
        kwargs['report_instance_id'] = \
            report_instance_id
        kwargs['report_file_name'] = \
            report_file_name
        return self.download_report_file_endpoint.call_with_http_info(**kwargs)

    def download_report_file_async(
        self,
        tenant,
        report_instance_id,
        report_file_name,
        **kwargs
    ) -> "ApplyResult[file_type]":
        """Gets the generated file  # noqa: E501

        Get the generated file for a report instance. Users can fetch the generated report once the generation is finished. The report instance id and the report file name are passed in as path paramters. The following mapping defines the respective Content-Type for the outputFormat defined during report generation. | outputFormat | Content-Type | | ---------------- | ------------| |WORD     | application/msword | |WORD2010 |   application/vnd.openxmlformats-officedocument.wordprocessingml.document| |EXCEL    |   application/vnd.ms-excel| |EXCEL2010|   application/vnd.openxmlformats-officedocument.spreadsheetml.sheet| |PPT      |   application/vnd.ms-powerpoint| |PPT2010  |   application/vnd.openxmlformats-officedocument.presentationml.presentation| |PDF      |   application/pdf| |CSV      |   text/csv| |XML      |   application/xml| |VXML     |   application/xml| |HTML     |   text/html| |PS       |   application/postscript|  # noqa: E501
        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult

        Args:
            tenant (str): The code of the tenancy
            report_instance_id (str): Used to validate that report file name belongs to the report instance passed
            report_file_name (str): The report file name that has to be retrieved. report file name. E.g: xyz.pdf

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[file_type]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        kwargs['tenant'] = \
            tenant
        kwargs['report_instance_id'] = \
            report_instance_id
        kwargs['report_file_name'] = \
            report_file_name
        return self.download_report_file_endpoint.call_with_http_info(**kwargs)

    def download_report_file_with_http_info_async(
        self,
        tenant,
        report_instance_id,
        report_file_name,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[file_type, int, typing.MutableMapping]]":
        """Gets the generated file  # noqa: E501

        Get the generated file for a report instance. Users can fetch the generated report once the generation is finished. The report instance id and the report file name are passed in as path paramters. The following mapping defines the respective Content-Type for the outputFormat defined during report generation. | outputFormat | Content-Type | | ---------------- | ------------| |WORD     | application/msword | |WORD2010 |   application/vnd.openxmlformats-officedocument.wordprocessingml.document| |EXCEL    |   application/vnd.ms-excel| |EXCEL2010|   application/vnd.openxmlformats-officedocument.spreadsheetml.sheet| |PPT      |   application/vnd.ms-powerpoint| |PPT2010  |   application/vnd.openxmlformats-officedocument.presentationml.presentation| |PDF      |   application/pdf| |CSV      |   text/csv| |XML      |   application/xml| |VXML     |   application/xml| |HTML     |   text/html| |PS       |   application/postscript|  # noqa: E501
        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult

        Args:
            tenant (str): The code of the tenancy
            report_instance_id (str): Used to validate that report file name belongs to the report instance passed
            report_file_name (str): The report file name that has to be retrieved. report file name. E.g: xyz.pdf

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(file_type, int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        kwargs['tenant'] = \
            tenant
        kwargs['report_instance_id'] = \
            report_instance_id
        kwargs['report_file_name'] = \
            report_file_name
        return self.download_report_file_endpoint.call_with_http_info(**kwargs)


    def get_all_report_instances(
        self,
        tenant,
        **kwargs
    ) -> ReportInstanceList:
        """Gets a list of report instances  # noqa: E501

        Gets a list of report instances. This can be filtered down further by including query parameters in the URL. For example, a report definition id can be added so the only report instances returned are the ones with a matching id  # noqa: E501
        This method makes a synchronous HTTP request. Returns the http data only

        Args:
            tenant (str): The code of the tenancy

        Keyword Args:
            report_definition_code (str): Acts as a filter for the retrieval process. Filters the report instances that match the report definition code. [optional]
            entity_codes (str): A series of query parameters used to filter the report instances by entity code. E.g: entityCode=DATE&entityCode=SYSTEM_LANG. [optional]
            entity_keys (str): A series of query parameters used to filter the report instances by entity keys. E.g: entityKey=en-gb. [optional]
            section_filter (str): Acts as a filter for the retrieval process. Filters the report instances that match the section filter. [optional]
            output_format (str): Acts as a filter for the retrieval process. Filters the report instances that match the output format. [optional]
            sort ([str]): The column to sort on. Append - to sort in descending order. If parameter is not given, sorting will be based on the report instance id in descending order. [optional]
            pagination_limit (int): Non-negative maximum number of entries to return. [optional]
            pagination_offset (int): Non-negative number of entries to skip. [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ReportInstanceList
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        kwargs['tenant'] = \
            tenant
        return self.get_all_report_instances_endpoint.call_with_http_info(**kwargs)

    def get_all_report_instances_with_http_info(
        self,
        tenant,
        **kwargs
    ) -> typing.Tuple[ReportInstanceList, int, typing.MutableMapping]:
        """Gets a list of report instances  # noqa: E501

        Gets a list of report instances. This can be filtered down further by including query parameters in the URL. For example, a report definition id can be added so the only report instances returned are the ones with a matching id  # noqa: E501
        This method makes a synchronous HTTP request. Returns http data, http status and headers

        Args:
            tenant (str): The code of the tenancy

        Keyword Args:
            report_definition_code (str): Acts as a filter for the retrieval process. Filters the report instances that match the report definition code. [optional]
            entity_codes (str): A series of query parameters used to filter the report instances by entity code. E.g: entityCode=DATE&entityCode=SYSTEM_LANG. [optional]
            entity_keys (str): A series of query parameters used to filter the report instances by entity keys. E.g: entityKey=en-gb. [optional]
            section_filter (str): Acts as a filter for the retrieval process. Filters the report instances that match the section filter. [optional]
            output_format (str): Acts as a filter for the retrieval process. Filters the report instances that match the output format. [optional]
            sort ([str]): The column to sort on. Append - to sort in descending order. If parameter is not given, sorting will be based on the report instance id in descending order. [optional]
            pagination_limit (int): Non-negative maximum number of entries to return. [optional]
            pagination_offset (int): Non-negative number of entries to skip. [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ReportInstanceList
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        kwargs['tenant'] = \
            tenant
        return self.get_all_report_instances_endpoint.call_with_http_info(**kwargs)

    def get_all_report_instances_async(
        self,
        tenant,
        **kwargs
    ) -> "ApplyResult[ReportInstanceList]":
        """Gets a list of report instances  # noqa: E501

        Gets a list of report instances. This can be filtered down further by including query parameters in the URL. For example, a report definition id can be added so the only report instances returned are the ones with a matching id  # noqa: E501
        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult

        Args:
            tenant (str): The code of the tenancy

        Keyword Args:
            report_definition_code (str): Acts as a filter for the retrieval process. Filters the report instances that match the report definition code. [optional]
            entity_codes (str): A series of query parameters used to filter the report instances by entity code. E.g: entityCode=DATE&entityCode=SYSTEM_LANG. [optional]
            entity_keys (str): A series of query parameters used to filter the report instances by entity keys. E.g: entityKey=en-gb. [optional]
            section_filter (str): Acts as a filter for the retrieval process. Filters the report instances that match the section filter. [optional]
            output_format (str): Acts as a filter for the retrieval process. Filters the report instances that match the output format. [optional]
            sort ([str]): The column to sort on. Append - to sort in descending order. If parameter is not given, sorting will be based on the report instance id in descending order. [optional]
            pagination_limit (int): Non-negative maximum number of entries to return. [optional]
            pagination_offset (int): Non-negative number of entries to skip. [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[ReportInstanceList]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        kwargs['tenant'] = \
            tenant
        return self.get_all_report_instances_endpoint.call_with_http_info(**kwargs)

    def get_all_report_instances_with_http_info_async(
        self,
        tenant,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[ReportInstanceList, int, typing.MutableMapping]]":
        """Gets a list of report instances  # noqa: E501

        Gets a list of report instances. This can be filtered down further by including query parameters in the URL. For example, a report definition id can be added so the only report instances returned are the ones with a matching id  # noqa: E501
        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult

        Args:
            tenant (str): The code of the tenancy

        Keyword Args:
            report_definition_code (str): Acts as a filter for the retrieval process. Filters the report instances that match the report definition code. [optional]
            entity_codes (str): A series of query parameters used to filter the report instances by entity code. E.g: entityCode=DATE&entityCode=SYSTEM_LANG. [optional]
            entity_keys (str): A series of query parameters used to filter the report instances by entity keys. E.g: entityKey=en-gb. [optional]
            section_filter (str): Acts as a filter for the retrieval process. Filters the report instances that match the section filter. [optional]
            output_format (str): Acts as a filter for the retrieval process. Filters the report instances that match the output format. [optional]
            sort ([str]): The column to sort on. Append - to sort in descending order. If parameter is not given, sorting will be based on the report instance id in descending order. [optional]
            pagination_limit (int): Non-negative maximum number of entries to return. [optional]
            pagination_offset (int): Non-negative number of entries to skip. [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(ReportInstanceList, int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        kwargs['tenant'] = \
            tenant
        return self.get_all_report_instances_endpoint.call_with_http_info(**kwargs)


    def get_report_generation_logs(
        self,
        tenant,
        report_instance_id,
        **kwargs
    ) -> ReportInstanceLogList:
        """Gets a list of logs for the report instance generation  # noqa: E501

        Gets a list of logs for the generated report instance. Allows the user to sort on log message, type and date. Also allows for retrieving of just the errors & warnings'  # noqa: E501
        This method makes a synchronous HTTP request. Returns the http data only

        Args:
            tenant (str): The code of the tenancy
            report_instance_id (str): Used to validate that report file name belongs to the report instance passed

        Keyword Args:
            errors_only (str): If the parameter is set to true the endpoint should return just errors and warnings E.g: errorsOnly=true. [optional]
            sort ([str]): The column to sort on. Can add - to sort. [optional]
            pagination_limit (int): Non-negative maximum number of entries to return. [optional]
            pagination_offset (int): Non-negative number of entries to skip. [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ReportInstanceLogList
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        kwargs['tenant'] = \
            tenant
        kwargs['report_instance_id'] = \
            report_instance_id
        return self.get_report_generation_logs_endpoint.call_with_http_info(**kwargs)

    def get_report_generation_logs_with_http_info(
        self,
        tenant,
        report_instance_id,
        **kwargs
    ) -> typing.Tuple[ReportInstanceLogList, int, typing.MutableMapping]:
        """Gets a list of logs for the report instance generation  # noqa: E501

        Gets a list of logs for the generated report instance. Allows the user to sort on log message, type and date. Also allows for retrieving of just the errors & warnings'  # noqa: E501
        This method makes a synchronous HTTP request. Returns http data, http status and headers

        Args:
            tenant (str): The code of the tenancy
            report_instance_id (str): Used to validate that report file name belongs to the report instance passed

        Keyword Args:
            errors_only (str): If the parameter is set to true the endpoint should return just errors and warnings E.g: errorsOnly=true. [optional]
            sort ([str]): The column to sort on. Can add - to sort. [optional]
            pagination_limit (int): Non-negative maximum number of entries to return. [optional]
            pagination_offset (int): Non-negative number of entries to skip. [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ReportInstanceLogList
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        kwargs['tenant'] = \
            tenant
        kwargs['report_instance_id'] = \
            report_instance_id
        return self.get_report_generation_logs_endpoint.call_with_http_info(**kwargs)

    def get_report_generation_logs_async(
        self,
        tenant,
        report_instance_id,
        **kwargs
    ) -> "ApplyResult[ReportInstanceLogList]":
        """Gets a list of logs for the report instance generation  # noqa: E501

        Gets a list of logs for the generated report instance. Allows the user to sort on log message, type and date. Also allows for retrieving of just the errors & warnings'  # noqa: E501
        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult

        Args:
            tenant (str): The code of the tenancy
            report_instance_id (str): Used to validate that report file name belongs to the report instance passed

        Keyword Args:
            errors_only (str): If the parameter is set to true the endpoint should return just errors and warnings E.g: errorsOnly=true. [optional]
            sort ([str]): The column to sort on. Can add - to sort. [optional]
            pagination_limit (int): Non-negative maximum number of entries to return. [optional]
            pagination_offset (int): Non-negative number of entries to skip. [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[ReportInstanceLogList]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        kwargs['tenant'] = \
            tenant
        kwargs['report_instance_id'] = \
            report_instance_id
        return self.get_report_generation_logs_endpoint.call_with_http_info(**kwargs)

    def get_report_generation_logs_with_http_info_async(
        self,
        tenant,
        report_instance_id,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[ReportInstanceLogList, int, typing.MutableMapping]]":
        """Gets a list of logs for the report instance generation  # noqa: E501

        Gets a list of logs for the generated report instance. Allows the user to sort on log message, type and date. Also allows for retrieving of just the errors & warnings'  # noqa: E501
        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult

        Args:
            tenant (str): The code of the tenancy
            report_instance_id (str): Used to validate that report file name belongs to the report instance passed

        Keyword Args:
            errors_only (str): If the parameter is set to true the endpoint should return just errors and warnings E.g: errorsOnly=true. [optional]
            sort ([str]): The column to sort on. Can add - to sort. [optional]
            pagination_limit (int): Non-negative maximum number of entries to return. [optional]
            pagination_offset (int): Non-negative number of entries to skip. [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(ReportInstanceLogList, int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        kwargs['tenant'] = \
            tenant
        kwargs['report_instance_id'] = \
            report_instance_id
        return self.get_report_generation_logs_endpoint.call_with_http_info(**kwargs)


    def get_report_instance_by_id(
        self,
        report_instance_id,
        tenant,
        **kwargs
    ) -> ReportInstanceData:
        """Gets a report instance based on the ID  # noqa: E501

        Gets a report instance object based on the ID passed  # noqa: E501
        This method makes a synchronous HTTP request. Returns the http data only

        Args:
            report_instance_id (str): The ID of the report instance
            tenant (str): The code of the tenancy

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ReportInstanceData
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        kwargs['report_instance_id'] = \
            report_instance_id
        kwargs['tenant'] = \
            tenant
        return self.get_report_instance_by_id_endpoint.call_with_http_info(**kwargs)

    def get_report_instance_by_id_with_http_info(
        self,
        report_instance_id,
        tenant,
        **kwargs
    ) -> typing.Tuple[ReportInstanceData, int, typing.MutableMapping]:
        """Gets a report instance based on the ID  # noqa: E501

        Gets a report instance object based on the ID passed  # noqa: E501
        This method makes a synchronous HTTP request. Returns http data, http status and headers

        Args:
            report_instance_id (str): The ID of the report instance
            tenant (str): The code of the tenancy

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ReportInstanceData
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        kwargs['report_instance_id'] = \
            report_instance_id
        kwargs['tenant'] = \
            tenant
        return self.get_report_instance_by_id_endpoint.call_with_http_info(**kwargs)

    def get_report_instance_by_id_async(
        self,
        report_instance_id,
        tenant,
        **kwargs
    ) -> "ApplyResult[ReportInstanceData]":
        """Gets a report instance based on the ID  # noqa: E501

        Gets a report instance object based on the ID passed  # noqa: E501
        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult

        Args:
            report_instance_id (str): The ID of the report instance
            tenant (str): The code of the tenancy

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[ReportInstanceData]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        kwargs['report_instance_id'] = \
            report_instance_id
        kwargs['tenant'] = \
            tenant
        return self.get_report_instance_by_id_endpoint.call_with_http_info(**kwargs)

    def get_report_instance_by_id_with_http_info_async(
        self,
        report_instance_id,
        tenant,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[ReportInstanceData, int, typing.MutableMapping]]":
        """Gets a report instance based on the ID  # noqa: E501

        Gets a report instance object based on the ID passed  # noqa: E501
        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult

        Args:
            report_instance_id (str): The ID of the report instance
            tenant (str): The code of the tenancy

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(ReportInstanceData, int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        kwargs['report_instance_id'] = \
            report_instance_id
        kwargs['tenant'] = \
            tenant
        return self.get_report_instance_by_id_endpoint.call_with_http_info(**kwargs)


    def start_report_generation(
        self,
        report_generation_request_body,
        **kwargs
    ) -> ReportInstanceDataResponse:
        """Generates a report  # noqa: E501

        Generates a report using the specified ID and the JSON in the request body  # noqa: E501
        This method makes a synchronous HTTP request. Returns the http data only

        Args:
            report_generation_request_body (ReportGenerationRequestBody):

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ReportInstanceDataResponse
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        kwargs['report_generation_request_body'] = \
            report_generation_request_body
        return self.start_report_generation_endpoint.call_with_http_info(**kwargs)

    def start_report_generation_with_http_info(
        self,
        report_generation_request_body,
        **kwargs
    ) -> typing.Tuple[ReportInstanceDataResponse, int, typing.MutableMapping]:
        """Generates a report  # noqa: E501

        Generates a report using the specified ID and the JSON in the request body  # noqa: E501
        This method makes a synchronous HTTP request. Returns http data, http status and headers

        Args:
            report_generation_request_body (ReportGenerationRequestBody):

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ReportInstanceDataResponse
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        kwargs['report_generation_request_body'] = \
            report_generation_request_body
        return self.start_report_generation_endpoint.call_with_http_info(**kwargs)

    def start_report_generation_async(
        self,
        report_generation_request_body,
        **kwargs
    ) -> "ApplyResult[ReportInstanceDataResponse]":
        """Generates a report  # noqa: E501

        Generates a report using the specified ID and the JSON in the request body  # noqa: E501
        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult

        Args:
            report_generation_request_body (ReportGenerationRequestBody):

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[ReportInstanceDataResponse]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        kwargs['report_generation_request_body'] = \
            report_generation_request_body
        return self.start_report_generation_endpoint.call_with_http_info(**kwargs)

    def start_report_generation_with_http_info_async(
        self,
        report_generation_request_body,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[ReportInstanceDataResponse, int, typing.MutableMapping]]":
        """Generates a report  # noqa: E501

        Generates a report using the specified ID and the JSON in the request body  # noqa: E501
        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult

        Args:
            report_generation_request_body (ReportGenerationRequestBody):

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(ReportInstanceDataResponse, int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        kwargs['report_generation_request_body'] = \
            report_generation_request_body
        return self.start_report_generation_endpoint.call_with_http_info(**kwargs)


