# coding: utf-8

"""
    Panviva API Suite v3

    Wouldn't it be great if you could share information seamlessly? This connector allows you to push your knowledge further and consume a complete list of Panviva's API offerings.  **Content APIs** perform resource related operations , e.g. `document`, `folder`, `file`, `container`, `image`.  **Live APIs** enable real-time communications with online users on our client application.  **Artefact APIs** interact with curated Panviva content, created by the Digital Orchestrator.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: support@panviva.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from panviva.api_client import ApiClient


class OperationsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def operations_artefact_nls(self, instance, **kwargs):  # noqa: E501
        """Search Artefacts  # noqa: E501

        Return search results for a given query  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.operations_artefact_nls(instance, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str instance: The instance name as shown on the Panviva Developer Portal. (required)
        :param str simplequery: Natural language query string. For example: ```Action Movies```. (Note: Use simplequery OR advancedquery, not both.)
        :param str advancedquery: Query string written in Lucene query syntax. For example: ```films AND \"a story\"```. (Note: Use simplequery OR advancedquery, not both.)
        :param str filter: Accepts a Lucene-formatted filter string. Examples: ```category eq 'Mortgages'```, ```panvivaDocumentVersion gt '8'```. (Filterable fields include dateCreated, dateModified, dateDeleted, categoryJson, queryVariationsJson, title, category, primaryQuery, isDeleted, timestamp, panvivaDocumentId, panvivaDocumentVersion, id)
        :param str channel: Return response for a specific channel, instead of the default
        :param int page_offset: The pagination offset to denote the number of initial search results to skip. For example, pageOffset of 100 and pageLimit of 10 would return records 101-110.
        :param int page_limit: The number of records to return. Must be an integer between 0 and 1000.
        :param str facet: Accepts a Lucene-formatted facet string. Examples: ```facet=Category,count:10&amp;facet=Rating```. (Facetable fields include metaData/values)
        :return: GetSearchArtefactResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.operations_artefact_nls_with_http_info(instance, **kwargs)  # noqa: E501
        else:
            (data) = self.operations_artefact_nls_with_http_info(instance, **kwargs)  # noqa: E501
            return data

    def operations_artefact_nls_with_http_info(self, instance, **kwargs):  # noqa: E501
        """Search Artefacts  # noqa: E501

        Return search results for a given query  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.operations_artefact_nls_with_http_info(instance, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str instance: The instance name as shown on the Panviva Developer Portal. (required)
        :param str simplequery: Natural language query string. For example: ```Action Movies```. (Note: Use simplequery OR advancedquery, not both.)
        :param str advancedquery: Query string written in Lucene query syntax. For example: ```films AND \"a story\"```. (Note: Use simplequery OR advancedquery, not both.)
        :param str filter: Accepts a Lucene-formatted filter string. Examples: ```category eq 'Mortgages'```, ```panvivaDocumentVersion gt '8'```. (Filterable fields include dateCreated, dateModified, dateDeleted, categoryJson, queryVariationsJson, title, category, primaryQuery, isDeleted, timestamp, panvivaDocumentId, panvivaDocumentVersion, id)
        :param str channel: Return response for a specific channel, instead of the default
        :param int page_offset: The pagination offset to denote the number of initial search results to skip. For example, pageOffset of 100 and pageLimit of 10 would return records 101-110.
        :param int page_limit: The number of records to return. Must be an integer between 0 and 1000.
        :param str facet: Accepts a Lucene-formatted facet string. Examples: ```facet=Category,count:10&amp;facet=Rating```. (Facetable fields include metaData/values)
        :return: GetSearchArtefactResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['instance', 'simplequery', 'advancedquery', 'filter', 'channel', 'page_offset', 'page_limit', 'facet']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method operations_artefact_nls" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'instance' is set
        if ('instance' not in params or
                params['instance'] is None):
            raise ValueError("Missing the required parameter `instance` when calling `operations_artefact_nls`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instance' in params:
            path_params['instance'] = params['instance']  # noqa: E501

        query_params = []
        if 'simplequery' in params:
            query_params.append(('simplequery', params['simplequery']))  # noqa: E501
        if 'advancedquery' in params:
            query_params.append(('advancedquery', params['advancedquery']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'channel' in params:
            query_params.append(('channel', params['channel']))  # noqa: E501
        if 'page_offset' in params:
            query_params.append(('pageOffset', params['page_offset']))  # noqa: E501
        if 'page_limit' in params:
            query_params.append(('pageLimit', params['page_limit']))  # noqa: E501
        if 'facet' in params:
            query_params.append(('facet', params['facet']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKeyHeader']  # noqa: E501

        return self.api_client.call_api(
            '/{instance}/operations/artefact/nls', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetSearchArtefactResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def operations_live_csh(self, instance, **kwargs):  # noqa: E501
        """Live CSH  # noqa: E501

        Present a CSH search result page of the passing query on Panviva client to specified user on Panviva client  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.operations_live_csh(instance, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str instance: The instance name as shown on the Panviva Developer Portal. (required)
        :param PostLiveCshRequest post_live_csh_request: JSON object containing information required to perform a live activity<span>:</span>
        :return: PostLiveCshResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.operations_live_csh_with_http_info(instance, **kwargs)  # noqa: E501
        else:
            (data) = self.operations_live_csh_with_http_info(instance, **kwargs)  # noqa: E501
            return data

    def operations_live_csh_with_http_info(self, instance, **kwargs):  # noqa: E501
        """Live CSH  # noqa: E501

        Present a CSH search result page of the passing query on Panviva client to specified user on Panviva client  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.operations_live_csh_with_http_info(instance, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str instance: The instance name as shown on the Panviva Developer Portal. (required)
        :param PostLiveCshRequest post_live_csh_request: JSON object containing information required to perform a live activity<span>:</span>
        :return: PostLiveCshResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['instance', 'post_live_csh_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method operations_live_csh" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'instance' is set
        if ('instance' not in params or
                params['instance'] is None):
            raise ValueError("Missing the required parameter `instance` when calling `operations_live_csh`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instance' in params:
            path_params['instance'] = params['instance']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'post_live_csh_request' in params:
            body_params = params['post_live_csh_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKeyHeader']  # noqa: E501

        return self.api_client.call_api(
            '/{instance}/operations/live/csh', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PostLiveCshResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def operations_live_document(self, instance, **kwargs):  # noqa: E501
        """Live Document  # noqa: E501

        Present a document page to specified user on Panviva client  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.operations_live_document(instance, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str instance: The instance name as shown on the Panviva Developer Portal. (required)
        :param PostLiveDocumentRequest post_live_document_request: JSON object containing information required to perform a live activity<span>:</span>
        :return: PostLiveDocumentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.operations_live_document_with_http_info(instance, **kwargs)  # noqa: E501
        else:
            (data) = self.operations_live_document_with_http_info(instance, **kwargs)  # noqa: E501
            return data

    def operations_live_document_with_http_info(self, instance, **kwargs):  # noqa: E501
        """Live Document  # noqa: E501

        Present a document page to specified user on Panviva client  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.operations_live_document_with_http_info(instance, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str instance: The instance name as shown on the Panviva Developer Portal. (required)
        :param PostLiveDocumentRequest post_live_document_request: JSON object containing information required to perform a live activity<span>:</span>
        :return: PostLiveDocumentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['instance', 'post_live_document_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method operations_live_document" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'instance' is set
        if ('instance' not in params or
                params['instance'] is None):
            raise ValueError("Missing the required parameter `instance` when calling `operations_live_document`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instance' in params:
            path_params['instance'] = params['instance']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'post_live_document_request' in params:
            body_params = params['post_live_document_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKeyHeader']  # noqa: E501

        return self.api_client.call_api(
            '/{instance}/operations/live/document', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PostLiveDocumentResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def operations_live_search(self, instance, **kwargs):  # noqa: E501
        """Live Search  # noqa: E501

        Present a search result page of the passing query on Panviva client to specified user on Panviva client  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.operations_live_search(instance, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str instance: The instance name as shown on the Panviva Developer Portal. (required)
        :param PostLiveSearchRequest post_live_search_request: JSON object containing information required to perform a live activity<span>:</span>
        :return: PostLiveSearchResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.operations_live_search_with_http_info(instance, **kwargs)  # noqa: E501
        else:
            (data) = self.operations_live_search_with_http_info(instance, **kwargs)  # noqa: E501
            return data

    def operations_live_search_with_http_info(self, instance, **kwargs):  # noqa: E501
        """Live Search  # noqa: E501

        Present a search result page of the passing query on Panviva client to specified user on Panviva client  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.operations_live_search_with_http_info(instance, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str instance: The instance name as shown on the Panviva Developer Portal. (required)
        :param PostLiveSearchRequest post_live_search_request: JSON object containing information required to perform a live activity<span>:</span>
        :return: PostLiveSearchResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['instance', 'post_live_search_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method operations_live_search" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'instance' is set
        if ('instance' not in params or
                params['instance'] is None):
            raise ValueError("Missing the required parameter `instance` when calling `operations_live_search`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instance' in params:
            path_params['instance'] = params['instance']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'post_live_search_request' in params:
            body_params = params['post_live_search_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKeyHeader']  # noqa: E501

        return self.api_client.call_api(
            '/{instance}/operations/live/search', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PostLiveSearchResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def operations_search(self, instance, term, **kwargs):  # noqa: E501
        """Search  # noqa: E501

        Searches documents, folders, and files (external documents) for a term and returns paginated results  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.operations_search(instance, term, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str instance: The instance name as shown on the Panviva Developer Portal. (required)
        :param str term: The word or phrase to be searched for (required)
        :param int page_offset: The pagination offset to denote the number of initial search results to skip. For example, pageOffset of 100 and pageLimit of 10 would return records 101-110.
        :param int page_limit: The number of records to return. Must be an integer between 0 and 1000.
        :return: GetSearchResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.operations_search_with_http_info(instance, term, **kwargs)  # noqa: E501
        else:
            (data) = self.operations_search_with_http_info(instance, term, **kwargs)  # noqa: E501
            return data

    def operations_search_with_http_info(self, instance, term, **kwargs):  # noqa: E501
        """Search  # noqa: E501

        Searches documents, folders, and files (external documents) for a term and returns paginated results  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.operations_search_with_http_info(instance, term, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str instance: The instance name as shown on the Panviva Developer Portal. (required)
        :param str term: The word or phrase to be searched for (required)
        :param int page_offset: The pagination offset to denote the number of initial search results to skip. For example, pageOffset of 100 and pageLimit of 10 would return records 101-110.
        :param int page_limit: The number of records to return. Must be an integer between 0 and 1000.
        :return: GetSearchResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['instance', 'term', 'page_offset', 'page_limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method operations_search" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'instance' is set
        if ('instance' not in params or
                params['instance'] is None):
            raise ValueError("Missing the required parameter `instance` when calling `operations_search`")  # noqa: E501
        # verify the required parameter 'term' is set
        if ('term' not in params or
                params['term'] is None):
            raise ValueError("Missing the required parameter `term` when calling `operations_search`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instance' in params:
            path_params['instance'] = params['instance']  # noqa: E501

        query_params = []
        if 'term' in params:
            query_params.append(('term', params['term']))  # noqa: E501
        if 'page_offset' in params:
            query_params.append(('pageOffset', params['page_offset']))  # noqa: E501
        if 'page_limit' in params:
            query_params.append(('pageLimit', params['page_limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKeyHeader']  # noqa: E501

        return self.api_client.call_api(
            '/{instance}/operations/search', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetSearchResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
