# coding: utf-8

"""
    Panviva API Suite v3

    Wouldn't it be great if you could share information seamlessly? This connector allows you to push your knowledge further and consume a complete list of Panviva's API offerings.  **Content APIs** perform resource related operations , e.g. `document`, `folder`, `file`, `container`, `image`.  **Live APIs** enable real-time communications with online users on our client application.  **Artefact APIs** interact with curated Panviva content, created by the Digital Orchestrator.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: support@panviva.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from panviva.api_client import ApiClient


class ResourcesApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def resources_artefact_by_id(self, instance, id, **kwargs):  # noqa: E501
        """Artefact  # noqa: E501

        Return an artefact using the ID provided  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.resources_artefact_by_id(instance, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str instance: The instance name as shown on the Panviva Developer Portal. (required)
        :param str id: Format - uuid. The id (ID) of an artefact (required)
        :return: GetResponseResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.resources_artefact_by_id_with_http_info(instance, id, **kwargs)  # noqa: E501
        else:
            (data) = self.resources_artefact_by_id_with_http_info(instance, id, **kwargs)  # noqa: E501
            return data

    def resources_artefact_by_id_with_http_info(self, instance, id, **kwargs):  # noqa: E501
        """Artefact  # noqa: E501

        Return an artefact using the ID provided  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.resources_artefact_by_id_with_http_info(instance, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str instance: The instance name as shown on the Panviva Developer Portal. (required)
        :param str id: Format - uuid. The id (ID) of an artefact (required)
        :return: GetResponseResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['instance', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method resources_artefact_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'instance' is set
        if ('instance' not in params or
                params['instance'] is None):
            raise ValueError("Missing the required parameter `instance` when calling `resources_artefact_by_id`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `resources_artefact_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instance' in params:
            path_params['instance'] = params['instance']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKeyHeader']  # noqa: E501

        return self.api_client.call_api(
            '/{instance}/resources/artefact/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetResponseResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def resources_artefact_categories_get(self, instance, **kwargs):  # noqa: E501
        """Get Artefact Categories  # noqa: E501

        Gets a list of all available artefact categories  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.resources_artefact_categories_get(instance, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str instance: The instance name as shown on the Panviva Developer Portal. (required)
        :return: GetArtefactCategoriesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.resources_artefact_categories_get_with_http_info(instance, **kwargs)  # noqa: E501
        else:
            (data) = self.resources_artefact_categories_get_with_http_info(instance, **kwargs)  # noqa: E501
            return data

    def resources_artefact_categories_get_with_http_info(self, instance, **kwargs):  # noqa: E501
        """Get Artefact Categories  # noqa: E501

        Gets a list of all available artefact categories  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.resources_artefact_categories_get_with_http_info(instance, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str instance: The instance name as shown on the Panviva Developer Portal. (required)
        :return: GetArtefactCategoriesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['instance']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method resources_artefact_categories_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'instance' is set
        if ('instance' not in params or
                params['instance'] is None):
            raise ValueError("Missing the required parameter `instance` when calling `resources_artefact_categories_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instance' in params:
            path_params['instance'] = params['instance']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKeyHeader']  # noqa: E501

        return self.api_client.call_api(
            '/{instance}/resources/artefactcategory', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetArtefactCategoriesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def resources_artefact_category_post(self, instance, **kwargs):  # noqa: E501
        """Create Artefact Category  # noqa: E501

        Creates a category for classifying artefacts  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.resources_artefact_category_post(instance, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str instance: The instance name as shown on the Panviva Developer Portal. (required)
        :param PostArtefactCategoryRequest post_artefact_category_request: JSON object containing the category name
        :return: PostArtefactCategoryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.resources_artefact_category_post_with_http_info(instance, **kwargs)  # noqa: E501
        else:
            (data) = self.resources_artefact_category_post_with_http_info(instance, **kwargs)  # noqa: E501
            return data

    def resources_artefact_category_post_with_http_info(self, instance, **kwargs):  # noqa: E501
        """Create Artefact Category  # noqa: E501

        Creates a category for classifying artefacts  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.resources_artefact_category_post_with_http_info(instance, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str instance: The instance name as shown on the Panviva Developer Portal. (required)
        :param PostArtefactCategoryRequest post_artefact_category_request: JSON object containing the category name
        :return: PostArtefactCategoryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['instance', 'post_artefact_category_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method resources_artefact_category_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'instance' is set
        if ('instance' not in params or
                params['instance'] is None):
            raise ValueError("Missing the required parameter `instance` when calling `resources_artefact_category_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instance' in params:
            path_params['instance'] = params['instance']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'post_artefact_category_request' in params:
            body_params = params['post_artefact_category_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKeyHeader']  # noqa: E501

        return self.api_client.call_api(
            '/{instance}/resources/artefactcategory', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PostArtefactCategoryResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def resources_container_by_id(self, instance, id, **kwargs):  # noqa: E501
        """Container  # noqa: E501

        Return a container using the container ID provided  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.resources_container_by_id(instance, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str instance: The instance name as shown on the Panviva Developer Portal. (required)
        :param str id: The id of a document container (required)
        :return: GetContainerResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.resources_container_by_id_with_http_info(instance, id, **kwargs)  # noqa: E501
        else:
            (data) = self.resources_container_by_id_with_http_info(instance, id, **kwargs)  # noqa: E501
            return data

    def resources_container_by_id_with_http_info(self, instance, id, **kwargs):  # noqa: E501
        """Container  # noqa: E501

        Return a container using the container ID provided  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.resources_container_by_id_with_http_info(instance, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str instance: The instance name as shown on the Panviva Developer Portal. (required)
        :param str id: The id of a document container (required)
        :return: GetContainerResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['instance', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method resources_container_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'instance' is set
        if ('instance' not in params or
                params['instance'] is None):
            raise ValueError("Missing the required parameter `instance` when calling `resources_container_by_id`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `resources_container_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instance' in params:
            path_params['instance'] = params['instance']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKeyHeader']  # noqa: E501

        return self.api_client.call_api(
            '/{instance}/resources/container/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetContainerResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def resources_document_by_id(self, instance, id, **kwargs):  # noqa: E501
        """Document  # noqa: E501

        Return a document using the document ID provided  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.resources_document_by_id(instance, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str instance: The instance name as shown on the Panviva Developer Portal. (required)
        :param str id: A document unique identifier, Document ID. If a document is a translated document, this value represents Internal ID or IID in Panviva API v1. (required)
        :param int version: Request the API to return a particular version of the specified document.
        :return: GetDocumentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.resources_document_by_id_with_http_info(instance, id, **kwargs)  # noqa: E501
        else:
            (data) = self.resources_document_by_id_with_http_info(instance, id, **kwargs)  # noqa: E501
            return data

    def resources_document_by_id_with_http_info(self, instance, id, **kwargs):  # noqa: E501
        """Document  # noqa: E501

        Return a document using the document ID provided  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.resources_document_by_id_with_http_info(instance, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str instance: The instance name as shown on the Panviva Developer Portal. (required)
        :param str id: A document unique identifier, Document ID. If a document is a translated document, this value represents Internal ID or IID in Panviva API v1. (required)
        :param int version: Request the API to return a particular version of the specified document.
        :return: GetDocumentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['instance', 'id', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method resources_document_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'instance' is set
        if ('instance' not in params or
                params['instance'] is None):
            raise ValueError("Missing the required parameter `instance` when calling `resources_document_by_id`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `resources_document_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instance' in params:
            path_params['instance'] = params['instance']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'version' in params:
            query_params.append(('version', params['version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKeyHeader']  # noqa: E501

        return self.api_client.call_api(
            '/{instance}/resources/document/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetDocumentResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def resources_document_by_id_containers(self, instance, id, **kwargs):  # noqa: E501
        """Document Containers  # noqa: E501

        Return a list of containers using the document ID provided  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.resources_document_by_id_containers(instance, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str instance: The instance name as shown on the Panviva Developer Portal. (required)
        :param int id: The internal id (IID) of a Panviva document (required)
        :return: GetDocumentContainersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.resources_document_by_id_containers_with_http_info(instance, id, **kwargs)  # noqa: E501
        else:
            (data) = self.resources_document_by_id_containers_with_http_info(instance, id, **kwargs)  # noqa: E501
            return data

    def resources_document_by_id_containers_with_http_info(self, instance, id, **kwargs):  # noqa: E501
        """Document Containers  # noqa: E501

        Return a list of containers using the document ID provided  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.resources_document_by_id_containers_with_http_info(instance, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str instance: The instance name as shown on the Panviva Developer Portal. (required)
        :param int id: The internal id (IID) of a Panviva document (required)
        :return: GetDocumentContainersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['instance', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method resources_document_by_id_containers" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'instance' is set
        if ('instance' not in params or
                params['instance'] is None):
            raise ValueError("Missing the required parameter `instance` when calling `resources_document_by_id_containers`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `resources_document_by_id_containers`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instance' in params:
            path_params['instance'] = params['instance']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKeyHeader']  # noqa: E501

        return self.api_client.call_api(
            '/{instance}/resources/document/{id}/containers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetDocumentContainersResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def resources_document_by_id_containers_relationships(self, instance, id, **kwargs):  # noqa: E501
        """Document Container Relationships  # noqa: E501

        Return a list of the parent-child relationship between each container for the document ID provided  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.resources_document_by_id_containers_relationships(instance, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str instance: The instance name as shown on the Panviva Developer Portal. (required)
        :param int id: The internal id (IID) of a Panviva document (required)
        :return: GetDocumentContainerRelationshipsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.resources_document_by_id_containers_relationships_with_http_info(instance, id, **kwargs)  # noqa: E501
        else:
            (data) = self.resources_document_by_id_containers_relationships_with_http_info(instance, id, **kwargs)  # noqa: E501
            return data

    def resources_document_by_id_containers_relationships_with_http_info(self, instance, id, **kwargs):  # noqa: E501
        """Document Container Relationships  # noqa: E501

        Return a list of the parent-child relationship between each container for the document ID provided  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.resources_document_by_id_containers_relationships_with_http_info(instance, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str instance: The instance name as shown on the Panviva Developer Portal. (required)
        :param int id: The internal id (IID) of a Panviva document (required)
        :return: GetDocumentContainerRelationshipsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['instance', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method resources_document_by_id_containers_relationships" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'instance' is set
        if ('instance' not in params or
                params['instance'] is None):
            raise ValueError("Missing the required parameter `instance` when calling `resources_document_by_id_containers_relationships`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `resources_document_by_id_containers_relationships`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instance' in params:
            path_params['instance'] = params['instance']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKeyHeader']  # noqa: E501

        return self.api_client.call_api(
            '/{instance}/resources/document/{id}/containers/relationships', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetDocumentContainerRelationshipsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def resources_document_by_id_translations(self, instance, id, **kwargs):  # noqa: E501
        """Document Translations  # noqa: E501

        Return a list of all translations (per language and locale) of a Panviva document  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.resources_document_by_id_translations(instance, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str instance: The instance name as shown on the Panviva Developer Portal. (required)
        :param int id: The internal id (IID) of a Panviva document. (required)
        :return: GetDocumentTranslationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.resources_document_by_id_translations_with_http_info(instance, id, **kwargs)  # noqa: E501
        else:
            (data) = self.resources_document_by_id_translations_with_http_info(instance, id, **kwargs)  # noqa: E501
            return data

    def resources_document_by_id_translations_with_http_info(self, instance, id, **kwargs):  # noqa: E501
        """Document Translations  # noqa: E501

        Return a list of all translations (per language and locale) of a Panviva document  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.resources_document_by_id_translations_with_http_info(instance, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str instance: The instance name as shown on the Panviva Developer Portal. (required)
        :param int id: The internal id (IID) of a Panviva document. (required)
        :return: GetDocumentTranslationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['instance', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method resources_document_by_id_translations" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'instance' is set
        if ('instance' not in params or
                params['instance'] is None):
            raise ValueError("Missing the required parameter `instance` when calling `resources_document_by_id_translations`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `resources_document_by_id_translations`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instance' in params:
            path_params['instance'] = params['instance']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKeyHeader']  # noqa: E501

        return self.api_client.call_api(
            '/{instance}/resources/document/{id}/translations', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetDocumentTranslationsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def resources_file_by_id(self, instance, id, **kwargs):  # noqa: E501
        """File  # noqa: E501

        Returns a file (external document) from Panviva  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.resources_file_by_id(instance, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str instance: The instance name as shown on the Panviva Developer Portal. (required)
        :param int id: The internal id (IID) of a Panviva file (external document) (required)
        :return: GetFileResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.resources_file_by_id_with_http_info(instance, id, **kwargs)  # noqa: E501
        else:
            (data) = self.resources_file_by_id_with_http_info(instance, id, **kwargs)  # noqa: E501
            return data

    def resources_file_by_id_with_http_info(self, instance, id, **kwargs):  # noqa: E501
        """File  # noqa: E501

        Returns a file (external document) from Panviva  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.resources_file_by_id_with_http_info(instance, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str instance: The instance name as shown on the Panviva Developer Portal. (required)
        :param int id: The internal id (IID) of a Panviva file (external document) (required)
        :return: GetFileResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['instance', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method resources_file_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'instance' is set
        if ('instance' not in params or
                params['instance'] is None):
            raise ValueError("Missing the required parameter `instance` when calling `resources_file_by_id`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `resources_file_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instance' in params:
            path_params['instance'] = params['instance']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKeyHeader']  # noqa: E501

        return self.api_client.call_api(
            '/{instance}/resources/file/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetFileResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def resources_folder_by_id(self, instance, id, **kwargs):  # noqa: E501
        """Folder  # noqa: E501

        Return information about a Panviva folder and references to each of its direct children  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.resources_folder_by_id(instance, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str instance: The instance name as shown on the Panviva Developer Portal. (required)
        :param int id: The internal id (IID) of a Panviva folder (required)
        :return: GetFolderResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.resources_folder_by_id_with_http_info(instance, id, **kwargs)  # noqa: E501
        else:
            (data) = self.resources_folder_by_id_with_http_info(instance, id, **kwargs)  # noqa: E501
            return data

    def resources_folder_by_id_with_http_info(self, instance, id, **kwargs):  # noqa: E501
        """Folder  # noqa: E501

        Return information about a Panviva folder and references to each of its direct children  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.resources_folder_by_id_with_http_info(instance, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str instance: The instance name as shown on the Panviva Developer Portal. (required)
        :param int id: The internal id (IID) of a Panviva folder (required)
        :return: GetFolderResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['instance', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method resources_folder_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'instance' is set
        if ('instance' not in params or
                params['instance'] is None):
            raise ValueError("Missing the required parameter `instance` when calling `resources_folder_by_id`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `resources_folder_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instance' in params:
            path_params['instance'] = params['instance']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKeyHeader']  # noqa: E501

        return self.api_client.call_api(
            '/{instance}/resources/folder/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetFolderResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def resources_folder_by_id_children(self, instance, id, **kwargs):  # noqa: E501
        """Folder Children  # noqa: E501

        Gets all the immediate children of a Panviva folder, not including grandchildren. Children can be folders, documents, or files (external documents)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.resources_folder_by_id_children(instance, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str instance: The instance name as shown on the Panviva Developer Portal. (required)
        :param int id: The internal id (IID) of a Panviva folder (required)
        :return: GetFolderChildrenResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.resources_folder_by_id_children_with_http_info(instance, id, **kwargs)  # noqa: E501
        else:
            (data) = self.resources_folder_by_id_children_with_http_info(instance, id, **kwargs)  # noqa: E501
            return data

    def resources_folder_by_id_children_with_http_info(self, instance, id, **kwargs):  # noqa: E501
        """Folder Children  # noqa: E501

        Gets all the immediate children of a Panviva folder, not including grandchildren. Children can be folders, documents, or files (external documents)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.resources_folder_by_id_children_with_http_info(instance, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str instance: The instance name as shown on the Panviva Developer Portal. (required)
        :param int id: The internal id (IID) of a Panviva folder (required)
        :return: GetFolderChildrenResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['instance', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method resources_folder_by_id_children" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'instance' is set
        if ('instance' not in params or
                params['instance'] is None):
            raise ValueError("Missing the required parameter `instance` when calling `resources_folder_by_id_children`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `resources_folder_by_id_children`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instance' in params:
            path_params['instance'] = params['instance']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKeyHeader']  # noqa: E501

        return self.api_client.call_api(
            '/{instance}/resources/folder/{id}/children', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetFolderChildrenResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def resources_folder_by_id_translations(self, instance, id, **kwargs):  # noqa: E501
        """Folder Translations  # noqa: E501

        Gets all the translations of a Panviva folder, along with each translated folders respective children  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.resources_folder_by_id_translations(instance, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str instance: The instance name as shown on the Panviva Developer Portal. (required)
        :param int id: The internal id (IID) of a Panviva folder (required)
        :return: GetFolderTranslationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.resources_folder_by_id_translations_with_http_info(instance, id, **kwargs)  # noqa: E501
        else:
            (data) = self.resources_folder_by_id_translations_with_http_info(instance, id, **kwargs)  # noqa: E501
            return data

    def resources_folder_by_id_translations_with_http_info(self, instance, id, **kwargs):  # noqa: E501
        """Folder Translations  # noqa: E501

        Gets all the translations of a Panviva folder, along with each translated folders respective children  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.resources_folder_by_id_translations_with_http_info(instance, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str instance: The instance name as shown on the Panviva Developer Portal. (required)
        :param int id: The internal id (IID) of a Panviva folder (required)
        :return: GetFolderTranslationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['instance', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method resources_folder_by_id_translations" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'instance' is set
        if ('instance' not in params or
                params['instance'] is None):
            raise ValueError("Missing the required parameter `instance` when calling `resources_folder_by_id_translations`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `resources_folder_by_id_translations`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instance' in params:
            path_params['instance'] = params['instance']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKeyHeader']  # noqa: E501

        return self.api_client.call_api(
            '/{instance}/resources/folder/{id}/translations', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetFolderTranslationsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def resources_folder_root(self, instance, **kwargs):  # noqa: E501
        """Folder Root  # noqa: E501

        Gets the root/home folder in all of Panviva, which can be drilled into using the Get Folder Children endpoint. Note this endpoint was formerly referred to as the 'Folder Search' endpoint  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.resources_folder_root(instance, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str instance: The instance name as shown on the Panviva Developer Portal. (required)
        :return: GetFolderRootResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.resources_folder_root_with_http_info(instance, **kwargs)  # noqa: E501
        else:
            (data) = self.resources_folder_root_with_http_info(instance, **kwargs)  # noqa: E501
            return data

    def resources_folder_root_with_http_info(self, instance, **kwargs):  # noqa: E501
        """Folder Root  # noqa: E501

        Gets the root/home folder in all of Panviva, which can be drilled into using the Get Folder Children endpoint. Note this endpoint was formerly referred to as the 'Folder Search' endpoint  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.resources_folder_root_with_http_info(instance, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str instance: The instance name as shown on the Panviva Developer Portal. (required)
        :return: GetFolderRootResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['instance']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method resources_folder_root" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'instance' is set
        if ('instance' not in params or
                params['instance'] is None):
            raise ValueError("Missing the required parameter `instance` when calling `resources_folder_root`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instance' in params:
            path_params['instance'] = params['instance']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKeyHeader']  # noqa: E501

        return self.api_client.call_api(
            '/{instance}/resources/folder/root', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetFolderRootResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def resources_image_by_id(self, instance, id, **kwargs):  # noqa: E501
        """Image  # noqa: E501

        Returns an image from Panviva. Image data is represented as a base64 string  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.resources_image_by_id(instance, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str instance: The instance name as shown on the Panviva Developer Portal. (required)
        :param int id: The id of a Panviva image (required)
        :return: GetImageResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.resources_image_by_id_with_http_info(instance, id, **kwargs)  # noqa: E501
        else:
            (data) = self.resources_image_by_id_with_http_info(instance, id, **kwargs)  # noqa: E501
            return data

    def resources_image_by_id_with_http_info(self, instance, id, **kwargs):  # noqa: E501
        """Image  # noqa: E501

        Returns an image from Panviva. Image data is represented as a base64 string  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.resources_image_by_id_with_http_info(instance, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str instance: The instance name as shown on the Panviva Developer Portal. (required)
        :param int id: The id of a Panviva image (required)
        :return: GetImageResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['instance', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method resources_image_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'instance' is set
        if ('instance' not in params or
                params['instance'] is None):
            raise ValueError("Missing the required parameter `instance` when calling `resources_image_by_id`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `resources_image_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instance' in params:
            path_params['instance'] = params['instance']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKeyHeader']  # noqa: E501

        return self.api_client.call_api(
            '/{instance}/resources/image/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetImageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
