# coding: utf-8

"""
    Panviva API Suite v3

    Wouldn't it be great if you could share information seamlessly? This connector allows you to push your knowledge further and consume a complete list of Panviva's API offerings.  **Content APIs** perform resource related operations , e.g. `document`, `folder`, `file`, `container`, `image`.  **Live APIs** enable real-time communications with online users on our client application.  **Artefact APIs** interact with curated Panviva content, created by the Digital Orchestrator.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: support@panviva.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class GetResponseResponse(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'links': 'list[Link]',
        'title': 'str',
        'content': 'list[ResponseSection]',
        'variations': 'list[ResponseVariation]',
        'category': 'Category',
        'primary_query': 'str',
        'query_variations': 'list[QueryVariation]',
        'panviva_document_id': 'int',
        'panviva_document_version': 'int',
        'meta_data': 'dict(str, MetaDataValueDetails)',
        'id': 'str',
        'date_created': 'datetime',
        'date_modified': 'datetime'
    }

    attribute_map = {
        'links': 'links',
        'title': 'title',
        'content': 'content',
        'variations': 'variations',
        'category': 'category',
        'primary_query': 'primaryQuery',
        'query_variations': 'queryVariations',
        'panviva_document_id': 'panvivaDocumentId',
        'panviva_document_version': 'panvivaDocumentVersion',
        'meta_data': 'metaData',
        'id': 'id',
        'date_created': 'dateCreated',
        'date_modified': 'dateModified'
    }

    def __init__(self, links=None, title=None, content=None, variations=None, category=None, primary_query=None, query_variations=None, panviva_document_id=None, panviva_document_version=None, meta_data=None, id=None, date_created=None, date_modified=None):  # noqa: E501
        """GetResponseResponse - a model defined in Swagger"""  # noqa: E501

        self._links = None
        self._title = None
        self._content = None
        self._variations = None
        self._category = None
        self._primary_query = None
        self._query_variations = None
        self._panviva_document_id = None
        self._panviva_document_version = None
        self._meta_data = None
        self._id = None
        self._date_created = None
        self._date_modified = None
        self.discriminator = None

        if links is not None:
            self.links = links
        if title is not None:
            self.title = title
        if content is not None:
            self.content = content
        if variations is not None:
            self.variations = variations
        if category is not None:
            self.category = category
        if primary_query is not None:
            self.primary_query = primary_query
        if query_variations is not None:
            self.query_variations = query_variations
        if panviva_document_id is not None:
            self.panviva_document_id = panviva_document_id
        if panviva_document_version is not None:
            self.panviva_document_version = panviva_document_version
        if meta_data is not None:
            self.meta_data = meta_data
        if id is not None:
            self.id = id
        if date_created is not None:
            self.date_created = date_created
        if date_modified is not None:
            self.date_modified = date_modified

    @property
    def links(self):
        """Gets the links of this GetResponseResponse.  # noqa: E501


        :return: The links of this GetResponseResponse.  # noqa: E501
        :rtype: list[Link]
        """
        return self._links

    @links.setter
    def links(self, links):
        """Sets the links of this GetResponseResponse.


        :param links: The links of this GetResponseResponse.  # noqa: E501
        :type: list[Link]
        """

        self._links = links

    @property
    def title(self):
        """Gets the title of this GetResponseResponse.  # noqa: E501


        :return: The title of this GetResponseResponse.  # noqa: E501
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """Sets the title of this GetResponseResponse.


        :param title: The title of this GetResponseResponse.  # noqa: E501
        :type: str
        """

        self._title = title

    @property
    def content(self):
        """Gets the content of this GetResponseResponse.  # noqa: E501


        :return: The content of this GetResponseResponse.  # noqa: E501
        :rtype: list[ResponseSection]
        """
        return self._content

    @content.setter
    def content(self, content):
        """Sets the content of this GetResponseResponse.


        :param content: The content of this GetResponseResponse.  # noqa: E501
        :type: list[ResponseSection]
        """

        self._content = content

    @property
    def variations(self):
        """Gets the variations of this GetResponseResponse.  # noqa: E501


        :return: The variations of this GetResponseResponse.  # noqa: E501
        :rtype: list[ResponseVariation]
        """
        return self._variations

    @variations.setter
    def variations(self, variations):
        """Sets the variations of this GetResponseResponse.


        :param variations: The variations of this GetResponseResponse.  # noqa: E501
        :type: list[ResponseVariation]
        """

        self._variations = variations

    @property
    def category(self):
        """Gets the category of this GetResponseResponse.  # noqa: E501


        :return: The category of this GetResponseResponse.  # noqa: E501
        :rtype: Category
        """
        return self._category

    @category.setter
    def category(self, category):
        """Sets the category of this GetResponseResponse.


        :param category: The category of this GetResponseResponse.  # noqa: E501
        :type: Category
        """

        self._category = category

    @property
    def primary_query(self):
        """Gets the primary_query of this GetResponseResponse.  # noqa: E501


        :return: The primary_query of this GetResponseResponse.  # noqa: E501
        :rtype: str
        """
        return self._primary_query

    @primary_query.setter
    def primary_query(self, primary_query):
        """Sets the primary_query of this GetResponseResponse.


        :param primary_query: The primary_query of this GetResponseResponse.  # noqa: E501
        :type: str
        """

        self._primary_query = primary_query

    @property
    def query_variations(self):
        """Gets the query_variations of this GetResponseResponse.  # noqa: E501


        :return: The query_variations of this GetResponseResponse.  # noqa: E501
        :rtype: list[QueryVariation]
        """
        return self._query_variations

    @query_variations.setter
    def query_variations(self, query_variations):
        """Sets the query_variations of this GetResponseResponse.


        :param query_variations: The query_variations of this GetResponseResponse.  # noqa: E501
        :type: list[QueryVariation]
        """

        self._query_variations = query_variations

    @property
    def panviva_document_id(self):
        """Gets the panviva_document_id of this GetResponseResponse.  # noqa: E501


        :return: The panviva_document_id of this GetResponseResponse.  # noqa: E501
        :rtype: int
        """
        return self._panviva_document_id

    @panviva_document_id.setter
    def panviva_document_id(self, panviva_document_id):
        """Sets the panviva_document_id of this GetResponseResponse.


        :param panviva_document_id: The panviva_document_id of this GetResponseResponse.  # noqa: E501
        :type: int
        """

        self._panviva_document_id = panviva_document_id

    @property
    def panviva_document_version(self):
        """Gets the panviva_document_version of this GetResponseResponse.  # noqa: E501


        :return: The panviva_document_version of this GetResponseResponse.  # noqa: E501
        :rtype: int
        """
        return self._panviva_document_version

    @panviva_document_version.setter
    def panviva_document_version(self, panviva_document_version):
        """Sets the panviva_document_version of this GetResponseResponse.


        :param panviva_document_version: The panviva_document_version of this GetResponseResponse.  # noqa: E501
        :type: int
        """

        self._panviva_document_version = panviva_document_version

    @property
    def meta_data(self):
        """Gets the meta_data of this GetResponseResponse.  # noqa: E501


        :return: The meta_data of this GetResponseResponse.  # noqa: E501
        :rtype: dict(str, MetaDataValueDetails)
        """
        return self._meta_data

    @meta_data.setter
    def meta_data(self, meta_data):
        """Sets the meta_data of this GetResponseResponse.


        :param meta_data: The meta_data of this GetResponseResponse.  # noqa: E501
        :type: dict(str, MetaDataValueDetails)
        """

        self._meta_data = meta_data

    @property
    def id(self):
        """Gets the id of this GetResponseResponse.  # noqa: E501


        :return: The id of this GetResponseResponse.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this GetResponseResponse.


        :param id: The id of this GetResponseResponse.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def date_created(self):
        """Gets the date_created of this GetResponseResponse.  # noqa: E501


        :return: The date_created of this GetResponseResponse.  # noqa: E501
        :rtype: datetime
        """
        return self._date_created

    @date_created.setter
    def date_created(self, date_created):
        """Sets the date_created of this GetResponseResponse.


        :param date_created: The date_created of this GetResponseResponse.  # noqa: E501
        :type: datetime
        """

        self._date_created = date_created

    @property
    def date_modified(self):
        """Gets the date_modified of this GetResponseResponse.  # noqa: E501


        :return: The date_modified of this GetResponseResponse.  # noqa: E501
        :rtype: datetime
        """
        return self._date_modified

    @date_modified.setter
    def date_modified(self, date_modified):
        """Sets the date_modified of this GetResponseResponse.


        :param date_modified: The date_modified of this GetResponseResponse.  # noqa: E501
        :type: datetime
        """

        self._date_modified = date_modified

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(GetResponseResponse, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, GetResponseResponse):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
