# coding: utf-8

"""
Aries Cloud Agent

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: v1.3.0rc1.post20250417
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations

import pprint
import re
from typing import Any, ClassVar, Dict, List, Optional, Set

import orjson
from pydantic import BaseModel, Field, StrictStr, field_validator
from typing_extensions import Annotated, Self

from aries_cloudcontroller.util import DEFAULT_PYDANTIC_MODEL_CONFIG


class DataIntegrityProofOptions(BaseModel):
    """
    DataIntegrityProofOptions
    """  # noqa: E501

    challenge: Optional[StrictStr] = Field(
        default=None,
        description="The value is used once for a particular domain and window of time. This value is used to mitigate replay attacks.",
    )
    created: Optional[StrictStr] = Field(
        default=None,
        description="The date and time the proof was created is OPTIONAL and, if included, MUST be specified as an [XMLSCHEMA11-2] dateTimeStamp string",
    )
    cryptosuite: StrictStr = Field(
        description="An identifier for the cryptographic suite that can be used to verify the proof."
    )
    domain: Optional[StrictStr] = Field(
        default=None,
        description="It conveys one or more security domains in which the proof is meant to be used.",
    )
    expires: Optional[StrictStr] = Field(
        default=None,
        description="The expires property is OPTIONAL and, if present, specifies when the proof expires. If present, it MUST be an [XMLSCHEMA11-2] dateTimeStamp string",
    )
    id: Optional[StrictStr] = Field(
        default=None,
        description="An optional identifier for the proof, which MUST be a URL [URL], such as a UUID as a URN",
    )
    nonce: Optional[StrictStr] = Field(
        default=None,
        description="One use of this field is to increase privacy by decreasing linkability that is the result of deterministically generated signatures.",
    )
    previous_proof: Optional[StrictStr] = Field(
        default=None,
        description="Each value identifies another data integrity proof that MUST verify before the current proof is processed.",
        alias="previousProof",
    )
    proof_purpose: StrictStr = Field(
        description="The proof purpose acts as a safeguard to prevent the proof from being misused by being applied to a purpose other than the one that was intended.",
        alias="proofPurpose",
    )
    proof_value: Optional[StrictStr] = Field(
        default=None,
        description="The value of the proof signature.",
        alias="proofValue",
    )
    type: StrictStr = Field(
        description="The specific type of proof MUST be specified as a string that maps to a URL [URL]."
    )
    verification_method: Annotated[str, Field(strict=True)] = Field(
        description="A verification method is the means and information needed to verify the proof.",
        alias="verificationMethod",
    )
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = [
        "challenge",
        "created",
        "cryptosuite",
        "domain",
        "expires",
        "id",
        "nonce",
        "previousProof",
        "proofPurpose",
        "proofValue",
        "type",
        "verificationMethod",
    ]

    @field_validator("verification_method")
    def verification_method_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"\w+:(\/?\/?)[^\s]+", value):
            raise ValueError(
                r"must validate the regular expression /\w+:(\/?\/?)[^\s]+/"
            )
        return value

    model_config = DEFAULT_PYDANTIC_MODEL_CONFIG

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return self.model_dump_json(by_alias=True, exclude_unset=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DataIntegrityProofOptions from a JSON string"""
        return cls.from_dict(orjson.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set(
            [
                "additional_properties",
            ]
        )

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DataIntegrityProofOptions from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "challenge": obj.get("challenge"),
                "created": obj.get("created"),
                "cryptosuite": obj.get("cryptosuite"),
                "domain": obj.get("domain"),
                "expires": obj.get("expires"),
                "id": obj.get("id"),
                "nonce": obj.get("nonce"),
                "previousProof": obj.get("previousProof"),
                "proofPurpose": obj.get("proofPurpose"),
                "proofValue": obj.get("proofValue"),
                "type": obj.get("type"),
                "verificationMethod": obj.get("verificationMethod"),
            }
        )
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj
