# coding: utf-8

"""
Aries Cloud Agent

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: v1.3.0rc1.post20250417
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations

import pprint
from typing import Any, ClassVar, Dict, List, Optional, Set

import orjson
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr
from typing_extensions import Self

from aries_cloudcontroller.util import DEFAULT_PYDANTIC_MODEL_CONFIG


class LedgerConfigInstance(BaseModel):
    """
    LedgerConfigInstance
    """  # noqa: E501

    endorser_alias: Optional[StrictStr] = Field(
        default=None, description="Endorser service alias (optional)"
    )
    endorser_did: Optional[StrictStr] = Field(
        default=None, description="Endorser DID (optional)"
    )
    id: StrictStr = Field(
        description="Ledger identifier. Auto-generated UUID4 if not provided"
    )
    is_production: StrictBool = Field(
        description="Production-grade ledger (true/false)"
    )
    is_write: Optional[StrictBool] = Field(
        default=None, description="Write capability enabled (default: False)"
    )
    keepalive: Optional[StrictInt] = Field(
        default=None, description="Keep-alive timeout in seconds for idle connections"
    )
    pool_name: Optional[StrictStr] = Field(
        default=None,
        description="Ledger pool name (defaults to ledger ID if not specified)",
    )
    read_only: Optional[StrictBool] = Field(
        default=None, description="Read-only access (default: False)"
    )
    socks_proxy: Optional[StrictStr] = Field(
        default=None, description="SOCKS proxy URL (optional)"
    )
    __properties: ClassVar[List[str]] = [
        "endorser_alias",
        "endorser_did",
        "id",
        "is_production",
        "is_write",
        "keepalive",
        "pool_name",
        "read_only",
        "socks_proxy",
    ]

    model_config = DEFAULT_PYDANTIC_MODEL_CONFIG

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return self.model_dump_json(by_alias=True, exclude_unset=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of LedgerConfigInstance from a JSON string"""
        return cls.from_dict(orjson.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of LedgerConfigInstance from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "endorser_alias": obj.get("endorser_alias"),
                "endorser_did": obj.get("endorser_did"),
                "id": obj.get("id"),
                "is_production": obj.get("is_production"),
                "is_write": obj.get("is_write"),
                "keepalive": obj.get("keepalive"),
                "pool_name": obj.get("pool_name"),
                "read_only": obj.get("read_only"),
                "socks_proxy": obj.get("socks_proxy"),
            }
        )
        return _obj
