# coding: utf-8

"""
Aries Cloud Agent

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: v1.3.0rc1.post20250417
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations

import pprint
from typing import Any, ClassVar, Dict, List, Optional, Set

import orjson
from pydantic import BaseModel, Field
from typing_extensions import Self

from aries_cloudcontroller.models.ledger_config_instance import LedgerConfigInstance
from aries_cloudcontroller.util import DEFAULT_PYDANTIC_MODEL_CONFIG


class LedgerConfigList(BaseModel):
    """
    LedgerConfigList
    """  # noqa: E501

    non_production_ledgers: List[LedgerConfigInstance] = Field(
        description="Non-production ledgers (may be empty)"
    )
    production_ledgers: List[LedgerConfigInstance] = Field(
        description="Production ledgers (may be empty)"
    )
    __properties: ClassVar[List[str]] = ["non_production_ledgers", "production_ledgers"]

    model_config = DEFAULT_PYDANTIC_MODEL_CONFIG

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return self.model_dump_json(by_alias=True, exclude_unset=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of LedgerConfigList from a JSON string"""
        return cls.from_dict(orjson.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in non_production_ledgers (list)
        _items = []
        if self.non_production_ledgers:
            for _item_non_production_ledgers in self.non_production_ledgers:
                if _item_non_production_ledgers:
                    _items.append(_item_non_production_ledgers.to_dict())
            _dict["non_production_ledgers"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in production_ledgers (list)
        _items = []
        if self.production_ledgers:
            for _item_production_ledgers in self.production_ledgers:
                if _item_production_ledgers:
                    _items.append(_item_production_ledgers.to_dict())
            _dict["production_ledgers"] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of LedgerConfigList from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "non_production_ledgers": (
                    [
                        LedgerConfigInstance.from_dict(_item)
                        for _item in obj["non_production_ledgers"]
                    ]
                    if obj.get("non_production_ledgers") is not None
                    else None
                ),
                "production_ledgers": (
                    [
                        LedgerConfigInstance.from_dict(_item)
                        for _item in obj["production_ledgers"]
                    ]
                    if obj.get("production_ledgers") is not None
                    else None
                ),
            }
        )
        return _obj
