# coding: utf-8

"""
Aries Cloud Agent

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: v1.3.0rc1.post20250417
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations

import pprint
from typing import Any, ClassVar, Dict, List, Optional, Set

import orjson
from pydantic import BaseModel, Field, StrictInt, StrictStr
from typing_extensions import Self

from aries_cloudcontroller.util import DEFAULT_PYDANTIC_MODEL_CONFIG


class RevList(BaseModel):
    """
    RevList
    """  # noqa: E501

    current_accumulator: Optional[StrictStr] = Field(
        default=None,
        description="The current accumulator value",
        alias="currentAccumulator",
    )
    issuer_id: Optional[StrictStr] = Field(
        default=None,
        description="Issuer Identifier of the credential definition or schema",
        alias="issuerId",
    )
    rev_reg_def_id: Optional[StrictStr] = Field(
        default=None,
        description="The ID of the revocation registry definition",
        alias="revRegDefId",
    )
    revocation_list: Optional[List[StrictInt]] = Field(
        default=None,
        description="Bit list representing revoked credentials",
        alias="revocationList",
    )
    timestamp: Optional[StrictInt] = Field(
        default=None, description="Timestamp at which revocation list is applicable"
    )
    __properties: ClassVar[List[str]] = [
        "currentAccumulator",
        "issuerId",
        "revRegDefId",
        "revocationList",
        "timestamp",
    ]

    model_config = DEFAULT_PYDANTIC_MODEL_CONFIG

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return self.model_dump_json(by_alias=True, exclude_unset=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RevList from a JSON string"""
        return cls.from_dict(orjson.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RevList from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "currentAccumulator": obj.get("currentAccumulator"),
                "issuerId": obj.get("issuerId"),
                "revRegDefId": obj.get("revRegDefId"),
                "revocationList": obj.get("revocationList"),
                "timestamp": obj.get("timestamp"),
            }
        )
        return _obj
