# coding: utf-8

"""
Aries Cloud Agent

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: v1.3.0rc1.post20250417
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations

import pprint
from typing import Any, ClassVar, Dict, List, Optional, Set

import orjson
from pydantic import BaseModel, Field, StrictStr
from typing_extensions import Annotated, Self

from aries_cloudcontroller.util import DEFAULT_PYDANTIC_MODEL_CONFIG


class VCRecord(BaseModel):
    """
    VCRecord
    """  # noqa: E501

    contexts: Optional[List[Annotated[str, Field(strict=True)]]] = None
    cred_tags: Optional[Dict[str, StrictStr]] = None
    cred_value: Optional[Dict[str, Any]] = Field(
        default=None, description="(JSON-serializable) credential value"
    )
    expanded_types: Optional[List[StrictStr]] = None
    given_id: Optional[StrictStr] = Field(
        default=None, description="Credential identifier"
    )
    issuer_id: Optional[StrictStr] = Field(
        default=None, description="Issuer identifier"
    )
    proof_types: Optional[List[StrictStr]] = None
    record_id: Optional[StrictStr] = Field(
        default=None, description="Record identifier"
    )
    schema_ids: Optional[List[StrictStr]] = None
    subject_ids: Optional[List[StrictStr]] = None
    __properties: ClassVar[List[str]] = [
        "contexts",
        "cred_tags",
        "cred_value",
        "expanded_types",
        "given_id",
        "issuer_id",
        "proof_types",
        "record_id",
        "schema_ids",
        "subject_ids",
    ]

    model_config = DEFAULT_PYDANTIC_MODEL_CONFIG

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return self.model_dump_json(by_alias=True, exclude_unset=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of VCRecord from a JSON string"""
        return cls.from_dict(orjson.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of VCRecord from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "contexts": obj.get("contexts"),
                "cred_tags": obj.get("cred_tags"),
                "cred_value": obj.get("cred_value"),
                "expanded_types": obj.get("expanded_types"),
                "given_id": obj.get("given_id"),
                "issuer_id": obj.get("issuer_id"),
                "proof_types": obj.get("proof_types"),
                "record_id": obj.get("record_id"),
                "schema_ids": obj.get("schema_ids"),
                "subject_ids": obj.get("subject_ids"),
            }
        )
        return _obj
