"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Offset = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/time/r/offset time_offset}
*/
class Offset extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/time/r/offset time_offset} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options OffsetConfig = {}
    */
    constructor(scope, id, config = {}) {
        super(scope, id, {
            terraformResourceType: 'time_offset',
            terraformGeneratorMetadata: {
                providerName: 'time',
                providerVersion: '0.8.0',
                providerVersionConstraint: '~> 0.7'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        this._baseRfc3339 = config.baseRfc3339;
        this._offsetDays = config.offsetDays;
        this._offsetHours = config.offsetHours;
        this._offsetMinutes = config.offsetMinutes;
        this._offsetMonths = config.offsetMonths;
        this._offsetSeconds = config.offsetSeconds;
        this._offsetYears = config.offsetYears;
        this._triggers = config.triggers;
    }
    get baseRfc3339() {
        return this.getStringAttribute('base_rfc3339');
    }
    set baseRfc3339(value) {
        this._baseRfc3339 = value;
    }
    resetBaseRfc3339() {
        this._baseRfc3339 = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get baseRfc3339Input() {
        return this._baseRfc3339;
    }
    // day - computed: true, optional: false, required: false
    get day() {
        return this.getNumberAttribute('day');
    }
    // hour - computed: true, optional: false, required: false
    get hour() {
        return this.getNumberAttribute('hour');
    }
    // id - computed: true, optional: false, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    // minute - computed: true, optional: false, required: false
    get minute() {
        return this.getNumberAttribute('minute');
    }
    // month - computed: true, optional: false, required: false
    get month() {
        return this.getNumberAttribute('month');
    }
    get offsetDays() {
        return this.getNumberAttribute('offset_days');
    }
    set offsetDays(value) {
        this._offsetDays = value;
    }
    resetOffsetDays() {
        this._offsetDays = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get offsetDaysInput() {
        return this._offsetDays;
    }
    get offsetHours() {
        return this.getNumberAttribute('offset_hours');
    }
    set offsetHours(value) {
        this._offsetHours = value;
    }
    resetOffsetHours() {
        this._offsetHours = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get offsetHoursInput() {
        return this._offsetHours;
    }
    get offsetMinutes() {
        return this.getNumberAttribute('offset_minutes');
    }
    set offsetMinutes(value) {
        this._offsetMinutes = value;
    }
    resetOffsetMinutes() {
        this._offsetMinutes = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get offsetMinutesInput() {
        return this._offsetMinutes;
    }
    get offsetMonths() {
        return this.getNumberAttribute('offset_months');
    }
    set offsetMonths(value) {
        this._offsetMonths = value;
    }
    resetOffsetMonths() {
        this._offsetMonths = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get offsetMonthsInput() {
        return this._offsetMonths;
    }
    get offsetSeconds() {
        return this.getNumberAttribute('offset_seconds');
    }
    set offsetSeconds(value) {
        this._offsetSeconds = value;
    }
    resetOffsetSeconds() {
        this._offsetSeconds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get offsetSecondsInput() {
        return this._offsetSeconds;
    }
    get offsetYears() {
        return this.getNumberAttribute('offset_years');
    }
    set offsetYears(value) {
        this._offsetYears = value;
    }
    resetOffsetYears() {
        this._offsetYears = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get offsetYearsInput() {
        return this._offsetYears;
    }
    // rfc3339 - computed: true, optional: false, required: false
    get rfc3339() {
        return this.getStringAttribute('rfc3339');
    }
    // second - computed: true, optional: false, required: false
    get second() {
        return this.getNumberAttribute('second');
    }
    get triggers() {
        return this.getStringMapAttribute('triggers');
    }
    set triggers(value) {
        this._triggers = value;
    }
    resetTriggers() {
        this._triggers = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get triggersInput() {
        return this._triggers;
    }
    // unix - computed: true, optional: false, required: false
    get unix() {
        return this.getNumberAttribute('unix');
    }
    // year - computed: true, optional: false, required: false
    get year() {
        return this.getNumberAttribute('year');
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            base_rfc3339: cdktf.stringToTerraform(this._baseRfc3339),
            offset_days: cdktf.numberToTerraform(this._offsetDays),
            offset_hours: cdktf.numberToTerraform(this._offsetHours),
            offset_minutes: cdktf.numberToTerraform(this._offsetMinutes),
            offset_months: cdktf.numberToTerraform(this._offsetMonths),
            offset_seconds: cdktf.numberToTerraform(this._offsetSeconds),
            offset_years: cdktf.numberToTerraform(this._offsetYears),
            triggers: cdktf.hashMapper(cdktf.stringToTerraform)(this._triggers),
        };
    }
}
exports.Offset = Offset;
_a = JSII_RTTI_SYMBOL_1;
Offset[_a] = { fqn: "@cdktf/provider-time.Offset", version: "2.0.80" };
// =================
// STATIC PROPERTIES
// =================
Offset.tfResourceType = "time_offset";
//# sourceMappingURL=data:application/json;base64,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