/*
 * Decompiled with CFR 0.152.
 */
package ai;

import java.math.BigInteger;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import rts.GameState;
import rts.PhysicalGameState;
import rts.PlayerAction;
import rts.PlayerActionGenerator;
import rts.ResourceUsage;
import rts.UnitAction;
import rts.units.Unit;
import util.Pair;

public class BranchingFactorCalculatorBigInteger {
    public static int DEBUG = 0;

    public static BigInteger branchingFactorUpperBound(GameState gameState, int n) throws Exception {
        PlayerActionGenerator playerActionGenerator = new PlayerActionGenerator(gameState, n);
        return BigInteger.valueOf(playerActionGenerator.getSize());
    }

    public static BigInteger branchingFactor(GameState gameState, int n) throws Exception {
        BigInteger bigInteger = BigInteger.valueOf(0L);
        PlayerActionGenerator playerActionGenerator = new PlayerActionGenerator(gameState, n);
        while (playerActionGenerator.getNextAction(-1L) != null) {
            bigInteger = bigInteger.add(BigInteger.ONE);
        }
        return bigInteger;
    }

    public static BigInteger[] branchingFactorByResourceUsage(GameState gameState, int n) throws Exception {
        BigInteger[] bigIntegerArray = new BigInteger[gameState.getPlayer(n).getResources() + 1];
        for (int j = 0; j < bigIntegerArray.length; ++j) {
            bigIntegerArray[j] = BigInteger.ZERO;
        }
        PlayerActionGenerator playerActionGenerator = new PlayerActionGenerator(gameState, n);
        PlayerAction playerAction = null;
        do {
            if ((playerAction = playerActionGenerator.getNextAction(-1L)) == null) continue;
            int n2 = 0;
            for (Pair<Unit, UnitAction> pair : playerAction.getActions()) {
                n2 += ((UnitAction)pair.m_b).resourceUsage((Unit)pair.m_a, gameState.getPhysicalGameState()).getResourcesUsed(n);
            }
            bigIntegerArray[n2] = bigIntegerArray[n2].add(BigInteger.ONE);
        } while (playerAction != null);
        return bigIntegerArray;
    }

    public static void addFootPrint(int[][] nArray, int n, int n2, int n3) {
        if (nArray[n2][n3] == 0) {
            nArray[n2][n3] = n;
        } else {
            int n4 = nArray[n2][n3];
            LinkedList<Integer> linkedList = new LinkedList<Integer>();
            LinkedList<Integer> linkedList2 = new LinkedList<Integer>();
            linkedList.add(n2);
            linkedList2.add(n3);
            while (!linkedList.isEmpty()) {
                n2 = (Integer)linkedList.remove(0);
                if (nArray[n2][n3 = ((Integer)linkedList2.remove(0)).intValue()] == n) continue;
                nArray[n2][n3] = n;
                if (n2 > 0 && nArray[n2 - 1][n3] == n4) {
                    linkedList.add(0, n2 - 1);
                    linkedList2.add(0, n3);
                }
                if (n2 < nArray.length - 1 && nArray[n2 + 1][n3] == n4) {
                    linkedList.add(0, n2 + 1);
                    linkedList2.add(0, n3);
                }
                if (n3 > 0 && nArray[n2][n3 - 1] == n4) {
                    linkedList.add(0, n2);
                    linkedList2.add(0, n3 - 1);
                }
                if (n3 >= nArray[0].length - 1 || nArray[n2][n3 + 1] != n4) continue;
                linkedList.add(0, n2);
                linkedList2.add(0, n3 + 1);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static BigInteger branchingFactorByResourceUsageSeparatingFast(GameState gameState, int n) throws Exception {
        void var11_23;
        Object object;
        BigInteger[] bigIntegerArray;
        int n2 = gameState.getPlayer(n).getResources();
        GameState gameState2 = gameState.clone();
        PhysicalGameState physicalGameState = gameState2.getPhysicalGameState();
        int[][] nArray = new int[physicalGameState.getWidth()][physicalGameState.getHeight()];
        int n3 = 1;
        for (Unit unit : gameState2.getUnits()) {
            if (unit.getPlayer() != n || gameState2.getUnitAction(unit) != null) continue;
            List<UnitAction> list = unit.getUnitActions(gameState2);
            BranchingFactorCalculatorBigInteger.addFootPrint(nArray, n3, unit.getX(), unit.getY());
            for (UnitAction bigIntegerArray2 : list) {
                bigIntegerArray = bigIntegerArray2.resourceUsage(unit, gameState2.getPhysicalGameState());
                object = bigIntegerArray.getPositionsUsed().iterator();
                while (object.hasNext()) {
                    int n4 = (Integer)object.next();
                    int n5 = n4 % physicalGameState.getWidth();
                    int n6 = n4 / physicalGameState.getWidth();
                    BranchingFactorCalculatorBigInteger.addFootPrint(nArray, n3, n5, n6);
                }
            }
            ++n3;
        }
        LinkedList linkedList = new LinkedList();
        for (int j = 0; j < physicalGameState.getHeight(); ++j) {
            for (int k = 0; k < physicalGameState.getWidth(); ++k) {
                if (nArray[k][j] == 0 || linkedList.contains(nArray[k][j])) continue;
                linkedList.add(nArray[k][j]);
            }
        }
        LinkedList<BigInteger[]> linkedList2 = new LinkedList<BigInteger[]>();
        BigInteger[] bigIntegerArray3 = linkedList.iterator();
        while (bigIntegerArray3.hasNext()) {
            int n7 = (Integer)bigIntegerArray3.next();
            PlayerAction playerAction = new PlayerAction();
            bigIntegerArray = new LinkedList();
            object = new LinkedList();
            for (Unit unit : gameState2.getUnits()) {
                if (unit.getPlayer() != n || gameState2.getUnitAction(unit) != null) continue;
                if (nArray[unit.getX()][unit.getY()] == n7) {
                    bigIntegerArray.add(unit);
                    continue;
                }
                object.add(unit);
                playerAction.addUnitAction(unit, new UnitAction(0));
            }
            GameState gameState3 = gameState2.cloneIssue(playerAction).clone();
            BigInteger[] bigIntegerArray2 = BranchingFactorCalculatorBigInteger.branchingFactorByResourceUsageFastInternal(gameState3, n);
            linkedList2.add(bigIntegerArray2);
        }
        if (linkedList2.isEmpty()) {
            return BigInteger.ONE;
        }
        bigIntegerArray3 = (BigInteger[])linkedList2.remove(0);
        for (BigInteger[] bigIntegerArray4 : linkedList2) {
            int n7;
            bigIntegerArray = new BigInteger[n2 + 1];
            for (n7 = 0; n7 < n2 + 1; ++n7) {
                bigIntegerArray[n7] = BigInteger.ZERO;
            }
            for (n7 = 0; n7 < n2 + 1; ++n7) {
                for (int j = 0; j < n2 - n7 + 1; ++j) {
                    bigIntegerArray[n7 + j] = bigIntegerArray[n7 + j].add(bigIntegerArray4[n7].multiply(bigIntegerArray3[j]));
                }
            }
            bigIntegerArray3 = bigIntegerArray;
        }
        Object object2 = BigInteger.ZERO;
        boolean bl = false;
        while (var11_23 < n2 + 1) {
            object2 = ((BigInteger)object2).add(bigIntegerArray3[var11_23]);
            ++var11_23;
        }
        return object2;
    }

    public static BigInteger branchingFactorByResourceUsageFast(GameState gameState, int n) throws Exception {
        int n2 = gameState.getPlayer(n).getResources();
        BigInteger[] bigIntegerArray = BranchingFactorCalculatorBigInteger.branchingFactorByResourceUsageFastInternal(gameState, n);
        BigInteger bigInteger = BigInteger.ZERO;
        for (int j = 0; j < n2 + 1; ++j) {
            bigInteger = bigInteger.add(bigIntegerArray[j]);
        }
        return bigInteger;
    }

    public static BigInteger[] branchingFactorByResourceUsageFastInternal(GameState gameState, int n) throws Exception {
        BigInteger[] bigIntegerArray;
        int n2;
        GameState gameState2 = gameState.clone();
        PhysicalGameState physicalGameState = gameState2.getPhysicalGameState();
        int n3 = gameState2.getPlayer(n).getResources();
        LinkedList<Unit> linkedList = new LinkedList<Unit>();
        LinkedList<Unit> linkedList2 = new LinkedList<Unit>();
        LinkedList<Object> linkedList3 = new LinkedList<Object>();
        PlayerAction playerAction = new PlayerAction();
        for (Unit object : gameState2.getUnits()) {
            Object object2;
            Object object3;
            int n4;
            Object object4;
            if (object.getPlayer() != n || gameState2.getUnitAction(object) != null) continue;
            HashSet<Integer> hashSet = new HashSet<Integer>();
            int n5 = 0;
            for (Unit unit : gameState2.getUnits()) {
                if (unit == object || unit.getPlayer() != n || gameState2.getUnitAction(unit) != null) continue;
                object4 = unit.getUnitActions(gameState2);
                n4 = 0;
                object3 = object4.iterator();
                while (object3.hasNext()) {
                    object2 = (UnitAction)object3.next();
                    ResourceUsage resourceUsage = ((UnitAction)object2).resourceUsage(unit, physicalGameState);
                    hashSet.addAll(resourceUsage.getPositionsUsed());
                    n4 = Math.max(n4, resourceUsage.getResourcesUsed(n));
                }
                n5 += n4;
            }
            if (DEBUG >= 1) {
                System.out.println("- " + object + " --------");
            }
            List<UnitAction> list = object.getUnitActions(gameState2);
            n2 = 0;
            object4 = new BigInteger[n3 + 1];
            for (n4 = 0; n4 < n3 + 1; ++n4) {
                object4[n4] = BigInteger.ZERO;
            }
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                object3 = (UnitAction)iterator.next();
                object2 = ((UnitAction)object3).resourceUsage(object, physicalGameState);
                int n6 = ((ResourceUsage)object2).getResourcesUsed(n);
                object4[n6] = ((BigInteger)object4[n6]).add(BigInteger.ONE);
                for (Integer n7 : ((ResourceUsage)object2).getPositionsUsed()) {
                    if (!hashSet.contains(n7)) continue;
                    n2 = 1;
                }
            }
            if (n2 == 0) {
                linkedList2.add(object);
                linkedList3.add(object4);
                playerAction.addUnitAction(object, new UnitAction(0));
                if (DEBUG < 1) continue;
                System.out.println("  *** Separating unit " + object);
                continue;
            }
            linkedList.add(object);
        }
        gameState2.issue(playerAction);
        if (!linkedList.isEmpty()) {
            bigIntegerArray = BranchingFactorCalculatorBigInteger.branchingFactorByResourceUsage(gameState2, n);
            linkedList3.add(bigIntegerArray);
        }
        bigIntegerArray = (BigInteger[])linkedList3.remove(0);
        for (BigInteger[] bigIntegerArray2 : linkedList3) {
            int n8;
            BigInteger[] bigIntegerArray3 = new BigInteger[n3 + 1];
            for (n8 = 0; n8 < n3 + 1; ++n8) {
                bigIntegerArray3[n8] = BigInteger.ZERO;
            }
            for (n8 = 0; n8 < n3 + 1; ++n8) {
                for (n2 = 0; n2 < n3 - n8 + 1; ++n2) {
                    bigIntegerArray3[n8 + n2] = bigIntegerArray3[n8 + n2].add(bigIntegerArray2[n8].multiply(bigIntegerArray[n2]));
                }
            }
            bigIntegerArray = bigIntegerArray3;
        }
        return bigIntegerArray;
    }
}

