/*
 * Decompiled with CFR 0.152.
 */
package ai;

import java.util.AbstractCollection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import rts.GameState;
import rts.PhysicalGameState;
import rts.PlayerAction;
import rts.PlayerActionGenerator;
import rts.ResourceUsage;
import rts.UnitAction;
import rts.units.Unit;
import util.Pair;

public class BranchingFactorCalculatorDouble {
    public static int DEBUG = 0;

    public static double branchingFactorUpperBound(GameState gameState, int n) throws Exception {
        PlayerActionGenerator playerActionGenerator = new PlayerActionGenerator(gameState, n);
        return playerActionGenerator.getSize();
    }

    public static double branchingFactor(GameState gameState, int n) throws Exception {
        double d = 0.0;
        PlayerActionGenerator playerActionGenerator = new PlayerActionGenerator(gameState, n);
        while (playerActionGenerator.getNextAction(-1L) != null) {
            d += 1.0;
        }
        return d;
    }

    public static double[] branchingFactorByResourceUsage(GameState gameState, int n) throws Exception {
        double[] dArray = new double[gameState.getPlayer(n).getResources() + 1];
        PlayerActionGenerator playerActionGenerator = new PlayerActionGenerator(gameState, n);
        PlayerAction playerAction = null;
        do {
            if ((playerAction = playerActionGenerator.getNextAction(-1L)) == null) continue;
            int n2 = 0;
            for (Pair<Unit, UnitAction> pair : playerAction.getActions()) {
                n2 += ((UnitAction)pair.m_b).resourceUsage((Unit)pair.m_a, gameState.getPhysicalGameState()).getResourcesUsed(n);
            }
            int n3 = n2;
            dArray[n3] = dArray[n3] + 1.0;
        } while (playerAction != null);
        return dArray;
    }

    public static void addFootPrint(int[][] nArray, int n, int n2, int n3) {
        if (nArray[n2][n3] == 0) {
            nArray[n2][n3] = n;
        } else {
            int n4 = nArray[n2][n3];
            LinkedList<Integer> linkedList = new LinkedList<Integer>();
            LinkedList<Integer> linkedList2 = new LinkedList<Integer>();
            linkedList.add(n2);
            linkedList2.add(n3);
            while (!linkedList.isEmpty()) {
                n2 = (Integer)linkedList.remove(0);
                if (nArray[n2][n3 = ((Integer)linkedList2.remove(0)).intValue()] == n) continue;
                nArray[n2][n3] = n;
                if (n2 > 0 && nArray[n2 - 1][n3] == n4) {
                    linkedList.add(0, n2 - 1);
                    linkedList2.add(0, n3);
                }
                if (n2 < nArray.length - 1 && nArray[n2 + 1][n3] == n4) {
                    linkedList.add(0, n2 + 1);
                    linkedList2.add(0, n3);
                }
                if (n3 > 0 && nArray[n2][n3 - 1] == n4) {
                    linkedList.add(0, n2);
                    linkedList2.add(0, n3 - 1);
                }
                if (n3 >= nArray[0].length - 1 || nArray[n2][n3 + 1] != n4) continue;
                linkedList.add(0, n2);
                linkedList2.add(0, n3 + 1);
            }
        }
    }

    public static double branchingFactorByResourceUsageSeparatingFast(GameState gameState, int n) throws Exception {
        Object object;
        Object object2;
        int n2 = gameState.getPlayer(n).getResources();
        GameState gameState2 = gameState.clone();
        PhysicalGameState physicalGameState = gameState2.getPhysicalGameState();
        int[][] nArray = new int[physicalGameState.getWidth()][physicalGameState.getHeight()];
        int n3 = 1;
        for (Unit unit : gameState2.getUnits()) {
            if (unit.getPlayer() != n || gameState2.getUnitAction(unit) != null) continue;
            List<UnitAction> list = unit.getUnitActions(gameState2);
            BranchingFactorCalculatorDouble.addFootPrint(nArray, n3, unit.getX(), unit.getY());
            for (UnitAction object32 : list) {
                object2 = object32.resourceUsage(unit, gameState2.getPhysicalGameState());
                object = ((ResourceUsage)object2).getPositionsUsed().iterator();
                while (object.hasNext()) {
                    int n4 = (Integer)object.next();
                    int n5 = n4 % physicalGameState.getWidth();
                    int n6 = n4 / physicalGameState.getWidth();
                    BranchingFactorCalculatorDouble.addFootPrint(nArray, n3, n5, n6);
                }
            }
            ++n3;
        }
        LinkedList linkedList = new LinkedList();
        for (int j = 0; j < physicalGameState.getHeight(); ++j) {
            for (int k = 0; k < physicalGameState.getWidth(); ++k) {
                if (nArray[k][j] == 0 || linkedList.contains(nArray[k][j])) continue;
                linkedList.add(nArray[k][j]);
            }
        }
        LinkedList<double[]> linkedList2 = new LinkedList<double[]>();
        Object object4 = linkedList.iterator();
        while (object4.hasNext()) {
            int n7 = (Integer)object4.next();
            PlayerAction playerAction = new PlayerAction();
            object2 = new LinkedList();
            object = new LinkedList();
            for (Unit unit : gameState2.getUnits()) {
                if (unit.getPlayer() != n || gameState2.getUnitAction(unit) != null) continue;
                if (nArray[unit.getX()][unit.getY()] == n7) {
                    object2.add(unit);
                    continue;
                }
                object.add(unit);
                playerAction.addUnitAction(unit, new UnitAction(0));
            }
            GameState gameState3 = gameState2.cloneIssue(playerAction).clone();
            double[] dArray = BranchingFactorCalculatorDouble.branchingFactorByResourceUsageFastInternal(gameState3, n);
            linkedList2.add(dArray);
        }
        if (linkedList2.isEmpty()) {
            return 1.0;
        }
        object4 = (double[])linkedList2.remove(0);
        for (double[] dArray : linkedList2) {
            object2 = new double[n2 + 1];
            for (int j = 0; j < n2 + 1; ++j) {
                for (int k = 0; k < n2 - j + 1; ++k) {
                    Object object3 = object2;
                    int n7 = j + k;
                    object3[n7] = object3[n7] + dArray[j] * object4[k];
                }
            }
            object4 = object2;
        }
        double d = 0.0;
        for (int j = 0; j < n2 + 1; ++j) {
            d += object4[j];
        }
        return d;
    }

    public static double branchingFactorByResourceUsageFast(GameState gameState, int n) throws Exception {
        int n2 = gameState.getPlayer(n).getResources();
        double[] dArray = BranchingFactorCalculatorDouble.branchingFactorByResourceUsageFastInternal(gameState, n);
        double d = 0.0;
        for (int j = 0; j < n2 + 1; ++j) {
            d += dArray[j];
        }
        return d;
    }

    public static double[] branchingFactorByResourceUsageFastInternal(GameState gameState, int n) throws Exception {
        Object object;
        int unit;
        Object object2;
        GameState gameState2 = gameState.clone();
        PhysicalGameState physicalGameState = gameState2.getPhysicalGameState();
        int n3 = gameState2.getPlayer(n).getResources();
        LinkedList<Unit> linkedList = new LinkedList<Unit>();
        LinkedList<Unit> linkedList2 = new LinkedList<Unit>();
        LinkedList<Object> linkedList3 = new LinkedList<Object>();
        PlayerAction playerAction = new PlayerAction();
        for (Unit object32 : gameState2.getUnits()) {
            Object object3;
            Object object4;
            Object object5;
            if (object32.getPlayer() != n || gameState2.getUnitAction(object32) != null) continue;
            object2 = new HashSet();
            int n2 = 0;
            for (Unit unit2 : gameState2.getUnits()) {
                if (unit2 == object32 || unit2.getPlayer() != n || gameState2.getUnitAction(unit2) != null) continue;
                object5 = unit2.getUnitActions(gameState2);
                int n4 = 0;
                object4 = object5.iterator();
                while (object4.hasNext()) {
                    object3 = (UnitAction)object4.next();
                    ResourceUsage resourceUsage = ((UnitAction)object3).resourceUsage(unit2, physicalGameState);
                    ((AbstractCollection)object2).addAll(resourceUsage.getPositionsUsed());
                    n4 = Math.max(n4, resourceUsage.getResourcesUsed(n));
                }
                n2 += n4;
            }
            if (DEBUG >= 1) {
                System.out.println("- " + object32 + " --------");
            }
            List<UnitAction> list = object32.getUnitActions(gameState2);
            unit = 0;
            object5 = new double[n3 + 1];
            Iterator n5 = list.iterator();
            while (n5.hasNext()) {
                object4 = (UnitAction)n5.next();
                object3 = ((UnitAction)object4).resourceUsage(object32, physicalGameState);
                Object object6 = object5;
                int n6 = ((ResourceUsage)object3).getResourcesUsed(n);
                object6[n6] = object6[n6] + 1.0;
                for (Integer n7 : ((ResourceUsage)object3).getPositionsUsed()) {
                    if (!((HashSet)object2).contains(n7)) continue;
                    unit = 1;
                }
            }
            if (unit == 0) {
                linkedList2.add(object32);
                linkedList3.add(object5);
                playerAction.addUnitAction(object32, new UnitAction(0));
                if (DEBUG < 1) continue;
                System.out.println("  *** Separating unit " + object32);
                continue;
            }
            linkedList.add(object32);
        }
        gameState2.issue(playerAction);
        if (!linkedList.isEmpty()) {
            object = BranchingFactorCalculatorDouble.branchingFactorByResourceUsage(gameState2, n);
            linkedList3.add(object);
        }
        object = (double[])linkedList3.remove(0);
        Iterator iterator = linkedList3.iterator();
        while (iterator.hasNext()) {
            object2 = (double[])iterator.next();
            double[] dArray = new double[n3 + 1];
            for (int j = 0; j < n3 + 1; ++j) {
                for (unit = 0; unit < n3 - j + 1; ++unit) {
                    int n8 = j + unit;
                    dArray[n8] = dArray[n8] + object2[j] * object[unit];
                }
            }
            object = dArray;
        }
        return object;
    }
}

