/*
 * Decompiled with CFR 0.152.
 */
package ai;

import ai.core.AI;
import ai.core.ParameterSpecification;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import rts.GameState;
import rts.PhysicalGameState;
import rts.PlayerAction;
import rts.ResourceUsage;
import rts.UnitAction;
import rts.UnitActionAssignment;
import rts.units.Unit;
import rts.units.UnitTypeTable;
import util.Sampler;

public class RandomBiasedAI
extends AI {
    static final double REGULAR_ACTION_WEIGHT = 1.0;
    static final double BIASED_ACTION_WEIGHT = 5.0;
    Random r = new Random();

    public RandomBiasedAI(UnitTypeTable unitTypeTable) {
    }

    public RandomBiasedAI() {
    }

    @Override
    public void reset() {
    }

    @Override
    public AI clone() {
        return new RandomBiasedAI();
    }

    @Override
    public PlayerAction getAction(int n, GameState gameState) {
        Object object;
        Object object2;
        PhysicalGameState physicalGameState = gameState.getPhysicalGameState();
        PlayerAction playerAction = new PlayerAction();
        if (!gameState.canExecuteAnyAction(n)) {
            return playerAction;
        }
        for (Unit unit : physicalGameState.getUnits()) {
            object2 = gameState.getActionAssignment(unit);
            if (object2 == null) continue;
            object = ((UnitActionAssignment)object2).action.resourceUsage(unit, physicalGameState);
            playerAction.getResourceUsage().merge((ResourceUsage)object);
        }
        for (Unit unit : physicalGameState.getUnits()) {
            Object object3;
            if (unit.getPlayer() != n || gameState.getActionAssignment(unit) != null) continue;
            object2 = unit.getUnitActions(gameState);
            object = null;
            int n2 = object2.size();
            double[] dArray = new double[n2];
            int n3 = 0;
            Object object4 = object2.iterator();
            while (object4.hasNext()) {
                object3 = (UnitAction)object4.next();
                if (((UnitAction)object3).getType() == 0) {
                    object = object3;
                }
                dArray[n3] = ((UnitAction)object3).getType() == 5 || ((UnitAction)object3).getType() == 2 || ((UnitAction)object3).getType() == 3 ? 5.0 : 1.0;
                ++n3;
            }
            try {
                object4 = (UnitAction)object2.get(Sampler.weighted(dArray));
                if (((UnitAction)object4).resourceUsage(unit, physicalGameState).consistentWith(playerAction.getResourceUsage(), gameState)) {
                    object3 = ((UnitAction)object4).resourceUsage(unit, physicalGameState);
                    playerAction.getResourceUsage().merge((ResourceUsage)object3);
                    playerAction.addUnitAction(unit, (UnitAction)object4);
                    continue;
                }
                playerAction.addUnitAction(unit, (UnitAction)object);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                playerAction.addUnitAction(unit, (UnitAction)object);
            }
        }
        return playerAction;
    }

    @Override
    public List<ParameterSpecification> getParameters() {
        return new ArrayList<ParameterSpecification>();
    }
}

