/*
 * Decompiled with CFR 0.152.
 */
package ai;

import ai.core.AI;
import ai.core.ParameterSpecification;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import rts.GameState;
import rts.PhysicalGameState;
import rts.PlayerAction;
import rts.ResourceUsage;
import rts.UnitAction;
import rts.UnitActionAssignment;
import rts.units.Unit;
import rts.units.UnitTypeTable;
import util.Sampler;

public class RandomBiasedSingleUnitAI
extends AI {
    static final double REGULAR_ACTION_WEIGHT = 1.0;
    static final double BIASED_ACTION_WEIGHT = 5.0;
    Random r = new Random();

    public RandomBiasedSingleUnitAI(UnitTypeTable unitTypeTable) {
    }

    public RandomBiasedSingleUnitAI() {
    }

    @Override
    public void reset() {
    }

    @Override
    public AI clone() {
        return new RandomBiasedSingleUnitAI();
    }

    @Override
    public PlayerAction getAction(int n, GameState gameState) {
        Object object;
        PhysicalGameState physicalGameState = gameState.getPhysicalGameState();
        PlayerAction playerAction = new PlayerAction();
        if (!gameState.canExecuteAnyAction(n)) {
            return playerAction;
        }
        for (Unit object3 : physicalGameState.getUnits()) {
            UnitActionAssignment unitActionAssignment = gameState.getActionAssignment(object3);
            if (unitActionAssignment == null) continue;
            object = unitActionAssignment.action.resourceUsage(object3, physicalGameState);
            playerAction.getResourceUsage().merge((ResourceUsage)object);
        }
        ArrayList arrayList = new ArrayList();
        for (Unit unit : physicalGameState.getUnits()) {
            if (unit.getPlayer() != n || gameState.getActionAssignment(unit) != null) continue;
            arrayList.add(unit);
        }
        if (!arrayList.isEmpty()) {
            Unit unit = (Unit)arrayList.get(this.r.nextInt(arrayList.size()));
            List<UnitAction> list = unit.getUnitActions(gameState);
            object = null;
            int n2 = list.size();
            double[] dArray = new double[n2];
            int n3 = 0;
            for (Object object2 : list) {
                if (((UnitAction)object2).getType() == 0) {
                    object = object2;
                }
                dArray[n3] = ((UnitAction)object2).getType() == 5 || ((UnitAction)object2).getType() == 2 || ((UnitAction)object2).getType() == 3 ? 5.0 : 1.0;
                ++n3;
            }
            try {
                UnitAction unitAction = list.get(Sampler.weighted(dArray));
                if (unitAction.resourceUsage(unit, physicalGameState).consistentWith(playerAction.getResourceUsage(), gameState)) {
                    Object object2;
                    object2 = unitAction.resourceUsage(unit, physicalGameState);
                    playerAction.getResourceUsage().merge((ResourceUsage)object2);
                    playerAction.addUnitAction(unit, unitAction);
                } else {
                    playerAction.addUnitAction(unit, (UnitAction)object);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                playerAction.addUnitAction(unit, (UnitAction)object);
            }
        }
        playerAction.fillWithNones(gameState, n, 10);
        return playerAction;
    }

    @Override
    public List<ParameterSpecification> getParameters() {
        return new ArrayList<ParameterSpecification>();
    }
}

