/*
 * Decompiled with CFR 0.152.
 */
package ai;

import ai.core.AI;
import ai.core.ParameterSpecification;
import ai.evaluation.SimpleEvaluationFunction;
import ai.socket.SocketAIInterface;
import gui.PhysicalGameStateJFrame;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import rts.GameState;
import rts.PhysicalGameState;
import rts.PlayerAction;
import rts.ResourceUsage;
import rts.UnitAction;
import rts.UnitActionAssignment;
import rts.units.Unit;
import util.Sampler;

public class RandomNoAttackAI
extends AI
implements SocketAIInterface {
    static final double REGULAR_ACTION_WEIGHT = 1.0;
    static final double BIASED_ACTION_WEIGHT = 0.0;
    int currentStep = 0;
    int episodeLenght = 2000;
    int totalTimestep = 10000;
    boolean reset = false;
    boolean finished = false;
    int seed;
    double reward = 0.0;
    double oldReward = 0.0;
    boolean firstRewardCalculation = true;
    Random r;
    SimpleEvaluationFunction ef = new SimpleEvaluationFunction();

    public RandomNoAttackAI(int n) {
        this.seed = n;
        this.r = new Random(this.seed);
    }

    @Override
    public void reset() {
        this.reset = false;
        this.finished = false;
    }

    @Override
    public AI clone() {
        return new RandomNoAttackAI(this.seed);
    }

    @Override
    public void connectToServer(boolean bl) throws Exception {
    }

    public void gameOver(int n, GameState gameState) throws Exception {
    }

    @Override
    public void computeReward(int n, int n2, GameState gameState) throws Exception {
        if (this.firstRewardCalculation) {
            this.oldReward = this.ef.evaluate(n, n2, gameState);
            this.reward = 0.0;
            this.firstRewardCalculation = false;
        } else {
            double d = this.ef.evaluate(n, n2, gameState);
            this.reward = d - this.oldReward;
            this.oldReward = d;
        }
    }

    @Override
    public PlayerAction getAction(int n, GameState gameState) {
        Object object;
        Object object2;
        PhysicalGameState physicalGameState = gameState.getPhysicalGameState();
        PlayerAction playerAction = new PlayerAction();
        ++this.currentStep;
        if (this.currentStep % this.episodeLenght == 0) {
            this.reset = true;
        }
        if (this.currentStep == this.totalTimestep) {
            this.reset = true;
            this.finished = true;
        }
        if (!gameState.canExecuteAnyAction(n)) {
            return playerAction;
        }
        for (Unit unit : physicalGameState.getUnits()) {
            object2 = gameState.getActionAssignment(unit);
            if (object2 == null) continue;
            object = ((UnitActionAssignment)object2).action.resourceUsage(unit, physicalGameState);
            playerAction.getResourceUsage().merge((ResourceUsage)object);
        }
        for (Unit unit : physicalGameState.getUnits()) {
            Object object3;
            if (unit.getPlayer() != n || gameState.getActionAssignment(unit) != null) continue;
            object2 = unit.getUnitActions(gameState);
            object = null;
            int n2 = object2.size();
            double[] dArray = new double[n2];
            int n3 = 0;
            Object object4 = object2.iterator();
            while (object4.hasNext()) {
                object3 = (UnitAction)object4.next();
                if (((UnitAction)object3).getType() == 0) {
                    object = object3;
                }
                dArray[n3] = ((UnitAction)object3).getType() == 5 || ((UnitAction)object3).getType() == 4 ? 0.0 : 1.0;
                ++n3;
            }
            try {
                object4 = (UnitAction)object2.get(Sampler.weighted(dArray));
                if (((UnitAction)object4).resourceUsage(unit, physicalGameState).consistentWith(playerAction.getResourceUsage(), gameState)) {
                    object3 = ((UnitAction)object4).resourceUsage(unit, physicalGameState);
                    playerAction.getResourceUsage().merge((ResourceUsage)object3);
                    playerAction.addUnitAction(unit, (UnitAction)object4);
                    continue;
                }
                playerAction.addUnitAction(unit, (UnitAction)object);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                playerAction.addUnitAction(unit, (UnitAction)object);
            }
        }
        return playerAction;
    }

    @Override
    public List<ParameterSpecification> getParameters() {
        return new ArrayList<ParameterSpecification>();
    }

    @Override
    public boolean getReset() {
        return this.reset;
    }

    @Override
    public boolean getFinished() {
        return this.finished;
    }

    @Override
    public double getReward() {
        return this.reward;
    }

    @Override
    public boolean getRender() {
        return false;
    }

    @Override
    public void sendGameStateRGBArray(PhysicalGameStateJFrame physicalGameStateJFrame) {
    }
}

