/*
 * Decompiled with CFR 0.152.
 */
package ai.abstraction;

import ai.abstraction.Attack;
import ai.abstraction.Build;
import ai.abstraction.Harvest;
import ai.abstraction.Idle;
import ai.abstraction.Move;
import ai.abstraction.Train;
import ai.abstraction.pathfinding.AStarPathFinding;
import ai.abstraction.pathfinding.BFSPathFinding;
import ai.abstraction.pathfinding.FloodFillPathFinding;
import ai.abstraction.pathfinding.GreedyPathFinding;
import ai.abstraction.pathfinding.PathFinding;
import org.jdom.Element;
import rts.GameState;
import rts.PhysicalGameState;
import rts.ResourceUsage;
import rts.UnitAction;
import rts.units.Unit;
import rts.units.UnitTypeTable;
import util.XMLWriter;

public abstract class AbstractAction {
    Unit unit;

    public AbstractAction(Unit unit) {
        this.unit = unit;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    public abstract boolean completed(GameState var1);

    public UnitAction execute(GameState gameState) {
        return this.execute(gameState, null);
    }

    public abstract void toxml(XMLWriter var1);

    public static AbstractAction fromXML(Element element, PhysicalGameState physicalGameState, UnitTypeTable unitTypeTable) {
        PathFinding pathFinding = null;
        String string = element.getAttributeValue("pathfinding");
        if (string != null) {
            if (string.equals("AStarPathFinding")) {
                pathFinding = new AStarPathFinding();
            }
            if (string.equals("BFSPathFinding")) {
                pathFinding = new BFSPathFinding();
            }
            if (string.equals("FloodFillPathFinding")) {
                pathFinding = new FloodFillPathFinding();
            }
            if (string.equals("GreedyPathFinding")) {
                pathFinding = new GreedyPathFinding();
            }
        }
        switch (element.getName()) {
            case "Attack": {
                return new Attack(physicalGameState.getUnit(Long.parseLong(element.getAttributeValue("unitID"))), physicalGameState.getUnit(Long.parseLong(element.getAttributeValue("target"))), pathFinding);
            }
            case "Build": {
                return new Build(physicalGameState.getUnit(Long.parseLong(element.getAttributeValue("unitID"))), unitTypeTable.getUnitType(element.getAttributeValue("type")), Integer.parseInt(element.getAttributeValue("x")), Integer.parseInt(element.getAttributeValue("y")), pathFinding);
            }
            case "Harvest": {
                return new Harvest(physicalGameState.getUnit(Long.parseLong(element.getAttributeValue("unitID"))), physicalGameState.getUnit(Long.parseLong(element.getAttributeValue("target"))), physicalGameState.getUnit(Long.parseLong(element.getAttributeValue("base"))), pathFinding);
            }
            case "Idle": {
                return new Idle(physicalGameState.getUnit(Long.parseLong(element.getAttributeValue("unitID"))));
            }
            case "Move": {
                return new Move(physicalGameState.getUnit(Long.parseLong(element.getAttributeValue("unitID"))), Integer.parseInt(element.getAttributeValue("x")), Integer.parseInt(element.getAttributeValue("y")), pathFinding);
            }
            case "Train": {
                return new Train(physicalGameState.getUnit(Long.parseLong(element.getAttributeValue("unitID"))), unitTypeTable.getUnitType(element.getAttributeValue("type")));
            }
        }
        return null;
    }

    public abstract UnitAction execute(GameState var1, ResourceUsage var2);
}

