/*
 * Decompiled with CFR 0.152.
 */
package ai.abstraction;

import ai.abstraction.AbstractAction;
import ai.abstraction.AbstractTraceEntry;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.jdom.Element;
import rts.units.Unit;
import rts.units.UnitTypeTable;
import util.XMLWriter;

public class AbstractTrace {
    UnitTypeTable utt = null;
    List<AbstractTraceEntry> entries = new LinkedList<AbstractTraceEntry>();
    protected HashMap<Unit, AbstractAction> currentActions = new LinkedHashMap<Unit, AbstractAction>();

    public AbstractTrace(UnitTypeTable unitTypeTable) {
        this.utt = unitTypeTable;
    }

    public List<AbstractTraceEntry> getEntries() {
        return this.entries;
    }

    public UnitTypeTable getUnitTypeTable() {
        return this.utt;
    }

    public int getLength() {
        return this.entries.get(this.entries.size() - 1).getTime();
    }

    public void addEntry(AbstractTraceEntry abstractTraceEntry) {
        this.entries.add(abstractTraceEntry);
    }

    public AbstractAction getCurrentAbstractAction(Unit unit) {
        return this.currentActions.get(unit);
    }

    public AbstractAction setCurrentAbstractAction(Unit unit, AbstractAction abstractAction) {
        return this.currentActions.put(unit, abstractAction);
    }

    public void toxml(XMLWriter xMLWriter) {
        xMLWriter.tag(this.getClass().getName());
        this.utt.toxml(xMLWriter);
        xMLWriter.tag("entries");
        for (AbstractTraceEntry abstractTraceEntry : this.entries) {
            abstractTraceEntry.toxml(xMLWriter);
        }
        xMLWriter.tag("/entries");
        xMLWriter.tag("/" + this.getClass().getName());
    }

    public AbstractTrace(Element element) throws Exception {
        this.utt = UnitTypeTable.fromXML(element.getChild(UnitTypeTable.class.getName()));
        Element element2 = element.getChild("entries");
        for (Object e : element2.getChildren()) {
            Element element3 = (Element)e;
            this.entries.add(new AbstractTraceEntry(element3, this.utt));
        }
    }

    public AbstractTrace(Element element, UnitTypeTable unitTypeTable) throws Exception {
        this.utt = unitTypeTable;
        Element element2 = element.getChild("entries");
        for (Object e : element2.getChildren()) {
            Element element3 = (Element)e;
            this.entries.add(new AbstractTraceEntry(element3, this.utt));
        }
    }
}

