/*
 * Decompiled with CFR 0.152.
 */
package ai.abstraction;

import ai.abstraction.AbstractAction;
import ai.abstraction.AbstractTrace;
import ai.abstraction.Train;
import java.util.LinkedList;
import java.util.List;
import org.jdom.Element;
import rts.PhysicalGameState;
import rts.units.Unit;
import rts.units.UnitTypeTable;
import util.Pair;
import util.XMLWriter;

public class AbstractTraceEntry {
    int time;
    PhysicalGameState pgs = null;
    List<Pair<Unit, AbstractAction>> actions = new LinkedList<Pair<Unit, AbstractAction>>();

    public AbstractTraceEntry(PhysicalGameState physicalGameState, int n) {
        this.pgs = physicalGameState;
        this.time = n;
    }

    public void addAbstractAction(Unit unit, AbstractAction abstractAction) {
        this.actions.add(new Pair<Unit, AbstractAction>(unit, abstractAction));
    }

    public void addAbstractActionIfNew(Unit unit, AbstractAction abstractAction, AbstractTrace abstractTrace) {
        if (!abstractAction.equals(abstractTrace.getCurrentAbstractAction(unit))) {
            this.addAbstractAction(unit, abstractAction);
            abstractTrace.setCurrentAbstractAction(unit, abstractAction);
        } else if (abstractAction instanceof Train) {
            this.addAbstractAction(unit, abstractAction);
            abstractTrace.setCurrentAbstractAction(unit, abstractAction);
        }
    }

    public PhysicalGameState getPhysicalGameState() {
        return this.pgs;
    }

    public List<Pair<Unit, AbstractAction>> getActions() {
        return this.actions;
    }

    public int getTime() {
        return this.time;
    }

    public void toxml(XMLWriter xMLWriter) {
        xMLWriter.tagWithAttributes(this.getClass().getName(), "time = \"" + this.time + "\"");
        this.pgs.toxml(xMLWriter);
        xMLWriter.tag("abstractactions");
        for (Pair<Unit, AbstractAction> pair : this.actions) {
            xMLWriter.tagWithAttributes("abstractaction", "unitID=\"" + ((Unit)pair.m_a).getID() + "\"");
            ((AbstractAction)pair.m_b).toxml(xMLWriter);
            xMLWriter.tag("/abstractaction");
        }
        xMLWriter.tag("/abstractactions");
        xMLWriter.tag("/" + this.getClass().getName());
    }

    public AbstractTraceEntry(Element element, UnitTypeTable unitTypeTable) throws Exception {
        Element element2 = element.getChild("abstractactions");
        this.time = Integer.parseInt(element.getAttributeValue("time"));
        Element element3 = element.getChild(PhysicalGameState.class.getName());
        this.pgs = PhysicalGameState.fromXML(element3, unitTypeTable);
        for (Object e : element2.getChildren()) {
            Element element4 = (Element)e;
            long l = Long.parseLong(element4.getAttributeValue("unitID"));
            AbstractAction abstractAction = AbstractAction.fromXML(element4.getChild("abstractaction"), this.pgs, unitTypeTable);
            Unit unit = this.pgs.getUnit(l);
            this.actions.add(new Pair<Unit, AbstractAction>(unit, abstractAction));
        }
    }
}

