/*
 * Decompiled with CFR 0.152.
 */
package ai.abstraction;

import ai.abstraction.AbstractAction;
import ai.abstraction.Attack;
import ai.abstraction.Build;
import ai.abstraction.Harvest;
import ai.abstraction.Idle;
import ai.abstraction.Move;
import ai.abstraction.Train;
import ai.abstraction.pathfinding.PathFinding;
import ai.core.AIWithComputationBudget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import rts.GameState;
import rts.PhysicalGameState;
import rts.Player;
import rts.PlayerAction;
import rts.ResourceUsage;
import rts.UnitAction;
import rts.units.Unit;
import rts.units.UnitType;
import util.Pair;

public abstract class AbstractionLayerAI
extends AIWithComputationBudget {
    public static boolean VERIFY_ACTION_CORRECTNESS = false;
    protected HashMap<Unit, AbstractAction> actions = new LinkedHashMap<Unit, AbstractAction>();
    protected PathFinding pf = null;
    protected GameState lastGameState = null;

    public AbstractionLayerAI(PathFinding pathFinding) {
        super(-1, -1);
        this.pf = pathFinding;
    }

    public AbstractionLayerAI(PathFinding pathFinding, int n, int n2) {
        super(n, n2);
        this.pf = pathFinding;
    }

    @Override
    public void reset() {
        this.actions.clear();
    }

    public PlayerAction translateActions(int n, GameState gameState) {
        Object object;
        PhysicalGameState physicalGameState = gameState.getPhysicalGameState();
        PlayerAction playerAction = new PlayerAction();
        ArrayList<Pair<Unit, UnitAction>> arrayList = new ArrayList<Pair<Unit, UnitAction>>();
        this.lastGameState = gameState;
        ArrayList<Unit> arrayList2 = new ArrayList<Unit>();
        ResourceUsage resourceUsage = new ResourceUsage();
        for (AbstractAction iterator : this.actions.values()) {
            UnitAction unitAction;
            if (!physicalGameState.getUnits().contains(iterator.unit)) {
                arrayList2.add(iterator.unit);
                continue;
            }
            if (iterator.completed(gameState)) {
                arrayList2.add(iterator.unit);
                continue;
            }
            if (gameState.getActionAssignment(iterator.unit) != null || (unitAction = iterator.execute(gameState, resourceUsage)) == null) continue;
            if (VERIFY_ACTION_CORRECTNESS) {
                object = iterator.unit.getUnitActions(gameState);
                if (object.contains(unitAction)) {
                    arrayList.add(new Pair<Unit, UnitAction>(iterator.unit, unitAction));
                }
            } else {
                arrayList.add(new Pair<Unit, UnitAction>(iterator.unit, unitAction));
            }
            resourceUsage.merge(unitAction.resourceUsage(iterator.unit, physicalGameState));
        }
        for (Unit unit : arrayList2) {
            this.actions.remove(unit);
        }
        ResourceUsage resourceUsage2 = gameState.getResourceUsage();
        playerAction.setResourceUsage(resourceUsage2);
        for (Pair pair : arrayList) {
            object = ((UnitAction)pair.m_b).resourceUsage((Unit)pair.m_a, physicalGameState);
            if (!playerAction.consistentWith((ResourceUsage)object, gameState)) continue;
            playerAction.addUnitAction((Unit)pair.m_a, (UnitAction)pair.m_b);
            playerAction.getResourceUsage().merge((ResourceUsage)object);
        }
        playerAction.fillWithNones(gameState, n, 10);
        return playerAction;
    }

    public AbstractAction getAbstractAction(Unit unit) {
        return this.actions.get(unit);
    }

    public void move(Unit unit, int n, int n2) {
        this.actions.put(unit, new Move(unit, n, n2, this.pf));
    }

    public void train(Unit unit, UnitType unitType) {
        this.actions.put(unit, new Train(unit, unitType));
    }

    public void build(Unit unit, UnitType unitType, int n, int n2) {
        this.actions.put(unit, new Build(unit, unitType, n, n2, this.pf));
    }

    public void harvest(Unit unit, Unit unit2, Unit unit3) {
        this.actions.put(unit, new Harvest(unit, unit2, unit3, this.pf));
    }

    public void attack(Unit unit, Unit unit2) {
        this.actions.put(unit, new Attack(unit, unit2, this.pf));
    }

    public void idle(Unit unit) {
        this.actions.put(unit, new Idle(unit));
    }

    public int findBuildingPosition(List<Integer> list, int n, int n2, Player player, PhysicalGameState physicalGameState) {
        boolean[][] blArray = physicalGameState.getAllFree();
        for (int j = 1; j < Math.max(physicalGameState.getHeight(), physicalGameState.getWidth()); ++j) {
            block7: for (int k = 0; k < 4; ++k) {
                switch (k) {
                    case 0: {
                        int n3;
                        int n4;
                        int n5;
                        int n6 = n2 - j;
                        if (n6 < 0) continue block7;
                        for (n5 = -j; n5 <= j; ++n5) {
                            n4 = n + n5;
                            if (n4 < 0 || n4 >= physicalGameState.getWidth() || list.contains(n3 = n4 + n6 * physicalGameState.getWidth()) || !blArray[n4][n6]) continue;
                            return n3;
                        }
                        continue block7;
                    }
                    case 1: {
                        int n3;
                        int n5;
                        int n6;
                        int n4 = n + j;
                        if (n4 >= physicalGameState.getWidth()) continue block7;
                        for (n5 = -j; n5 <= j; ++n5) {
                            n6 = n2 + n5;
                            if (n6 < 0 || n6 >= physicalGameState.getHeight() || list.contains(n3 = n4 + n6 * physicalGameState.getWidth()) || !blArray[n4][n6]) continue;
                            return n3;
                        }
                        continue block7;
                    }
                    case 2: {
                        int n3;
                        int n4;
                        int n5;
                        int n6 = n2 + j;
                        if (n6 >= physicalGameState.getHeight()) continue block7;
                        for (n5 = -j; n5 <= j; ++n5) {
                            n4 = n + n5;
                            if (n4 < 0 || n4 >= physicalGameState.getWidth() || list.contains(n3 = n4 + n6 * physicalGameState.getWidth()) || !blArray[n4][n6]) continue;
                            return n3;
                        }
                        continue block7;
                    }
                    case 3: {
                        int n3;
                        int n5;
                        int n6;
                        int n4 = n - j;
                        if (n4 < 0) continue block7;
                        for (n5 = -j; n5 <= j; ++n5) {
                            n6 = n2 + n5;
                            if (n6 < 0 || n6 >= physicalGameState.getHeight() || list.contains(n3 = n4 + n6 * physicalGameState.getWidth()) || !blArray[n4][n6]) continue;
                            return n3;
                        }
                        continue block7;
                    }
                }
            }
        }
        return -1;
    }

    public boolean buildIfNotAlreadyBuilding(Unit unit, UnitType unitType, int n, int n2, List<Integer> list, Player player, PhysicalGameState physicalGameState) {
        AbstractAction abstractAction = this.getAbstractAction(unit);
        if (!(abstractAction instanceof Build) || ((Build)abstractAction).type != unitType) {
            int n3 = this.findBuildingPosition(list, n, n2, player, physicalGameState);
            this.build(unit, unitType, n3 % physicalGameState.getWidth(), n3 / physicalGameState.getWidth());
            list.add(n3);
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.pf + ")";
    }

    public PathFinding getPathFinding() {
        return this.pf;
    }

    public void setPathFinding(PathFinding pathFinding) {
        this.pf = pathFinding;
    }
}

