/*
 * Decompiled with CFR 0.152.
 */
package ai.abstraction;

import ai.abstraction.AbstractAction;
import ai.abstraction.pathfinding.PathFinding;
import rts.GameState;
import rts.PhysicalGameState;
import rts.ResourceUsage;
import rts.UnitAction;
import rts.units.Unit;
import util.XMLWriter;

public class Attack
extends AbstractAction {
    Unit target;
    PathFinding pf;

    public Attack(Unit unit, Unit unit2, PathFinding pathFinding) {
        super(unit);
        this.target = unit2;
        this.pf = pathFinding;
    }

    @Override
    public boolean completed(GameState gameState) {
        PhysicalGameState physicalGameState = gameState.getPhysicalGameState();
        return !physicalGameState.getUnits().contains(this.target);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Attack)) {
            return false;
        }
        Attack attack = (Attack)object;
        if (this.target.getID() != attack.target.getID()) {
            return false;
        }
        return this.pf.getClass() == attack.pf.getClass();
    }

    @Override
    public void toxml(XMLWriter xMLWriter) {
        xMLWriter.tagWithAttributes("Attack", "unitID=\"" + this.unit.getID() + "\" target=\"" + this.target.getID() + "\" pathfinding=\"" + this.pf.getClass().getSimpleName() + "\"");
        xMLWriter.tag("/Attack");
    }

    @Override
    public UnitAction execute(GameState gameState, ResourceUsage resourceUsage) {
        int n;
        int n2 = this.target.getX() - this.unit.getX();
        double d = Math.sqrt(n2 * n2 + (n = this.target.getY() - this.unit.getY()) * n);
        if (d <= (double)this.unit.getAttackRange()) {
            return new UnitAction(5, this.target.getX(), this.target.getY());
        }
        UnitAction unitAction = this.pf.findPathToPositionInRange(this.unit, this.target.getX() + this.target.getY() * gameState.getPhysicalGameState().getWidth(), this.unit.getAttackRange(), gameState, resourceUsage);
        if (unitAction != null && gameState.isUnitActionAllowed(this.unit, unitAction)) {
            return unitAction;
        }
        return null;
    }
}

