/*
 * Decompiled with CFR 0.152.
 */
package ai.abstraction;

import ai.abstraction.AbstractAction;
import ai.abstraction.pathfinding.PathFinding;
import rts.GameState;
import rts.PhysicalGameState;
import rts.ResourceUsage;
import rts.UnitAction;
import rts.units.Unit;
import rts.units.UnitType;
import util.XMLWriter;

public class Build
extends AbstractAction {
    UnitType type;
    int x;
    int y;
    PathFinding pf;

    public Build(Unit unit, UnitType unitType, int n, int n2, PathFinding pathFinding) {
        super(unit);
        this.type = unitType;
        this.x = n;
        this.y = n2;
        this.pf = pathFinding;
    }

    @Override
    public boolean completed(GameState gameState) {
        PhysicalGameState physicalGameState = gameState.getPhysicalGameState();
        Unit unit = physicalGameState.getUnitAt(this.x, this.y);
        return unit != null;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Build)) {
            return false;
        }
        Build build = (Build)object;
        if (this.type != build.type) {
            return false;
        }
        if (this.x != build.x) {
            return false;
        }
        if (this.y != build.y) {
            return false;
        }
        return this.pf.getClass() == build.pf.getClass();
    }

    @Override
    public void toxml(XMLWriter xMLWriter) {
        xMLWriter.tagWithAttributes("Build", "unitID=\"" + this.unit.getID() + "\" type=\"" + this.type.name + "\" x=\"" + this.x + "\" y=\"" + this.y + "\" pathfinding=\"" + this.pf.getClass().getSimpleName() + "\"");
        xMLWriter.tag("/Build");
    }

    @Override
    public UnitAction execute(GameState gameState, ResourceUsage resourceUsage) {
        PhysicalGameState physicalGameState = gameState.getPhysicalGameState();
        UnitAction unitAction = this.pf.findPathToAdjacentPosition(this.unit, this.x + this.y * physicalGameState.getWidth(), gameState, resourceUsage);
        if (unitAction != null) {
            if (gameState.isUnitActionAllowed(this.unit, unitAction)) {
                return unitAction;
            }
            return null;
        }
        UnitAction unitAction2 = null;
        if (this.x == this.unit.getX() && this.y == this.unit.getY() - 1) {
            unitAction2 = new UnitAction(4, 0, this.type);
        }
        if (this.x == this.unit.getX() + 1 && this.y == this.unit.getY()) {
            unitAction2 = new UnitAction(4, 1, this.type);
        }
        if (this.x == this.unit.getX() && this.y == this.unit.getY() + 1) {
            unitAction2 = new UnitAction(4, 2, this.type);
        }
        if (this.x == this.unit.getX() - 1 && this.y == this.unit.getY()) {
            unitAction2 = new UnitAction(4, 3, this.type);
        }
        if (unitAction2 != null && gameState.isUnitActionAllowed(this.unit, unitAction2)) {
            return unitAction2;
        }
        return null;
    }
}

