/*
 * Decompiled with CFR 0.152.
 */
package ai.abstraction;

import ai.abstraction.AbstractAction;
import ai.abstraction.AbstractionLayerAI;
import ai.abstraction.Harvest;
import ai.abstraction.pathfinding.AStarPathFinding;
import ai.abstraction.pathfinding.PathFinding;
import ai.core.AI;
import ai.core.ParameterSpecification;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import rts.GameState;
import rts.PhysicalGameState;
import rts.Player;
import rts.PlayerAction;
import rts.units.Unit;
import rts.units.UnitType;
import rts.units.UnitTypeTable;

public class EconomyMilitaryRush
extends AbstractionLayerAI {
    Random r = new Random();
    protected UnitTypeTable utt;
    UnitType workerType;
    UnitType baseType;
    UnitType barracksType;
    UnitType rangedType;
    UnitType lightType;
    UnitType heavyType;
    int nWorkerBase = 8;

    public EconomyMilitaryRush(UnitTypeTable unitTypeTable) {
        this(unitTypeTable, new AStarPathFinding());
    }

    public EconomyMilitaryRush(UnitTypeTable unitTypeTable, PathFinding pathFinding) {
        super(pathFinding);
        this.reset(unitTypeTable);
    }

    @Override
    public void reset() {
        super.reset();
    }

    @Override
    public void reset(UnitTypeTable unitTypeTable) {
        this.utt = unitTypeTable;
        this.workerType = this.utt.getUnitType("Worker");
        this.baseType = this.utt.getUnitType("Base");
        this.barracksType = this.utt.getUnitType("Barracks");
        this.rangedType = this.utt.getUnitType("Ranged");
        this.lightType = this.utt.getUnitType("Light");
        this.heavyType = this.utt.getUnitType("Heavy");
    }

    @Override
    public PlayerAction getAction(int n, GameState gameState) throws Exception {
        PhysicalGameState physicalGameState = gameState.getPhysicalGameState();
        Player player = gameState.getPlayer(n);
        PlayerAction playerAction = new PlayerAction();
        for (Unit object : physicalGameState.getUnits()) {
            if (object.getType() != this.baseType || object.getPlayer() != n || gameState.getActionAssignment(object) != null) continue;
            this.baseBehavior(object, player, physicalGameState);
        }
        for (Unit unit : physicalGameState.getUnits()) {
            if (unit.getType() != this.barracksType || unit.getPlayer() != n || gameState.getActionAssignment(unit) != null) continue;
            this.barracksBehavior(unit, player, physicalGameState);
        }
        ArrayList arrayList = new ArrayList();
        for (Unit unit : physicalGameState.getUnits()) {
            if (!unit.getType().canHarvest || unit.getPlayer() != n || unit.getType() != this.workerType) continue;
            arrayList.add(unit);
        }
        this.workersBehavior(arrayList, player, physicalGameState);
        for (Unit unit : physicalGameState.getUnits()) {
            if (!unit.getType().canAttack || unit.getType().canHarvest || unit.getPlayer() != n || gameState.getActionAssignment(unit) != null) continue;
            this.meleeUnitBehavior(unit, player, gameState);
        }
        return this.translateActions(n, gameState);
    }

    @Override
    public AI clone() {
        return new EconomyMilitaryRush(this.utt, this.pf);
    }

    @Override
    public List<ParameterSpecification> getParameters() {
        ArrayList<ParameterSpecification> arrayList = new ArrayList<ParameterSpecification>();
        arrayList.add(new ParameterSpecification("PathFinding", PathFinding.class, new AStarPathFinding()));
        return arrayList;
    }

    public void baseBehavior(Unit unit, Player player, PhysicalGameState physicalGameState) {
        int n = 0;
        for (Unit unit2 : physicalGameState.getUnits()) {
            if (unit2.getType() != this.workerType || unit2.getPlayer() != player.getID()) continue;
            ++n;
        }
        int n2 = 0;
        int n3 = 0;
        for (Unit unit3 : physicalGameState.getUnits()) {
            if (unit3.getType() == this.baseType && unit3.getPlayer() == player.getID()) {
                ++n2;
                continue;
            }
            if (unit3.getType() != this.barracksType || unit3.getPlayer() != player.getID()) continue;
            ++n3;
        }
        int n4 = n3 == 0 ? 4 : this.nWorkerBase * n2;
        if (n < n4 && player.getResources() >= this.workerType.cost) {
            this.train(unit, this.workerType);
        }
    }

    public void barracksBehavior(Unit unit, Player player, PhysicalGameState physicalGameState) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (Unit unit2 : physicalGameState.getUnits()) {
            if (unit2.getType() == this.lightType && unit.getPlayer() == player.getID()) {
                ++n;
            }
            if (unit2.getType() == this.rangedType && unit.getPlayer() == player.getID()) {
                ++n2;
            }
            if (unit2.getType() != this.heavyType || unit.getPlayer() != player.getID()) continue;
            ++n3;
        }
        if (n == 0 && player.getResources() >= this.lightType.cost) {
            this.train(unit, this.lightType);
        } else if (n2 == 0 && player.getResources() >= this.rangedType.cost) {
            this.train(unit, this.rangedType);
        } else if (n3 == 0 && player.getResources() >= this.heavyType.cost) {
            this.train(unit, this.heavyType);
        }
        if (n != 0 && n2 != 0 && n3 != 0) {
            int n4 = this.r.nextInt(3);
            switch (n4) {
                case 0: {
                    if (player.getResources() < this.lightType.cost) break;
                    this.train(unit, this.lightType);
                    break;
                }
                case 1: {
                    if (player.getResources() < this.rangedType.cost) break;
                    this.train(unit, this.rangedType);
                    break;
                }
                case 2: {
                    if (player.getResources() < this.heavyType.cost) break;
                    this.train(unit, this.heavyType);
                }
            }
        }
    }

    public void meleeUnitBehavior(Unit unit, Player player, GameState gameState) {
        PhysicalGameState physicalGameState = gameState.getPhysicalGameState();
        Unit unit2 = null;
        int n = 0;
        for (Unit unit3 : physicalGameState.getUnits()) {
            if (unit3.getPlayer() < 0 || unit3.getPlayer() == player.getID()) continue;
            int n2 = Math.abs(unit3.getX() - unit.getX()) + Math.abs(unit3.getY() - unit.getY());
            if (unit2 != null && n2 >= n) continue;
            unit2 = unit3;
            n = n2;
        }
        if (unit2 != null) {
            this.attack(unit, unit2);
        }
    }

    public void workersBehavior(List<Unit> list, Player player, PhysicalGameState physicalGameState) {
        ArrayList<Unit> arrayList;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        ArrayList<Unit> arrayList2 = new ArrayList<Unit>();
        arrayList2.addAll(list);
        if (list.isEmpty()) {
            return;
        }
        for (Unit serializable2 : physicalGameState.getUnits()) {
            if (serializable2.getType() == this.baseType && serializable2.getPlayer() == player.getID()) {
                ++n;
            }
            if (serializable2.getType() == this.barracksType && serializable2.getPlayer() == player.getID()) {
                ++n2;
            }
            if (serializable2.getType() != this.lightType && serializable2.getType() != this.rangedType && serializable2.getType() != this.heavyType || serializable2.getPlayer() != player.getID()) continue;
            ++n4;
        }
        ArrayList arrayList22 = new ArrayList();
        if (n == 0 && !arrayList2.isEmpty() && player.getResources() >= this.baseType.cost + n3) {
            Unit unit = (Unit)arrayList2.remove(0);
            this.buildIfNotAlreadyBuilding(unit, this.baseType, unit.getX(), unit.getY(), arrayList22, player, physicalGameState);
            n3 += this.baseType.cost;
        }
        if (n2 == 0 && !arrayList2.isEmpty()) {
            if (player.getResources() >= this.barracksType.cost + n3) {
                Unit unit = (Unit)arrayList2.remove(0);
                this.buildIfNotAlreadyBuilding(unit, this.barracksType, unit.getX(), unit.getY(), arrayList22, player, physicalGameState);
                n3 += this.barracksType.cost;
            }
        } else if (n2 > 0 && !arrayList2.isEmpty() && n4 > 2 && player.getResources() >= this.barracksType.cost + n3) {
            Unit unit = (Unit)arrayList2.remove(0);
            this.buildIfNotAlreadyBuilding(unit, this.barracksType, unit.getX(), unit.getY(), arrayList22, player, physicalGameState);
            n3 += this.barracksType.cost;
        }
        if (n2 != 0 && !(arrayList = new ArrayList<Unit>(this.otherResourcePoint(player, physicalGameState))).isEmpty() && !arrayList2.isEmpty() && player.getResources() >= this.baseType.cost + n3) {
            Unit unit = (Unit)arrayList2.remove(0);
            this.buildIfNotAlreadyBuilding(unit, this.baseType, ((Unit)arrayList.get(0)).getX() + 1, ((Unit)arrayList.get(0)).getY() + 1, arrayList22, player, physicalGameState);
            n3 += this.baseType.cost;
        }
        this.harvestWorkers(arrayList2, player, physicalGameState);
    }

    protected List<Unit> otherResourcePoint(Player player, PhysicalGameState physicalGameState) {
        List<Unit> list = this.getMyBases(player, physicalGameState);
        HashSet<Unit> hashSet = new HashSet<Unit>();
        HashSet<Unit> hashSet2 = new HashSet<Unit>();
        for (Unit unit : list) {
            ArrayList<Unit> arrayList = new ArrayList<Unit>(physicalGameState.getUnitsAround(unit.getX(), unit.getY(), 10));
            for (Unit unit2 : arrayList) {
                if (!unit2.getType().isResource) continue;
                hashSet.add(unit2);
            }
        }
        for (Unit unit : physicalGameState.getUnits()) {
            if (!unit.getType().isResource || hashSet.contains(unit)) continue;
            hashSet2.add(unit);
        }
        return new ArrayList<Unit>(hashSet2);
    }

    protected List<Unit> getMyBases(Player player, PhysicalGameState physicalGameState) {
        ArrayList<Unit> arrayList = new ArrayList<Unit>();
        for (Unit unit : physicalGameState.getUnits()) {
            if (unit.getType() != this.baseType || unit.getPlayer() != player.getID()) continue;
            arrayList.add(unit);
        }
        return arrayList;
    }

    protected void harvestWorkers(List<Unit> list, Player player, PhysicalGameState physicalGameState) {
        for (Unit unit : list) {
            int n;
            Unit object = null;
            Unit object2 = null;
            int n2 = 0;
            for (Unit unit2 : physicalGameState.getUnits()) {
                if (!unit2.getType().isResource) continue;
                n = Math.abs(unit2.getX() - unit.getX()) + Math.abs(unit2.getY() - unit.getY());
                if (object2 != null && n >= n2) continue;
                object2 = unit2;
                n2 = n;
            }
            n2 = 0;
            for (Unit unit3 : physicalGameState.getUnits()) {
                if (!unit3.getType().isStockpile || unit3.getPlayer() != player.getID()) continue;
                n = Math.abs(unit3.getX() - unit.getX()) + Math.abs(unit3.getY() - unit.getY());
                if (object != null && n >= n2) continue;
                object = unit3;
                n2 = n;
            }
            if (object2 == null || object == null) continue;
            AbstractAction abstractAction = this.getAbstractAction(unit);
            if (abstractAction instanceof Harvest) {
                Harvest harvest = (Harvest)abstractAction;
                if (harvest.getTarget() == object2 && harvest.getBase() == object) continue;
                this.harvest(unit, object2, object);
                continue;
            }
            this.harvest(unit, object2, object);
        }
    }
}

