/*
 * Decompiled with CFR 0.152.
 */
package ai.abstraction;

import ai.abstraction.AbstractAction;
import ai.abstraction.pathfinding.PathFinding;
import rts.GameState;
import rts.PhysicalGameState;
import rts.ResourceUsage;
import rts.UnitAction;
import rts.units.Unit;
import util.XMLWriter;

public class Harvest
extends AbstractAction {
    Unit target;
    Unit base;
    PathFinding pf;

    public Harvest(Unit unit, Unit unit2, Unit unit3, PathFinding pathFinding) {
        super(unit);
        this.target = unit2;
        this.base = unit3;
        this.pf = pathFinding;
    }

    public Unit getTarget() {
        return this.target;
    }

    public Unit getBase() {
        return this.base;
    }

    @Override
    public boolean completed(GameState gameState) {
        return !gameState.getPhysicalGameState().getUnits().contains(this.target);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Harvest)) {
            return false;
        }
        Harvest harvest = (Harvest)object;
        if (this.target.getID() != harvest.target.getID()) {
            return false;
        }
        if (this.base.getID() != harvest.base.getID()) {
            return false;
        }
        return this.pf.getClass() == harvest.pf.getClass();
    }

    @Override
    public void toxml(XMLWriter xMLWriter) {
        xMLWriter.tagWithAttributes("Harvest", "unitID=\"" + this.unit.getID() + "\" target=\"" + this.target.getID() + "\" base=\"" + this.base.getID() + "\" pathfinding=\"" + this.pf.getClass().getSimpleName() + "\"");
        xMLWriter.tag("/Harvest");
    }

    @Override
    public UnitAction execute(GameState gameState, ResourceUsage resourceUsage) {
        PhysicalGameState physicalGameState = gameState.getPhysicalGameState();
        if (this.unit.getResources() == 0) {
            UnitAction unitAction = this.pf.findPathToAdjacentPosition(this.unit, this.target.getX() + this.target.getY() * gameState.getPhysicalGameState().getWidth(), gameState, resourceUsage);
            if (unitAction != null) {
                if (gameState.isUnitActionAllowed(this.unit, unitAction)) {
                    return unitAction;
                }
                return null;
            }
            if (this.target.getX() == this.unit.getX() && this.target.getY() == this.unit.getY() - 1) {
                return new UnitAction(2, 0);
            }
            if (this.target.getX() == this.unit.getX() + 1 && this.target.getY() == this.unit.getY()) {
                return new UnitAction(2, 1);
            }
            if (this.target.getX() == this.unit.getX() && this.target.getY() == this.unit.getY() + 1) {
                return new UnitAction(2, 2);
            }
            if (this.target.getX() == this.unit.getX() - 1 && this.target.getY() == this.unit.getY()) {
                return new UnitAction(2, 3);
            }
        } else {
            UnitAction unitAction = this.pf.findPathToAdjacentPosition(this.unit, this.base.getX() + this.base.getY() * gameState.getPhysicalGameState().getWidth(), gameState, resourceUsage);
            if (unitAction != null) {
                if (gameState.isUnitActionAllowed(this.unit, unitAction)) {
                    return unitAction;
                }
                return null;
            }
            if (this.base.getX() == this.unit.getX() && this.base.getY() == this.unit.getY() - 1) {
                return new UnitAction(3, 0);
            }
            if (this.base.getX() == this.unit.getX() + 1 && this.base.getY() == this.unit.getY()) {
                return new UnitAction(3, 1);
            }
            if (this.base.getX() == this.unit.getX() && this.base.getY() == this.unit.getY() + 1) {
                return new UnitAction(3, 2);
            }
            if (this.base.getX() == this.unit.getX() - 1 && this.base.getY() == this.unit.getY()) {
                return new UnitAction(3, 3);
            }
        }
        return null;
    }
}

