/*
 * Decompiled with CFR 0.152.
 */
package ai.abstraction;

import ai.abstraction.AbstractAction;
import ai.abstraction.pathfinding.PathFinding;
import rts.GameState;
import rts.PhysicalGameState;
import rts.ResourceUsage;
import rts.UnitAction;
import rts.units.Unit;
import util.XMLWriter;

public class Move
extends AbstractAction {
    int x;
    int y;
    PathFinding pf;

    public Move(Unit unit, int n, int n2, PathFinding pathFinding) {
        super(unit);
        this.x = n;
        this.y = n2;
        this.pf = pathFinding;
    }

    @Override
    public boolean completed(GameState gameState) {
        return this.unit.getX() == this.x && this.unit.getY() == this.y;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Move)) {
            return false;
        }
        Move move = (Move)object;
        if (this.x != move.x) {
            return false;
        }
        if (this.y != move.y) {
            return false;
        }
        return this.pf.getClass() == move.pf.getClass();
    }

    @Override
    public void toxml(XMLWriter xMLWriter) {
        xMLWriter.tagWithAttributes("Move", "unitID=\"" + this.unit.getID() + "\" x=\"" + this.x + "\" y=\"" + this.y + "\" pathfinding=\"" + this.pf.getClass().getSimpleName() + "\"");
        xMLWriter.tag("/Move");
    }

    @Override
    public UnitAction execute(GameState gameState, ResourceUsage resourceUsage) {
        PhysicalGameState physicalGameState = gameState.getPhysicalGameState();
        UnitAction unitAction = this.pf.findPath(this.unit, this.x + this.y * physicalGameState.getWidth(), gameState, resourceUsage);
        if (unitAction != null && gameState.isUnitActionAllowed(this.unit, unitAction)) {
            return unitAction;
        }
        return null;
    }
}

