/*
 * Decompiled with CFR 0.152.
 */
package ai.abstraction;

import ai.abstraction.AbstractAction;
import ai.abstraction.AbstractionLayerAI;
import ai.abstraction.Harvest;
import ai.abstraction.pathfinding.AStarPathFinding;
import ai.abstraction.pathfinding.PathFinding;
import ai.core.AI;
import ai.core.ParameterSpecification;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import rts.GameState;
import rts.PhysicalGameState;
import rts.Player;
import rts.PlayerAction;
import rts.units.Unit;
import rts.units.UnitType;
import rts.units.UnitTypeTable;

public class RangedDefense
extends AbstractionLayerAI {
    Random r = new Random();
    protected UnitTypeTable utt;
    UnitType workerType;
    UnitType baseType;
    UnitType barracksType;
    UnitType rangedType;

    public RangedDefense(UnitTypeTable unitTypeTable) {
        this(unitTypeTable, new AStarPathFinding());
    }

    public RangedDefense(UnitTypeTable unitTypeTable, PathFinding pathFinding) {
        super(pathFinding);
        this.reset(unitTypeTable);
    }

    @Override
    public void reset() {
        super.reset();
    }

    @Override
    public void reset(UnitTypeTable unitTypeTable) {
        this.utt = unitTypeTable;
        this.workerType = this.utt.getUnitType("Worker");
        this.baseType = this.utt.getUnitType("Base");
        this.barracksType = this.utt.getUnitType("Barracks");
        this.rangedType = this.utt.getUnitType("Ranged");
    }

    @Override
    public AI clone() {
        return new RangedDefense(this.utt, this.pf);
    }

    @Override
    public PlayerAction getAction(int n, GameState gameState) {
        PhysicalGameState physicalGameState = gameState.getPhysicalGameState();
        Player player = gameState.getPlayer(n);
        for (Unit object : physicalGameState.getUnits()) {
            if (object.getType() != this.baseType || object.getPlayer() != n || gameState.getActionAssignment(object) != null) continue;
            this.baseBehavior(object, player, physicalGameState);
        }
        for (Unit unit : physicalGameState.getUnits()) {
            if (unit.getType() != this.barracksType || unit.getPlayer() != n || gameState.getActionAssignment(unit) != null) continue;
            this.barracksBehavior(unit, player, physicalGameState);
        }
        for (Unit unit : physicalGameState.getUnits()) {
            if (!unit.getType().canAttack || unit.getType().canHarvest || unit.getPlayer() != n || gameState.getActionAssignment(unit) != null) continue;
            this.meleeUnitBehavior(unit, player, gameState);
        }
        LinkedList linkedList = new LinkedList();
        for (Unit unit : physicalGameState.getUnits()) {
            if (!unit.getType().canHarvest || unit.getPlayer() != n) continue;
            linkedList.add(unit);
        }
        this.workersBehavior(linkedList, player, physicalGameState);
        return this.translateActions(n, gameState);
    }

    public void baseBehavior(Unit unit, Player player, PhysicalGameState physicalGameState) {
        int n = 0;
        for (Unit unit2 : physicalGameState.getUnits()) {
            if (unit2.getType() != this.workerType || unit2.getPlayer() != player.getID()) continue;
            ++n;
        }
        if (n < 1 && player.getResources() >= this.workerType.cost) {
            this.train(unit, this.workerType);
        }
    }

    public void barracksBehavior(Unit unit, Player player, PhysicalGameState physicalGameState) {
        if (player.getResources() >= this.rangedType.cost) {
            this.train(unit, this.rangedType);
        }
    }

    public void meleeUnitBehavior(Unit unit, Player player, GameState gameState) {
        PhysicalGameState physicalGameState = gameState.getPhysicalGameState();
        Unit unit2 = null;
        int n = 0;
        int n2 = 0;
        for (Unit unit3 : physicalGameState.getUnits()) {
            if (unit3.getPlayer() >= 0 && unit3.getPlayer() != player.getID()) {
                int n3 = Math.abs(unit3.getX() - unit.getX()) + Math.abs(unit3.getY() - unit.getY());
                if (unit2 != null && n3 >= n) continue;
                unit2 = unit3;
                n = n3;
                continue;
            }
            if (unit3.getPlayer() != player.getID() || unit3.getType() != this.baseType) continue;
            n2 = Math.abs(unit3.getX() - unit.getX()) + Math.abs(unit3.getY() - unit.getY());
        }
        if (unit2 != null && (n < physicalGameState.getHeight() / 2 || n2 < physicalGameState.getHeight() / 2)) {
            this.attack(unit, unit2);
        } else {
            this.attack(unit, null);
        }
    }

    public void workersBehavior(List<Unit> list, Player player, PhysicalGameState physicalGameState) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        LinkedList<Unit> linkedList = new LinkedList<Unit>();
        linkedList.addAll(list);
        if (list.isEmpty()) {
            return;
        }
        for (Unit object2 : physicalGameState.getUnits()) {
            if (object2.getType() == this.baseType && object2.getPlayer() == player.getID()) {
                ++n;
            }
            if (object2.getType() != this.barracksType || object2.getPlayer() != player.getID()) continue;
            ++n2;
        }
        LinkedList linkedList2 = new LinkedList();
        if (n == 0 && !linkedList.isEmpty() && player.getResources() >= this.baseType.cost + n3) {
            Unit unit = (Unit)linkedList.remove(0);
            this.buildIfNotAlreadyBuilding(unit, this.baseType, unit.getX(), unit.getY(), linkedList2, player, physicalGameState);
            n3 += this.baseType.cost;
        }
        if (n2 == 0 && !linkedList.isEmpty() && player.getResources() >= this.barracksType.cost + n3) {
            Unit unit = (Unit)linkedList.remove(0);
            this.buildIfNotAlreadyBuilding(unit, this.barracksType, unit.getX(), unit.getY(), linkedList2, player, physicalGameState);
            n3 += this.barracksType.cost;
        }
        for (Unit unit : linkedList) {
            int n4;
            Unit unit2 = null;
            Unit unit3 = null;
            int n5 = 0;
            for (Unit unit4 : physicalGameState.getUnits()) {
                if (!unit4.getType().isResource) continue;
                n4 = Math.abs(unit4.getX() - unit.getX()) + Math.abs(unit4.getY() - unit.getY());
                if (unit3 != null && n4 >= n5) continue;
                unit3 = unit4;
                n5 = n4;
            }
            n5 = 0;
            for (Unit unit5 : physicalGameState.getUnits()) {
                if (!unit5.getType().isStockpile || unit5.getPlayer() != player.getID()) continue;
                n4 = Math.abs(unit5.getX() - unit.getX()) + Math.abs(unit5.getY() - unit.getY());
                if (unit2 != null && n4 >= n5) continue;
                unit2 = unit5;
                n5 = n4;
            }
            if (unit3 == null || unit2 == null) continue;
            AbstractAction abstractAction = this.getAbstractAction(unit);
            if (abstractAction instanceof Harvest) {
                Harvest harvest = (Harvest)abstractAction;
                if (harvest.getTarget() == unit3 && harvest.getBase() == unit2) continue;
                this.harvest(unit, unit3, unit2);
                continue;
            }
            this.harvest(unit, unit3, unit2);
        }
    }

    @Override
    public List<ParameterSpecification> getParameters() {
        ArrayList<ParameterSpecification> arrayList = new ArrayList<ParameterSpecification>();
        arrayList.add(new ParameterSpecification("PathFinding", PathFinding.class, new AStarPathFinding()));
        return arrayList;
    }
}

