/*
 * Decompiled with CFR 0.152.
 */
package ai.abstraction;

import ai.abstraction.AbstractAction;
import ai.abstraction.AbstractionLayerAI;
import ai.abstraction.Harvest;
import ai.abstraction.pathfinding.AStarPathFinding;
import ai.abstraction.pathfinding.PathFinding;
import ai.core.AI;
import ai.core.ParameterSpecification;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import rts.GameState;
import rts.PhysicalGameState;
import rts.Player;
import rts.PlayerAction;
import rts.units.Unit;
import rts.units.UnitType;
import rts.units.UnitTypeTable;

public class SimpleEconomyRush
extends AbstractionLayerAI {
    Random r = new Random();
    protected UnitTypeTable utt;
    UnitType workerType;
    UnitType baseType;
    UnitType barracksType;
    UnitType rangedType;
    UnitType lightType;
    UnitType heavyType;

    public SimpleEconomyRush(UnitTypeTable unitTypeTable) {
        this(unitTypeTable, new AStarPathFinding());
    }

    public SimpleEconomyRush(UnitTypeTable unitTypeTable, PathFinding pathFinding) {
        super(pathFinding);
        this.reset(unitTypeTable);
    }

    @Override
    public void reset() {
        super.reset();
    }

    @Override
    public void reset(UnitTypeTable unitTypeTable) {
        this.utt = unitTypeTable;
        this.workerType = this.utt.getUnitType("Worker");
        this.baseType = this.utt.getUnitType("Base");
        this.barracksType = this.utt.getUnitType("Barracks");
        this.rangedType = this.utt.getUnitType("Ranged");
        this.lightType = this.utt.getUnitType("Light");
        this.heavyType = this.utt.getUnitType("Heavy");
    }

    @Override
    public PlayerAction getAction(int n, GameState gameState) throws Exception {
        PhysicalGameState physicalGameState = gameState.getPhysicalGameState();
        Player player = gameState.getPlayer(n);
        PlayerAction playerAction = new PlayerAction();
        for (Unit object : physicalGameState.getUnits()) {
            if (object.getType() != this.baseType || object.getPlayer() != n || gameState.getActionAssignment(object) != null) continue;
            this.baseBehavior(object, player, physicalGameState);
        }
        for (Unit unit : physicalGameState.getUnits()) {
            if (unit.getType() != this.barracksType || unit.getPlayer() != n || gameState.getActionAssignment(unit) != null) continue;
            this.barracksBehavior(unit, player, physicalGameState);
        }
        ArrayList arrayList = new ArrayList();
        for (Unit unit : physicalGameState.getUnits()) {
            if (!unit.getType().canHarvest || unit.getPlayer() != n || unit.getType() != this.workerType) continue;
            arrayList.add(unit);
        }
        this.workersBehavior(arrayList, player, physicalGameState);
        for (Unit unit : physicalGameState.getUnits()) {
            if (!unit.getType().canAttack || unit.getType().canHarvest || unit.getPlayer() != n || gameState.getActionAssignment(unit) != null) continue;
            this.meleeUnitBehavior(unit, player, gameState);
        }
        return this.translateActions(n, gameState);
    }

    @Override
    public AI clone() {
        return new SimpleEconomyRush(this.utt, this.pf);
    }

    @Override
    public List<ParameterSpecification> getParameters() {
        ArrayList<ParameterSpecification> arrayList = new ArrayList<ParameterSpecification>();
        arrayList.add(new ParameterSpecification("PathFinding", PathFinding.class, new AStarPathFinding()));
        return arrayList;
    }

    public void baseBehavior(Unit unit, Player player, PhysicalGameState physicalGameState) {
        int n = 0;
        for (Unit object : physicalGameState.getUnits()) {
            if (object.getType() != this.workerType || object.getPlayer() != player.getID()) continue;
            ++n;
        }
        int n2 = 0;
        for (Unit unit2 : physicalGameState.getUnits()) {
            if (unit2.getType() != this.baseType || unit2.getPlayer() != player.getID()) continue;
            ++n2;
        }
        int n3 = 3 * n2;
        if (n < n3 && player.getResources() >= this.workerType.cost) {
            this.train(unit, this.workerType);
        }
    }

    public void barracksBehavior(Unit unit, Player player, PhysicalGameState physicalGameState) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (Unit unit2 : physicalGameState.getUnits()) {
            if (unit2.getType() == this.lightType && unit.getPlayer() == player.getID()) {
                ++n;
            }
            if (unit2.getType() == this.rangedType && unit.getPlayer() == player.getID()) {
                ++n2;
            }
            if (unit2.getType() != this.heavyType || unit.getPlayer() != player.getID()) continue;
            ++n3;
        }
        if (n == 0 && player.getResources() >= this.lightType.cost) {
            this.train(unit, this.lightType);
        } else if (n2 == 0 && player.getResources() >= this.rangedType.cost) {
            this.train(unit, this.rangedType);
        } else if (n3 == 0 && player.getResources() >= this.heavyType.cost) {
            this.train(unit, this.heavyType);
        }
        if (n != 0 && n2 != 0 && n3 != 0) {
            int n4 = this.r.nextInt(3);
            switch (n4) {
                case 0: {
                    if (player.getResources() < this.lightType.cost) break;
                    this.train(unit, this.lightType);
                    break;
                }
                case 1: {
                    if (player.getResources() < this.rangedType.cost) break;
                    this.train(unit, this.rangedType);
                    break;
                }
                case 2: {
                    if (player.getResources() < this.heavyType.cost) break;
                    this.train(unit, this.heavyType);
                }
            }
        }
    }

    public void meleeUnitBehavior(Unit unit, Player player, GameState gameState) {
        PhysicalGameState physicalGameState = gameState.getPhysicalGameState();
        Unit unit2 = null;
        int n = 0;
        for (Unit unit3 : physicalGameState.getUnits()) {
            if (unit3.getPlayer() < 0 || unit3.getPlayer() == player.getID()) continue;
            int n2 = Math.abs(unit3.getX() - unit.getX()) + Math.abs(unit3.getY() - unit.getY());
            if (unit2 != null && n2 >= n) continue;
            unit2 = unit3;
            n = n2;
        }
        if (unit2 != null) {
            this.attack(unit, unit2);
        }
    }

    public void workersBehavior(List<Unit> list, Player player, PhysicalGameState physicalGameState) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        ArrayList<Unit> arrayList = new ArrayList<Unit>();
        arrayList.addAll(list);
        if (list.isEmpty()) {
            return;
        }
        for (Unit object2 : physicalGameState.getUnits()) {
            if (object2.getType() == this.baseType && object2.getPlayer() == player.getID()) {
                ++n;
            }
            if (object2.getType() != this.barracksType || object2.getPlayer() != player.getID()) continue;
            ++n2;
        }
        ArrayList arrayList2 = new ArrayList();
        if (n == 0 && !arrayList.isEmpty() && player.getResources() >= this.baseType.cost + n3) {
            Unit unit = (Unit)arrayList.remove(0);
            this.buildIfNotAlreadyBuilding(unit, this.baseType, unit.getX(), unit.getY(), arrayList2, player, physicalGameState);
            n3 += this.baseType.cost;
        }
        if (n2 == 0 && !arrayList.isEmpty() && player.getResources() >= this.barracksType.cost + n3) {
            Unit unit = (Unit)arrayList.remove(0);
            this.buildIfNotAlreadyBuilding(unit, this.barracksType, unit.getX(), unit.getY(), arrayList2, player, physicalGameState);
            n3 += this.barracksType.cost;
        }
        for (Unit unit : arrayList) {
            int n4;
            Unit unit2 = null;
            Unit unit3 = null;
            int n5 = 0;
            for (Unit unit4 : physicalGameState.getUnits()) {
                if (!unit4.getType().isResource) continue;
                n4 = Math.abs(unit4.getX() - unit.getX()) + Math.abs(unit4.getY() - unit.getY());
                if (unit3 != null && n4 >= n5) continue;
                unit3 = unit4;
                n5 = n4;
            }
            n5 = 0;
            for (Unit unit5 : physicalGameState.getUnits()) {
                if (!unit5.getType().isStockpile || unit5.getPlayer() != player.getID()) continue;
                n4 = Math.abs(unit5.getX() - unit.getX()) + Math.abs(unit5.getY() - unit.getY());
                if (unit2 != null && n4 >= n5) continue;
                unit2 = unit5;
                n5 = n4;
            }
            if (unit3 == null || unit2 == null) continue;
            AbstractAction abstractAction = this.getAbstractAction(unit);
            if (abstractAction instanceof Harvest) {
                Harvest harvest = (Harvest)abstractAction;
                if (harvest.getTarget() == unit3 && harvest.getBase() == unit2) continue;
                this.harvest(unit, unit3, unit2);
                continue;
            }
            this.harvest(unit, unit3, unit2);
        }
    }
}

