/*
 * Decompiled with CFR 0.152.
 */
package ai.abstraction;

import ai.abstraction.AbstractAction;
import rts.GameState;
import rts.PhysicalGameState;
import rts.ResourceUsage;
import rts.UnitAction;
import rts.units.Unit;
import rts.units.UnitType;
import util.XMLWriter;

public class Train
extends AbstractAction {
    UnitType type;
    boolean completed = false;

    public Train(Unit unit, UnitType unitType) {
        super(unit);
        this.type = unitType;
    }

    @Override
    public boolean completed(GameState gameState) {
        return this.completed;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Train)) {
            return false;
        }
        Train train = (Train)object;
        return this.type == train.type;
    }

    @Override
    public void toxml(XMLWriter xMLWriter) {
        xMLWriter.tagWithAttributes("Train", "unitID=\"" + this.unit.getID() + "\" type=\"" + this.type.name + "\"");
        xMLWriter.tag("/Train");
    }

    @Override
    public UnitAction execute(GameState gameState, ResourceUsage resourceUsage) {
        UnitAction unitAction;
        int n;
        PhysicalGameState physicalGameState = gameState.getPhysicalGameState();
        int n2 = this.unit.getX();
        int n3 = this.unit.getY();
        int n4 = -1;
        int n5 = -1;
        if (n3 > 0 && gameState.free(n2, n3 - 1) && ((n = this.score(n2, n3 - 1, this.type, this.unit.getPlayer(), physicalGameState)) > n5 || n4 == -1)) {
            n5 = n;
            n4 = 0;
        }
        if (n2 < physicalGameState.getWidth() - 1 && gameState.free(n2 + 1, n3) && ((n = this.score(n2 + 1, n3, this.type, this.unit.getPlayer(), physicalGameState)) > n5 || n4 == -1)) {
            n5 = n;
            n4 = 1;
        }
        if (n3 < physicalGameState.getHeight() - 1 && gameState.free(n2, n3 + 1) && ((n = this.score(n2, n3 + 1, this.type, this.unit.getPlayer(), physicalGameState)) > n5 || n4 == -1)) {
            n5 = n;
            n4 = 2;
        }
        if (n2 > 0 && gameState.free(n2 - 1, n3) && ((n = this.score(n2 - 1, n3, this.type, this.unit.getPlayer(), physicalGameState)) > n5 || n4 == -1)) {
            n5 = n;
            n4 = 3;
        }
        this.completed = true;
        if (n4 != -1 && gameState.isUnitActionAllowed(this.unit, unitAction = new UnitAction(4, n4, this.type))) {
            return unitAction;
        }
        return null;
    }

    public int score(int n, int n2, UnitType unitType, int n3, PhysicalGameState physicalGameState) {
        int n4 = 0;
        boolean bl = true;
        if (unitType.canHarvest) {
            for (Unit unit : physicalGameState.getUnits()) {
                if (!unit.getType().isResource) continue;
                int n5 = Math.abs(unit.getX() - n) + Math.abs(unit.getY() - n2);
                if (!bl && n5 >= n4) continue;
                n4 = n5;
                bl = false;
            }
        } else {
            for (Unit unit : physicalGameState.getUnits()) {
                if (unit.getPlayer() < 0 || unit.getPlayer() == n3) continue;
                int n6 = Math.abs(unit.getX() - n) + Math.abs(unit.getY() - n2);
                if (!bl && n6 >= n4) continue;
                n4 = n6;
                bl = false;
            }
        }
        return -n4;
    }
}

