/*
 * Decompiled with CFR 0.152.
 */
package ai.abstraction;

import ai.abstraction.AbstractAction;
import ai.abstraction.AbstractionLayerAI;
import ai.abstraction.Harvest;
import ai.abstraction.pathfinding.AStarPathFinding;
import ai.abstraction.pathfinding.PathFinding;
import ai.core.AI;
import ai.core.ParameterSpecification;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import rts.GameState;
import rts.PhysicalGameState;
import rts.Player;
import rts.PlayerAction;
import rts.units.Unit;
import rts.units.UnitType;
import rts.units.UnitTypeTable;

public class WorkerRush
extends AbstractionLayerAI {
    Random r = new Random();
    protected UnitTypeTable utt;
    UnitType workerType;
    UnitType baseType;

    public WorkerRush(UnitTypeTable unitTypeTable) {
        this(unitTypeTable, new AStarPathFinding());
    }

    public WorkerRush(UnitTypeTable unitTypeTable, PathFinding pathFinding) {
        super(pathFinding);
        this.reset(unitTypeTable);
    }

    @Override
    public void reset() {
        super.reset();
    }

    @Override
    public void reset(UnitTypeTable unitTypeTable) {
        this.utt = unitTypeTable;
        if (this.utt != null) {
            this.workerType = this.utt.getUnitType("Worker");
            this.baseType = this.utt.getUnitType("Base");
        }
    }

    @Override
    public AI clone() {
        return new WorkerRush(this.utt, this.pf);
    }

    @Override
    public PlayerAction getAction(int n, GameState gameState) {
        PhysicalGameState physicalGameState = gameState.getPhysicalGameState();
        Player player = gameState.getPlayer(n);
        PlayerAction playerAction = new PlayerAction();
        for (Unit object : physicalGameState.getUnits()) {
            if (object.getType() != this.baseType || object.getPlayer() != n || gameState.getActionAssignment(object) != null) continue;
            this.baseBehavior(object, player, physicalGameState);
        }
        for (Unit unit : physicalGameState.getUnits()) {
            if (!unit.getType().canAttack || unit.getType().canHarvest || unit.getPlayer() != n || gameState.getActionAssignment(unit) != null) continue;
            this.meleeUnitBehavior(unit, player, gameState);
        }
        LinkedList linkedList = new LinkedList();
        for (Unit unit : physicalGameState.getUnits()) {
            if (!unit.getType().canHarvest || unit.getPlayer() != n) continue;
            linkedList.add(unit);
        }
        this.workersBehavior(linkedList, player, gameState);
        return this.translateActions(n, gameState);
    }

    public void baseBehavior(Unit unit, Player player, PhysicalGameState physicalGameState) {
        if (player.getResources() >= this.workerType.cost) {
            this.train(unit, this.workerType);
        }
    }

    public void meleeUnitBehavior(Unit unit, Player player, GameState gameState) {
        PhysicalGameState physicalGameState = gameState.getPhysicalGameState();
        Unit unit2 = null;
        int n = 0;
        for (Unit unit3 : physicalGameState.getUnits()) {
            if (unit3.getPlayer() < 0 || unit3.getPlayer() == player.getID()) continue;
            int n2 = Math.abs(unit3.getX() - unit.getX()) + Math.abs(unit3.getY() - unit.getY());
            if (unit2 != null && n2 >= n) continue;
            unit2 = unit3;
            n = n2;
        }
        if (unit2 != null) {
            this.attack(unit, unit2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void workersBehavior(List<Unit> list, Player player, GameState gameState) {
        PhysicalGameState physicalGameState = gameState.getPhysicalGameState();
        int n = 0;
        int n2 = 0;
        Unit unit = null;
        LinkedList<Unit> linkedList = new LinkedList<Unit>();
        linkedList.addAll(list);
        if (list.isEmpty()) {
            return;
        }
        for (Unit object2 : physicalGameState.getUnits()) {
            if (object2.getType() != this.baseType || object2.getPlayer() != player.getID()) continue;
            ++n;
        }
        LinkedList linkedList2 = new LinkedList();
        if (n == 0 && !linkedList.isEmpty() && player.getResources() >= this.baseType.cost + n2) {
            Unit unit2 = (Unit)linkedList.remove(0);
            this.buildIfNotAlreadyBuilding(unit2, this.baseType, unit2.getX(), unit2.getY(), linkedList2, player, physicalGameState);
            n2 += this.baseType.cost;
        }
        if (linkedList.size() > 0) {
            unit = (Unit)linkedList.remove(0);
        }
        if (unit != null) {
            void var10_14;
            void var11_19;
            int n3;
            Object var10_13 = null;
            Object var11_18 = null;
            int n4 = 0;
            for (Unit unit3 : physicalGameState.getUnits()) {
                if (!unit3.getType().isResource) continue;
                n3 = Math.abs(unit3.getX() - unit.getX()) + Math.abs(unit3.getY() - unit.getY());
                if (var11_19 != null && n3 >= n4) continue;
                Unit unit4 = unit3;
                n4 = n3;
            }
            n4 = 0;
            for (Unit unit5 : physicalGameState.getUnits()) {
                if (!unit5.getType().isStockpile || unit5.getPlayer() != player.getID()) continue;
                n3 = Math.abs(unit5.getX() - unit.getX()) + Math.abs(unit5.getY() - unit.getY());
                if (var10_14 != null && n3 >= n4) continue;
                Unit unit6 = unit5;
                n4 = n3;
            }
            if (var11_19 != null && var10_14 != null) {
                AbstractAction abstractAction = this.getAbstractAction(unit);
                if (abstractAction instanceof Harvest) {
                    Harvest harvest = (Harvest)abstractAction;
                    if (harvest.target != var11_19 || harvest.base != var10_14) {
                        this.harvest(unit, (Unit)var11_19, (Unit)var10_14);
                    }
                } else {
                    this.harvest(unit, (Unit)var11_19, (Unit)var10_14);
                }
            }
        }
        for (Unit unit7 : linkedList) {
            this.meleeUnitBehavior(unit7, player, gameState);
        }
    }

    @Override
    public List<ParameterSpecification> getParameters() {
        ArrayList<ParameterSpecification> arrayList = new ArrayList<ParameterSpecification>();
        arrayList.add(new ParameterSpecification("PathFinding", PathFinding.class, new AStarPathFinding()));
        return arrayList;
    }
}

