/*
 * Decompiled with CFR 0.152.
 */
package ai.abstraction.cRush;

import ai.abstraction.AbstractAction;
import ai.abstraction.Attack;
import ai.abstraction.pathfinding.PathFinding;
import java.util.List;
import rts.GameState;
import rts.PhysicalGameState;
import rts.Player;
import rts.ResourceUsage;
import rts.UnitAction;
import rts.units.Unit;
import rts.units.UnitType;
import rts.units.UnitTypeTable;
import util.XMLWriter;

public class CRanged_Tactic
extends AbstractAction {
    Unit target;
    PathFinding pf;
    Unit home;
    Unit enemyBase;
    UnitType workerType;
    UnitType rangedType;
    UnitType heavyType;
    UnitType baseType;
    UnitType barracksType;
    UnitType resourceType;
    UnitType lightType;
    UnitTypeTable utt;
    Player p;

    public CRanged_Tactic(Unit unit, Unit unit2, Unit unit3, Unit unit4, PathFinding pathFinding, UnitTypeTable unitTypeTable, Player player) {
        super(unit);
        this.target = unit2;
        this.pf = pathFinding;
        this.home = unit3;
        this.utt = unitTypeTable;
        this.p = player;
        this.workerType = this.utt.getUnitType("Worker");
        this.rangedType = this.utt.getUnitType("Ranged");
        this.heavyType = this.utt.getUnitType("Heavy");
        this.baseType = this.utt.getUnitType("Base");
        this.barracksType = this.utt.getUnitType("Barracks");
        this.resourceType = this.utt.getUnitType("Resource");
        this.lightType = this.utt.getUnitType("Light");
        this.enemyBase = unit4;
    }

    @Override
    public boolean completed(GameState gameState) {
        PhysicalGameState physicalGameState = gameState.getPhysicalGameState();
        return !physicalGameState.getUnits().contains(this.target);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Attack)) {
            return false;
        }
        CRanged_Tactic cRanged_Tactic = (CRanged_Tactic)object;
        if (this.target.getID() != cRanged_Tactic.target.getID()) {
            return false;
        }
        return this.pf.getClass() == cRanged_Tactic.pf.getClass();
    }

    @Override
    public void toxml(XMLWriter xMLWriter) {
        xMLWriter.tagWithAttributes("Attack", "unitID=\"" + this.getUnit().getID() + "\" target=\"" + this.target.getID() + "\" pathfinding=\"" + this.pf.getClass().getSimpleName() + "\"");
        xMLWriter.tag("/Attack");
    }

    @Override
    public UnitAction execute(GameState gameState, ResourceUsage resourceUsage) {
        PhysicalGameState physicalGameState = gameState.getPhysicalGameState();
        Unit unit = this.getUnit();
        boolean bl = false;
        if (this.home == null) {
            this.home = unit;
        }
        if (this.enemyBase == null) {
            this.enemyBase = this.target;
        }
        double d = 0.0;
        if (this.home != null) {
            d = this.distance(unit, this.home);
        }
        double d2 = this.distance(unit, this.target);
        List<Unit> list = physicalGameState.getUnits();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 5000;
        if (physicalGameState.getWidth() * physicalGameState.getHeight() > 3000) {
            n4 = 15000;
        }
        for (Unit unit2 : list) {
            if (unit2 != null && unit2.getPlayer() != this.p.getID() && unit2.getType() == this.baseType) {
                ++n;
            }
            if (unit2 != null && unit2.getPlayer() != this.p.getID() && (unit2.getType() == this.rangedType || unit2.getType() == this.heavyType || unit2.getType() == this.lightType)) {
                ++n2;
            }
            if (unit2 == null || unit2.getPlayer() == this.p.getID() || unit2.getType() != this.workerType) continue;
            ++n3;
        }
        if ((n3 < 2 * n || n == 0) && n2 == 0) {
            bl = true;
        }
        if (gameState.getTime() > n4) {
            bl = true;
        }
        Object object = this.nearestRangedAlly(this.enemyBase, list, gameState);
        double d3 = 0.0;
        if (object != null) {
            d3 = this.distance((Unit)object, this.target);
        }
        if (unit.getType() == this.workerType) {
            UnitAction unitAction = null;
            if (d2 <= (double)unit.getAttackRange()) {
                return new UnitAction(5, this.target.getX(), this.target.getY());
            }
            if (bl) {
                unitAction = this.pf.findPathToPositionInRange(unit, this.target.getX() + this.target.getY() * gameState.getPhysicalGameState().getWidth(), unit.getAttackRange(), gameState, resourceUsage);
            } else if (object != null) {
                unitAction = d2 > d3 ? this.pf.findPathToPositionInRange(unit, this.target.getX() + this.target.getY() * gameState.getPhysicalGameState().getWidth(), unit.getAttackRange(), gameState, resourceUsage) : this.pf.findPathToPositionInRange(unit, ((Unit)object).getX() + ((Unit)object).getY() * gameState.getPhysicalGameState().getWidth(), unit.getAttackRange(), gameState, resourceUsage);
                if (unitAction == null) {
                    unitAction = this.pf.findPathToPositionInRange(unit, ((Unit)object).getX() - 1 + ((Unit)object).getY() * gameState.getPhysicalGameState().getWidth(), unit.getAttackRange() + 1, gameState, resourceUsage);
                }
                if (unitAction == null) {
                    unitAction = this.pf.findPathToPositionInRange(unit, this.target.getX() + this.target.getY() * gameState.getPhysicalGameState().getWidth(), unit.getAttackRange(), gameState, resourceUsage);
                }
            } else {
                unitAction = this.pf.findPathToPositionInRange(unit, this.target.getX() + this.target.getY() * gameState.getPhysicalGameState().getWidth(), unit.getAttackRange(), gameState, resourceUsage);
            }
            if (unitAction != null && gameState.isUnitActionAllowed(unit, unitAction)) {
                return unitAction;
            }
            return null;
        }
        if (d2 <= (double)unit.getAttackRange()) {
            return new UnitAction(5, this.target.getX(), this.target.getY());
        }
        if (object == null || ((Unit)object).getID() == unit.getID()) {
            UnitAction unitAction = null;
            if (bl && this.target.getType() == this.baseType) {
                unitAction = this.pf.findPathToPositionInRange(unit, this.target.getX() + this.target.getY() * gameState.getPhysicalGameState().getWidth(), unit.getAttackRange(), gameState, resourceUsage);
            } else if (d < 5.0 || this.distance(unit, this.enemyBase) > this.distance(this.home, this.enemyBase)) {
                unitAction = this.pf.findPathToPositionInRange(unit, this.enemyBase.getX() + this.enemyBase.getY() * gameState.getPhysicalGameState().getWidth(), unit.getAttackRange(), gameState, resourceUsage);
            }
            if (unitAction != null && gameState.isUnitActionAllowed(unit, unitAction)) {
                return unitAction;
            }
            return null;
        }
        if (bl) {
            if (d2 <= (double)(unit.getAttackRange() - 1) && d > 2.0 && unit.getMoveTime() < this.target.getMoveTime()) {
                UnitAction unitAction = this.pf.findPathToPositionInRange(unit, this.home.getX() + this.home.getY() * gameState.getPhysicalGameState().getWidth(), this.getUnit().getAttackRange(), gameState, resourceUsage);
                if (unitAction != null && gameState.isUnitActionAllowed(unit, unitAction)) {
                    return unitAction;
                }
                return null;
            }
            if (d2 <= (double)unit.getAttackRange()) {
                return new UnitAction(5, this.target.getX(), this.target.getY());
            }
            UnitAction unitAction = this.pf.findPathToPositionInRange(unit, this.target.getX() + this.target.getY() * gameState.getPhysicalGameState().getWidth(), this.getUnit().getAttackRange(), gameState, resourceUsage);
            if (unitAction != null && gameState.isUnitActionAllowed(unit, unitAction)) {
                return unitAction;
            }
            return null;
        }
        Unit unit3 = physicalGameState.getUnitAt(((Unit)object).getX(), ((Unit)object).getY() - 1);
        Unit unit4 = physicalGameState.getUnitAt(((Unit)object).getX() - 1, ((Unit)object).getY() - 1);
        Unit unit5 = physicalGameState.getUnitAt(((Unit)object).getX() - 1, ((Unit)object).getY());
        Unit unit6 = physicalGameState.getUnitAt(((Unit)object).getX(), ((Unit)object).getY() + 1);
        Unit unit7 = physicalGameState.getUnitAt(((Unit)object).getX() + 1, ((Unit)object).getY() + 1);
        Unit unit8 = physicalGameState.getUnitAt(((Unit)object).getX() + 1, ((Unit)object).getY());
        boolean bl2 = false;
        if (this.distanceWithoutUnits(((Unit)object).getX(), ((Unit)object).getY() + 1, this.enemyBase.getX(), this.enemyBase.getY()) > this.distance((Unit)object, this.enemyBase)) {
            while (!bl2) {
                if (unit6 != null && unit != unit6 && unit7 != null && unit != unit7 && unit8 != null && unit != unit8) {
                    object = unit8;
                } else {
                    bl2 = true;
                }
                unit6 = physicalGameState.getUnitAt(((Unit)object).getX(), ((Unit)object).getY() + 1);
                unit7 = physicalGameState.getUnitAt(((Unit)object).getX() + 1, ((Unit)object).getY() + 1);
                unit8 = physicalGameState.getUnitAt(((Unit)object).getX() + 1, ((Unit)object).getY());
                if (unit6 != null && unit7 != null && unit8 != null) continue;
                bl2 = true;
            }
        } else {
            while (!bl2) {
                if (unit3 != null && unit != unit3 && unit4 != null && unit != unit4 && unit5 != null && unit != unit5) {
                    object = unit5;
                } else {
                    bl2 = true;
                }
                unit3 = physicalGameState.getUnitAt(((Unit)object).getX(), ((Unit)object).getY() - 1);
                unit4 = physicalGameState.getUnitAt(((Unit)object).getX() - 1, ((Unit)object).getY() - 1);
                unit5 = physicalGameState.getUnitAt(((Unit)object).getX() - 1, ((Unit)object).getY());
                if (unit3 != null && unit4 != null && unit5 != null) continue;
                bl2 = true;
            }
        }
        return this.squareMove(gameState, resourceUsage, (Unit)object);
    }

    public double distance(Unit unit, Unit unit2) {
        if (unit == null || unit2 == null) {
            return 0.0;
        }
        int n = unit2.getX() - unit.getX();
        int n2 = unit2.getY() - unit.getY();
        double d = Math.sqrt(n * n + n2 * n2);
        return d;
    }

    public double distanceWithoutUnits(int n, int n2, int n3, int n4) {
        int n5 = n3 - n;
        int n6 = n4 - n2;
        double d = Math.sqrt(n5 * n5 + n6 * n6);
        return d;
    }

    public UnitAction squareMove(GameState gameState, ResourceUsage resourceUsage, Unit unit) {
        PhysicalGameState physicalGameState = gameState.getPhysicalGameState();
        Unit unit2 = this.getUnit();
        Unit unit3 = unit;
        Unit unit4 = physicalGameState.getUnitAt(unit3.getX(), unit3.getY() - 1);
        Unit unit5 = physicalGameState.getUnitAt(unit3.getX() - 1, unit3.getY() - 1);
        Unit unit6 = physicalGameState.getUnitAt(unit3.getX() - 1, unit3.getY());
        Unit unit7 = physicalGameState.getUnitAt(unit3.getX(), unit3.getY() + 1);
        Unit unit8 = physicalGameState.getUnitAt(unit3.getX() + 1, unit3.getY() + 1);
        Unit unit9 = physicalGameState.getUnitAt(unit3.getX() + 1, unit3.getY());
        UnitAction unitAction = this.pf.findPath(unit2, unit3.getX() + (unit3.getY() - 1) * gameState.getPhysicalGameState().getWidth(), gameState, resourceUsage);
        UnitAction unitAction2 = this.pf.findPath(unit2, unit3.getX() - 1 + (unit3.getY() - 1) * gameState.getPhysicalGameState().getWidth(), gameState, resourceUsage);
        UnitAction unitAction3 = this.pf.findPath(unit2, unit3.getX() - 1 + unit3.getY() * gameState.getPhysicalGameState().getWidth(), gameState, resourceUsage);
        UnitAction unitAction4 = this.pf.findPath(unit2, unit3.getX() + (unit3.getY() + 1) * gameState.getPhysicalGameState().getWidth(), gameState, resourceUsage);
        UnitAction unitAction5 = this.pf.findPath(unit2, unit3.getX() + 1 + (unit3.getY() + 1) * gameState.getPhysicalGameState().getWidth(), gameState, resourceUsage);
        UnitAction unitAction6 = this.pf.findPath(unit2, unit3.getX() + 1 + unit3.getY() * gameState.getPhysicalGameState().getWidth(), gameState, resourceUsage);
        if (this.distanceWithoutUnits(unit3.getX(), unit3.getY() + 1, this.enemyBase.getX(), this.enemyBase.getY()) > this.distance(unit3, this.enemyBase)) {
            UnitAction unitAction7 = null;
            if (unit2 == unit7 || unit2 == unit8 || unit2 == unit9) {
                return null;
            }
            if (unit7 == null) {
                unitAction7 = unitAction4;
            } else if (unit9 == null) {
                unitAction7 = unitAction6;
            } else if (unit8 == null) {
                unitAction7 = unitAction5;
            }
            if (unitAction7 != null && gameState.isUnitActionAllowed(unit2, unitAction7)) {
                return unitAction7;
            }
            return null;
        }
        UnitAction unitAction8 = null;
        if (unit2 == unit4 || unit2 == unit5 || unit2 == unit6) {
            return null;
        }
        if (unit4 == null) {
            unitAction8 = unitAction;
        } else if (unit6 == null) {
            unitAction8 = unitAction3;
        } else if (unit5 == null) {
            unitAction8 = unitAction2;
        }
        if (unitAction8 != null && gameState.isUnitActionAllowed(unit2, unitAction8)) {
            return unitAction8;
        }
        return null;
    }

    public Unit farthestRangedAlly(Unit unit, List<Unit> list, GameState gameState) {
        PhysicalGameState physicalGameState = gameState.getPhysicalGameState();
        Unit unit2 = null;
        double d = 0.0;
        for (Unit unit3 : list) {
            int n;
            int n2;
            double d2;
            if (unit3.getType() != this.rangedType || unit3.getPlayer() != this.p.getID() || this.home == null || !((d2 = Math.sqrt((n2 = unit.getX() - unit3.getX()) * n2 + (n = unit.getY() - unit3.getY()) * n)) > d)) continue;
            d = d2;
            unit2 = unit3;
        }
        return unit2;
    }

    public Unit nearestRangedAlly(Unit unit, List<Unit> list, GameState gameState) {
        PhysicalGameState physicalGameState = gameState.getPhysicalGameState();
        Unit unit2 = null;
        double d = -1.0;
        if (unit != null) {
            for (Unit unit3 : list) {
                int n;
                int n2;
                double d2;
                if (unit3 == null || unit3.getPlayer() != this.p.getID() || unit3.getType() != this.rangedType || !((d2 = Math.sqrt((n2 = unit.getX() - unit3.getX()) * n2 + (n = unit.getY() - unit3.getY()) * n)) < d) && d != -1.0) continue;
                d = d2;
                unit2 = unit3;
            }
        }
        return unit2;
    }
}

