/*
 * Decompiled with CFR 0.152.
 */
package ai.abstraction.cRush;

import ai.abstraction.AbstractAction;
import ai.abstraction.AbstractionLayerAI;
import ai.abstraction.Harvest;
import ai.abstraction.cRush.RangedAttack;
import ai.abstraction.pathfinding.AStarPathFinding;
import ai.abstraction.pathfinding.PathFinding;
import ai.core.AI;
import ai.core.ParameterSpecification;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import rts.GameState;
import rts.PhysicalGameState;
import rts.Player;
import rts.PlayerAction;
import rts.units.Unit;
import rts.units.UnitType;
import rts.units.UnitTypeTable;

public class CRush_V1
extends AbstractionLayerAI {
    Random r = new Random();
    protected UnitTypeTable utt;
    UnitType workerType;
    UnitType baseType;
    UnitType barracksType;
    UnitType rangedType;
    UnitType heavyType;
    UnitType lightType;
    boolean buildingRacks = false;
    int resourcesUsed = 0;

    public CRush_V1(UnitTypeTable unitTypeTable) {
        this(unitTypeTable, new AStarPathFinding());
    }

    public CRush_V1(UnitTypeTable unitTypeTable, PathFinding pathFinding) {
        super(pathFinding);
        this.reset(unitTypeTable);
    }

    @Override
    public void reset() {
        super.reset();
    }

    @Override
    public void reset(UnitTypeTable unitTypeTable) {
        this.utt = unitTypeTable;
        this.workerType = this.utt.getUnitType("Worker");
        this.baseType = this.utt.getUnitType("Base");
        this.barracksType = this.utt.getUnitType("Barracks");
        this.rangedType = this.utt.getUnitType("Ranged");
        this.lightType = this.utt.getUnitType("Light");
    }

    @Override
    public AI clone() {
        return new CRush_V1(this.utt, this.pf);
    }

    @Override
    public PlayerAction getAction(int n, GameState gameState) {
        PhysicalGameState physicalGameState = gameState.getPhysicalGameState();
        Player player = gameState.getPlayer(n);
        boolean bl = false;
        if (physicalGameState.getWidth() * physicalGameState.getHeight() <= 144) {
            bl = true;
        }
        LinkedList<Unit> linkedList = new LinkedList<Unit>();
        for (Unit unit : physicalGameState.getUnits()) {
            if (!unit.getType().canHarvest || unit.getPlayer() != n) continue;
            linkedList.add(unit);
        }
        if (bl) {
            this.rushWorkersBehavior(linkedList, player, physicalGameState, gameState);
        } else {
            this.workersBehavior(linkedList, player, physicalGameState, gameState);
        }
        for (Unit unit : physicalGameState.getUnits()) {
            if (unit.getType() != this.baseType || unit.getPlayer() != n || gameState.getActionAssignment(unit) != null) continue;
            if (bl) {
                this.rushBaseBehavior(unit, player, physicalGameState);
                continue;
            }
            this.baseBehavior(unit, player, physicalGameState);
        }
        for (Unit unit : physicalGameState.getUnits()) {
            if (unit.getType() != this.barracksType || unit.getPlayer() != n || gameState.getActionAssignment(unit) != null) continue;
            this.barracksBehavior(unit, player, physicalGameState);
        }
        for (Unit unit : physicalGameState.getUnits()) {
            if (!unit.getType().canAttack || unit.getType().canHarvest || unit.getPlayer() != n || gameState.getActionAssignment(unit) != null) continue;
            if (unit.getType() == this.rangedType) {
                this.rangedUnitBehavior(unit, player, gameState);
                continue;
            }
            this.meleeUnitBehavior(unit, player, gameState);
        }
        return this.translateActions(n, gameState);
    }

    public void baseBehavior(Unit unit, Player player, PhysicalGameState physicalGameState) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = player.getResources();
        for (Unit unit2 : physicalGameState.getUnits()) {
            if (unit2.getType() == this.workerType && unit2.getPlayer() == player.getID()) {
                ++n3;
            }
            if (unit2.getType() == this.barracksType && unit2.getPlayer() == player.getID()) {
                ++n2;
            }
            if (unit2.getType() != this.baseType || unit2.getPlayer() != player.getID()) continue;
            ++n;
        }
        if (n3 < n + 1 && player.getResources() >= this.workerType.cost) {
            this.train(unit, this.workerType);
        }
        if (this.resourcesUsed != this.barracksType.cost * n2) {
            n4 -= this.barracksType.cost;
        }
        if (this.buildingRacks && n4 >= this.workerType.cost + this.rangedType.cost) {
            this.train(unit, this.workerType);
        }
    }

    public void barracksBehavior(Unit unit, Player player, PhysicalGameState physicalGameState) {
        if (player.getResources() >= this.rangedType.cost) {
            this.train(unit, this.rangedType);
        }
    }

    public void meleeUnitBehavior(Unit unit, Player player, GameState gameState) {
        PhysicalGameState physicalGameState = gameState.getPhysicalGameState();
        Unit unit2 = null;
        int n = 0;
        for (Unit unit3 : physicalGameState.getUnits()) {
            if (unit3.getPlayer() < 0 || unit3.getPlayer() == player.getID()) continue;
            int n2 = Math.abs(unit3.getX() - unit.getX()) + Math.abs(unit3.getY() - unit.getY());
            if (unit2 != null && n2 >= n) continue;
            unit2 = unit3;
            n = n2;
        }
        if (unit2 != null) {
            this.attack(unit, unit2);
        }
    }

    public void rangedUnitBehavior(Unit unit, Player player, GameState gameState) {
        PhysicalGameState physicalGameState = gameState.getPhysicalGameState();
        Unit unit2 = null;
        Unit unit3 = null;
        int n = 0;
        for (Unit unit4 : physicalGameState.getUnits()) {
            int n2;
            if (unit4.getPlayer() >= 0 && unit4.getPlayer() != player.getID()) {
                n2 = Math.abs(unit4.getX() - unit.getX()) + Math.abs(unit4.getY() - unit.getY());
                if (unit2 == null || n2 < n) {
                    unit2 = unit4;
                    n = n2;
                }
            }
            if (unit4.getType() != this.barracksType || unit4.getPlayer() != player.getID()) continue;
            n2 = Math.abs(unit4.getX() - unit.getX()) + Math.abs(unit4.getY() - unit.getY());
            if (unit3 != null && n2 >= n) continue;
            unit3 = unit4;
            n = n2;
        }
        if (unit2 != null) {
            this.rangedAttack(unit, unit2, unit3);
        }
    }

    public void workersBehavior(List<Unit> list, Player player, PhysicalGameState physicalGameState, GameState gameState) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        this.resourcesUsed = 0;
        LinkedList<Unit> linkedList = new LinkedList<Unit>();
        LinkedList<Unit> linkedList2 = new LinkedList<Unit>();
        for (Unit unit : physicalGameState.getUnits()) {
            if (unit.getType() == this.baseType && unit.getPlayer() == player.getID()) {
                ++n;
            }
            if (unit.getType() == this.barracksType && unit.getPlayer() == player.getID()) {
                ++n2;
            }
            if (unit.getType() != this.workerType || unit.getPlayer() != player.getID()) continue;
            ++n3;
        }
        if (list.size() > n + 1) {
            for (int j = 0; j < n + 1; ++j) {
                linkedList.add(list.get(0));
                list.remove(0);
            }
            linkedList2.addAll(list);
        } else {
            linkedList.addAll(list);
        }
        if (list.isEmpty()) {
            return;
        }
        LinkedList<Integer> linkedList3 = new LinkedList<Integer>();
        if (n == 0 && !linkedList.isEmpty() && player.getResources() >= this.baseType.cost) {
            Unit unit;
            unit = (Unit)linkedList.remove(0);
            this.buildIfNotAlreadyBuilding(unit, this.baseType, unit.getX(), unit.getY(), linkedList3, player, physicalGameState);
        }
        if (n2 == 0 && !linkedList.isEmpty() && n3 > 1 && player.getResources() >= this.barracksType.cost) {
            int n4 = player.getResources();
            Unit unit = (Unit)linkedList.remove(0);
            this.buildIfNotAlreadyBuilding(unit, this.barracksType, unit.getX(), unit.getY(), linkedList3, player, physicalGameState);
            this.resourcesUsed += this.barracksType.cost;
            this.buildingRacks = true;
        } else {
            this.resourcesUsed = this.barracksType.cost * n2;
        }
        if (n2 > 1) {
            this.buildingRacks = true;
        }
        for (Unit unit : linkedList2) {
            this.meleeUnitBehavior(unit, player, gameState);
        }
        for (Unit unit : linkedList) {
            int n4;
            Unit object = null;
            Unit object2 = null;
            int n6 = 0;
            for (Unit unit2 : physicalGameState.getUnits()) {
                if (!unit2.getType().isResource) continue;
                n4 = Math.abs(unit2.getX() - unit.getX()) + Math.abs(unit2.getY() - unit.getY());
                if (object2 != null && n4 >= n6) continue;
                object2 = unit2;
                n6 = n4;
            }
            n6 = 0;
            for (Unit unit3 : physicalGameState.getUnits()) {
                if (!unit3.getType().isStockpile || unit3.getPlayer() != player.getID()) continue;
                n4 = Math.abs(unit3.getX() - unit.getX()) + Math.abs(unit3.getY() - unit.getY());
                if (object != null && n4 >= n6) continue;
                object = unit3;
                n6 = n4;
            }
            if (object2 == null || object == null) continue;
            AbstractAction abstractAction = this.getAbstractAction(unit);
            if (abstractAction instanceof Harvest) {
                Harvest harvest = (Harvest)abstractAction;
                if (harvest.getTarget() == object2 && harvest.getBase() == object) continue;
                this.harvest(unit, object2, object);
                continue;
            }
            this.harvest(unit, object2, object);
        }
    }

    public void rushBaseBehavior(Unit unit, Player player, PhysicalGameState physicalGameState) {
        if (player.getResources() >= this.workerType.cost) {
            this.train(unit, this.workerType);
        }
    }

    public void rushWorkersBehavior(List<Unit> list, Player player, PhysicalGameState physicalGameState, GameState gameState) {
        int n = 0;
        int n2 = 0;
        this.resourcesUsed = 0;
        LinkedList<Unit> linkedList = new LinkedList<Unit>();
        LinkedList<Unit> linkedList2 = new LinkedList<Unit>();
        for (Unit object : physicalGameState.getUnits()) {
            if (object.getType() == this.baseType && object.getPlayer() == player.getID()) {
                ++n;
            }
            if (object.getType() != this.workerType || object.getPlayer() != player.getID()) continue;
            ++n2;
        }
        if (player.getResources() == 0) {
            linkedList2.addAll(list);
        } else if (list.size() > n) {
            for (int j = 0; j < n; ++j) {
                linkedList.add(list.get(0));
                list.remove(0);
            }
            linkedList2.addAll(list);
        } else {
            linkedList.addAll(list);
        }
        if (list.isEmpty()) {
            return;
        }
        LinkedList linkedList3 = new LinkedList();
        if (n == 0 && !linkedList.isEmpty() && player.getResources() >= this.baseType.cost) {
            Unit unit = (Unit)linkedList.remove(0);
            this.buildIfNotAlreadyBuilding(unit, this.baseType, unit.getX(), unit.getY(), linkedList3, player, physicalGameState);
        }
        for (Unit unit : linkedList2) {
            this.meleeUnitBehavior(unit, player, gameState);
        }
        for (Unit unit : linkedList) {
            int n3;
            Unit unit2 = null;
            Unit unit3 = null;
            int n4 = 0;
            for (Unit unit4 : physicalGameState.getUnits()) {
                if (!unit4.getType().isResource) continue;
                n3 = Math.abs(unit4.getX() - unit.getX()) + Math.abs(unit4.getY() - unit.getY());
                if (unit3 != null && n3 >= n4) continue;
                unit3 = unit4;
                n4 = n3;
            }
            n4 = 0;
            for (Unit unit5 : physicalGameState.getUnits()) {
                if (!unit5.getType().isStockpile || unit5.getPlayer() != player.getID()) continue;
                n3 = Math.abs(unit5.getX() - unit.getX()) + Math.abs(unit5.getY() - unit.getY());
                if (unit2 != null && n3 >= n4) continue;
                unit2 = unit5;
                n4 = n3;
            }
            if (unit3 == null || unit2 == null) continue;
            AbstractAction abstractAction = this.getAbstractAction(unit);
            if (abstractAction instanceof Harvest) {
                Harvest harvest = (Harvest)abstractAction;
                if (harvest.getTarget() == unit3 && harvest.getBase() == unit2) continue;
                this.harvest(unit, unit3, unit2);
                continue;
            }
            this.harvest(unit, unit3, unit2);
        }
    }

    public void rangedAttack(Unit unit, Unit unit2, Unit unit3) {
        this.actions.put(unit, new RangedAttack(unit, unit2, unit3, this.pf));
    }

    @Override
    public List<ParameterSpecification> getParameters() {
        ArrayList<ParameterSpecification> arrayList = new ArrayList<ParameterSpecification>();
        arrayList.add(new ParameterSpecification("PathFinding", PathFinding.class, new AStarPathFinding()));
        return arrayList;
    }
}

