/*
 * Decompiled with CFR 0.152.
 */
package ai.abstraction.cRush;

import ai.abstraction.AbstractAction;
import ai.abstraction.pathfinding.PathFinding;
import rts.GameState;
import rts.PhysicalGameState;
import rts.ResourceUsage;
import rts.UnitAction;
import rts.units.Unit;
import rts.units.UnitType;
import util.XMLWriter;

public class RangedAttack
extends AbstractAction {
    Unit target;
    PathFinding pf;
    Unit racks;
    UnitType workerType;
    UnitType rangedType;
    UnitType heavyType;

    public RangedAttack(Unit unit, Unit unit2, Unit unit3, PathFinding pathFinding) {
        super(unit);
        this.target = unit2;
        this.pf = pathFinding;
        this.racks = unit3;
    }

    @Override
    public boolean completed(GameState gameState) {
        PhysicalGameState physicalGameState = gameState.getPhysicalGameState();
        return !physicalGameState.getUnits().contains(this.target);
    }

    public boolean equals(Object object) {
        if (!(object instanceof RangedAttack)) {
            return false;
        }
        RangedAttack rangedAttack = (RangedAttack)object;
        if (this.target.getID() != rangedAttack.target.getID()) {
            return false;
        }
        if (this.pf.getClass() != rangedAttack.pf.getClass()) {
            return false;
        }
        return this.racks.getID() == rangedAttack.racks.getID();
    }

    @Override
    public void toxml(XMLWriter xMLWriter) {
        xMLWriter.tagWithAttributes("RangedAttack", "unitID=\"" + this.getUnit().getID() + "\" target=\"" + this.target.getID() + "\" pathfinding=\"" + this.pf.getClass().getSimpleName() + "\" racks=\"" + this.racks.getID() + "\"");
        xMLWriter.tag("/RangedAttack");
    }

    @Override
    public UnitAction execute(GameState gameState, ResourceUsage resourceUsage) {
        int n;
        int n2;
        double d;
        int n3 = 0;
        int n4 = 0;
        double d2 = 0.0;
        if (this.racks != null) {
            n3 = this.racks.getX() - this.getUnit().getX();
            n4 = this.racks.getY() - this.getUnit().getY();
            d2 = Math.sqrt(n3 * n3 + n4 * n4);
        }
        if ((d = Math.sqrt((n2 = this.target.getX() - this.getUnit().getX()) * n2 + (n = this.target.getY() - this.getUnit().getY()) * n)) <= (double)(this.getUnit().getAttackRange() - 1) && d2 > 2.0 && this.getUnit().getMoveTime() < this.target.getMoveTime()) {
            UnitAction unitAction = this.pf.findPathToPositionInRange(this.getUnit(), this.racks.getX() + this.racks.getY() * gameState.getPhysicalGameState().getWidth(), this.getUnit().getAttackRange(), gameState, resourceUsage);
            if (unitAction != null && gameState.isUnitActionAllowed(this.getUnit(), unitAction)) {
                return unitAction;
            }
            return null;
        }
        if (d <= (double)this.getUnit().getAttackRange()) {
            return new UnitAction(5, this.target.getX(), this.target.getY());
        }
        UnitAction unitAction = this.pf.findPathToPositionInRange(this.getUnit(), this.target.getX() + this.target.getY() * gameState.getPhysicalGameState().getWidth(), this.getUnit().getAttackRange(), gameState, resourceUsage);
        if (unitAction != null && gameState.isUnitActionAllowed(this.getUnit(), unitAction)) {
            return unitAction;
        }
        return null;
    }
}

