/*
 * Decompiled with CFR 0.152.
 */
package ai.abstraction.pathfinding;

import ai.abstraction.pathfinding.PathFinding;
import rts.GameState;
import rts.PhysicalGameState;
import rts.ResourceUsage;
import rts.UnitAction;
import rts.units.Unit;

public class BFSPathFinding
extends PathFinding {
    public static int iterations = 0;
    public static int accumlength = 0;
    Boolean[][] free = null;
    int[] closed = null;
    int[] open = null;
    int[] inOpenOrClosed = null;
    int[] parents = null;
    int openinsert = 0;
    int openremove = 0;

    @Override
    public UnitAction findPath(Unit unit, int n, GameState gameState, ResourceUsage resourceUsage) {
        return this.findPathToPositionInRange(unit, n, 0, gameState, resourceUsage);
    }

    @Override
    public UnitAction findPathToPositionInRange(Unit unit, int n, int n2, GameState gameState, ResourceUsage resourceUsage) {
        int n3;
        int n4;
        PhysicalGameState physicalGameState = gameState.getPhysicalGameState();
        int n5 = physicalGameState.getWidth();
        int n6 = physicalGameState.getHeight();
        if (this.free == null || this.free.length < n5 * n6) {
            this.free = new Boolean[physicalGameState.getWidth()][physicalGameState.getHeight()];
            this.closed = new int[physicalGameState.getWidth() * physicalGameState.getHeight()];
            this.open = new int[physicalGameState.getWidth() * physicalGameState.getHeight()];
            this.inOpenOrClosed = new int[physicalGameState.getWidth() * physicalGameState.getHeight()];
            this.parents = new int[physicalGameState.getWidth() * physicalGameState.getHeight()];
        }
        int n72 = 0;
        for (n4 = 0; n4 < physicalGameState.getHeight(); ++n4) {
            n3 = 0;
            while (n3 < n5) {
                this.free[n3][n4] = null;
                this.closed[n72] = -1;
                this.inOpenOrClosed[n72] = 0;
                ++n3;
                ++n72;
            }
        }
        if (resourceUsage != null) {
            for (int n72 : resourceUsage.getPositionsUsed()) {
                this.free[n72 % n5][n72 / n5] = false;
            }
        }
        n4 = n % n5;
        n72 = n / n5;
        n3 = n2 * n2;
        int n8 = unit.getY() * n5 + unit.getX();
        this.openinsert = 0;
        this.openremove = 0;
        this.open[this.openinsert] = n8;
        this.parents[this.openinsert] = n8;
        this.inOpenOrClosed[n8] = 1;
        ++this.openinsert;
        while (this.openinsert != this.openremove) {
            ++iterations;
            int n9 = this.open[this.openremove];
            int n10 = this.parents[this.openremove];
            ++this.openremove;
            if (this.openremove >= this.open.length) {
                this.openremove = 0;
            }
            if (this.closed[n9] != -1) continue;
            this.closed[n9] = n10;
            int n11 = n9 % n5;
            int n12 = n9 / n5;
            if ((n11 - n4) * (n11 - n4) + (n12 - n72) * (n12 - n72) <= n3) {
                int n13 = n9;
                while (n10 != n9) {
                    n13 = n9;
                    n9 = n10;
                    n10 = this.closed[n9];
                    ++accumlength;
                }
                if (n13 == n9 + n5) {
                    return new UnitAction(1, 2);
                }
                if (n13 == n9 - 1) {
                    return new UnitAction(1, 3);
                }
                if (n13 == n9 - n5) {
                    return new UnitAction(1, 0);
                }
                if (n13 == n9 + 1) {
                    return new UnitAction(1, 1);
                }
                return null;
            }
            if (n12 > 0 && this.inOpenOrClosed[n9 - n5] == 0) {
                if (this.free[n11][n12 - 1] == null) {
                    this.free[n11][n12 - 1] = gameState.free(n11, n12 - 1);
                }
                if (this.free[n11][n12 - 1].booleanValue()) {
                    this.open[this.openinsert] = n9 - n5;
                    this.parents[this.openinsert] = n9;
                    ++this.openinsert;
                    if (this.openinsert >= this.open.length) {
                        this.openinsert = 0;
                    }
                    this.inOpenOrClosed[n9 - n5] = 1;
                }
            }
            if (n11 < physicalGameState.getWidth() - 1 && this.inOpenOrClosed[n9 + 1] == 0) {
                if (this.free[n11 + 1][n12] == null) {
                    this.free[n11 + 1][n12] = gameState.free(n11 + 1, n12);
                }
                if (this.free[n11 + 1][n12].booleanValue()) {
                    this.open[this.openinsert] = n9 + 1;
                    this.parents[this.openinsert] = n9;
                    ++this.openinsert;
                    if (this.openinsert >= this.open.length) {
                        this.openinsert = 0;
                    }
                    this.inOpenOrClosed[n9 + 1] = 1;
                }
            }
            if (n12 < physicalGameState.getHeight() - 1 && this.inOpenOrClosed[n9 + n5] == 0) {
                if (this.free[n11][n12 + 1] == null) {
                    this.free[n11][n12 + 1] = gameState.free(n11, n12 + 1);
                }
                if (this.free[n11][n12 + 1].booleanValue()) {
                    this.open[this.openinsert] = n9 + n5;
                    this.parents[this.openinsert] = n9;
                    ++this.openinsert;
                    if (this.openinsert >= this.open.length) {
                        this.openinsert = 0;
                    }
                    this.inOpenOrClosed[n9 + n5] = 1;
                }
            }
            if (n11 <= 0 || this.inOpenOrClosed[n9 - 1] != 0) continue;
            if (this.free[n11 - 1][n12] == null) {
                this.free[n11 - 1][n12] = gameState.free(n11 - 1, n12);
            }
            if (!this.free[n11 - 1][n12].booleanValue()) continue;
            this.open[this.openinsert] = n9 - 1;
            this.parents[this.openinsert] = n9;
            ++this.openinsert;
            if (this.openinsert >= this.open.length) {
                this.openinsert = 0;
            }
            this.inOpenOrClosed[n9 - 1] = 1;
        }
        return null;
    }

    @Override
    public UnitAction findPathToAdjacentPosition(Unit unit, int n, GameState gameState, ResourceUsage resourceUsage) {
        return this.findPathToPositionInRange(unit, n, 1, gameState, resourceUsage);
    }

    @Override
    public boolean pathExists(Unit unit, int n, GameState gameState, ResourceUsage resourceUsage) {
        if (unit.getPosition(gameState.getPhysicalGameState()) == n) {
            return true;
        }
        return this.findPath(unit, n, gameState, resourceUsage) != null;
    }

    @Override
    public boolean pathToPositionInRangeExists(Unit unit, int n, int n2, GameState gameState, ResourceUsage resourceUsage) {
        int n3 = n % gameState.getPhysicalGameState().getWidth();
        int n4 = n / gameState.getPhysicalGameState().getWidth();
        int n5 = (n3 - unit.getX()) * (n3 - unit.getX()) + (n4 - unit.getY()) * (n4 - unit.getY());
        if (n5 <= n2 * n2) {
            return true;
        }
        return this.findPathToPositionInRange(unit, n, n2, gameState, resourceUsage) != null;
    }
}

