/*
 * Decompiled with CFR 0.152.
 */
package ai.abstraction.pathfinding;

import ai.abstraction.pathfinding.AStarPathFinding;
import ai.abstraction.pathfinding.PathFinding;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import rts.GameState;
import rts.PhysicalGameState;
import rts.ResourceUsage;
import rts.UnitAction;
import rts.units.Unit;
import util.Pair;

public class FloodFillPathFinding
extends PathFinding {
    PathFinding altPF = new AStarPathFinding();
    private static final int ALT_THRESHOLD = 0;
    HashMap<Integer, int[][]> cache = new HashMap();
    boolean[][] free = null;
    int[][] distances = null;
    int w;
    int h;
    int lastFrame = -1;

    @Override
    public boolean pathExists(Unit unit, int n, GameState gameState, ResourceUsage resourceUsage) {
        if (unit.getPosition(gameState.getPhysicalGameState()) == n) {
            return true;
        }
        return this.findPath(unit, n, gameState, resourceUsage) != null;
    }

    @Override
    public boolean pathToPositionInRangeExists(Unit unit, int n, int n2, GameState gameState, ResourceUsage resourceUsage) {
        int n3 = n % gameState.getPhysicalGameState().getWidth();
        int n4 = n / gameState.getPhysicalGameState().getWidth();
        int n5 = (n3 - unit.getX()) * (n3 - unit.getX()) + (n4 - unit.getY()) * (n4 - unit.getY());
        if (n5 <= n2 * n2) {
            return true;
        }
        return this.findPathToPositionInRange(unit, n, n2, gameState, resourceUsage) != null;
    }

    @Override
    public UnitAction findPath(Unit unit, int n, GameState gameState, ResourceUsage resourceUsage) {
        return this.findPathToPositionInRange(unit, n, 0, gameState, resourceUsage);
    }

    private boolean bounds(int n, int n2) {
        return n >= 0 && n2 >= 0 && n < this.w && n2 < this.h;
    }

    private void doFloodFill(int n, int n2, GameState gameState, int n3, int n4) {
        assert (this.distances[n][n2] != Integer.MAX_VALUE);
        boolean[][] blArray = gameState.getAllFree();
        ArrayList<Pair<Integer, Integer>> arrayList = new ArrayList<Pair<Integer, Integer>>(this.h * this.w);
        arrayList.add(new Pair<Integer, Integer>(n, n2));
        boolean bl = false;
        for (int j = 0; j < arrayList.size(); ++j) {
            n = (Integer)((Pair)arrayList.get((int)j)).m_a;
            n2 = (Integer)((Pair)arrayList.get((int)j)).m_b;
            int n5 = n - 1;
            int n6 = n2;
            if (n5 == n3 && n6 == n4) {
                bl = true;
            }
            if (this.bounds(n5, n6) && this.distances[n5][n6] == Integer.MAX_VALUE && this.free[n5][n6] && blArray[n5][n6]) {
                this.distances[n5][n6] = this.distances[n][n2] + 1;
                arrayList.add(new Pair<Integer, Integer>(n5, n6));
            }
            n5 = n;
            n6 = n2 - 1;
            if (n5 == n3 && n6 == n4) {
                bl = true;
            }
            if (this.bounds(n5, n6) && this.distances[n5][n6] == Integer.MAX_VALUE && this.free[n5][n6] && blArray[n5][n6]) {
                this.distances[n5][n6] = this.distances[n][n2] + 1;
                arrayList.add(new Pair<Integer, Integer>(n5, n6));
            }
            n5 = n + 1;
            n6 = n2;
            if (n5 == n3 && n6 == n4) {
                bl = true;
            }
            if (this.bounds(n5, n6) && this.distances[n5][n6] == Integer.MAX_VALUE && this.free[n5][n6] && blArray[n5][n6]) {
                this.distances[n5][n6] = this.distances[n][n2] + 1;
                arrayList.add(new Pair<Integer, Integer>(n5, n6));
            }
            n5 = n;
            n6 = n2 + 1;
            if (n5 == n3 && n6 == n4) {
                bl = true;
            }
            if (this.bounds(n5, n6) && this.distances[n5][n6] == Integer.MAX_VALUE && this.free[n5][n6] && blArray[n5][n6]) {
                this.distances[n5][n6] = this.distances[n][n2] + 1;
                arrayList.add(new Pair<Integer, Integer>(n5, n6));
            }
            if (bl) break;
        }
    }

    private UnitAction calculateDistances(Unit unit, int n, int n2, GameState gameState, ResourceUsage resourceUsage) {
        int n3 = n % this.w;
        int n4 = n / this.w;
        if (Math.abs(unit.getX() - n3) + Math.abs(unit.getY() - n4) <= 0) {
            return this.altPF.findPathToPositionInRange(unit, n, n2, gameState, resourceUsage);
        }
        for (int[] nArray : this.distances = new int[this.w][this.h]) {
            Arrays.fill(nArray, Integer.MAX_VALUE);
        }
        this.distances[n3][n4] = 0;
        this.doFloodFill(n3, n4, gameState, unit.getX(), unit.getY());
        this.cache.put(n, this.distances);
        return this.getAction(unit);
    }

    private void initFree(GameState gameState, ResourceUsage resourceUsage) {
        if (this.free == null || this.free.length < this.w || this.free[0].length < this.h) {
            this.free = new boolean[this.w][this.h];
        }
        for (boolean[] blArray : this.free) {
            Arrays.fill(blArray, true);
        }
        if (resourceUsage != null) {
            Object object = resourceUsage.getPositionsUsed().iterator();
            while (object.hasNext()) {
                int n = (Integer)object.next();
                this.free[n % this.w][n / this.w] = false;
            }
        }
    }

    private UnitAction getAction(Unit unit) {
        int n = unit.getX();
        int n2 = unit.getY();
        int[] nArray = new int[]{this.bounds(n - 1, n2) ? this.distances[n - 1][n2] : Integer.MAX_VALUE, this.bounds(n, n2 - 1) ? this.distances[n][n2 - 1] : Integer.MAX_VALUE, this.bounds(n + 1, n2) ? this.distances[n + 1][n2] : Integer.MAX_VALUE, this.bounds(n, n2 + 1) ? this.distances[n][n2 + 1] : Integer.MAX_VALUE};
        int n3 = 0;
        int n4 = nArray[0];
        for (int j = 1; j < nArray.length; ++j) {
            if (nArray[j] >= n4) continue;
            n3 = j;
            n4 = nArray[j];
        }
        if (n4 == Integer.MAX_VALUE) {
            return null;
        }
        switch (n3) {
            case 0: {
                return new UnitAction(1, 3);
            }
            case 1: {
                return new UnitAction(1, 0);
            }
            case 2: {
                return new UnitAction(1, 1);
            }
            case 3: {
                return new UnitAction(1, 2);
            }
        }
        return null;
    }

    @Override
    public UnitAction findPathToPositionInRange(Unit unit, int n, int n2, GameState gameState, ResourceUsage resourceUsage) {
        PhysicalGameState physicalGameState = gameState.getPhysicalGameState();
        this.w = physicalGameState.getWidth();
        this.h = physicalGameState.getHeight();
        int n3 = n % this.w;
        int n4 = n / this.w;
        if ((unit.getX() - n3) * (unit.getX() - n3) + (unit.getY() - n4) * (unit.getY() - n4) <= n2 * n2) {
            return null;
        }
        if (gameState.getTime() < this.lastFrame) {
            this.cache.clear();
        }
        this.lastFrame = gameState.getTime();
        this.initFree(gameState, resourceUsage);
        if (this.cache.containsKey(n)) {
            this.distances = this.cache.get(n);
            UnitAction unitAction = this.getAction(unit);
            if (unitAction != null) {
                ResourceUsage resourceUsage2 = unitAction.resourceUsage(unit, physicalGameState);
                for (int n5 : resourceUsage2.getPositionsUsed()) {
                    if (this.free[n5 % this.w][n5 / this.w] && gameState.free(n5 % this.w, n5 / this.w)) continue;
                    this.cache.remove(n);
                    return this.calculateDistances(unit, n, n2, gameState, resourceUsage);
                }
            } else {
                this.cache.remove(n);
                return this.calculateDistances(unit, n, n2, gameState, resourceUsage);
            }
            return unitAction;
        }
        return this.calculateDistances(unit, n, n2, gameState, resourceUsage);
    }

    @Override
    public UnitAction findPathToAdjacentPosition(Unit unit, int n, GameState gameState, ResourceUsage resourceUsage) {
        return this.findPathToPositionInRange(unit, n, 1, gameState, resourceUsage);
    }
}

