/*
 * Decompiled with CFR 0.152.
 */
package ai.ahtn;

import ai.abstraction.WorkerRush;
import ai.ahtn.domain.DomainDefinition;
import ai.ahtn.domain.MethodDecomposition;
import ai.ahtn.domain.PredefinedOperators;
import ai.ahtn.domain.Term;
import ai.ahtn.planner.AdversarialBoundedDepthPlannerAlphaBeta;
import ai.core.AI;
import ai.core.AIWithComputationBudget;
import ai.core.ParameterSpecification;
import ai.evaluation.EvaluationFunction;
import ai.evaluation.SimpleSqrtEvaluationFunction3;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import rts.GameState;
import rts.PlayerAction;
import rts.UnitAction;
import rts.units.Unit;
import rts.units.UnitTypeTable;
import util.Pair;

public class AHTNAI
extends AIWithComputationBudget {
    public static int DEBUG = 0;
    String domainFileName = null;
    DomainDefinition dd = null;
    EvaluationFunction ef = null;
    AI playoutAI = null;
    public int PLAYOUT_LOOKAHEAD = 100;
    List<MethodDecomposition> actionsBeingExecuted = null;

    public AHTNAI(UnitTypeTable unitTypeTable) throws Exception {
        this("data/ahtn/microrts-ahtn-definition-flexible-single-target-portfolio.lisp", 100, -1, 100, new SimpleSqrtEvaluationFunction3(), new WorkerRush(unitTypeTable));
    }

    public AHTNAI(String string, int n, int n2, int n3, EvaluationFunction evaluationFunction, AI aI) throws Exception {
        super(n, n2);
        this.domainFileName = string;
        this.dd = DomainDefinition.fromLispFile(this.domainFileName);
        this.PLAYOUT_LOOKAHEAD = n3;
        this.ef = evaluationFunction;
        this.playoutAI = aI;
        this.actionsBeingExecuted = new LinkedList<MethodDecomposition>();
    }

    @Override
    public void reset() {
        this.actionsBeingExecuted = new LinkedList<MethodDecomposition>();
        AdversarialBoundedDepthPlannerAlphaBeta.clearStatistics();
    }

    @Override
    public PlayerAction getAction(int n, GameState gameState) throws Exception {
        Term term = Term.fromString("(destroy-player " + n + " " + (1 - n) + ")");
        Term term2 = Term.fromString("(destroy-player " + (1 - n) + " " + n + ")");
        if (gameState.canExecuteAnyAction(n)) {
            Object object;
            Pair<MethodDecomposition, MethodDecomposition> pair = AdversarialBoundedDepthPlannerAlphaBeta.getBestPlanIterativeDeepening(term, term2, n, this.TIME_BUDGET, this.ITERATIONS_BUDGET, this.PLAYOUT_LOOKAHEAD, gameState, this.dd, this.ef, this.playoutAI);
            PlayerAction playerAction = new PlayerAction();
            if (pair != null) {
                LinkedList object4;
                object = (MethodDecomposition)pair.m_a;
                LinkedList linkedList = object4 = object != null ? ((MethodDecomposition)object).convertToOperatorList() : new LinkedList();
                if (DEBUG >= 1) {
                    List<Object> list = pair.m_b != null ? ((MethodDecomposition)pair.m_b).convertToOperatorList() : new LinkedList();
                    System.out.println("---- ---- ---- ----");
                    System.out.println(gameState);
                    System.out.println("Max plan:");
                    for (Pair<Unit, UnitAction> pair2 : object4) {
                        System.out.println("  " + pair2.m_a + ": " + pair2.m_b);
                    }
                    System.out.println("Min plan:");
                    for (Pair pair3 : list) {
                        System.out.println("  " + pair3.m_a + ": " + pair3.m_b);
                    }
                }
                if (DEBUG >= 2) {
                    System.out.println("Detailed Max plan:");
                    ((MethodDecomposition)pair.m_a).printDetailed();
                }
                this.actionsBeingExecuted.clear();
                while (!object4.isEmpty()) {
                    Pair pair4 = (Pair)object4.remove(0);
                    if (((Integer)pair4.m_a).intValue() != gameState.getTime()) break;
                    Iterator<Object> iterator = (List)pair4.m_b;
                    Iterator iterator2 = iterator.iterator();
                    while (iterator2.hasNext()) {
                        Term term3 = (Term)iterator2.next();
                        MethodDecomposition methodDecomposition = new MethodDecomposition(term3);
                        this.actionsBeingExecuted.add(methodDecomposition);
                    }
                }
            }
            if (DEBUG >= 1) {
                System.out.println("Actions being executed:");
                for (MethodDecomposition methodDecomposition : this.actionsBeingExecuted) {
                    System.out.println("    " + methodDecomposition.getTerm());
                }
            }
            object = new LinkedList();
            for (MethodDecomposition methodDecomposition : this.actionsBeingExecuted) {
                if (PredefinedOperators.execute(methodDecomposition, gameState, playerAction)) {
                    object.add((MethodDecomposition)methodDecomposition);
                }
                for (Pair<Unit, UnitAction> pair5 : playerAction.getActions()) {
                    if (gameState.getUnit(((Unit)pair5.m_a).getID()) != null) continue;
                    playerAction.removeUnitAction((Unit)pair5.m_a, (UnitAction)pair5.m_b);
                }
            }
            this.actionsBeingExecuted.removeAll((Collection<?>)object);
            if (DEBUG >= 1) {
                System.out.println("Result in the following unit actions:");
                System.out.println("    " + playerAction);
            }
            playerAction.fillWithNones(gameState, n, 10);
            return playerAction;
        }
        return new PlayerAction();
    }

    @Override
    public AI clone() {
        try {
            return new AHTNAI(this.domainFileName, this.TIME_BUDGET, this.ITERATIONS_BUDGET, this.PLAYOUT_LOOKAHEAD, this.ef, this.playoutAI);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.domainFileName + ", " + this.TIME_BUDGET + ", " + this.ITERATIONS_BUDGET + ", " + this.PLAYOUT_LOOKAHEAD + ", " + this.ef + ", " + this.playoutAI + ")";
    }

    @Override
    public String statisticsString() {
        return "Max depth: " + AdversarialBoundedDepthPlannerAlphaBeta.max_iterative_deepening_depth + ", Average depth: " + AdversarialBoundedDepthPlannerAlphaBeta.average_iterative_deepening_depth / (double)AdversarialBoundedDepthPlannerAlphaBeta.n_iterative_deepening_runs + ", Max tree leaves: " + AdversarialBoundedDepthPlannerAlphaBeta.max_tree_leaves + ", Average tree leaves: " + AdversarialBoundedDepthPlannerAlphaBeta.average_tree_leaves / (double)AdversarialBoundedDepthPlannerAlphaBeta.n_trees + ", Max tree nodes: " + AdversarialBoundedDepthPlannerAlphaBeta.max_tree_nodes + ", Average tree nodes: " + AdversarialBoundedDepthPlannerAlphaBeta.average_tree_nodes / (double)AdversarialBoundedDepthPlannerAlphaBeta.n_trees + ", Max tree depth: " + AdversarialBoundedDepthPlannerAlphaBeta.max_tree_depth + ", Average tree depth: " + AdversarialBoundedDepthPlannerAlphaBeta.average_tree_depth / (double)AdversarialBoundedDepthPlannerAlphaBeta.n_trees + ", Max time depth: " + AdversarialBoundedDepthPlannerAlphaBeta.max_time_depth + ", Average time depth: " + AdversarialBoundedDepthPlannerAlphaBeta.average_time_depth / (double)AdversarialBoundedDepthPlannerAlphaBeta.n_trees;
    }

    @Override
    public List<ParameterSpecification> getParameters() {
        ArrayList<ParameterSpecification> arrayList = new ArrayList<ParameterSpecification>();
        arrayList.add(new ParameterSpecification("DomainFileName", String.class, "data/ahtn/microrts-ahtn-definition-flexible-single-target-portfolio.lisp"));
        arrayList.add(new ParameterSpecification("TimeBudget", Integer.TYPE, 100));
        arrayList.add(new ParameterSpecification("IterationsBudget", Integer.TYPE, -1));
        arrayList.add(new ParameterSpecification("PlayoutLookahead", Integer.TYPE, 100));
        arrayList.add(new ParameterSpecification("PlayoutAI", AI.class, this.playoutAI));
        arrayList.add(new ParameterSpecification("EvaluationFunction", EvaluationFunction.class, new SimpleSqrtEvaluationFunction3()));
        return arrayList;
    }

    public String getDomainFileName() {
        return this.domainFileName;
    }

    public void setDomainFileName(String string) throws Exception {
        this.domainFileName = string;
        this.dd = DomainDefinition.fromLispFile(this.domainFileName);
    }

    public int getPlayoutLookahead() {
        return this.PLAYOUT_LOOKAHEAD;
    }

    public void setPlayoutLookahead(int n) {
        this.PLAYOUT_LOOKAHEAD = n;
    }

    public AI getPlayoutAI() {
        return this.playoutAI;
    }

    public void setPlayoutAI(AI aI) {
        this.playoutAI = aI;
    }

    public EvaluationFunction getEvaluationFunction() {
        return this.ef;
    }

    public void setEvaluationFunction(EvaluationFunction evaluationFunction) {
        this.ef = evaluationFunction;
    }
}

