/*
 * Decompiled with CFR 0.152.
 */
package ai.ahtn.domain;

import ai.ahtn.domain.Binding;
import ai.ahtn.domain.LispParser.LispElement;
import ai.ahtn.domain.PredefinedPredicates;
import ai.ahtn.domain.Symbol;
import ai.ahtn.domain.Term;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import rts.GameState;

public class Clause {
    public static int DEBUG = 0;
    public static final int CLAUSE_TERM = 0;
    public static final int CLAUSE_AND = 1;
    public static final int CLAUSE_OR = 2;
    public static final int CLAUSE_NOT = 3;
    public static final int CLAUSE_TRUE = 4;
    public static final int CLAUSE_FALSE = 5;
    int type = 1;
    Term term = null;
    Clause[] clauses = null;
    List<List<Binding>> matches_left;
    int matches_current;
    int matches_previous;
    List<Binding> matches_l;
    Clause[] matches_resolved;
    int[] matches_trail;

    public static Clause fromLispElement(LispElement lispElement) throws Exception {
        LispElement lispElement2 = lispElement.children.get(0);
        if (lispElement2.element.equals("and")) {
            Clause clause = new Clause();
            clause.type = 1;
            clause.clauses = new Clause[lispElement.children.size() - 1];
            for (int j = 0; j < lispElement.children.size() - 1; ++j) {
                clause.clauses[j] = Clause.fromLispElement(lispElement.children.get(j + 1));
            }
            return clause;
        }
        if (lispElement2.element.equals("or")) {
            Clause clause = new Clause();
            clause.type = 2;
            clause.clauses = new Clause[lispElement.children.size() - 1];
            for (int j = 0; j < lispElement.children.size() - 1; ++j) {
                clause.clauses[j] = Clause.fromLispElement(lispElement.children.get(j + 1));
            }
            return clause;
        }
        if (lispElement2.element.equals("not")) {
            Clause clause = new Clause();
            clause.type = 3;
            clause.clauses = new Clause[1];
            clause.clauses[0] = Clause.fromLispElement(lispElement.children.get(1));
            return clause;
        }
        if (lispElement2.element.equals("true")) {
            Clause clause = new Clause();
            clause.type = 4;
            return clause;
        }
        if (lispElement2.element.equals("false")) {
            Clause clause = new Clause();
            clause.type = 5;
            return clause;
        }
        Clause clause = new Clause();
        clause.type = 0;
        clause.term = Term.fromLispElement(lispElement);
        return clause;
    }

    public String toString() {
        switch (this.type) {
            case 0: {
                return this.term.toString();
            }
            case 1: {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("(and");
                for (int j = 0; j < this.clauses.length; ++j) {
                    stringBuilder.append(" ");
                    stringBuilder.append(this.clauses[j]);
                }
                stringBuilder.append(")");
                return stringBuilder.toString();
            }
            case 2: {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("(or");
                for (int j = 0; j < this.clauses.length; ++j) {
                    stringBuilder.append(" ");
                    stringBuilder.append(this.clauses[j]);
                }
                stringBuilder.append(")");
                return stringBuilder.toString();
            }
            case 3: {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("(not");
                for (int j = 0; j < this.clauses.length; ++j) {
                    stringBuilder.append(" ");
                    stringBuilder.append(this.clauses[j]);
                }
                stringBuilder.append(")");
                return stringBuilder.toString();
            }
            case 4: {
                return "(true)";
            }
            case 5: {
                return "(false)";
            }
        }
        return null;
    }

    public Clause resolve(List<Binding> list, GameState gameState) throws Exception {
        if (list.isEmpty()) {
            return this;
        }
        Clause clause = new Clause();
        clause.type = this.type;
        if (this.term != null) {
            clause.term = this.term.resolve(list, gameState);
        }
        if (this.clauses != null) {
            clause.clauses = new Clause[this.clauses.length];
            for (int j = 0; j < this.clauses.length; ++j) {
                clause.clauses[j] = this.clauses[j].resolve(list, gameState);
            }
        } else {
            clause.clauses = null;
        }
        return clause;
    }

    public Clause clone() {
        Clause clause = new Clause();
        clause.type = this.type;
        if (this.term != null) {
            clause.term = this.term.clone();
        }
        if (this.clauses != null) {
            clause.clauses = new Clause[this.clauses.length];
            for (int j = 0; j < this.clauses.length; ++j) {
                clause.clauses[j] = this.clauses[j].clone();
            }
        } else {
            clause.clauses = null;
        }
        return clause;
    }

    public void renameVariables(int n) {
        if (this.term != null) {
            this.term.renameVariables(n);
        }
        if (this.clauses != null) {
            for (int j = 0; j < this.clauses.length; ++j) {
                this.clauses[j].renameVariables(n);
            }
        }
    }

    public void applyBindings(List<Binding> list) throws Exception {
        if (list.isEmpty()) {
            return;
        }
        if (this.term != null) {
            this.term.applyBindings(list);
        }
        if (this.clauses != null) {
            for (int j = 0; j < this.clauses.length; ++j) {
                this.clauses[j].applyBindings(list);
            }
        }
    }

    public List<Binding> firstMatch(GameState gameState) throws Exception {
        if (DEBUG >= 1) {
            System.out.println("Clause.firstMatch");
        }
        switch (this.type) {
            case 0: {
                this.matches_left = PredefinedPredicates.allMatches(this.term, gameState);
                if (this.matches_left.isEmpty()) {
                    return null;
                }
                return this.matches_left.remove(0);
            }
            case 1: {
                this.matches_left = new ArrayList<List<Binding>>();
                this.matches_current = 0;
                this.matches_previous = -1;
                this.matches_l = new ArrayList<Binding>();
                this.matches_resolved = new Clause[this.clauses.length];
                this.matches_trail = new int[this.clauses.length];
                block8: while (true) {
                    List<Binding> list;
                    if (DEBUG >= 1) {
                        System.out.println("Clause.firstMatch(AND): current = " + this.matches_current + " (previous: " + this.matches_previous + ")");
                    }
                    Clause clause = this.clauses[this.matches_current];
                    if (this.matches_previous < this.matches_current) {
                        this.matches_resolved[this.matches_current] = clause;
                        if (this.matches_l != null) {
                            this.matches_resolved[this.matches_current] = clause.resolve(this.matches_l, gameState);
                        }
                        if (DEBUG >= 1) {
                            System.out.println("Clause.firstMatch(AND): resolved clause = " + this.matches_resolved[this.matches_current]);
                        }
                        list = this.matches_resolved[this.matches_current].firstMatch(gameState);
                        if (DEBUG >= 1) {
                            System.out.println("Clause.firstMatch(AND): match = " + list);
                        }
                    } else {
                        list = this.matches_resolved[this.matches_current].nextMatch(gameState);
                        if (DEBUG >= 1) {
                            System.out.println("Clause.firstMatch(AND): match = " + list);
                        }
                    }
                    this.matches_previous = this.matches_current--;
                    if (list == null) {
                        if (this.matches_current < 0) {
                            this.matches_left = null;
                            return null;
                        }
                        while (true) {
                            if (this.matches_l.size() <= this.matches_trail[this.matches_current]) continue block8;
                            this.matches_l.remove(this.matches_l.size() - 1);
                        }
                    }
                    this.matches_trail[this.matches_current] = this.matches_l.size();
                    this.matches_l.addAll(list);
                    ++this.matches_current;
                    if (this.matches_current >= this.clauses.length) break;
                }
                return this.matches_l;
            }
            case 2: {
                this.matches_left = new ArrayList<List<Binding>>();
                this.matches_current = 0;
                while (this.matches_current < this.clauses.length) {
                    List<Binding> list = this.clauses[this.matches_current].firstMatch(gameState);
                    if (list != null) {
                        return list;
                    }
                    ++this.matches_current;
                }
                this.matches_left = null;
                return null;
            }
            case 3: {
                List<Binding> list = this.clauses[0].firstMatch(gameState);
                this.matches_left = new ArrayList<List<Binding>>();
                if (list == null) {
                    return new ArrayList<Binding>();
                }
                return null;
            }
            case 4: {
                this.matches_left = new ArrayList<List<Binding>>();
                return new ArrayList<Binding>();
            }
            case 5: {
                this.matches_left = new ArrayList<List<Binding>>();
                return null;
            }
        }
        return null;
    }

    public List<Binding> nextMatch(GameState gameState) throws Exception {
        if (DEBUG >= 1) {
            System.out.println("Clause.nextMatch");
        }
        if (this.matches_left == null) {
            return this.firstMatch(gameState);
        }
        switch (this.type) {
            case 0: {
                if (this.matches_left.isEmpty()) {
                    this.matches_left = null;
                    return null;
                }
                return this.matches_left.remove(0);
            }
            case 1: {
                if (this.matches_current >= this.clauses.length) {
                    --this.matches_current;
                    while (this.matches_l.size() > this.matches_trail[this.matches_current]) {
                        this.matches_l.remove(this.matches_l.size() - 1);
                    }
                }
                block9: while (true) {
                    List<Binding> list;
                    Clause clause = this.clauses[this.matches_current];
                    if (this.matches_previous < this.matches_current) {
                        this.matches_resolved[this.matches_current] = clause;
                        if (this.matches_l != null) {
                            this.matches_resolved[this.matches_current] = clause.resolve(this.matches_l, gameState);
                        }
                        list = this.matches_resolved[this.matches_current].firstMatch(gameState);
                    } else {
                        list = this.matches_resolved[this.matches_current].nextMatch(gameState);
                    }
                    this.matches_previous = this.matches_current--;
                    if (list == null) {
                        if (this.matches_current < 0) {
                            this.matches_left = null;
                            return null;
                        }
                        while (true) {
                            if (this.matches_l.size() <= this.matches_trail[this.matches_current]) continue block9;
                            this.matches_l.remove(this.matches_l.size() - 1);
                        }
                    }
                    this.matches_trail[this.matches_current] = this.matches_l.size();
                    this.matches_l.addAll(list);
                    ++this.matches_current;
                    if (this.matches_current >= this.clauses.length) break;
                }
                return this.matches_l;
            }
            case 2: {
                while (this.matches_current < this.clauses.length) {
                    List<Binding> list = this.clauses[this.matches_current].nextMatch(gameState);
                    if (list != null) {
                        return list;
                    }
                    ++this.matches_current;
                }
                this.matches_left = null;
                return null;
            }
            case 3: {
                this.matches_left = null;
                return null;
            }
            case 4: {
                this.matches_left = null;
                return null;
            }
            case 5: {
                this.matches_left = null;
                return null;
            }
        }
        return null;
    }

    public void countVariableAppearances(HashMap<Symbol, Integer> hashMap) throws Exception {
        if (this.term != null) {
            this.term.countVariableAppearances(hashMap);
        }
        if (this.clauses != null) {
            for (Clause clause : this.clauses) {
                clause.countVariableAppearances(hashMap);
            }
        }
    }

    public void replaceSingletonsByWildcards(List<Symbol> list) throws Exception {
        if (this.term != null) {
            this.term.replaceSingletonsByWildcards(list);
        }
        if (this.clauses != null) {
            for (Clause clause : this.clauses) {
                clause.replaceSingletonsByWildcards(list);
            }
        }
    }
}

