/*
 * Decompiled with CFR 0.152.
 */
package ai.ahtn.domain;

import ai.ahtn.domain.HTNMethod;
import ai.ahtn.domain.HTNOperator;
import ai.ahtn.domain.LispParser.LispElement;
import ai.ahtn.domain.LispParser.LispParser;
import ai.ahtn.domain.Symbol;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class DomainDefinition {
    public static int DEBUG = 0;
    String name = null;
    List<HTNOperator> operators = new LinkedList<HTNOperator>();
    List<HTNMethod> methods = new LinkedList<HTNMethod>();
    HashMap<Symbol, List<HTNMethod>> methodsPerGoal = new HashMap();

    public List<HTNOperator> getOperators() {
        return this.operators;
    }

    public List<HTNMethod> getMethods() {
        return this.methods;
    }

    public void addMethod(HTNMethod hTNMethod) {
        this.methods.add(hTNMethod);
        Symbol symbol = hTNMethod.head.getFunctor();
        List<HTNMethod> list = this.methodsPerGoal.get(symbol);
        if (list == null) {
            list = new LinkedList<HTNMethod>();
            this.methodsPerGoal.put(symbol, list);
        }
        list.add(hTNMethod);
    }

    public static DomainDefinition fromLispFile(String string) throws Exception {
        List<LispElement> list = LispParser.parseLispFile(string);
        if (DEBUG >= 1) {
            for (LispElement lispElement : list) {
                System.out.println(lispElement);
            }
        }
        if (list.isEmpty()) {
            return null;
        }
        return DomainDefinition.fromLispElement(list.get(0));
    }

    public static DomainDefinition fromLispElement(LispElement lispElement) throws Exception {
        Object object;
        DomainDefinition domainDefinition = new DomainDefinition();
        if (lispElement.children.size() != 3) {
            throw new Exception("Lisp domain definition does not have 3 arguments");
        }
        LispElement lispElement2 = lispElement.children.get(0);
        if (lispElement2.element == null || !lispElement2.element.equals("defdomain")) {
            throw new Exception("Lisp domain definition does not start by 'defdomain'");
        }
        LispElement lispElement3 = lispElement.children.get(1);
        if (lispElement3.element == null) {
            throw new Exception("second parameter of defdomain is not a domain name");
        }
        domainDefinition.name = lispElement3.element;
        LispElement lispElement4 = lispElement.children.get(2);
        if (lispElement4.children == null) {
            throw new Exception("third parameter of defdomain is not a list");
        }
        for (LispElement object2 : lispElement4.children) {
            if (object2.children != null && object2.children.size() > 0) {
                Object object3;
                object = object2.children.get(0);
                if (((LispElement)object).element != null && ((LispElement)object).element.equals(":operator")) {
                    object3 = HTNOperator.fromLispElement(object2);
                    domainDefinition.operators.add((HTNOperator)object3);
                    continue;
                }
                if (((LispElement)object).element != null && ((LispElement)object).element.equals(":method")) {
                    object3 = HTNMethod.fromLispElement(object2);
                    domainDefinition.addMethod((HTNMethod)object3);
                    continue;
                }
                throw new Exception("Element in domain definition is not an operator nor method");
            }
            throw new Exception("Element in domain definition is not an operator nor method");
        }
        for (HTNMethod hTNMethod : domainDefinition.getMethods()) {
            if (DEBUG >= 1 && !(object = hTNMethod.findSingletons()).isEmpty()) {
                System.out.println("Singletons in '" + hTNMethod.getName() + "': " + object);
            }
            hTNMethod.replaceSingletonsByWildcards();
        }
        return domainDefinition;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Domain: " + this.name + "\n");
        stringBuilder.append("Operators:\n");
        for (HTNOperator object : this.operators) {
            stringBuilder.append("  " + object + "\n");
        }
        stringBuilder.append("Methods:\n");
        for (HTNMethod hTNMethod : this.methods) {
            stringBuilder.append("  " + hTNMethod + "\n");
        }
        return stringBuilder.toString();
    }

    public List<HTNMethod> getMethodsForGoal(Symbol symbol) {
        return this.methodsPerGoal.get(symbol);
    }
}

