/*
 * Decompiled with CFR 0.152.
 */
package ai.ahtn.domain;

import ai.ahtn.domain.Binding;
import ai.ahtn.domain.LispParser.LispElement;
import ai.ahtn.domain.MethodDecomposition;
import ai.ahtn.domain.Symbol;
import ai.ahtn.domain.Term;
import ai.ahtn.planner.AdversarialChoicePoint;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import rts.GameState;

public class HTNMethod {
    String name;
    Term head;
    MethodDecomposition method;

    public HTNMethod(String string, Term term, MethodDecomposition methodDecomposition) {
        this.name = string;
        this.head = term;
        this.method = methodDecomposition;
    }

    public String getName() {
        return this.name;
    }

    public Term getHead() {
        return this.head;
    }

    public MethodDecomposition getDecomposition() {
        return this.method;
    }

    public HTNMethod clone() {
        HTNMethod hTNMethod = new HTNMethod(this.name, this.head.clone(), this.method.clone());
        return hTNMethod;
    }

    public HTNMethod cloneTrackingDescendants(MethodDecomposition[] methodDecompositionArray, MethodDecomposition[] methodDecompositionArray2) {
        HTNMethod hTNMethod = new HTNMethod(this.name, this.head.clone(), this.method.cloneTrackingDescendants(methodDecompositionArray, methodDecompositionArray2));
        return hTNMethod;
    }

    public void renameVariables(int n) {
        this.head.renameVariables(n);
        this.method.renameVariables(n);
    }

    public void applyBindings(List<Binding> list) throws Exception {
        this.head.applyBindings(list);
        this.method.applyBindings(list);
    }

    public static HTNMethod fromLispElement(LispElement lispElement) throws Exception {
        LispElement lispElement2 = lispElement.children.get(1);
        LispElement lispElement3 = lispElement.children.get(2);
        LispElement lispElement4 = lispElement.children.get(3);
        String string = lispElement2.element;
        Term term = Term.fromLispElement(lispElement3);
        MethodDecomposition methodDecomposition = MethodDecomposition.fromLispElement(lispElement4);
        return new HTNMethod(string, term, methodDecomposition);
    }

    public void replaceSingletonsByWildcards() throws Exception {
        List<Symbol> list = this.findSingletons();
        this.head.replaceSingletonsByWildcards(list);
        this.method.replaceSingletonsByWildcards(list);
    }

    public List<Symbol> findSingletons() throws Exception {
        HashMap<Symbol, Integer> hashMap = new HashMap<Symbol, Integer>();
        this.countVariableAppearances(hashMap);
        ArrayList<Symbol> arrayList = new ArrayList<Symbol>();
        for (Symbol symbol : hashMap.keySet()) {
            if (hashMap.get(symbol) != 1) continue;
            arrayList.add(symbol);
        }
        return arrayList;
    }

    public void countVariableAppearances(HashMap<Symbol, Integer> hashMap) throws Exception {
        this.head.countVariableAppearances(hashMap);
        this.method.countVariableAppearances(hashMap);
    }

    public String toString() {
        return "method(" + this.name + "): " + this.head + ", decomposition: " + this.method;
    }

    public int executionCycle(GameState gameState, List<MethodDecomposition> list, List<MethodDecomposition> list2) {
        return this.method.executionCycle(gameState, list, list2);
    }

    public int executionCycle(GameState gameState, List<MethodDecomposition> list, List<MethodDecomposition> list2, AdversarialChoicePoint adversarialChoicePoint) {
        return this.method.executionCycle(gameState, list, list2, adversarialChoicePoint);
    }
}

