/*
 * Decompiled with CFR 0.152.
 */
package ai.ahtn.domain.LispParser;

import ai.ahtn.domain.LispParser.LispElement;
import ai.ahtn.domain.LispParser.LispTokenizer;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;

public class LispParser {
    public static int DEBUG = 0;

    public static List<LispElement> parseString(String string) throws Exception {
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        return LispParser.parseLisp(bufferedReader);
    }

    public static List<LispElement> parseLispFile(String string) throws Exception {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        return LispParser.parseLisp(bufferedReader);
    }

    public static List<LispElement> parseLisp(BufferedReader bufferedReader) throws Exception {
        LinkedList<LispElement> linkedList = new LinkedList<LispElement>();
        LinkedList<LispElement> linkedList2 = new LinkedList<LispElement>();
        LispTokenizer lispTokenizer = new LispTokenizer(bufferedReader);
        String string = lispTokenizer.nextToken();
        while (string != null) {
            if (DEBUG >= 1) {
                System.out.println("next token: " + string);
            }
            if (string.equals("(")) {
                linkedList2.add(0, new LispElement());
            } else if (string.equals(")")) {
                LispElement lispElement = (LispElement)linkedList2.remove(0);
                if (linkedList2.isEmpty()) {
                    linkedList.add(lispElement);
                } else {
                    ((LispElement)linkedList2.get((int)0)).children.add(lispElement);
                }
            } else if (linkedList2.isEmpty()) {
                linkedList.add(new LispElement(string));
            } else {
                ((LispElement)linkedList2.get((int)0)).children.add(new LispElement(string));
            }
            string = lispTokenizer.nextToken();
        }
        return linkedList;
    }
}

