/*
 * Decompiled with CFR 0.152.
 */
package ai.ahtn.domain;

import ai.ahtn.domain.Binding;
import ai.ahtn.domain.Clause;
import ai.ahtn.domain.HTNMethod;
import ai.ahtn.domain.LispParser.LispElement;
import ai.ahtn.domain.Symbol;
import ai.ahtn.domain.Term;
import ai.ahtn.planner.AdversarialChoicePoint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import rts.GameState;
import util.Pair;

public class MethodDecomposition {
    public static int DEBUG = 0;
    public static final int METHOD_CONDITION = 0;
    public static final int METHOD_OPERATOR = 1;
    public static final int METHOD_METHOD = 2;
    public static final int METHOD_SEQUENCE = 3;
    public static final int METHOD_PARALLEL = 4;
    public static final int METHOD_NON_BRANCHING_CONDITION = 5;
    public static final int EXECUTION_SUCCESS = 0;
    public static final int EXECUTION_FAILURE = 1;
    public static final int EXECUTION_ACTION_ISSUE = 2;
    public static final int EXECUTION_WAITING_FOR_ACTION = 3;
    public static final int EXECUTION_CHOICE_POINT = 4;
    protected int type = 0;
    protected Clause clause = null;
    protected Term term = null;
    protected MethodDecomposition[] subelements = null;
    HTNMethod method = null;
    int executionState = 0;
    int operatorExecutingState = 0;
    List<MethodDecomposition> operatorsBeingExecuted = null;
    Term updatedTerm = null;
    int updatedTermCycle = -1;

    public MethodDecomposition() {
    }

    public MethodDecomposition(Term term, HTNMethod hTNMethod) {
        this.type = 2;
        this.term = term;
        this.method = hTNMethod;
    }

    public MethodDecomposition(Term term) {
        this.type = 1;
        this.term = term;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    public Clause getClause() {
        return this.clause;
    }

    public Term getTerm() {
        return this.term;
    }

    public Term getUpdatedTerm() {
        return this.updatedTerm;
    }

    public void setUpdatedTerm(Term term) {
        this.updatedTerm = term;
    }

    public int getUpdatedTermCycle() {
        return this.updatedTermCycle;
    }

    public void setUpdatedTermCycle(int n) {
        this.updatedTermCycle = n;
    }

    public HTNMethod getMethod() {
        return this.method;
    }

    public MethodDecomposition[] getSubparts() {
        return this.subelements;
    }

    public void setSubparts(MethodDecomposition[] methodDecompositionArray) {
        this.subelements = methodDecompositionArray;
    }

    public int getExecutionState() {
        return this.executionState;
    }

    public int getOperatorExecutingState() {
        return this.operatorExecutingState;
    }

    public List<MethodDecomposition> getOperatorsBeingExecuted() {
        return this.operatorsBeingExecuted;
    }

    public void setOperatorsBeingExecuted(List<MethodDecomposition> list) {
        this.operatorsBeingExecuted = list;
    }

    public void setOperatorExecutingState(int n) {
        this.operatorExecutingState = n;
    }

    public void setMethod(HTNMethod hTNMethod) {
        this.method = hTNMethod;
    }

    public void setExecutionState(int n) {
        this.executionState = n;
    }

    public static MethodDecomposition fromLispElement(LispElement lispElement) throws Exception {
        LispElement lispElement2 = lispElement.children.get(0);
        if (lispElement2.element.equals(":condition")) {
            MethodDecomposition methodDecomposition = new MethodDecomposition();
            methodDecomposition.type = 0;
            methodDecomposition.clause = Clause.fromLispElement(lispElement.children.get(1));
            return methodDecomposition;
        }
        if (lispElement2.element.equals(":!condition")) {
            MethodDecomposition methodDecomposition = new MethodDecomposition();
            methodDecomposition.type = 5;
            methodDecomposition.clause = Clause.fromLispElement(lispElement.children.get(1));
            return methodDecomposition;
        }
        if (lispElement2.element.equals(":operator")) {
            MethodDecomposition methodDecomposition = new MethodDecomposition();
            methodDecomposition.type = 1;
            methodDecomposition.term = Term.fromLispElement(lispElement.children.get(1));
            return methodDecomposition;
        }
        if (lispElement2.element.equals(":method")) {
            MethodDecomposition methodDecomposition = new MethodDecomposition();
            methodDecomposition.type = 2;
            methodDecomposition.term = Term.fromLispElement(lispElement.children.get(1));
            return methodDecomposition;
        }
        if (lispElement2.element.equals(":sequence")) {
            MethodDecomposition methodDecomposition = new MethodDecomposition();
            methodDecomposition.type = 3;
            methodDecomposition.subelements = new MethodDecomposition[lispElement.children.size() - 1];
            for (int j = 0; j < lispElement.children.size() - 1; ++j) {
                methodDecomposition.subelements[j] = MethodDecomposition.fromLispElement(lispElement.children.get(j + 1));
            }
            return methodDecomposition;
        }
        if (lispElement2.element.equals(":parallel")) {
            MethodDecomposition methodDecomposition = new MethodDecomposition();
            methodDecomposition.type = 4;
            methodDecomposition.subelements = new MethodDecomposition[lispElement.children.size() - 1];
            for (int j = 0; j < lispElement.children.size() - 1; ++j) {
                methodDecomposition.subelements[j] = MethodDecomposition.fromLispElement(lispElement.children.get(j + 1));
            }
            return methodDecomposition;
        }
        throw new Exception("unrecognized method decomposition!: " + lispElement2.element);
    }

    public String toString() {
        switch (this.type) {
            case 0: {
                return "(:condition " + this.clause + ")";
            }
            case 5: {
                return "(:!condition " + this.clause + ")";
            }
            case 1: {
                if (this.updatedTerm != null) {
                    return "(:operator " + this.updatedTerm + ")";
                }
                return "(:operator " + this.term + ")";
            }
            case 2: {
                if (this.method == null) {
                    return "(:method " + this.term + ")";
                }
                return "(" + this.method + ")";
            }
            case 3: {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("(:sequence");
                for (int j = 0; j < this.subelements.length; ++j) {
                    stringBuilder.append(" ");
                    stringBuilder.append(this.subelements[j]);
                }
                stringBuilder.append(")");
                return stringBuilder.toString();
            }
            case 4: {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("(:parallel");
                for (int j = 0; j < this.subelements.length; ++j) {
                    stringBuilder.append(" ");
                    stringBuilder.append(this.subelements[j]);
                }
                stringBuilder.append(")");
                return stringBuilder.toString();
            }
        }
        return null;
    }

    public void printDetailed() {
        this.printDetailed(0);
    }

    public void printDetailed(int n) {
        int n2;
        for (n2 = 0; n2 < n; ++n2) {
            System.out.print("  ");
        }
        switch (this.type) {
            case 0: {
                System.out.println(this.hashCode() + " - " + this.executionState + " - (:condition " + this.clause + ")");
                break;
            }
            case 5: {
                System.out.println(this.hashCode() + " - " + this.executionState + " - (:!condition " + this.clause + ")");
                break;
            }
            case 1: {
                if (this.updatedTerm != null) {
                    System.out.println(this.hashCode() + " - " + this.executionState + " - (:operator " + this.updatedTerm + ")");
                    break;
                }
                System.out.println(this.hashCode() + " - " + this.executionState + " - (:operator " + this.term + ")");
                break;
            }
            case 2: {
                if (this.method != null) {
                    System.out.println(this.hashCode() + " - " + this.executionState + " - (:method " + this.method.head + ")");
                    for (n2 = 0; n2 < n; ++n2) {
                        System.out.print("  ");
                    }
                    System.out.println("Decomposition:");
                    this.method.getDecomposition().printDetailed(n + 1);
                    break;
                }
                System.out.println(this.hashCode() + " - " + this.executionState + " - (:method " + this.term + ")");
                break;
            }
            case 3: {
                System.out.println(this.hashCode() + " - " + this.executionState + " - (:sequence");
                for (n2 = 0; n2 < this.subelements.length; ++n2) {
                    this.subelements[n2].printDetailed(n + 1);
                }
                for (n2 = 0; n2 < n; ++n2) {
                    System.out.print("  ");
                }
                System.out.println(")");
                break;
            }
            case 4: {
                System.out.println(this.hashCode() + " - " + this.executionState + " - (:parallel");
                for (n2 = 0; n2 < this.subelements.length; ++n2) {
                    this.subelements[n2].printDetailed(n + 1);
                }
                for (n2 = 0; n2 < n; ++n2) {
                    System.out.print("  ");
                }
                System.out.println(")");
            }
        }
    }

    public List<MethodDecomposition> getLeaves() {
        ArrayList<MethodDecomposition> arrayList = new ArrayList<MethodDecomposition>();
        if (this.subelements == null) {
            if (this.method != null) {
                arrayList.addAll(this.method.getDecomposition().getLeaves());
            } else {
                arrayList.add(this);
            }
        } else {
            for (MethodDecomposition methodDecomposition : this.subelements) {
                arrayList.addAll(methodDecomposition.getLeaves());
            }
        }
        return arrayList;
    }

    public MethodDecomposition clone() {
        MethodDecomposition methodDecomposition = new MethodDecomposition();
        methodDecomposition.type = this.type;
        if (this.clause != null) {
            methodDecomposition.clause = this.clause.clone();
        }
        if (this.term != null) {
            methodDecomposition.term = this.term.clone();
        }
        if (this.updatedTerm != null) {
            methodDecomposition.updatedTerm = this.updatedTerm.clone();
        }
        methodDecomposition.updatedTermCycle = this.updatedTermCycle;
        methodDecomposition.executionState = this.executionState;
        methodDecomposition.operatorExecutingState = this.operatorExecutingState;
        if (this.subelements != null) {
            methodDecomposition.subelements = new MethodDecomposition[this.subelements.length];
            for (int j = 0; j < this.subelements.length; ++j) {
                methodDecomposition.subelements[j] = this.subelements[j].clone();
            }
        }
        if (this.method != null) {
            methodDecomposition.method = this.method.clone();
        }
        return methodDecomposition;
    }

    public MethodDecomposition cloneTrackingDescendants(MethodDecomposition[] methodDecompositionArray, MethodDecomposition[] methodDecompositionArray2) {
        int n;
        MethodDecomposition methodDecomposition = new MethodDecomposition();
        for (n = 0; n < methodDecompositionArray.length; ++n) {
            if (methodDecompositionArray[n] != this) continue;
            methodDecompositionArray2[n] = methodDecomposition;
        }
        methodDecomposition.type = this.type;
        if (this.clause != null) {
            methodDecomposition.clause = this.clause.clone();
        }
        if (this.term != null) {
            methodDecomposition.term = this.term.clone();
        }
        if (this.updatedTerm != null) {
            methodDecomposition.updatedTerm = this.updatedTerm.clone();
        }
        methodDecomposition.updatedTermCycle = this.updatedTermCycle;
        methodDecomposition.executionState = this.executionState;
        methodDecomposition.operatorExecutingState = this.operatorExecutingState;
        if (this.subelements != null) {
            methodDecomposition.subelements = new MethodDecomposition[this.subelements.length];
            for (n = 0; n < this.subelements.length; ++n) {
                methodDecomposition.subelements[n] = this.subelements[n].cloneTrackingDescendants(methodDecompositionArray, methodDecompositionArray2);
            }
        }
        if (this.method != null) {
            methodDecomposition.method = this.method.cloneTrackingDescendants(methodDecompositionArray, methodDecompositionArray2);
        }
        return methodDecomposition;
    }

    public void renameVariables(int n) {
        if (this.clause != null) {
            this.clause.renameVariables(n);
        }
        if (this.term != null) {
            this.term.renameVariables(n);
        }
        if (this.updatedTerm != null) {
            this.updatedTerm.renameVariables(n);
        }
        if (this.subelements != null) {
            for (int j = 0; j < this.subelements.length; ++j) {
                this.subelements[j].renameVariables(n);
            }
        }
        if (this.method != null) {
            this.method.renameVariables(n);
        }
    }

    public void applyBindings(List<Binding> list) throws Exception {
        if (this.clause != null) {
            this.clause.applyBindings(list);
        }
        if (this.term != null) {
            this.term.applyBindings(list);
        }
        if (this.updatedTerm != null) {
            this.updatedTerm.applyBindings(list);
        }
        if (this.subelements != null) {
            for (int j = 0; j < this.subelements.length; ++j) {
                this.subelements[j].applyBindings(list);
            }
        }
        if (this.method != null) {
            this.method.applyBindings(list);
        }
    }

    public void executionReset() {
        this.executionState = 0;
        this.operatorExecutingState = 0;
        this.operatorsBeingExecuted = null;
        if (this.subelements != null) {
            for (int j = 0; j < this.subelements.length; ++j) {
                this.subelements[j].executionReset();
            }
        }
        if (this.method != null) {
            this.method.getDecomposition().executionReset();
        }
    }

    public int executionCycle(GameState gameState, List<MethodDecomposition> list, List<MethodDecomposition> list2) {
        switch (this.type) {
            case 0: 
            case 5: {
                if (this.executionState == 0) {
                    list2.add(this);
                    return 4;
                }
                if (this.executionState == 1) {
                    return 0;
                }
                return 1;
            }
            case 1: {
                if (this.executionState == 0) {
                    list.add(this);
                    return 2;
                }
                if (this.executionState == 1) {
                    return 3;
                }
                return 0;
            }
            case 2: {
                if (this.method == null) {
                    list2.add(this);
                    return 4;
                }
                return this.method.executionCycle(gameState, list, list2);
            }
            case 3: {
                int n;
                while (true) {
                    if (this.executionState >= this.subelements.length) {
                        return 0;
                    }
                    n = this.subelements[this.executionState].executionCycle(gameState, list, list2);
                    if (n != 0) break;
                    ++this.executionState;
                }
                return n;
            }
            case 4: {
                boolean bl = true;
                boolean bl2 = false;
                for (int j = 0; j < this.subelements.length; ++j) {
                    int n = this.subelements[j].executionCycle(gameState, list, list2);
                    if (n == 2) {
                        bl2 = true;
                    }
                    if (n == 4 || n == 1) {
                        return n;
                    }
                    if (n == 0) continue;
                    bl = false;
                }
                if (bl) {
                    return 0;
                }
                if (bl2) {
                    return 2;
                }
                return 3;
            }
        }
        return 0;
    }

    public int executionCycle(GameState gameState, List<MethodDecomposition> list, List<MethodDecomposition> list2, AdversarialChoicePoint adversarialChoicePoint) {
        switch (this.type) {
            case 0: 
            case 5: {
                if (this.executionState == 0) {
                    list2.add(this);
                    return 4;
                }
                if (this.executionState == 1) {
                    return 0;
                }
                return 1;
            }
            case 1: {
                if (this.executionState == 0) {
                    adversarialChoicePoint.captureExecutionStateNonRecursive(this);
                    list.add(this);
                    return 2;
                }
                if (this.executionState == 1) {
                    return 3;
                }
                return 0;
            }
            case 2: {
                if (this.method == null) {
                    list2.add(this);
                    return 4;
                }
                return this.method.executionCycle(gameState, list, list2, adversarialChoicePoint);
            }
            case 3: {
                int n;
                while (true) {
                    if (this.executionState >= this.subelements.length) {
                        return 0;
                    }
                    n = this.subelements[this.executionState].executionCycle(gameState, list, list2, adversarialChoicePoint);
                    if (n != 0) break;
                    adversarialChoicePoint.captureExecutionStateNonRecursive(this);
                    ++this.executionState;
                }
                return n;
            }
            case 4: {
                boolean bl = true;
                boolean bl2 = false;
                for (int j = 0; j < this.subelements.length; ++j) {
                    int n = this.subelements[j].executionCycle(gameState, list, list2, adversarialChoicePoint);
                    if (n == 2) {
                        bl2 = true;
                    }
                    if (n == 4 || n == 1) {
                        return n;
                    }
                    if (n == 0) continue;
                    bl = false;
                }
                if (bl) {
                    return 0;
                }
                if (bl2) {
                    return 2;
                }
                return 3;
            }
        }
        return 0;
    }

    public List<Pair<Integer, List<Term>>> convertToOperatorList() throws Exception {
        ArrayList<Pair<Integer, List<Term>>> arrayList = new ArrayList<Pair<Integer, List<Term>>>();
        this.convertToOperatorList(arrayList);
        Collections.sort(arrayList, new Comparator<Pair<Integer, List<Term>>>(){

            @Override
            public int compare(Pair<Integer, List<Term>> pair, Pair<Integer, List<Term>> pair2) {
                return Integer.compare((Integer)pair.m_a, (Integer)pair2.m_a);
            }
        });
        return arrayList;
    }

    public void convertToOperatorList(List<Pair<Integer, List<Term>>> list) throws Exception {
        switch (this.type) {
            case 0: {
                return;
            }
            case 5: {
                return;
            }
            case 1: {
                if (this.updatedTerm == null) break;
                if (list.isEmpty()) {
                    Pair pair = new Pair(this.updatedTermCycle, new ArrayList());
                    ((List)pair.m_b).add(this.updatedTerm);
                    list.add(pair);
                    break;
                }
                Pair<Integer, List<Term>> pair = list.get(list.size() - 1);
                if ((Integer)pair.m_a == this.updatedTermCycle) {
                    ((List)pair.m_b).add(this.updatedTerm);
                    break;
                }
                pair = new Pair(this.updatedTermCycle, new ArrayList());
                ((List)pair.m_b).add(this.updatedTerm);
                list.add(pair);
                break;
            }
            case 2: {
                if (this.method == null) break;
                this.method.getDecomposition().convertToOperatorList(list);
                break;
            }
            case 3: 
            case 4: {
                if (this.subelements == null) break;
                for (int j = 0; j < this.subelements.length; ++j) {
                    this.subelements[j].convertToOperatorList(list);
                }
                break;
            }
        }
    }

    public void countVariableAppearances(HashMap<Symbol, Integer> hashMap) throws Exception {
        if (this.clause != null) {
            this.clause.countVariableAppearances(hashMap);
        }
        if (this.term != null) {
            this.term.countVariableAppearances(hashMap);
        }
        if (this.subelements != null) {
            for (MethodDecomposition methodDecomposition : this.subelements) {
                methodDecomposition.countVariableAppearances(hashMap);
            }
        }
    }

    public void replaceSingletonsByWildcards(List<Symbol> list) throws Exception {
        if (this.clause != null) {
            this.clause.replaceSingletonsByWildcards(list);
        }
        if (this.term != null) {
            this.term.replaceSingletonsByWildcards(list);
        }
        if (this.subelements != null) {
            for (MethodDecomposition methodDecomposition : this.subelements) {
                methodDecomposition.replaceSingletonsByWildcards(list);
            }
        }
    }
}

