/*
 * Decompiled with CFR 0.152.
 */
package ai.ahtn.domain;

import ai.ahtn.domain.Function;
import ai.ahtn.domain.IntegerConstant;
import ai.ahtn.domain.Parameter;
import ai.ahtn.domain.Symbol;
import java.util.HashMap;
import rts.GameState;

public class PredefinedFunctions {
    public static int DEBUG = 0;
    static final HashMap<Symbol, FunctionEvaluator> functions = new HashMap();

    public static Parameter evaluate(Function function, GameState gameState) throws Exception {
        FunctionEvaluator functionEvaluator = functions.get(function.functor);
        if (functionEvaluator == null) {
            System.err.println("PredefinedFunctions.evaluate: undefined function " + function);
            return null;
        }
        return functionEvaluator.evaluate(function, gameState);
    }

    static {
        try {
            functions.put(new Symbol("neighbor-position"), new FunctionEvaluator(){

                @Override
                public Parameter evaluate(Function function, GameState gameState) throws Exception {
                    if (function.parameters.length != 2) {
                        return null;
                    }
                    if (function.parameters[0] instanceof IntegerConstant && function.parameters[1] instanceof IntegerConstant) {
                        int n = ((IntegerConstant)function.parameters[0]).value;
                        int n2 = ((IntegerConstant)function.parameters[1]).value;
                        switch (n2) {
                            case 0: {
                                return new IntegerConstant(n - gameState.getPhysicalGameState().getWidth());
                            }
                            case 1: {
                                return new IntegerConstant(n + 1);
                            }
                            case 2: {
                                return new IntegerConstant(n + gameState.getPhysicalGameState().getWidth());
                            }
                            case 3: {
                                return new IntegerConstant(n - 1);
                            }
                        }
                    }
                    return null;
                }
            });
            functions.put(new Symbol("+"), new FunctionEvaluator(){

                @Override
                public Parameter evaluate(Function function, GameState gameState) throws Exception {
                    if (function.parameters.length != 2) {
                        return null;
                    }
                    if (function.parameters[0] instanceof IntegerConstant && function.parameters[1] instanceof IntegerConstant) {
                        int n = ((IntegerConstant)function.parameters[0]).value;
                        int n2 = ((IntegerConstant)function.parameters[1]).value;
                        return new IntegerConstant(n + n2);
                    }
                    return null;
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static interface FunctionEvaluator {
        public Parameter evaluate(Function var1, GameState var2) throws Exception;
    }
}

