/*
 * Decompiled with CFR 0.152.
 */
package ai.ahtn.domain;

import ai.abstraction.pathfinding.AStarPathFinding;
import ai.abstraction.pathfinding.PathFinding;
import ai.ahtn.domain.IntegerConstant;
import ai.ahtn.domain.MethodDecomposition;
import ai.ahtn.domain.Parameter;
import ai.ahtn.domain.Symbol;
import ai.ahtn.domain.SymbolConstant;
import ai.ahtn.domain.Term;
import java.util.HashMap;
import rts.GameState;
import rts.PlayerAction;
import rts.ResourceUsage;
import rts.UnitAction;
import rts.units.Unit;
import rts.units.UnitType;
import util.Pair;

public class PredefinedOperators {
    public static int DEBUG = 0;
    static PathFinding pf = new AStarPathFinding();
    static final HashMap<Symbol, OperatorExecutor> operators = new HashMap();

    public static boolean execute(MethodDecomposition methodDecomposition, GameState gameState) throws Exception {
        OperatorExecutor operatorExecutor;
        Term term = methodDecomposition.updatedTerm;
        if (term == null) {
            term = methodDecomposition.term;
        }
        if ((operatorExecutor = operators.get(term.functor)) == null) {
            throw new Exception("PredefinedFunctions.evaluate: undefined operator " + term);
        }
        return operatorExecutor.execute(term, methodDecomposition, gameState, null);
    }

    public static boolean execute(MethodDecomposition methodDecomposition, GameState gameState, PlayerAction playerAction) throws Exception {
        OperatorExecutor operatorExecutor;
        Term term = methodDecomposition.updatedTerm;
        if (term == null) {
            term = methodDecomposition.term;
        }
        if ((operatorExecutor = operators.get(term.functor)) == null) {
            throw new Exception("PredefinedFunctions.evaluate: undefined operator " + term);
        }
        return operatorExecutor.execute(term, methodDecomposition, gameState, playerAction);
    }

    static {
        try {
            operators.put(new Symbol("!wait"), new OperatorExecutor(){

                @Override
                public boolean execute(Term term, MethodDecomposition methodDecomposition, GameState gameState, PlayerAction playerAction) throws Exception {
                    int n = ((IntegerConstant)term.parameters[0]).value;
                    if (methodDecomposition.getOperatorExecutingState() == 1) {
                        return gameState.getTime() - methodDecomposition.getUpdatedTermCycle() >= n;
                    }
                    methodDecomposition.setOperatorExecutingState(1);
                    return false;
                }
            });
            operators.put(new Symbol("!wait-for-free-unit"), new OperatorExecutor(){

                @Override
                public boolean execute(Term term, MethodDecomposition methodDecomposition, GameState gameState, PlayerAction playerAction) throws Exception {
                    int n = ((IntegerConstant)term.parameters[0]).value;
                    for (Unit unit : gameState.getUnits()) {
                        if (unit.getPlayer() != n || gameState.getUnitAction(unit) != null) continue;
                        return true;
                    }
                    return false;
                }
            });
            operators.put(new Symbol("!fill-with-idles"), new OperatorExecutor(){

                @Override
                public boolean execute(Term term, MethodDecomposition methodDecomposition, GameState gameState, PlayerAction playerAction) throws Exception {
                    int n = ((IntegerConstant)term.parameters[0]).value;
                    if (playerAction == null) {
                        playerAction = new PlayerAction();
                        for (Unit unit : gameState.getUnits()) {
                            if (unit.getPlayer() != n || gameState.getUnitAction(unit) != null) continue;
                            playerAction.addUnitAction(unit, new UnitAction(0, 10));
                        }
                        gameState.issue(playerAction);
                    } else {
                        for (Unit unit : gameState.getUnits()) {
                            if (unit.getPlayer() != n || playerAction.getAction(unit) != null || gameState.getUnitAction(unit) != null) continue;
                            playerAction.addUnitAction(unit, new UnitAction(0, 10));
                        }
                    }
                    return true;
                }
            });
            operators.put(new Symbol("!idle"), new OperatorExecutor(){

                @Override
                public boolean execute(Term term, MethodDecomposition methodDecomposition, GameState gameState, PlayerAction playerAction) throws Exception {
                    int n = ((IntegerConstant)term.parameters[0]).value;
                    Unit unit = gameState.getUnit(n);
                    if (unit == null) {
                        return true;
                    }
                    if (methodDecomposition.getOperatorExecutingState() == 1) {
                        return gameState.getUnitAction(unit) == null;
                    }
                    if (playerAction == null) {
                        playerAction = new PlayerAction();
                        playerAction.addUnitAction(unit, new UnitAction(0, 10));
                        gameState.issue(playerAction);
                    } else {
                        playerAction.addUnitAction(unit, new UnitAction(0, 10));
                    }
                    methodDecomposition.setOperatorExecutingState(1);
                    return false;
                }
            });
            operators.put(new Symbol("!attack"), new OperatorExecutor(){

                @Override
                public boolean execute(Term term, MethodDecomposition methodDecomposition, GameState gameState, PlayerAction playerAction) throws Exception {
                    int n = ((IntegerConstant)term.parameters[0]).value;
                    Unit unit = gameState.getUnit(n);
                    if (unit == null) {
                        return true;
                    }
                    if (gameState.getUnitAction(unit) != null) {
                        return false;
                    }
                    if (methodDecomposition.getOperatorExecutingState() == 1) {
                        return gameState.getUnitAction(unit) == null;
                    }
                    int n2 = ((IntegerConstant)term.parameters[1]).value;
                    Unit unit2 = gameState.getUnit(n2);
                    if (unit2 == null) {
                        return true;
                    }
                    if (playerAction == null) {
                        playerAction = new PlayerAction();
                        playerAction.addUnitAction(unit, new UnitAction(5, unit2.getX(), unit2.getY()));
                        gameState.issue(playerAction);
                    } else {
                        playerAction.addUnitAction(unit, new UnitAction(5, unit2.getX(), unit2.getY()));
                    }
                    methodDecomposition.setOperatorExecutingState(1);
                    return false;
                }
            });
            operators.put(new Symbol("!harvest"), new OperatorExecutor(){

                @Override
                public boolean execute(Term term, MethodDecomposition methodDecomposition, GameState gameState, PlayerAction playerAction) throws Exception {
                    int n = ((IntegerConstant)term.parameters[0]).value;
                    Unit unit = gameState.getUnit(n);
                    if (unit == null) {
                        return true;
                    }
                    if (gameState.getUnitAction(unit) != null) {
                        return false;
                    }
                    if (methodDecomposition.getOperatorExecutingState() == 1) {
                        return gameState.getUnitAction(unit) == null;
                    }
                    int n2 = ((IntegerConstant)term.parameters[1]).value;
                    Unit unit2 = gameState.getUnit(n2);
                    if (unit2 == null) {
                        return true;
                    }
                    if (playerAction == null) {
                        playerAction = new PlayerAction();
                        if (unit.getX() == unit2.getX() - 1) {
                            playerAction.addUnitAction(unit, new UnitAction(2, 1));
                        }
                        if (unit.getX() == unit2.getX() + 1) {
                            playerAction.addUnitAction(unit, new UnitAction(2, 3));
                        }
                        if (unit.getY() == unit2.getY() - 1) {
                            playerAction.addUnitAction(unit, new UnitAction(2, 2));
                        }
                        if (unit.getY() == unit2.getY() + 1) {
                            playerAction.addUnitAction(unit, new UnitAction(2, 0));
                        }
                        gameState.issue(playerAction);
                    } else {
                        if (unit.getX() == unit2.getX() - 1) {
                            playerAction.addUnitAction(unit, new UnitAction(2, 1));
                        }
                        if (unit.getX() == unit2.getX() + 1) {
                            playerAction.addUnitAction(unit, new UnitAction(2, 3));
                        }
                        if (unit.getY() == unit2.getY() - 1) {
                            playerAction.addUnitAction(unit, new UnitAction(2, 2));
                        }
                        if (unit.getY() == unit2.getY() + 1) {
                            playerAction.addUnitAction(unit, new UnitAction(2, 0));
                        }
                    }
                    methodDecomposition.setOperatorExecutingState(1);
                    return false;
                }
            });
            operators.put(new Symbol("!return"), new OperatorExecutor(){

                @Override
                public boolean execute(Term term, MethodDecomposition methodDecomposition, GameState gameState, PlayerAction playerAction) throws Exception {
                    int n = ((IntegerConstant)term.parameters[0]).value;
                    Unit unit = gameState.getUnit(n);
                    if (unit == null) {
                        return true;
                    }
                    if (gameState.getUnitAction(unit) != null) {
                        return false;
                    }
                    if (methodDecomposition.getOperatorExecutingState() == 1) {
                        return gameState.getUnitAction(unit) == null;
                    }
                    int n2 = ((IntegerConstant)term.parameters[1]).value;
                    Unit unit2 = gameState.getUnit(n2);
                    if (unit2 == null) {
                        return true;
                    }
                    if (playerAction == null) {
                        playerAction = new PlayerAction();
                        if (unit.getX() == unit2.getX() - 1) {
                            playerAction.addUnitAction(unit, new UnitAction(3, 1));
                        }
                        if (unit.getX() == unit2.getX() + 1) {
                            playerAction.addUnitAction(unit, new UnitAction(3, 3));
                        }
                        if (unit.getY() == unit2.getY() - 1) {
                            playerAction.addUnitAction(unit, new UnitAction(3, 2));
                        }
                        if (unit.getY() == unit2.getY() + 1) {
                            playerAction.addUnitAction(unit, new UnitAction(3, 0));
                        }
                        gameState.issue(playerAction);
                    } else {
                        if (unit.getX() == unit2.getX() - 1) {
                            playerAction.addUnitAction(unit, new UnitAction(3, 1));
                        }
                        if (unit.getX() == unit2.getX() + 1) {
                            playerAction.addUnitAction(unit, new UnitAction(3, 3));
                        }
                        if (unit.getY() == unit2.getY() - 1) {
                            playerAction.addUnitAction(unit, new UnitAction(3, 2));
                        }
                        if (unit.getY() == unit2.getY() + 1) {
                            playerAction.addUnitAction(unit, new UnitAction(3, 0));
                        }
                    }
                    methodDecomposition.setOperatorExecutingState(1);
                    return false;
                }
            });
            operators.put(new Symbol("!produce"), new OperatorExecutor(){

                @Override
                public boolean execute(Term term, MethodDecomposition methodDecomposition, GameState gameState, PlayerAction playerAction) throws Exception {
                    int n = ((IntegerConstant)term.parameters[0]).value;
                    Unit unit = gameState.getUnit(n);
                    if (unit == null) {
                        return true;
                    }
                    if (gameState.getUnitAction(unit) != null) {
                        return false;
                    }
                    if (methodDecomposition.getOperatorExecutingState() == 1) {
                        return gameState.getUnitAction(unit) == null;
                    }
                    int n2 = ((IntegerConstant)term.parameters[1]).value;
                    String string = ((SymbolConstant)term.parameters[2]).get();
                    UnitType unitType = gameState.getUnitTypeTable().getUnitType(string);
                    ResourceUsage resourceUsage = gameState.getResourceUsage();
                    if (playerAction != null) {
                        for (Pair<Unit, UnitAction> pair : playerAction.getActions()) {
                            resourceUsage.merge(((UnitAction)pair.m_b).resourceUsage((Unit)pair.m_a, gameState.getPhysicalGameState()));
                        }
                    }
                    int n3 = unit.getX() + UnitAction.DIRECTION_OFFSET_X[n2];
                    int n4 = unit.getY() + UnitAction.DIRECTION_OFFSET_Y[n2];
                    if (n3 >= 0 && n3 < gameState.getPhysicalGameState().getWidth() && n4 >= 0 && n4 < gameState.getPhysicalGameState().getHeight() && gameState.free(n3, n4) && gameState.getPlayer(unit.getPlayer()).getResources() - resourceUsage.getResourcesUsed(unit.getPlayer()) >= unitType.cost) {
                        if (playerAction == null) {
                            playerAction = new PlayerAction();
                            playerAction.addUnitAction(unit, new UnitAction(4, n2, unitType));
                            gameState.issue(playerAction);
                        } else {
                            UnitAction unitAction = new UnitAction(4, n2, unitType);
                            ResourceUsage resourceUsage2 = unitAction.resourceUsage(unit, gameState.getPhysicalGameState());
                            playerAction.getResourceUsage().merge(resourceUsage2);
                            playerAction.addUnitAction(unit, unitAction);
                        }
                        methodDecomposition.setOperatorExecutingState(1);
                    }
                    return false;
                }
            });
            operators.put(new Symbol("!move"), new OperatorExecutor(){

                @Override
                public boolean execute(Term term, MethodDecomposition methodDecomposition, GameState gameState, PlayerAction playerAction) throws Exception {
                    int n;
                    Unit unit;
                    ResourceUsage resourceUsage = gameState.getResourceUsage();
                    if (playerAction != null) {
                        for (Pair<Unit, UnitAction> object2 : playerAction.getActions()) {
                            resourceUsage.merge(((UnitAction)object2.m_b).resourceUsage((Unit)object2.m_a, gameState.getPhysicalGameState()));
                        }
                    }
                    if ((unit = gameState.getUnit(n = ((IntegerConstant)term.parameters[0]).value)) == null) {
                        return true;
                    }
                    if (gameState.getUnitAction(unit) == null) {
                        Parameter parameter = term.parameters[1].resolveParameter(null, gameState);
                        int n2 = ((IntegerConstant)parameter).value;
                        UnitAction unitAction = pf.findPath(unit, n2, gameState, resourceUsage);
                        if (unitAction != null) {
                            if (playerAction == null) {
                                playerAction = new PlayerAction();
                                playerAction.addUnitAction(unit, unitAction);
                                gameState.issue(playerAction);
                            } else {
                                ResourceUsage resourceUsage2 = unitAction.resourceUsage(unit, gameState.getPhysicalGameState());
                                playerAction.getResourceUsage().merge(resourceUsage2);
                                playerAction.addUnitAction(unit, unitAction);
                            }
                            return false;
                        }
                        return true;
                    }
                    return false;
                }
            });
            operators.put(new Symbol("!move-into-attack-range"), new OperatorExecutor(){

                @Override
                public boolean execute(Term term, MethodDecomposition methodDecomposition, GameState gameState, PlayerAction playerAction) throws Exception {
                    int n;
                    Unit unit;
                    ResourceUsage resourceUsage = gameState.getResourceUsage();
                    if (playerAction != null) {
                        for (Pair<Unit, UnitAction> object2 : playerAction.getActions()) {
                            resourceUsage.merge(((UnitAction)object2.m_b).resourceUsage((Unit)object2.m_a, gameState.getPhysicalGameState()));
                        }
                    }
                    if ((unit = gameState.getUnit(n = ((IntegerConstant)term.parameters[0]).value)) == null) {
                        return true;
                    }
                    if (gameState.getUnitAction(unit) == null) {
                        int n2 = ((IntegerConstant)term.parameters[1]).value;
                        Unit unit2 = gameState.getUnit(n2);
                        if (unit2 == null) {
                            return true;
                        }
                        UnitAction unitAction = pf.findPathToPositionInRange(unit, unit2.getPosition(gameState.getPhysicalGameState()), unit.getType().attackRange, gameState, resourceUsage);
                        if (unitAction != null) {
                            if (playerAction == null) {
                                playerAction = new PlayerAction();
                                playerAction.addUnitAction(unit, unitAction);
                                gameState.issue(playerAction);
                            } else {
                                ResourceUsage resourceUsage2 = unitAction.resourceUsage(unit, gameState.getPhysicalGameState());
                                playerAction.getResourceUsage().merge(resourceUsage2);
                                playerAction.addUnitAction(unit, unitAction);
                            }
                            return false;
                        }
                        return true;
                    }
                    return false;
                }
            });
            operators.put(new Symbol("!move-into-harvest-range"), new OperatorExecutor(){

                @Override
                public boolean execute(Term term, MethodDecomposition methodDecomposition, GameState gameState, PlayerAction playerAction) throws Exception {
                    int n;
                    Unit unit;
                    ResourceUsage resourceUsage = gameState.getResourceUsage();
                    if (playerAction != null) {
                        for (Pair<Unit, UnitAction> object2 : playerAction.getActions()) {
                            resourceUsage.merge(((UnitAction)object2.m_b).resourceUsage((Unit)object2.m_a, gameState.getPhysicalGameState()));
                        }
                    }
                    if ((unit = gameState.getUnit(n = ((IntegerConstant)term.parameters[0]).value)) == null) {
                        return true;
                    }
                    if (gameState.getUnitAction(unit) == null) {
                        int n2 = ((IntegerConstant)term.parameters[1]).value;
                        Unit unit2 = gameState.getUnit(n2);
                        if (unit2 == null) {
                            return true;
                        }
                        UnitAction unitAction = pf.findPathToPositionInRange(unit, unit2.getPosition(gameState.getPhysicalGameState()), 1, gameState, resourceUsage);
                        if (unitAction != null) {
                            if (playerAction == null) {
                                playerAction = new PlayerAction();
                                playerAction.addUnitAction(unit, unitAction);
                                gameState.issue(playerAction);
                            } else {
                                ResourceUsage resourceUsage2 = unitAction.resourceUsage(unit, gameState.getPhysicalGameState());
                                playerAction.getResourceUsage().merge(resourceUsage2);
                                playerAction.addUnitAction(unit, unitAction);
                            }
                            return false;
                        }
                        return true;
                    }
                    return false;
                }
            });
            operators.put(new Symbol("!move-into-return-range"), new OperatorExecutor(){

                @Override
                public boolean execute(Term term, MethodDecomposition methodDecomposition, GameState gameState, PlayerAction playerAction) throws Exception {
                    int n;
                    Unit unit;
                    ResourceUsage resourceUsage = gameState.getResourceUsage();
                    if (playerAction != null) {
                        for (Pair<Unit, UnitAction> object2 : playerAction.getActions()) {
                            resourceUsage.merge(((UnitAction)object2.m_b).resourceUsage((Unit)object2.m_a, gameState.getPhysicalGameState()));
                        }
                    }
                    if ((unit = gameState.getUnit(n = ((IntegerConstant)term.parameters[0]).value)) == null) {
                        return true;
                    }
                    if (gameState.getUnitAction(unit) == null) {
                        int n2 = ((IntegerConstant)term.parameters[1]).value;
                        Unit unit2 = gameState.getUnit(n2);
                        if (unit2 == null) {
                            return true;
                        }
                        UnitAction unitAction = pf.findPathToPositionInRange(unit, unit2.getPosition(gameState.getPhysicalGameState()), 1, gameState, resourceUsage);
                        if (unitAction != null) {
                            if (playerAction == null) {
                                playerAction = new PlayerAction();
                                playerAction.addUnitAction(unit, unitAction);
                                gameState.issue(playerAction);
                            } else {
                                ResourceUsage resourceUsage2 = unitAction.resourceUsage(unit, gameState.getPhysicalGameState());
                                playerAction.getResourceUsage().merge(resourceUsage2);
                                playerAction.addUnitAction(unit, unitAction);
                            }
                            return false;
                        }
                        return true;
                    }
                    return false;
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static interface OperatorExecutor {
        public boolean execute(Term var1, MethodDecomposition var2, GameState var3, PlayerAction var4) throws Exception;
    }
}

