/*
 * Decompiled with CFR 0.152.
 */
package ai.ahtn.domain;

import ai.abstraction.pathfinding.AStarPathFinding;
import ai.abstraction.pathfinding.PathFinding;
import ai.ahtn.domain.Binding;
import ai.ahtn.domain.IntegerConstant;
import ai.ahtn.domain.Parameter;
import ai.ahtn.domain.Symbol;
import ai.ahtn.domain.SymbolConstant;
import ai.ahtn.domain.Term;
import ai.ahtn.domain.Variable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import rts.GameState;
import rts.Player;
import rts.ResourceUsage;
import rts.UnitAction;
import rts.units.Unit;
import rts.units.UnitType;

public class PredefinedPredicates {
    public static int DEBUG = 0;
    static PathFinding pf = new AStarPathFinding();
    static final HashMap<Symbol, PredicateTester> predicates = new HashMap();

    public static List<Binding> firstMatch(Term term, GameState gameState) throws Exception {
        PredicateTester predicateTester = predicates.get(term.functor);
        if (predicateTester == null) {
            System.err.println("PredefinedPredicates.firstMatch: undefined predicate " + term);
            return null;
        }
        return predicateTester.firstMatch(term, gameState);
    }

    public static List<List<Binding>> allMatches(Term term, GameState gameState) throws Exception {
        PredicateTester predicateTester = predicates.get(term.functor);
        if (predicateTester == null) {
            System.err.println("PredefinedPredicates.allMatches: undefined predicate " + term);
            return null;
        }
        return predicateTester.allMatches(term, gameState);
    }

    static {
        try {
            predicates.put(new Symbol("="), new PredicateTester(){

                @Override
                public List<Binding> firstMatch(Term term, GameState gameState) throws Exception {
                    LinkedList<Binding> linkedList = new LinkedList<Binding>();
                    Parameter parameter = term.parameters[0].resolveParameter(null, gameState);
                    Parameter parameter2 = term.parameters[1].resolveParameter(null, gameState);
                    if (parameter instanceof Variable) {
                        if (!(parameter2 instanceof Variable && parameter2.equals(parameter) || ((Variable)parameter).ignore())) {
                            linkedList.add(new Binding((Variable)parameter, parameter2));
                        }
                    } else if (parameter2 instanceof Variable) {
                        if (!((Variable)parameter2).ignore()) {
                            linkedList.add(new Binding((Variable)parameter2, parameter));
                        }
                    } else if (!parameter.equals(parameter2)) {
                        return null;
                    }
                    return linkedList;
                }

                @Override
                public List<List<Binding>> allMatches(Term term, GameState gameState) throws Exception {
                    List<Binding> list = this.firstMatch(term, gameState);
                    if (list == null) {
                        return new LinkedList<List<Binding>>();
                    }
                    LinkedList<List<Binding>> linkedList = new LinkedList<List<Binding>>();
                    linkedList.add(list);
                    return linkedList;
                }
            });
            predicates.put(new Symbol("unit"), new PredicateTester(){

                @Override
                public List<Binding> firstMatch(Term term, GameState gameState) throws Exception {
                    for (Unit unit : gameState.getUnits()) {
                        Parameter parameter;
                        List<Binding> list;
                        List<Binding> list2 = term.parameters[0].match((int)unit.getID());
                        if (list2 == null || (list = (parameter = term.parameters[1].resolveParameter(list2, gameState)).match(unit.getType().name)) == null) continue;
                        list2.addAll(list);
                        parameter = term.parameters[2].resolveParameter(list2, gameState);
                        list = parameter.match(unit.getPlayer());
                        if (list == null) continue;
                        list2.addAll(list);
                        parameter = term.parameters[3].resolveParameter(list2, gameState);
                        list = parameter.match(unit.getResources());
                        if (list == null) continue;
                        list2.addAll(list);
                        parameter = term.parameters[4].resolveParameter(list2, gameState);
                        list = parameter.match(unit.getPosition(gameState.getPhysicalGameState()));
                        if (list == null) continue;
                        list2.addAll(list);
                        return list2;
                    }
                    return null;
                }

                @Override
                public List<List<Binding>> allMatches(Term term, GameState gameState) throws Exception {
                    LinkedList<List<Binding>> linkedList = new LinkedList<List<Binding>>();
                    for (Unit unit : gameState.getUnits()) {
                        Parameter parameter;
                        List<Binding> list;
                        List<Binding> list2 = term.parameters[0].match((int)unit.getID());
                        if (list2 == null || (list = (parameter = term.parameters[1].resolveParameter(list2, gameState)).match(unit.getType().name)) == null) continue;
                        list2.addAll(list);
                        parameter = term.parameters[2].resolveParameter(list2, gameState);
                        list = parameter.match(unit.getPlayer());
                        if (list == null) continue;
                        list2.addAll(list);
                        parameter = term.parameters[3].resolveParameter(list2, gameState);
                        list = parameter.match(unit.getResources());
                        if (list == null) continue;
                        list2.addAll(list);
                        parameter = term.parameters[4].resolveParameter(list2, gameState);
                        list = parameter.match(unit.getPosition(gameState.getPhysicalGameState()));
                        if (list == null) continue;
                        list2.addAll(list);
                        linkedList.add(list2);
                    }
                    return linkedList;
                }
            });
            predicates.put(new Symbol("closest-unit-to"), new PredicateTester(){

                @Override
                public List<Binding> firstMatch(Term term, GameState gameState) throws Exception {
                    List<Binding> list = null;
                    int n = 0;
                    Parameter parameter = term.parameters[0];
                    Unit unit = null;
                    if (parameter instanceof IntegerConstant) {
                        unit = gameState.getUnit(((IntegerConstant)parameter).value);
                    }
                    if (unit == null) {
                        return null;
                    }
                    for (Unit unit2 : gameState.getUnits()) {
                        Parameter parameter2;
                        List<Binding> list2;
                        List<Binding> list3 = term.parameters[1].match((int)unit2.getID());
                        if (list3 == null || (list2 = (parameter2 = term.parameters[2].resolveParameter(list3, gameState)).match(unit2.getType().name)) == null) continue;
                        list3.addAll(list2);
                        parameter2 = term.parameters[3].resolveParameter(list3, gameState);
                        list2 = parameter2.match(unit2.getPlayer());
                        if (list2 == null) continue;
                        list3.addAll(list2);
                        parameter2 = term.parameters[4].resolveParameter(list3, gameState);
                        list2 = parameter2.match(unit2.getResources());
                        if (list2 == null) continue;
                        list3.addAll(list2);
                        parameter2 = term.parameters[5].resolveParameter(list3, gameState);
                        list2 = parameter2.match(unit2.getPosition(gameState.getPhysicalGameState()));
                        if (list2 == null) continue;
                        list3.addAll(list2);
                        int n2 = Math.abs(unit2.getX() - unit.getX()) + Math.abs(unit2.getY() - unit.getY());
                        if (list != null && n2 >= n) continue;
                        list = list3;
                        n = n2;
                    }
                    return list;
                }

                @Override
                public List<List<Binding>> allMatches(Term term, GameState gameState) throws Exception {
                    List<Binding> list = this.firstMatch(term, gameState);
                    if (list == null) {
                        return new LinkedList<List<Binding>>();
                    }
                    LinkedList<List<Binding>> linkedList = new LinkedList<List<Binding>>();
                    linkedList.add(list);
                    return linkedList;
                }
            });
            predicates.put(new Symbol("can-move"), new PredicateTester(){

                @Override
                public List<Binding> firstMatch(Term term, GameState gameState) throws Exception {
                    UnitType unitType;
                    Parameter parameter = term.parameters[0];
                    if (parameter instanceof SymbolConstant && (unitType = gameState.getUnitTypeTable().getUnitType(parameter.toString())) != null && unitType.canMove) {
                        return new LinkedList<Binding>();
                    }
                    return null;
                }

                @Override
                public List<List<Binding>> allMatches(Term term, GameState gameState) throws Exception {
                    List<Binding> list = this.firstMatch(term, gameState);
                    if (list == null) {
                        return new LinkedList<List<Binding>>();
                    }
                    LinkedList<List<Binding>> linkedList = new LinkedList<List<Binding>>();
                    linkedList.add(list);
                    return linkedList;
                }
            });
            predicates.put(new Symbol("can-attack"), new PredicateTester(){

                @Override
                public List<Binding> firstMatch(Term term, GameState gameState) throws Exception {
                    UnitType unitType;
                    Parameter parameter = term.parameters[0];
                    if (parameter instanceof SymbolConstant && (unitType = gameState.getUnitTypeTable().getUnitType(parameter.toString())) != null && unitType.canAttack) {
                        return new LinkedList<Binding>();
                    }
                    return null;
                }

                @Override
                public List<List<Binding>> allMatches(Term term, GameState gameState) throws Exception {
                    List<Binding> list = this.firstMatch(term, gameState);
                    if (list == null) {
                        return new LinkedList<List<Binding>>();
                    }
                    LinkedList<List<Binding>> linkedList = new LinkedList<List<Binding>>();
                    linkedList.add(list);
                    return linkedList;
                }
            });
            predicates.put(new Symbol("can-harvest"), new PredicateTester(){

                @Override
                public List<Binding> firstMatch(Term term, GameState gameState) throws Exception {
                    UnitType unitType;
                    Parameter parameter = term.parameters[0];
                    if (parameter instanceof SymbolConstant && (unitType = gameState.getUnitTypeTable().getUnitType(parameter.toString())) != null && unitType.canHarvest) {
                        return new LinkedList<Binding>();
                    }
                    return null;
                }

                @Override
                public List<List<Binding>> allMatches(Term term, GameState gameState) throws Exception {
                    List<Binding> list = this.firstMatch(term, gameState);
                    if (list == null) {
                        return new LinkedList<List<Binding>>();
                    }
                    LinkedList<List<Binding>> linkedList = new LinkedList<List<Binding>>();
                    linkedList.add(list);
                    return linkedList;
                }
            });
            predicates.put(new Symbol("can-produce"), new PredicateTester(){

                @Override
                public List<Binding> firstMatch(Term term, GameState gameState) throws Exception {
                    block13: {
                        Parameter parameter;
                        Parameter parameter2;
                        block14: {
                            block12: {
                                if (DEBUG >= 1) {
                                    System.out.println("can-produce.firstMatch: " + Arrays.toString(term.parameters));
                                }
                                parameter2 = term.parameters[0];
                                parameter = term.parameters[1];
                                if (!(parameter2 instanceof SymbolConstant)) break block12;
                                UnitType unitType = gameState.getUnitTypeTable().getUnitType(parameter2.toString());
                                if (unitType != null) {
                                    Iterator<UnitType> iterator;
                                    if (parameter instanceof SymbolConstant) {
                                        UnitType unitType2 = gameState.getUnitTypeTable().getUnitType(parameter2.toString());
                                        if (unitType != null && unitType2 != null && unitType.produces.contains(unitType2)) {
                                            return new LinkedList<Binding>();
                                        }
                                    } else if (parameter instanceof Variable && (iterator = unitType.produces.iterator()).hasNext()) {
                                        UnitType unitType3 = iterator.next();
                                        LinkedList<Binding> linkedList = new LinkedList<Binding>();
                                        if (!((Variable)parameter).ignore()) {
                                            linkedList.add(new Binding((Variable)parameter, new SymbolConstant(unitType3.name)));
                                        }
                                        return linkedList;
                                    }
                                }
                                break block13;
                            }
                            if (!(parameter2 instanceof Variable)) break block13;
                            if (!(parameter instanceof SymbolConstant)) break block14;
                            UnitType unitType = gameState.getUnitTypeTable().getUnitType(parameter2.toString());
                            for (UnitType unitType4 : gameState.getUnitTypeTable().getUnitTypes()) {
                                if (!unitType4.produces.contains(unitType)) continue;
                                LinkedList<Binding> linkedList = new LinkedList<Binding>();
                                if (!((Variable)parameter2).ignore()) {
                                    linkedList.add(new Binding((Variable)parameter2, new SymbolConstant(unitType4.name)));
                                }
                                return linkedList;
                            }
                            break block13;
                        }
                        if (!(parameter instanceof Variable)) break block13;
                        for (UnitType unitType : gameState.getUnitTypeTable().getUnitTypes()) {
                            Iterator<UnitType> iterator = unitType.produces.iterator();
                            if (!iterator.hasNext()) continue;
                            UnitType unitType5 = iterator.next();
                            LinkedList<Binding> linkedList = new LinkedList<Binding>();
                            if (!((Variable)parameter2).ignore()) {
                                linkedList.add(new Binding((Variable)parameter2, new SymbolConstant(unitType.name)));
                            }
                            if (!((Variable)parameter).ignore()) {
                                linkedList.add(new Binding((Variable)parameter, new SymbolConstant(unitType5.name)));
                            }
                            return linkedList;
                        }
                    }
                    return null;
                }

                @Override
                public List<List<Binding>> allMatches(Term term, GameState gameState) throws Exception {
                    LinkedList<List<Binding>> linkedList;
                    block14: {
                        Parameter parameter;
                        Parameter parameter2;
                        block13: {
                            UnitType unitType;
                            block15: {
                                if (DEBUG >= 1) {
                                    System.out.println("can-produce.allMatches: " + Arrays.toString(term.parameters));
                                }
                                linkedList = new LinkedList<List<Binding>>();
                                parameter2 = term.parameters[0];
                                parameter = term.parameters[1];
                                if (!(parameter2 instanceof SymbolConstant)) break block13;
                                unitType = gameState.getUnitTypeTable().getUnitType(parameter2.toString());
                                if (unitType == null) break block14;
                                if (!(parameter instanceof SymbolConstant)) break block15;
                                UnitType unitType2 = gameState.getUnitTypeTable().getUnitType(parameter2.toString());
                                if (unitType == null || unitType2 == null || !unitType.produces.contains(unitType2)) break block14;
                                linkedList.add(new LinkedList());
                                break block14;
                            }
                            if (!(parameter instanceof Variable)) break block14;
                            for (UnitType unitType3 : unitType.produces) {
                                LinkedList<Binding> linkedList2 = new LinkedList<Binding>();
                                if (!((Variable)parameter).ignore()) {
                                    linkedList2.add(new Binding((Variable)parameter, new SymbolConstant(unitType3.name)));
                                }
                                linkedList.add(linkedList2);
                            }
                            break block14;
                        }
                        if (parameter2 instanceof Variable) {
                            if (parameter instanceof SymbolConstant) {
                                UnitType unitType = gameState.getUnitTypeTable().getUnitType(parameter2.toString());
                                for (UnitType unitType4 : gameState.getUnitTypeTable().getUnitTypes()) {
                                    if (!unitType4.produces.contains(unitType)) continue;
                                    LinkedList<Binding> linkedList3 = new LinkedList<Binding>();
                                    if (!((Variable)parameter2).ignore()) {
                                        linkedList3.add(new Binding((Variable)parameter2, new SymbolConstant(unitType4.name)));
                                    }
                                    linkedList.add(linkedList3);
                                }
                            } else if (parameter instanceof Variable) {
                                for (UnitType unitType : gameState.getUnitTypeTable().getUnitTypes()) {
                                    for (UnitType unitType5 : unitType.produces) {
                                        LinkedList<Binding> linkedList4 = new LinkedList<Binding>();
                                        if (!((Variable)parameter2).ignore()) {
                                            linkedList4.add(new Binding((Variable)parameter2, new SymbolConstant(unitType.name)));
                                        }
                                        if (!((Variable)parameter).ignore()) {
                                            linkedList4.add(new Binding((Variable)parameter, new SymbolConstant(unitType5.name)));
                                        }
                                        linkedList.add(linkedList4);
                                    }
                                }
                            }
                        }
                    }
                    return linkedList;
                }
            });
            predicates.put(new Symbol("in-attack-range"), new PredicateTester(){

                @Override
                public List<Binding> firstMatch(Term term, GameState gameState) throws Exception {
                    Parameter parameter = term.parameters[0];
                    Parameter parameter2 = term.parameters[1];
                    if (parameter instanceof IntegerConstant && parameter2 instanceof IntegerConstant) {
                        int n;
                        Unit unit = gameState.getPhysicalGameState().getUnit(((IntegerConstant)parameter).value);
                        Unit unit2 = gameState.getPhysicalGameState().getUnit(((IntegerConstant)parameter2).value);
                        if (unit == null || unit2 == null) {
                            return null;
                        }
                        int n2 = unit.getAttackRange() * unit.getAttackRange();
                        int n3 = unit.getX() - unit2.getX();
                        if (n3 * n3 + (n = unit.getY() - unit2.getY()) * n <= n2) {
                            return new LinkedList<Binding>();
                        }
                    }
                    return null;
                }

                @Override
                public List<List<Binding>> allMatches(Term term, GameState gameState) throws Exception {
                    List<Binding> list = this.firstMatch(term, gameState);
                    if (list == null) {
                        return new LinkedList<List<Binding>>();
                    }
                    LinkedList<List<Binding>> linkedList = new LinkedList<List<Binding>>();
                    linkedList.add(list);
                    return linkedList;
                }
            });
            predicates.put(new Symbol("in-harvest-range"), new PredicateTester(){

                @Override
                public List<Binding> firstMatch(Term term, GameState gameState) throws Exception {
                    Parameter parameter = term.parameters[0];
                    Parameter parameter2 = term.parameters[1];
                    if (parameter instanceof IntegerConstant && parameter2 instanceof IntegerConstant) {
                        int n;
                        Unit unit = gameState.getPhysicalGameState().getUnit(((IntegerConstant)parameter).value);
                        Unit unit2 = gameState.getPhysicalGameState().getUnit(((IntegerConstant)parameter2).value);
                        int n2 = 1;
                        int n3 = unit.getX() - unit2.getX();
                        if (n3 * n3 + (n = unit.getY() - unit2.getY()) * n <= n2) {
                            return new LinkedList<Binding>();
                        }
                    }
                    return null;
                }

                @Override
                public List<List<Binding>> allMatches(Term term, GameState gameState) throws Exception {
                    List<Binding> list = this.firstMatch(term, gameState);
                    if (list == null) {
                        return new LinkedList<List<Binding>>();
                    }
                    LinkedList<List<Binding>> linkedList = new LinkedList<List<Binding>>();
                    linkedList.add(list);
                    return linkedList;
                }
            });
            predicates.put(new Symbol("in-return-range"), new PredicateTester(){

                @Override
                public List<Binding> firstMatch(Term term, GameState gameState) throws Exception {
                    Parameter parameter = term.parameters[0];
                    Parameter parameter2 = term.parameters[1];
                    if (parameter instanceof IntegerConstant && parameter2 instanceof IntegerConstant) {
                        int n;
                        Unit unit = gameState.getPhysicalGameState().getUnit(((IntegerConstant)parameter).value);
                        Unit unit2 = gameState.getPhysicalGameState().getUnit(((IntegerConstant)parameter2).value);
                        int n2 = 1;
                        int n3 = unit.getX() - unit2.getX();
                        if (n3 * n3 + (n = unit.getY() - unit2.getY()) * n <= n2) {
                            return new LinkedList<Binding>();
                        }
                    }
                    return null;
                }

                @Override
                public List<List<Binding>> allMatches(Term term, GameState gameState) throws Exception {
                    List<Binding> list = this.firstMatch(term, gameState);
                    if (list == null) {
                        return new LinkedList<List<Binding>>();
                    }
                    LinkedList<List<Binding>> linkedList = new LinkedList<List<Binding>>();
                    linkedList.add(list);
                    return linkedList;
                }
            });
            predicates.put(new Symbol("has-resources-to-produce"), new PredicateTester(){

                @Override
                public List<Binding> firstMatch(Term term, GameState gameState) throws Exception {
                    if (DEBUG >= 1) {
                        System.out.println("has-resources-to-produce.firstMatch");
                    }
                    Parameter parameter = term.parameters[0];
                    Parameter parameter2 = term.parameters[1];
                    if (parameter instanceof IntegerConstant && parameter2 instanceof SymbolConstant) {
                        Player player = gameState.getPlayer(((IntegerConstant)parameter).value);
                        UnitType unitType = gameState.getUnitTypeTable().getUnitType(((SymbolConstant)parameter2).toString());
                        ResourceUsage resourceUsage = gameState.getResourceUsage();
                        if (player.getResources() - resourceUsage.getResourcesUsed(player.getID()) >= unitType.cost) {
                            return new LinkedList<Binding>();
                        }
                    }
                    return null;
                }

                @Override
                public List<List<Binding>> allMatches(Term term, GameState gameState) throws Exception {
                    List<Binding> list;
                    if (DEBUG >= 1) {
                        System.out.println("has-resources-to-produce.allMatches");
                    }
                    if ((list = this.firstMatch(term, gameState)) == null) {
                        return new LinkedList<List<Binding>>();
                    }
                    LinkedList<List<Binding>> linkedList = new LinkedList<List<Binding>>();
                    linkedList.add(list);
                    return linkedList;
                }
            });
            predicates.put(new Symbol("direction"), new PredicateTester(){

                @Override
                public List<Binding> firstMatch(Term term, GameState gameState) throws Exception {
                    Parameter parameter = term.parameters[0];
                    if (parameter instanceof IntegerConstant) {
                        int n = ((IntegerConstant)parameter).value;
                        if (n == 0 || n == 1 || n == 2 || n == 3) {
                            return new LinkedList<Binding>();
                        }
                    } else {
                        LinkedList<Binding> linkedList = new LinkedList<Binding>();
                        if (!((Variable)parameter).ignore()) {
                            linkedList.add(new Binding((Variable)parameter, new IntegerConstant(0)));
                        }
                    }
                    return null;
                }

                @Override
                public List<List<Binding>> allMatches(Term term, GameState gameState) throws Exception {
                    LinkedList<List<Binding>> linkedList = new LinkedList<List<Binding>>();
                    Parameter parameter = term.parameters[0];
                    if (parameter instanceof IntegerConstant) {
                        int n = ((IntegerConstant)parameter).value;
                        if (n == 0 || n == 1 || n == 2 || n == 3) {
                            linkedList.add(new LinkedList());
                        }
                    } else {
                        LinkedList<Binding> linkedList2 = new LinkedList<Binding>();
                        if (!((Variable)parameter).ignore()) {
                            linkedList2.add(new Binding((Variable)parameter, new IntegerConstant(0)));
                        }
                        linkedList.add(linkedList2);
                        linkedList2 = new LinkedList();
                        if (!((Variable)parameter).ignore()) {
                            linkedList2.add(new Binding((Variable)parameter, new IntegerConstant(1)));
                        }
                        linkedList.add(linkedList2);
                        linkedList2 = new LinkedList();
                        if (!((Variable)parameter).ignore()) {
                            linkedList2.add(new Binding((Variable)parameter, new IntegerConstant(2)));
                        }
                        linkedList.add(linkedList2);
                        linkedList2 = new LinkedList();
                        if (!((Variable)parameter).ignore()) {
                            linkedList2.add(new Binding((Variable)parameter, new IntegerConstant(3)));
                        }
                        linkedList.add(linkedList2);
                    }
                    return linkedList;
                }
            });
            predicates.put(new Symbol("free-building-position"), new PredicateTester(){

                @Override
                public List<Binding> firstMatch(Term term, GameState gameState) throws Exception {
                    int n;
                    int n2;
                    Parameter parameter = term.parameters[0];
                    if (parameter instanceof IntegerConstant && gameState.free((n2 = ((IntegerConstant)parameter).value) % (n = gameState.getPhysicalGameState().getWidth()), n2 / n)) {
                        return new LinkedList<Binding>();
                    }
                    return null;
                }

                @Override
                public List<List<Binding>> allMatches(Term term, GameState gameState) throws Exception {
                    List<Binding> list = this.firstMatch(term, gameState);
                    if (list == null) {
                        return new LinkedList<List<Binding>>();
                    }
                    LinkedList<List<Binding>> linkedList = new LinkedList<List<Binding>>();
                    linkedList.add(list);
                    return linkedList;
                }
            });
            predicates.put(new Symbol("free-producing-direction"), new PredicateTester(){

                @Override
                public List<Binding> firstMatch(Term term, GameState gameState) throws Exception {
                    Parameter parameter = term.parameters[0];
                    Parameter parameter2 = term.parameters[1];
                    if (parameter instanceof IntegerConstant) {
                        Unit unit = gameState.getUnit(((IntegerConstant)parameter).value);
                        if (parameter2 instanceof IntegerConstant) {
                            int n = ((IntegerConstant)parameter2).value;
                            int n2 = unit.getX() + UnitAction.DIRECTION_OFFSET_X[n];
                            int n3 = unit.getY() + UnitAction.DIRECTION_OFFSET_Y[n];
                            if (n2 >= 0 && n2 < gameState.getPhysicalGameState().getWidth() && n3 >= 0 && n3 < gameState.getPhysicalGameState().getHeight() && gameState.free(n2, n3)) {
                                return new LinkedList<Binding>();
                            }
                        } else if (parameter2 instanceof Variable) {
                            for (int j = 0; j < 4; ++j) {
                                int n = unit.getX() + UnitAction.DIRECTION_OFFSET_X[j];
                                int n4 = unit.getY() + UnitAction.DIRECTION_OFFSET_Y[j];
                                if (n < 0 || n >= gameState.getPhysicalGameState().getWidth() || n4 < 0 || n4 >= gameState.getPhysicalGameState().getHeight() || !gameState.free(n, n4)) continue;
                                LinkedList<Binding> linkedList = new LinkedList<Binding>();
                                if (!((Variable)parameter2).ignore()) {
                                    linkedList.add(new Binding((Variable)parameter2, new IntegerConstant(j)));
                                }
                                return linkedList;
                            }
                        }
                    }
                    return null;
                }

                @Override
                public List<List<Binding>> allMatches(Term term, GameState gameState) throws Exception {
                    Parameter parameter = term.parameters[0];
                    Parameter parameter2 = term.parameters[1];
                    LinkedList<List<Binding>> linkedList = new LinkedList<List<Binding>>();
                    if (parameter instanceof IntegerConstant) {
                        Unit unit = gameState.getUnit(((IntegerConstant)parameter).value);
                        if (parameter2 instanceof IntegerConstant) {
                            int n = ((IntegerConstant)parameter2).value;
                            int n2 = unit.getX() + UnitAction.DIRECTION_OFFSET_X[n];
                            int n3 = unit.getY() + UnitAction.DIRECTION_OFFSET_Y[n];
                            if (n2 >= 0 && n2 < gameState.getPhysicalGameState().getWidth() && n3 >= 0 && n3 < gameState.getPhysicalGameState().getHeight() && gameState.free(n2, n3)) {
                                linkedList.add(new LinkedList());
                            }
                        } else if (parameter2 instanceof Variable) {
                            for (int j = 0; j < 4; ++j) {
                                int n = unit.getX() + UnitAction.DIRECTION_OFFSET_X[j];
                                int n4 = unit.getY() + UnitAction.DIRECTION_OFFSET_Y[j];
                                if (n < 0 || n >= gameState.getPhysicalGameState().getWidth() || n4 < 0 || n4 >= gameState.getPhysicalGameState().getHeight() || !gameState.free(n, n4)) continue;
                                LinkedList<Binding> linkedList2 = new LinkedList<Binding>();
                                if (!((Variable)parameter2).ignore()) {
                                    linkedList2.add(new Binding((Variable)parameter2, new IntegerConstant(j)));
                                }
                                linkedList.add(linkedList2);
                            }
                        }
                    }
                    return linkedList;
                }
            });
            predicates.put(new Symbol("next-available-unit"), new PredicateTester(){

                @Override
                public List<Binding> firstMatch(Term term, GameState gameState) throws Exception {
                    Parameter parameter = term.parameters[0];
                    Parameter parameter2 = term.parameters[1];
                    Parameter parameter3 = term.parameters[2];
                    if (!(parameter instanceof IntegerConstant)) {
                        return null;
                    }
                    if (!(parameter2 instanceof IntegerConstant)) {
                        return null;
                    }
                    if (!(parameter3 instanceof Variable)) {
                        return null;
                    }
                    int n = ((IntegerConstant)parameter).value;
                    int n2 = ((IntegerConstant)parameter2).value;
                    Unit unit = null;
                    for (Unit unit2 : gameState.getUnits()) {
                        if (unit2.getPlayer() != n2 || unit2.getID() <= (long)n || gameState.getUnitAction(unit2) != null) continue;
                        if (unit == null) {
                            unit = unit2;
                            continue;
                        }
                        if (unit2.getID() >= unit.getID()) continue;
                        unit = unit2;
                    }
                    if (unit != null) {
                        LinkedList linkedList = new LinkedList();
                        linkedList.add(new Binding((Variable)parameter3, new IntegerConstant((int)unit.getID())));
                        return linkedList;
                    }
                    return null;
                }

                @Override
                public List<List<Binding>> allMatches(Term term, GameState gameState) throws Exception {
                    List<Binding> list = this.firstMatch(term, gameState);
                    if (list == null) {
                        return new LinkedList<List<Binding>>();
                    }
                    LinkedList<List<Binding>> linkedList = new LinkedList<List<Binding>>();
                    linkedList.add(list);
                    return linkedList;
                }
            });
            predicates.put(new Symbol("no-more-available-units"), new PredicateTester(){

                @Override
                public List<Binding> firstMatch(Term term, GameState gameState) throws Exception {
                    Parameter parameter = term.parameters[0];
                    Parameter parameter2 = term.parameters[1];
                    if (!(parameter instanceof IntegerConstant)) {
                        return null;
                    }
                    if (!(parameter2 instanceof IntegerConstant)) {
                        return null;
                    }
                    int n = ((IntegerConstant)parameter).value;
                    int n2 = ((IntegerConstant)parameter2).value;
                    for (Unit unit : gameState.getUnits()) {
                        if (unit.getPlayer() != n2 || unit.getID() <= (long)n || gameState.getUnitAction(unit) != null) continue;
                        return null;
                    }
                    return new LinkedList<Binding>();
                }

                @Override
                public List<List<Binding>> allMatches(Term term, GameState gameState) throws Exception {
                    List<Binding> list = this.firstMatch(term, gameState);
                    if (list == null) {
                        return new LinkedList<List<Binding>>();
                    }
                    LinkedList<List<Binding>> linkedList = new LinkedList<List<Binding>>();
                    linkedList.add(list);
                    return linkedList;
                }
            });
            predicates.put(new Symbol("path"), new PredicateTester(){

                @Override
                public List<Binding> firstMatch(Term term, GameState gameState) throws Exception {
                    Parameter parameter = term.parameters[0];
                    Parameter parameter2 = term.parameters[1];
                    if (parameter instanceof IntegerConstant && parameter2 instanceof IntegerConstant) {
                        Unit unit = gameState.getPhysicalGameState().getUnit(((IntegerConstant)parameter).value);
                        Unit unit2 = gameState.getPhysicalGameState().getUnit(((IntegerConstant)parameter2).value);
                        if (unit == null || unit2 == null) {
                            return null;
                        }
                        if (pf.pathToPositionInRangeExists(unit, unit2.getPosition(gameState.getPhysicalGameState()), 1, gameState, null)) {
                            return new LinkedList<Binding>();
                        }
                        return null;
                    }
                    return null;
                }

                @Override
                public List<List<Binding>> allMatches(Term term, GameState gameState) throws Exception {
                    List<Binding> list = this.firstMatch(term, gameState);
                    if (list == null) {
                        return new LinkedList<List<Binding>>();
                    }
                    LinkedList<List<Binding>> linkedList = new LinkedList<List<Binding>>();
                    linkedList.add(list);
                    return linkedList;
                }
            });
            predicates.put(new Symbol("path-to-attack"), new PredicateTester(){

                @Override
                public List<Binding> firstMatch(Term term, GameState gameState) throws Exception {
                    Parameter parameter = term.parameters[0];
                    Parameter parameter2 = term.parameters[1];
                    if (parameter instanceof IntegerConstant && parameter2 instanceof IntegerConstant) {
                        Unit unit = gameState.getPhysicalGameState().getUnit(((IntegerConstant)parameter).value);
                        Unit unit2 = gameState.getPhysicalGameState().getUnit(((IntegerConstant)parameter2).value);
                        if (unit == null || unit2 == null) {
                            return null;
                        }
                        if (pf.pathToPositionInRangeExists(unit, unit2.getPosition(gameState.getPhysicalGameState()), unit.getAttackRange(), gameState, null)) {
                            return new LinkedList<Binding>();
                        }
                        return null;
                    }
                    throw new Exception("no path, invalid units: " + parameter + ", " + parameter2);
                }

                @Override
                public List<List<Binding>> allMatches(Term term, GameState gameState) throws Exception {
                    List<Binding> list = this.firstMatch(term, gameState);
                    if (list == null) {
                        return new LinkedList<List<Binding>>();
                    }
                    LinkedList<List<Binding>> linkedList = new LinkedList<List<Binding>>();
                    linkedList.add(list);
                    return linkedList;
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static interface PredicateTester {
        public List<Binding> firstMatch(Term var1, GameState var2) throws Exception;

        public List<List<Binding>> allMatches(Term var1, GameState var2) throws Exception;
    }
}

