/*
 * Decompiled with CFR 0.152.
 */
package ai.ahtn.domain;

import ai.ahtn.domain.Binding;
import ai.ahtn.domain.Function;
import ai.ahtn.domain.IntegerConstant;
import ai.ahtn.domain.LispParser.LispElement;
import ai.ahtn.domain.LispParser.LispParser;
import ai.ahtn.domain.Parameter;
import ai.ahtn.domain.Symbol;
import ai.ahtn.domain.SymbolConstant;
import ai.ahtn.domain.Variable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import rts.GameState;

public class Term {
    public static int DEBUG = 0;
    Symbol functor;
    Parameter[] parameters;

    public Term() {
        this.functor = null;
        this.parameters = null;
    }

    public Term(Symbol symbol) {
        this.functor = symbol;
        this.parameters = null;
    }

    public Term(Symbol symbol, Parameter parameter) {
        this.functor = symbol;
        this.parameters = new Parameter[1];
        this.parameters[0] = parameter;
    }

    public Term(Symbol symbol, Parameter parameter, Parameter parameter2) {
        this.functor = symbol;
        this.parameters = new Parameter[2];
        this.parameters[0] = parameter;
        this.parameters[1] = parameter2;
    }

    public Term(Symbol symbol, Parameter[] parameterArray) {
        this.functor = symbol;
        this.parameters = parameterArray;
    }

    public Symbol getFunctor() {
        return this.functor;
    }

    public static Term fromString(String string) throws Exception {
        return Term.fromLispElement(LispParser.parseString(string).get(0));
    }

    public static Term fromLispElement(LispElement lispElement) throws Exception {
        Term term = new Term();
        term.functor = new Symbol(lispElement.children.get((int)0).element);
        int n = lispElement.children.size() - 1;
        if (n == 0) {
            term.parameters = null;
        } else {
            term.parameters = new Parameter[n];
            for (int j = 0; j < n; ++j) {
                LispElement lispElement2 = lispElement.children.get(j + 1);
                if (lispElement2.children != null) {
                    term.parameters[j] = Function.fromLispElement(lispElement2);
                    continue;
                }
                String string = lispElement2.element;
                if (string.startsWith("?")) {
                    term.parameters[j] = new Variable(string);
                    continue;
                }
                try {
                    int n2 = Integer.parseInt(string);
                    term.parameters[j] = new IntegerConstant(n2);
                    continue;
                }
                catch (Exception exception) {
                    term.parameters[j] = new SymbolConstant(string);
                }
            }
        }
        return term;
    }

    public void renameVariables(int n) {
        if (this.parameters != null) {
            for (Parameter parameter : this.parameters) {
                if (parameter instanceof Variable) {
                    ((Variable)parameter).setRenaming(n);
                    continue;
                }
                if (!(parameter instanceof Function)) continue;
                ((Function)parameter).renameVariables(n);
            }
        }
    }

    public List<Binding> simpleUnificationDestructiveNoSharedVariables(Term term, GameState gameState) throws Exception {
        if (DEBUG >= 1) {
            System.out.println("simpleUnificationDestructiveNoSharedVariables: start");
        }
        if (!this.functor.equals(term.functor)) {
            return null;
        }
        if (this.parameters.length != term.parameters.length) {
            return null;
        }
        LinkedList<Binding> linkedList = new LinkedList<Binding>();
        Parameter[] parameterArray = new Parameter[this.parameters.length];
        for (int j = 0; j < this.parameters.length; ++j) {
            Parameter parameter = this.parameters[j].resolveParameter(linkedList, gameState);
            Parameter parameter2 = term.parameters[j].resolveParameter(linkedList, gameState);
            if (DEBUG >= 1) {
                System.out.println("simpleUnificationDestructiveNoSharedVariables: " + j + " -> " + parameter + " U " + parameter2);
            }
            parameterArray[j] = parameter;
            if (parameter instanceof Variable) {
                if (parameter2 instanceof Variable && parameter2.equals(parameter) || ((Variable)parameter).ignore()) continue;
                linkedList.add(new Binding((Variable)parameter, parameter2));
                continue;
            }
            if (parameter2 instanceof Variable) {
                if (((Variable)parameter2).ignore()) continue;
                linkedList.add(new Binding((Variable)parameter2, parameter));
                continue;
            }
            if (parameter.equals(parameter2)) continue;
            return null;
        }
        this.parameters = parameterArray;
        return linkedList;
    }

    public Term resolve(List<Binding> list, GameState gameState) throws Exception {
        if (list.isEmpty()) {
            return this;
        }
        Term term = new Term();
        term.functor = this.functor;
        term.parameters = new Parameter[this.parameters.length];
        for (int j = 0; j < term.parameters.length; ++j) {
            term.parameters[j] = this.parameters[j].resolveParameter(list, gameState);
        }
        return term;
    }

    public Term clone() {
        Term term = new Term(this.functor);
        if (this.parameters != null) {
            term.parameters = new Parameter[this.parameters.length];
            for (int j = 0; j < term.parameters.length; ++j) {
                term.parameters[j] = this.parameters[j].cloneParameter();
            }
        }
        return term;
    }

    public void applyBindings(List<Binding> list) throws Exception {
        if (list.isEmpty()) {
            return;
        }
        if (this.parameters != null) {
            for (int j = 0; j < this.parameters.length; ++j) {
                this.parameters[j] = this.parameters[j].applyBindingsParameter(list);
            }
        }
    }

    public boolean isGround() {
        for (Parameter parameter : this.parameters) {
            if (parameter instanceof Variable) {
                return false;
            }
            if (!(parameter instanceof Function) || ((Function)parameter).isGround()) continue;
            return false;
        }
        return true;
    }

    public void countVariableAppearances(HashMap<Symbol, Integer> hashMap) throws Exception {
        for (Parameter parameter : this.parameters) {
            if (parameter instanceof Variable && !((Variable)parameter).ignore()) {
                Symbol symbol = ((Variable)parameter).getName();
                if (hashMap.containsKey(symbol)) {
                    hashMap.put(symbol, hashMap.get(symbol) + 1);
                } else {
                    hashMap.put(symbol, 1);
                }
            }
            if (!(parameter instanceof Function)) continue;
            ((Function)parameter).countVariableAppearances(hashMap);
        }
    }

    public void replaceSingletonsByWildcards(List<Symbol> list) throws Exception {
        for (int j = 0; j < this.parameters.length; ++j) {
            Symbol symbol;
            Parameter parameter = this.parameters[j];
            if (parameter instanceof Variable && list.contains(symbol = ((Variable)parameter).getName())) {
                this.parameters[j] = new Variable(new Symbol("?_"));
            }
            if (!(parameter instanceof Function)) continue;
            ((Function)parameter).replaceSingletonsByWildcards(list);
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof Term)) {
            return false;
        }
        Term term = (Term)object;
        if (!this.functor.equals(term.functor)) {
            return false;
        }
        if (this.parameters.length != term.parameters.length) {
            return false;
        }
        for (int j = 0; j < this.parameters.length; ++j) {
            if (this.parameters[j].equals(term.parameters[j])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        stringBuilder.append(this.functor);
        if (this.parameters != null) {
            for (int j = 0; j < this.parameters.length; ++j) {
                stringBuilder.append(" ");
                stringBuilder.append(this.parameters[j]);
            }
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

