/*
 * Decompiled with CFR 0.152.
 */
package ai.ahtn.domain;

import ai.ahtn.domain.Binding;
import ai.ahtn.domain.IntegerConstant;
import ai.ahtn.domain.Parameter;
import ai.ahtn.domain.Symbol;
import ai.ahtn.domain.SymbolConstant;
import java.util.LinkedList;
import java.util.List;
import rts.GameState;

public class Variable
implements Parameter {
    static Symbol variable_to_ignore;
    Symbol name;
    int renaming = 0;

    public Variable(String string) throws Exception {
        this.name = new Symbol(string);
    }

    public Variable(Symbol symbol) {
        this.name = symbol;
    }

    public Symbol getName() {
        return this.name;
    }

    public void setRenaming(int n) {
        this.renaming = n;
    }

    public boolean ignore() throws Exception {
        if (variable_to_ignore == null) {
            variable_to_ignore = new Symbol("?_");
        }
        return this.name.equals(variable_to_ignore);
    }

    @Override
    public List<Binding> match(int n) throws Exception {
        LinkedList<Binding> linkedList = new LinkedList<Binding>();
        if (!this.ignore()) {
            linkedList.add(new Binding(this, new IntegerConstant(n)));
        }
        return linkedList;
    }

    @Override
    public List<Binding> match(String string) throws Exception {
        LinkedList<Binding> linkedList = new LinkedList<Binding>();
        if (!this.ignore()) {
            linkedList.add(new Binding(this, new SymbolConstant(new Symbol(string))));
        }
        return linkedList;
    }

    @Override
    public Parameter cloneParameter() {
        Variable variable = new Variable(this.name);
        variable.renaming = this.renaming;
        return variable;
    }

    @Override
    public Parameter resolveParameter(List<Binding> list, GameState gameState) throws Exception {
        if (list == null) {
            return this;
        }
        return this.applyBindingsParameter(list);
    }

    @Override
    public Parameter applyBindingsParameter(List<Binding> list) throws Exception {
        if (this.ignore()) {
            return this;
        }
        Parameter parameter = this;
        for (Binding binding : list) {
            if (!binding.v.equals(parameter)) continue;
            parameter = binding.p;
        }
        return parameter;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Variable)) {
            return false;
        }
        Variable variable = (Variable)object;
        return this.name.equals(variable.name) && this.renaming == variable.renaming;
    }

    public String toString() {
        if (this.renaming == 0) {
            return this.name.toString();
        }
        return this.name + "/" + this.renaming;
    }
}

