/*
 * Decompiled with CFR 0.152.
 */
package ai.ahtn.planner;

import ai.ahtn.domain.Binding;
import ai.ahtn.domain.DomainDefinition;
import ai.ahtn.domain.MethodDecomposition;
import ai.ahtn.domain.PredefinedOperators;
import ai.ahtn.domain.Term;
import ai.ahtn.planner.AdversarialChoicePoint;
import ai.core.AI;
import ai.evaluation.EvaluationFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import rts.GameState;
import rts.PlayerAction;
import util.Pair;

public class AdversarialBoundedDepthPlannerAlphaBeta {
    public static int DEBUG = 0;
    public static boolean ALPHA_BETA_CUT = true;
    public static boolean SIMULATE_UNTIL_NEXT_CHOICEPOINT = true;
    MethodDecomposition maxPlanRoot;
    MethodDecomposition minPlanRoot;
    int maxPlayer;
    GameState gs;
    DomainDefinition dd;
    EvaluationFunction f;
    AI playoutAI = null;
    int PLAYOUT_LOOKAHEAD = 100;
    int maxDepth = 3;
    int operatorExecutionTimeout = 1000;
    static int MAX_TREE_DEPTH = 25;
    static int nPlayouts = 0;
    List<AdversarialChoicePoint> stack;
    List<Integer> trail;
    List<Binding> bindings;
    int renamingIndex = 1;
    boolean lastRunSolvedTheProblem = false;
    public static int n_iterative_deepening_runs = 0;
    public static double max_iterative_deepening_depth = 0.0;
    public static double average_iterative_deepening_depth = 0.0;
    public static int n_trees = 0;
    public static double max_tree_leaves = 0.0;
    public static double last_tree_leaves = 0.0;
    public static double average_tree_leaves = 0.0;
    public static double max_tree_nodes = 0.0;
    public static double last_tree_nodes = 0.0;
    public static double average_tree_nodes = 0.0;
    public static double max_tree_depth = 0.0;
    public static double last_tree_depth = 0.0;
    public static double average_tree_depth = 0.0;
    public static double max_time_depth = 0.0;
    public static double last_time_depth = 0.0;
    public static double average_time_depth = 0.0;

    public static void clearStatistics() {
        n_iterative_deepening_runs = 0;
        max_iterative_deepening_depth = 0.0;
        average_iterative_deepening_depth = 0.0;
        n_trees = 0;
        max_tree_leaves = 0.0;
        last_tree_leaves = 0.0;
        average_tree_leaves = 0.0;
        max_tree_nodes = 0.0;
        last_tree_nodes = 0.0;
        average_tree_nodes = 0.0;
        max_tree_depth = 0.0;
        last_tree_depth = 0.0;
        average_tree_depth = 0.0;
        max_time_depth = 0.0;
        last_time_depth = 0.0;
        average_time_depth = 0.0;
    }

    public AdversarialBoundedDepthPlannerAlphaBeta(Term term, Term term2, int n, int n2, int n3, GameState gameState, DomainDefinition domainDefinition, EvaluationFunction evaluationFunction, AI aI) {
        this.maxPlanRoot = new MethodDecomposition(term, null);
        this.minPlanRoot = new MethodDecomposition(term2, null);
        this.minPlanRoot.renameVariables(1);
        this.renamingIndex = 2;
        this.maxPlayer = n;
        this.gs = gameState;
        this.dd = domainDefinition;
        this.stack = null;
        this.maxDepth = n2;
        this.PLAYOUT_LOOKAHEAD = n3;
        this.f = evaluationFunction;
        this.playoutAI = aI;
    }

    public Pair<MethodDecomposition, MethodDecomposition> getBestPlan() throws Exception {
        return this.getBestPlan(-1L, -1, false);
    }

    public Pair<MethodDecomposition, MethodDecomposition> getBestPlan(long l, int n, boolean bl) throws Exception {
        if (DEBUG >= 1) {
            System.out.println("AdversarialBoundedDepthPlanner.getBestPlan");
        }
        if (this.stack == null) {
            if (DEBUG >= 1) {
                System.out.println("AdversarialBoundedDepthPlanner.getBestPlan: first time, initializing stack");
            }
            this.stack = new ArrayList<AdversarialChoicePoint>();
            this.stack.add(0, new AdversarialChoicePoint(this.maxPlanRoot, this.minPlanRoot, this.maxPlanRoot, this.minPlanRoot, this.gs, 0, -1, -EvaluationFunction.VICTORY, EvaluationFunction.VICTORY, false));
            this.trail = new ArrayList<Integer>();
            this.trail.add(0, 0);
            this.bindings = new ArrayList<Binding>();
        }
        last_tree_leaves = 0.0;
        last_tree_nodes = 0.0;
        last_tree_depth = 0.0;
        last_time_depth = 0.0;
        AdversarialChoicePoint adversarialChoicePoint = this.stack.get(this.stack.size() - 1);
        boolean bl2 = false;
        do {
            AdversarialChoicePoint adversarialChoicePoint2;
            int n2;
            int n3;
            if (l > 0L && System.currentTimeMillis() >= l || n > 0 && nPlayouts >= n) {
                if (bl) {
                    bl2 = true;
                } else {
                    return null;
                }
            }
            if ((double)(n3 = this.stack.size()) >= last_tree_depth) {
                last_tree_depth = n3;
            }
            AdversarialChoicePoint adversarialChoicePoint3 = this.stack.get(0);
            adversarialChoicePoint3.restoreExecutionState();
            if (DEBUG >= 2) {
                System.out.println("\nAdversarialBoundedDepthPlanner.getBestPlan: stack size: " + this.stack.size() + ", bindings: " + this.bindings.size() + ", gs.time: " + adversarialChoicePoint3.gs.getTime() + ", operators: " + adversarialChoicePoint.choicePointPlayerMin.getOperatorsBeingExecuted() + ", " + adversarialChoicePoint.choicePointPlayerMax.getOperatorsBeingExecuted());
            }
            if (DEBUG >= 3) {
                System.out.println("AdversarialBoundedDepthPlanner.getBestPlan: bindings: " + this.bindings);
                System.out.println("AdversarialBoundedDepthPlanner.getBestPlan: trail: " + this.trail);
                System.out.println("AdversarialBoundedDepthPlanner.getBestPlan: stack:");
                for (n2 = 0; n2 < this.stack.size(); ++n2) {
                    System.out.println(this.stack.size() - n2 + ": " + this.stack.get(n2));
                }
                this.maxPlanRoot.printDetailed();
                this.minPlanRoot.printDetailed();
            }
            n2 = this.bindings.size();
            boolean bl3 = true;
            while (!bl2 && adversarialChoicePoint3.nextExpansion(this.dd, this.bindings, this.renamingIndex, adversarialChoicePoint3)) {
                ++this.renamingIndex;
                adversarialChoicePoint2 = this.simulateUntilNextChoicePoint(this.bindings, adversarialChoicePoint3);
                if (adversarialChoicePoint2 == null) {
                    if (DEBUG >= 2) {
                        System.out.println("AdversarialBoundedDepthPlanner.getBestPlan: plan execution failed");
                    }
                    adversarialChoicePoint3.restoreExecutionState();
                    continue;
                }
                if (adversarialChoicePoint2.choicePointPlayerMax == null && adversarialChoicePoint2.choicePointPlayerMin == null) {
                    double d;
                    last_tree_nodes += 1.0;
                    if (DEBUG >= 2) {
                        System.out.println("AdversarialBoundedDepthPlanner.getBestPlan: plan execution success or depth limit reached");
                    }
                    if (DEBUG >= 3) {
                        System.out.println(adversarialChoicePoint2.gs);
                    }
                    if (DEBUG >= 3) {
                        this.maxPlanRoot.printDetailed();
                        this.minPlanRoot.printDetailed();
                    }
                    float f = this.playout(this.maxPlayer, adversarialChoicePoint2.gs);
                    last_tree_leaves += 1.0;
                    boolean bl4 = adversarialChoicePoint3.processEvaluation(f, adversarialChoicePoint3.maxPlanRoot, adversarialChoicePoint3.minPlanRoot, true);
                    if (!ALPHA_BETA_CUT) {
                        bl4 = false;
                    }
                    if ((d = (double)(adversarialChoicePoint2.gs.getTime() - adversarialChoicePoint.gs.getTime())) > last_time_depth) {
                        last_time_depth = d;
                    }
                    if (DEBUG >= 2) {
                        System.out.println("---- ---- ---- ----");
                        System.out.println(adversarialChoicePoint2.gs);
                        System.out.println("Evaluation: " + f);
                        System.out.println("Bindings: " + this.bindings.size());
                        System.out.println("Bindings: " + this.bindings);
                        System.out.println("Max plan:");
                        List<Pair<Integer, List<Term>>> list = this.maxPlanRoot.convertToOperatorList();
                        for (Pair<Integer, List<Term>> pair : list) {
                            System.out.println("  " + pair.m_a + ": " + pair.m_b);
                        }
                        System.out.println("Min plan:");
                        List<Pair<Integer, List<Term>>> list2 = this.minPlanRoot.convertToOperatorList();
                        Iterator object2 = list2.iterator();
                        while (object2.hasNext()) {
                            Pair pair = (Pair)object2.next();
                            System.out.println("  " + pair.m_a + ": " + pair.m_b);
                        }
                    }
                    adversarialChoicePoint3.restoreExecutionState();
                    int n4 = this.bindings.size() - n2;
                    for (int j = 0; j < n4; ++j) {
                        this.bindings.remove(0);
                    }
                    if (!bl4) continue;
                    break;
                }
                last_tree_nodes += 1.0;
                if (DEBUG >= 2) {
                    System.out.println("AdversarialBoundedDepthPlanner.getBestPlan: stack push");
                }
                this.stack.add(0, adversarialChoicePoint2);
                this.trail.add(0, this.bindings.size() - n2);
                bl3 = false;
                break;
            }
            if (!bl3) continue;
            if (!bl2 && nPlayouts == 0) {
                adversarialChoicePoint2 = this.stack.get(0);
                if (adversarialChoicePoint2.choicePointPlayerMax != null && adversarialChoicePoint2.choicePointPlayerMax.getType() == 2 || adversarialChoicePoint2.choicePointPlayerMax == null && adversarialChoicePoint2.choicePointPlayerMin != null && adversarialChoicePoint2.choicePointPlayerMin.getType() == 2) {
                    System.err.println("Popping without finding any decomposition:");
                    System.err.println(adversarialChoicePoint2);
                    System.err.println(this.bindings);
                    System.err.println(adversarialChoicePoint2.gs);
                    throw new Error("Popping without finding any decomposition");
                }
            }
            do {
                bl3 = false;
                this.stackPop();
                if (DEBUG >= 2) {
                    System.out.println("AdversarialBoundedDepthPlanner.nextPlan: stack pop");
                }
                if (this.stack.isEmpty()) continue;
                if (adversarialChoicePoint3.minimaxType != -1) {
                    bl3 = this.stack.get(0).processEvaluation(adversarialChoicePoint3.bestEvaluation, adversarialChoicePoint3.bestMaxPlan, adversarialChoicePoint3.bestMinPlan, false);
                    if (!ALPHA_BETA_CUT) {
                        bl3 = false;
                    }
                }
                if (!bl3) continue;
                adversarialChoicePoint3 = this.stack.get(0);
            } while (bl3 && !this.stack.isEmpty());
        } while (!this.stack.isEmpty());
        if (DEBUG >= 1) {
            System.out.println(last_tree_leaves);
        }
        this.stack = null;
        if (DEBUG >= 1) {
            System.out.println("AdversarialBoundedDepthPlanner.nextPlan: options exhausted for rootPlan");
        }
        if (DEBUG >= 1) {
            System.out.println("best evaluation: " + adversarialChoicePoint.bestEvaluation);
        }
        if (adversarialChoicePoint.bestEvaluation == EvaluationFunction.VICTORY || adversarialChoicePoint.bestEvaluation == -EvaluationFunction.VICTORY) {
            this.lastRunSolvedTheProblem = true;
        }
        if (adversarialChoicePoint.bestMaxPlan == null && adversarialChoicePoint.bestMinPlan == null) {
            this.lastRunSolvedTheProblem = true;
            System.out.println("No AHTN can be found for situation:");
            System.out.println(this.gs);
        }
        return new Pair<MethodDecomposition, MethodDecomposition>(adversarialChoicePoint.bestMaxPlan, adversarialChoicePoint.bestMinPlan);
    }

    public static Pair<MethodDecomposition, MethodDecomposition> getBestPlanIterativeDeepening(Term term, Term term2, int n, int n2, int n3, int n4, GameState gameState, DomainDefinition domainDefinition, EvaluationFunction evaluationFunction, AI aI) throws Exception {
        long l = System.currentTimeMillis();
        long l2 = l + (long)n2;
        if (n2 <= 0) {
            l2 = 0L;
        }
        Pair<MethodDecomposition, MethodDecomposition> pair = null;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n5 = 0;
        int n6 = 0;
        nPlayouts = 0;
        int n7 = 1;
        while (true) {
            Pair<MethodDecomposition, MethodDecomposition> pair2 = null;
            long l3 = System.currentTimeMillis();
            if (DEBUG >= 1) {
                System.out.println("Iterative Deepening depth: " + n7 + " (total time so far: " + (l3 - l) + "/" + n2 + ") (total playouts so far: " + nPlayouts + "/" + n3 + ")");
            }
            AdversarialBoundedDepthPlannerAlphaBeta adversarialBoundedDepthPlannerAlphaBeta = new AdversarialBoundedDepthPlannerAlphaBeta(term, term2, n, n7, n4, gameState, domainDefinition, evaluationFunction, aI);
            n5 = nPlayouts;
            if (n7 <= MAX_TREE_DEPTH) {
                int n8 = n3 - nPlayouts;
                if (n3 < 0 || n8 > n6) {
                    if (DEBUG >= 1) {
                        System.out.println("last time we used " + n6 + ", and there are " + n8 + " left, trying one more depth!");
                    }
                    pair2 = adversarialBoundedDepthPlannerAlphaBeta.getBestPlan(l2, n3, pair == null);
                } else if (DEBUG >= 1) {
                    System.out.println("last time we used " + n6 + ", and there are only " + n8 + " left..., canceling search");
                }
            }
            n6 = nPlayouts - n5;
            if (DEBUG >= 1) {
                System.out.println("    time taken: " + (System.currentTimeMillis() - l3));
            }
            if (DEBUG >= 1 && pair2 != null) {
                System.out.println("Max plan:");
                if (pair2.m_a != null) {
                    List<Pair<Integer, List<Term>>> list = ((MethodDecomposition)pair2.m_a).convertToOperatorList();
                    for (Pair<Integer, List<Term>> pair3 : list) {
                        System.out.println("  " + pair3.m_a + ": " + pair3.m_b);
                    }
                }
                if (pair2.m_b != null) {
                    System.out.println("Min plan:");
                    List<Pair<Integer, List<Term>>> list = ((MethodDecomposition)pair2.m_b).convertToOperatorList();
                    for (Pair<Integer, List<Term>> pair3 : list) {
                        System.out.println("  " + pair3.m_a + ": " + pair3.m_b);
                    }
                }
            }
            if (pair2 != null) {
                pair = pair2;
                d = last_tree_leaves;
                d2 = last_tree_nodes;
                d3 = last_tree_depth;
                d4 = last_time_depth;
                if (adversarialBoundedDepthPlannerAlphaBeta.lastRunSolvedTheProblem) {
                    ++n_trees;
                    if (d > max_tree_leaves) {
                        max_tree_leaves = d;
                    }
                    average_tree_leaves += d;
                    if (d2 > max_tree_nodes) {
                        max_tree_nodes = d2;
                    }
                    average_tree_nodes += d2;
                    average_tree_depth += d3;
                    if (d3 >= max_tree_depth) {
                        max_tree_depth = d3;
                    }
                    average_time_depth += d4;
                    if (d4 >= max_time_depth) {
                        max_time_depth = d4;
                    }
                    ++n_iterative_deepening_runs;
                    average_iterative_deepening_depth += (double)n7;
                    if ((double)n7 > max_iterative_deepening_depth) {
                        max_iterative_deepening_depth = n7;
                    }
                    return pair;
                }
            } else {
                ++n_trees;
                if (d > max_tree_leaves) {
                    max_tree_leaves = d;
                }
                average_tree_leaves += d;
                if (d2 > max_tree_nodes) {
                    max_tree_nodes = d2;
                }
                average_tree_nodes += d2;
                average_tree_depth += d3;
                if (d3 >= max_tree_depth) {
                    max_tree_depth = d3;
                }
                average_time_depth += d4;
                if (d4 >= max_time_depth) {
                    max_time_depth = d4;
                }
                ++n_iterative_deepening_runs;
                average_iterative_deepening_depth += (double)(n7 - 1);
                if ((double)(n7 - 1) > max_iterative_deepening_depth) {
                    max_iterative_deepening_depth = n7 - 1;
                }
                return pair;
            }
            ++n7;
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public AdversarialChoicePoint simulateUntilNextChoicePoint(List<Binding> var1_1, AdversarialChoicePoint var2_2) throws Exception {
        var3_3 = var2_2.gs;
        var4_4 = var3_3.clone();
        var5_5 = var2_2.getLastTimeOperatorsIssued();
        var6_6 = var2_2.getOperatorDepth();
        block0: while (true) {
            if (!AdversarialBoundedDepthPlannerAlphaBeta.SIMULATE_UNTIL_NEXT_CHOICEPOINT && var6_6 >= this.maxDepth && var4_4.getTime() > var5_5) {
                return new AdversarialChoicePoint(null, null, var2_2.maxPlanRoot, var2_2.minPlanRoot, var4_4, var6_6, var5_5, var2_2.getAlpha(), var2_2.getBeta(), false);
            }
            var7_7 = new ArrayList<MethodDecomposition>();
            var8_8 = new ArrayList<MethodDecomposition>();
            var9_9 = new ArrayList<MethodDecomposition>();
            var10_10 = new ArrayList<MethodDecomposition>();
            var11_11 = var2_2.maxPlanRoot.executionCycle(var4_4, var7_7, var9_9, var2_2);
            var12_12 = var2_2.minPlanRoot.executionCycle(var4_4, var8_8, var10_10, var2_2);
            if (AdversarialBoundedDepthPlannerAlphaBeta.SIMULATE_UNTIL_NEXT_CHOICEPOINT && var6_6 >= this.maxDepth && var4_4.getTime() > var5_5 && (var11_11 == 4 || var12_12 == 4)) {
                return new AdversarialChoicePoint(null, null, var2_2.maxPlanRoot, var2_2.minPlanRoot, var4_4, var6_6, var5_5, var2_2.getAlpha(), var2_2.getBeta(), false);
            }
            if (var11_11 == 0 && var12_12 == 0) {
                return new AdversarialChoicePoint(null, null, var2_2.maxPlanRoot, var2_2.minPlanRoot, var4_4, var6_6, var5_5, var2_2.getAlpha(), var2_2.getBeta(), false);
            }
            if (var11_11 == 1 || var12_12 == 1) {
                if (AdversarialBoundedDepthPlannerAlphaBeta.DEBUG >= 2) {
                    System.out.println("AdversarialBoundedDepthPlanner.simulateUntilNextChoicePoint: execution failure " + var11_11 + ", " + var12_12);
                }
                return null;
            }
            if (var11_11 != 4 && var12_12 != 4) ** GOTO lbl33
            v0 = var13_13 = var9_9.isEmpty() != false ? null : (MethodDecomposition)var9_9.get(0);
            if (var13_13 == null) {
                v1 = var13_13 = var10_10.isEmpty() != false ? null : (MethodDecomposition)var10_10.get(0);
            }
            if (var13_13.getType() == 5) {
                var14_17 = new AdversarialChoicePoint(var9_9.isEmpty() != false ? null : (MethodDecomposition)var9_9.get(0), var10_10.isEmpty() != false ? null : (MethodDecomposition)var10_10.get(0), var2_2.maxPlanRoot, var2_2.minPlanRoot, var4_4, var6_6, var5_5, var2_2.getAlpha(), var2_2.getBeta(), false);
                if (!var14_17.nextExpansion(this.dd, var1_1, this.renamingIndex, (AdversarialChoicePoint)var14_17)) {
                    return null;
                }
                ++this.renamingIndex;
            } else {
                return new AdversarialChoicePoint(var9_9.isEmpty() != false ? null : (MethodDecomposition)var9_9.get(0), var10_10.isEmpty() != false ? null : (MethodDecomposition)var10_10.get(0), var2_2.maxPlanRoot, var2_2.minPlanRoot, var4_4, var6_6, var5_5, var2_2.getAlpha(), var2_2.getBeta(), false);
lbl33:
                // 1 sources

                if ((var11_11 == 3 || var12_12 == 3) && var11_11 != 2 && var12_12 != 2) {
                    var13_14 = var4_4.cycle();
                    if (var13_14) {
                        return new AdversarialChoicePoint(null, null, var2_2.maxPlanRoot, var2_2.minPlanRoot, var4_4, var6_6, var5_5, var2_2.getAlpha(), var2_2.getBeta(), false);
                    }
                    var14_17 = null;
                    if (var2_2.maxPlanRoot.getOperatorsBeingExecuted() != null) {
                        for (MethodDecomposition var16_19 : var2_2.maxPlanRoot.getOperatorsBeingExecuted()) {
                            var2_2.captureExecutionStateNonRecursive(var16_19);
                            if (AdversarialBoundedDepthPlannerAlphaBeta.DEBUG >= 2) {
                                System.out.println("AdversarialBoundedDepthPlanner.simulateUntilNextChoicePoint: continuing executing operator " + var16_19.getUpdatedTerm());
                            }
                            if (PredefinedOperators.execute(var16_19, var4_4) || var4_4.getTime() > var16_19.getUpdatedTermCycle() + this.operatorExecutionTimeout) {
                                var16_19.setExecutionState(2);
                                if (var14_17 == null) {
                                    var14_17 = new ArrayList<MethodDecomposition>();
                                }
                                var14_17.add(var16_19);
                                if (AdversarialBoundedDepthPlannerAlphaBeta.DEBUG < 2) continue;
                                System.out.println("AdversarialBoundedDepthPlanner.simulateUntilNextChoicePoint: operator complete (1).");
                                continue;
                            }
                            var16_19.setExecutionState(1);
                        }
                        if (var14_17 != null) {
                            var2_2.maxPlanRoot.getOperatorsBeingExecuted().removeAll((Collection<?>)var14_17);
                        }
                    }
                    if (var2_2.minPlanRoot.getOperatorsBeingExecuted() != null) {
                        var14_17 = null;
                        for (MethodDecomposition var16_19 : var2_2.minPlanRoot.getOperatorsBeingExecuted()) {
                            var2_2.captureExecutionStateNonRecursive(var16_19);
                            if (AdversarialBoundedDepthPlannerAlphaBeta.DEBUG >= 2) {
                                System.out.println("AdversarialBoundedDepthPlanner.simulateUntilNextChoicePoint: continuing executing operator " + var16_19.getUpdatedTerm());
                            }
                            if (PredefinedOperators.execute(var16_19, var4_4) || var4_4.getTime() > var16_19.getUpdatedTermCycle() + this.operatorExecutionTimeout) {
                                var16_19.setExecutionState(2);
                                if (var14_17 == null) {
                                    var14_17 = new ArrayList<E>();
                                }
                                var14_17.add(var16_19);
                                if (AdversarialBoundedDepthPlannerAlphaBeta.DEBUG < 2) continue;
                                System.out.println("AdversarialBoundedDepthPlanner.simulateUntilNextChoicePoint: operator complete (2).");
                                continue;
                            }
                            var16_19.setExecutionState(1);
                        }
                        if (var14_17 != null) {
                            var2_2.minPlanRoot.getOperatorsBeingExecuted().removeAll((Collection<?>)var14_17);
                        }
                    }
                }
            }
            if ((var11_11 == 2 || var12_12 == 2) && var4_4.getTime() > var5_5) {
                var5_5 = var4_4.getTime();
                ++var6_6;
            }
            if (var11_11 == 2) {
                for (Object var14_17 : var7_7) {
                    var2_2.captureExecutionStateNonRecursive((MethodDecomposition)var14_17);
                    var14_17.setUpdatedTerm(var14_17.getTerm().clone());
                    var14_17.getUpdatedTerm().applyBindings(var1_1);
                    var14_17.setUpdatedTermCycle(var4_4.getTime());
                    if (AdversarialBoundedDepthPlannerAlphaBeta.DEBUG >= 2) {
                        System.out.println("AdversarialBoundedDepthPlanner.simulateUntilNextChoicePoint: executing operator " + var14_17.getUpdatedTerm());
                    }
                    var14_17.setOperatorExecutingState(0);
                    if (PredefinedOperators.execute((MethodDecomposition)var14_17, var4_4)) {
                        var14_17.setExecutionState(2);
                        if (AdversarialBoundedDepthPlannerAlphaBeta.DEBUG < 2) continue;
                        System.out.println("AdversarialBoundedDepthPlanner.simulateUntilNextChoicePoint: operator complete (3).");
                        continue;
                    }
                    var14_17.setExecutionState(1);
                    if (var2_2.maxPlanRoot.getOperatorsBeingExecuted() == null) {
                        var2_2.maxPlanRoot.setOperatorsBeingExecuted(new ArrayList<MethodDecomposition>());
                    }
                    var2_2.maxPlanRoot.getOperatorsBeingExecuted().add((MethodDecomposition)var14_17);
                }
            }
            if (var12_12 != 2) continue;
            var13_16 = var8_8.iterator();
            while (true) {
                if (var13_16.hasNext()) ** break;
                continue block0;
                var14_17 = (MethodDecomposition)var13_16.next();
                var2_2.captureExecutionStateNonRecursive((MethodDecomposition)var14_17);
                var14_17.setUpdatedTerm(var14_17.getTerm().clone());
                var14_17.getUpdatedTerm().applyBindings(var1_1);
                var14_17.setUpdatedTermCycle(var4_4.getTime());
                if (AdversarialBoundedDepthPlannerAlphaBeta.DEBUG >= 2) {
                    System.out.println("AdversarialBoundedDepthPlanner.simulateUntilNextChoicePoint: executing operator " + var14_17.getUpdatedTerm());
                }
                var14_17.setOperatorExecutingState(0);
                if (PredefinedOperators.execute(var14_17, var4_4)) {
                    var14_17.setExecutionState(2);
                    if (AdversarialBoundedDepthPlannerAlphaBeta.DEBUG < 2) continue;
                    System.out.println("AdversarialBoundedDepthPlanner.simulateUntilNextChoicePoint: operator complete (4).");
                    continue;
                }
                var14_17.setExecutionState(1);
                if (var2_2.minPlanRoot.getOperatorsBeingExecuted() == null) {
                    var2_2.minPlanRoot.setOperatorsBeingExecuted(new ArrayList<MethodDecomposition>());
                }
                var2_2.minPlanRoot.getOperatorsBeingExecuted().add((MethodDecomposition)var14_17);
            }
            break;
        }
    }

    public void stackPop() {
        AdversarialChoicePoint adversarialChoicePoint = this.stack.remove(0);
        adversarialChoicePoint.restoreAfterPop();
        int n = this.trail.remove(0);
        if (DEBUG >= 2) {
            System.out.println("StackPop! removing " + n + " bindings.");
        }
        for (int j = 0; j < n; ++j) {
            this.bindings.remove(0);
        }
        if (!this.stack.isEmpty()) {
            this.stack.get(0).restoreExecutionState();
        }
    }

    public float playout(int n, GameState gameState) throws Exception {
        ++nPlayouts;
        GameState gameState2 = gameState;
        if (this.PLAYOUT_LOOKAHEAD > 0 && this.playoutAI != null) {
            AI aI = this.playoutAI.clone();
            AI aI2 = this.playoutAI.clone();
            gameState2 = gameState.clone();
            aI.reset();
            aI2.reset();
            int n2 = gameState2.getTime() + this.PLAYOUT_LOOKAHEAD;
            boolean bl = false;
            while (!bl && gameState2.getTime() < n2) {
                if (gameState2.isComplete()) {
                    bl = gameState2.cycle();
                    continue;
                }
                PlayerAction playerAction = aI.getAction(n, gameState2);
                PlayerAction playerAction2 = aI2.getAction(1 - n, gameState2);
                gameState2.issue(playerAction);
                gameState2.issue(playerAction2);
            }
        }
        float f = this.f.evaluate(n, 1 - n, gameState2);
        return f;
    }
}

