/*
 * Decompiled with CFR 0.152.
 */
package ai.ahtn.planner;

import ai.ahtn.domain.Binding;
import ai.ahtn.domain.Clause;
import ai.ahtn.domain.DomainDefinition;
import ai.ahtn.domain.HTNMethod;
import ai.ahtn.domain.MethodDecomposition;
import ai.ahtn.planner.MethodDecompositionState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import rts.GameState;

public class AdversarialChoicePoint {
    public static int DEBUG = 0;
    public MethodDecomposition maxPlanRoot;
    public MethodDecomposition minPlanRoot;
    public MethodDecomposition choicePointPlayerMax;
    public MethodDecomposition choicePointPlayerMin;
    public GameState gs;
    int lastTimeOperatorsIssued = -1;
    int operatorDepth = 0;
    List<HTNMethod> possibleMethods = null;
    Clause updatedClause = null;
    boolean updatedClauseHadAnyMatches = false;
    List<Binding> lastBindings = null;
    HashMap<MethodDecomposition, MethodDecompositionState> executionState = null;
    public int minimaxType = -1;
    public float bestEvaluation = 0.0f;
    public MethodDecomposition bestMaxPlan = null;
    public MethodDecomposition bestMinPlan = null;
    float alpha = 0.0f;
    float beta = 0.0f;

    private AdversarialChoicePoint() {
        this.executionState = new HashMap();
    }

    public AdversarialChoicePoint(MethodDecomposition methodDecomposition, MethodDecomposition methodDecomposition2, MethodDecomposition methodDecomposition3, MethodDecomposition methodDecomposition4, GameState gameState, int n, int n2) {
        this.maxPlanRoot = methodDecomposition3;
        this.minPlanRoot = methodDecomposition4;
        this.choicePointPlayerMax = methodDecomposition;
        this.choicePointPlayerMin = methodDecomposition2;
        this.gs = gameState;
        this.operatorDepth = n;
        this.lastTimeOperatorsIssued = n2;
        this.executionState = new HashMap();
        this.captureExecutionState(methodDecomposition3);
        this.captureExecutionState(methodDecomposition4);
    }

    public AdversarialChoicePoint(MethodDecomposition methodDecomposition, MethodDecomposition methodDecomposition2, MethodDecomposition methodDecomposition3, MethodDecomposition methodDecomposition4, GameState gameState, int n, int n2, float f, float f2, boolean bl) {
        this.maxPlanRoot = methodDecomposition3;
        this.minPlanRoot = methodDecomposition4;
        this.choicePointPlayerMax = methodDecomposition;
        this.choicePointPlayerMin = methodDecomposition2;
        this.gs = gameState;
        this.operatorDepth = n;
        this.lastTimeOperatorsIssued = n2;
        this.alpha = f;
        this.beta = f2;
        this.executionState = new HashMap();
        if (bl) {
            this.captureExecutionState(methodDecomposition3);
            this.captureExecutionState(methodDecomposition4);
        } else {
            this.captureExecutionStateNonRecursive(methodDecomposition3);
            this.captureExecutionStateNonRecursive(methodDecomposition4);
        }
    }

    public AdversarialChoicePoint cloneForMCTS() {
        AdversarialChoicePoint adversarialChoicePoint = new AdversarialChoicePoint();
        MethodDecomposition[] methodDecompositionArray = new MethodDecomposition[]{this.choicePointPlayerMax};
        MethodDecomposition[] methodDecompositionArray2 = new MethodDecomposition[]{null};
        adversarialChoicePoint.maxPlanRoot = this.maxPlanRoot.cloneTrackingDescendants(methodDecompositionArray, methodDecompositionArray2);
        MethodDecomposition[] methodDecompositionArray3 = new MethodDecomposition[]{this.choicePointPlayerMin};
        MethodDecomposition[] methodDecompositionArray4 = new MethodDecomposition[]{null};
        adversarialChoicePoint.minPlanRoot = this.minPlanRoot.cloneTrackingDescendants(methodDecompositionArray3, methodDecompositionArray4);
        adversarialChoicePoint.choicePointPlayerMax = methodDecompositionArray2[0];
        adversarialChoicePoint.choicePointPlayerMin = methodDecompositionArray4[0];
        adversarialChoicePoint.gs = this.gs.clone();
        adversarialChoicePoint.lastTimeOperatorsIssued = this.lastTimeOperatorsIssued;
        adversarialChoicePoint.operatorDepth = this.operatorDepth;
        return adversarialChoicePoint;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public float getBeta() {
        return this.beta;
    }

    public void setAlpha(float f) {
        this.alpha = f;
    }

    public void setBeta(float f) {
        this.beta = f;
    }

    public int getOperatorDepth() {
        return this.operatorDepth;
    }

    public int getLastTimeOperatorsIssued() {
        return this.lastTimeOperatorsIssued;
    }

    public void setLastTimeOperatorsIssued(int n) {
        this.lastTimeOperatorsIssued = n;
    }

    public float getBestEvaluation() {
        return this.bestEvaluation;
    }

    public void setBestEvaluation(float f) {
        this.bestEvaluation = f;
    }

    public int getMiniMaxType() {
        return this.minimaxType;
    }

    public GameState getGameState() {
        return this.gs;
    }

    public void captureExecutionState(MethodDecomposition methodDecomposition) {
        this.executionState.put(methodDecomposition, new MethodDecompositionState(methodDecomposition));
        if (methodDecomposition.getSubparts() != null) {
            for (int j = 0; j < methodDecomposition.getSubparts().length; ++j) {
                this.captureExecutionState(methodDecomposition.getSubparts()[j]);
            }
        }
        if (methodDecomposition.getMethod() != null) {
            this.captureExecutionState(methodDecomposition.getMethod().getDecomposition());
        }
    }

    public void captureExecutionStateNonRecursive(MethodDecomposition methodDecomposition) {
        if (this.executionState.get(methodDecomposition) == null) {
            this.executionState.put(methodDecomposition, new MethodDecompositionState(methodDecomposition));
        }
    }

    public void restoreExecutionState() {
        for (MethodDecomposition methodDecomposition : this.executionState.keySet()) {
            this.executionState.get(methodDecomposition).restoreState(methodDecomposition);
        }
    }

    public void restoreAfterPop() {
        if (this.choicePointPlayerMax != null && this.choicePointPlayerMax.getType() == 2) {
            this.choicePointPlayerMax.setMethod(null);
        }
        if (this.choicePointPlayerMin != null && this.choicePointPlayerMin.getType() == 2) {
            this.choicePointPlayerMin.setMethod(null);
        }
    }

    public boolean nextExpansion(DomainDefinition domainDefinition, List<Binding> list, int n, AdversarialChoicePoint adversarialChoicePoint) throws Exception {
        if (this.choicePointPlayerMax != null) {
            adversarialChoicePoint.captureExecutionStateNonRecursive(this.choicePointPlayerMax);
            if (this.choicePointPlayerMax.getType() == 2) {
                return this.nextMethodExpansion(this.choicePointPlayerMax, this.gs, domainDefinition, list, n);
            }
            if (this.choicePointPlayerMax.getType() == 0 || this.choicePointPlayerMax.getType() == 5) {
                return this.nextConditionExpansion(this.choicePointPlayerMax, list);
            }
            throw new Exception("Wrong MethodDecomposition in choicePoint!");
        }
        adversarialChoicePoint.captureExecutionStateNonRecursive(this.choicePointPlayerMin);
        if (this.choicePointPlayerMin.getType() == 2) {
            return this.nextMethodExpansion(this.choicePointPlayerMin, this.gs, domainDefinition, list, n);
        }
        if (this.choicePointPlayerMin.getType() == 0 || this.choicePointPlayerMin.getType() == 5) {
            return this.nextConditionExpansion(this.choicePointPlayerMin, list);
        }
        throw new Exception("Wrong MethodDecomposition in choicePoint!");
    }

    private boolean nextConditionExpansion(MethodDecomposition methodDecomposition, List<Binding> list) throws Exception {
        List<Binding> list2;
        if (DEBUG >= 1) {
            System.out.println("AdversarialChoicePoint.nextExpansionCondition: testing " + methodDecomposition.getClause());
        }
        if (this.updatedClause == null) {
            this.updatedClause = methodDecomposition.getClause().clone();
            this.updatedClause.applyBindings(list);
            this.updatedClauseHadAnyMatches = false;
            this.lastBindings = null;
        }
        do {
            list2 = this.updatedClause.nextMatch(this.gs);
            if (DEBUG >= 1) {
                System.out.println("AdversarialChoicePoint.nextConditionExpansion: bindings: " + list2);
            }
            if (list2 != null) continue;
            if (this.updatedClauseHadAnyMatches) {
                this.updatedClause = null;
                return false;
            }
            methodDecomposition.setExecutionState(2);
            this.updatedClauseHadAnyMatches = true;
            return true;
        } while (this.lastBindings != null && list2.equals(this.lastBindings));
        this.lastBindings = new ArrayList<Binding>();
        this.lastBindings.addAll(list2);
        this.updatedClauseHadAnyMatches = true;
        methodDecomposition.setExecutionState(1);
        for (Binding binding : list2) {
            list.add(0, binding);
        }
        return true;
    }

    public boolean nextMethodExpansion(MethodDecomposition methodDecomposition, GameState gameState, DomainDefinition domainDefinition, List<Binding> list, int n) throws Exception {
        List<HTNMethod> list2;
        if (DEBUG >= 1) {
            System.out.println("AdversarialChoicePoint.nextMethodExpansion: testing " + methodDecomposition.getTerm());
        }
        if (this.possibleMethods == null) {
            list2 = domainDefinition.getMethodsForGoal(methodDecomposition.getTerm().getFunctor());
            if (list2 == null) {
                throw new Exception("No methods for: " + methodDecomposition.getTerm().getFunctor());
            }
            this.possibleMethods = new ArrayList<HTNMethod>();
            this.possibleMethods.addAll((Collection<HTNMethod>)list2);
            if (DEBUG >= 1) {
                System.out.println("AdversarialChoicePoint.nextMethodExpansion: Goal: " + methodDecomposition.getTerm());
            }
            if (DEBUG >= 1) {
                System.out.println("AdversarialChoicePoint.nextMethodExpansion: Methods found: " + list2.size());
            }
        }
        if (this.possibleMethods.isEmpty()) {
            this.possibleMethods = null;
            methodDecomposition.setMethod(null);
            return false;
        }
        list2 = this.possibleMethods.remove(0);
        this.setMethod(methodDecomposition, (HTNMethod)((Object)list2), gameState, list, n);
        return true;
    }

    public void setMethod(MethodDecomposition methodDecomposition, HTNMethod hTNMethod, GameState gameState, List<Binding> list, int n) throws Exception {
        HTNMethod hTNMethod2 = hTNMethod.clone();
        methodDecomposition.setMethod(hTNMethod2);
        List<Binding> list2 = hTNMethod2.getHead().simpleUnificationDestructiveNoSharedVariables(methodDecomposition.getTerm(), gameState);
        if (DEBUG >= 1) {
            System.out.println("AdversarialChoicePoint.setMethod: bindings2 " + list2);
        }
        hTNMethod2.applyBindings(list2);
        hTNMethod2.applyBindings(list);
        hTNMethod2.renameVariables(n);
    }

    public boolean processEvaluation(float f, MethodDecomposition methodDecomposition, MethodDecomposition methodDecomposition2, boolean bl) {
        switch (this.minimaxType) {
            case -1: {
                if (this.choicePointPlayerMax != null) {
                    this.bestEvaluation = f;
                    MethodDecomposition methodDecomposition3 = methodDecomposition == null ? null : (this.bestMaxPlan = bl ? methodDecomposition.clone() : methodDecomposition);
                    this.bestMinPlan = methodDecomposition2 == null ? null : (bl ? methodDecomposition2.clone() : methodDecomposition2);
                    this.minimaxType = 0;
                    break;
                }
                this.bestEvaluation = f;
                MethodDecomposition methodDecomposition4 = methodDecomposition == null ? null : (this.bestMaxPlan = bl ? methodDecomposition.clone() : methodDecomposition);
                this.bestMinPlan = methodDecomposition2 == null ? null : (bl ? methodDecomposition2.clone() : methodDecomposition2);
                this.minimaxType = 1;
                break;
            }
            case 0: {
                if ((this.bestMaxPlan != null || methodDecomposition == null && !(f > this.bestEvaluation)) && (this.bestMaxPlan == null || methodDecomposition2 == null || !(f > this.bestEvaluation))) break;
                this.bestEvaluation = f;
                MethodDecomposition methodDecomposition5 = methodDecomposition == null ? null : (this.bestMaxPlan = bl ? methodDecomposition.clone() : methodDecomposition);
                this.bestMinPlan = methodDecomposition2 == null ? null : (bl ? methodDecomposition2.clone() : methodDecomposition2);
                break;
            }
            case 1: {
                if ((this.bestMinPlan != null || methodDecomposition2 == null && !(f < this.bestEvaluation)) && (this.bestMinPlan == null || methodDecomposition2 == null || !(f < this.bestEvaluation))) break;
                this.bestEvaluation = f;
                MethodDecomposition methodDecomposition6 = methodDecomposition == null ? null : (this.bestMaxPlan = bl ? methodDecomposition.clone() : methodDecomposition);
                MethodDecomposition methodDecomposition7 = methodDecomposition2 == null ? null : (this.bestMinPlan = bl ? methodDecomposition2.clone() : methodDecomposition2);
            }
        }
        if (this.minimaxType == 0) {
            this.alpha = Math.max(this.alpha, f);
            if (this.beta <= this.alpha) {
                return true;
            }
        } else if (this.minimaxType == 1) {
            this.beta = Math.min(this.beta, f);
            if (this.beta <= this.alpha) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        String string = "( ";
        string = this.choicePointPlayerMax == null ? string + "null" : (this.choicePointPlayerMax.getType() == 2 ? string + "choicePointPlayerMax(" + this.choicePointPlayerMax.getTerm() + ")" : (this.choicePointPlayerMax.getType() == 0 ? string + "choicePointPlayerMax(" + this.choicePointPlayerMax.getClause() + ")" : string + "choicePointPlayerMax(???)"));
        string = string + " , ";
        string = this.choicePointPlayerMin == null ? string + "null" : (this.choicePointPlayerMin.getType() == 2 ? string + "choicePointPlayerMin(" + this.choicePointPlayerMin.getTerm() + ")" : (this.choicePointPlayerMin.getType() == 0 ? string + "choicePointPlayerMin(" + this.choicePointPlayerMin.getClause() + ")" : string + "choicePointPlayerMin(???)"));
        return string + ")";
    }
}

