/*
 * Decompiled with CFR 0.152.
 */
package ai.ahtn.planner;

import ai.ahtn.domain.MethodDecomposition;
import java.util.ArrayList;
import java.util.List;

public class MethodDecompositionState {
    int executionState = 0;
    int operatorExecutingState = 0;
    List<MethodDecomposition> operatorsBeingExecuted = null;

    public MethodDecompositionState(MethodDecomposition methodDecomposition) {
        this.executionState = methodDecomposition.getExecutionState();
        this.operatorExecutingState = methodDecomposition.getOperatorExecutingState();
        if (methodDecomposition.getOperatorsBeingExecuted() != null) {
            this.operatorsBeingExecuted = new ArrayList<MethodDecomposition>();
            this.operatorsBeingExecuted.addAll(methodDecomposition.getOperatorsBeingExecuted());
        }
    }

    public void restoreState(MethodDecomposition methodDecomposition) {
        methodDecomposition.setExecutionState(this.executionState);
        methodDecomposition.setOperatorExecutingState(this.operatorExecutingState);
        if (this.operatorsBeingExecuted == null) {
            methodDecomposition.setOperatorsBeingExecuted(null);
        } else {
            List<MethodDecomposition> list = methodDecomposition.getOperatorsBeingExecuted();
            if (list == null) {
                list = new ArrayList<MethodDecomposition>();
                methodDecomposition.setOperatorsBeingExecuted(list);
            }
            list.clear();
            list.addAll(this.operatorsBeingExecuted);
        }
    }
}

