/*
 * Decompiled with CFR 0.152.
 */
package ai.ahtn.visualization;

import ai.ahtn.domain.DomainDefinition;
import ai.ahtn.domain.HTNMethod;
import ai.ahtn.domain.MethodDecomposition;
import ai.ahtn.domain.Symbol;
import ai.ahtn.domain.Term;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import javax.imageio.ImageIO;

public class HTNDomainVisualizer {
    public static int DEBUG = 0;
    int hpadding = 8;
    int vpadding = 4;
    int hMethodPadding = 16;
    int vMethodPadding = 16;
    Font font = new Font("Arial", 0, 10);
    FontMetrics fm = null;

    public static void main(String[] stringArray) throws Exception {
        DomainDefinition domainDefinition = DomainDefinition.fromLispFile("ahtn/microrts-ahtn-definition-portfolio.lisp");
        System.out.println(domainDefinition);
        HTNDomainVisualizer hTNDomainVisualizer = new HTNDomainVisualizer();
        BufferedImage bufferedImage = hTNDomainVisualizer.visualizeHTNDomain(domainDefinition, new Symbol("destroy-player"));
        ImageIO.write((RenderedImage)bufferedImage, "png", new File("HTN-domain.png"));
    }

    public HTNDomainVisualizer() {
        Canvas canvas = new Canvas();
        this.fm = canvas.getFontMetrics(this.font);
    }

    public BufferedImage visualizeHTNDomain(DomainDefinition domainDefinition, Symbol symbol) throws Exception {
        LinkedList<Symbol> linkedList = new LinkedList<Symbol>();
        return this.visualizeHTNTask(domainDefinition, symbol, linkedList);
    }

    public BufferedImage visualizeHTNOperator(Symbol symbol) throws Exception {
        int n = this.fm.stringWidth(symbol.get());
        BufferedImage bufferedImage = new BufferedImage(this.hpadding * 2 + n, this.vpadding * 2 + this.fm.getHeight(), 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setFont(this.font);
        graphics2D.setColor(new Color(0, 127, 0));
        graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics2D.setColor(Color.WHITE);
        graphics2D.drawString(symbol.get(), this.hpadding, this.vpadding + this.fm.getHeight());
        return bufferedImage;
    }

    public BufferedImage visualizeHTNOperator(Term term) throws Exception {
        String string = term.toString();
        int n = this.fm.stringWidth(string);
        BufferedImage bufferedImage = new BufferedImage(this.hpadding * 2 + n, this.vpadding * 2 + this.fm.getHeight(), 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setFont(this.font);
        graphics2D.setColor(new Color(0, 127, 0));
        graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics2D.setColor(Color.WHITE);
        graphics2D.drawString(string, this.hpadding, this.vpadding + this.fm.getHeight());
        return bufferedImage;
    }

    public BufferedImage visualizeHTNTask(DomainDefinition domainDefinition, Symbol symbol, List<Symbol> list) throws Exception {
        Object object;
        if (list.contains(symbol)) {
            if (DEBUG >= 1) {
                System.out.println("visualizeHTNTask (already processed): " + symbol);
            }
            int n = this.fm.stringWidth(symbol.get());
            BufferedImage bufferedImage = new BufferedImage(this.hpadding * 2 + n, this.vpadding * 2 + this.fm.getHeight(), 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setFont(this.font);
            graphics2D.setColor(Color.RED);
            graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
            graphics2D.setColor(Color.WHITE);
            graphics2D.drawString(symbol.get(), this.hpadding, this.vpadding + this.fm.getHeight());
            return bufferedImage;
        }
        if (DEBUG >= 1) {
            System.out.println("visualizeHTNTask: " + symbol);
        }
        list.add(symbol);
        List<HTNMethod> list2 = domainDefinition.getMethodsForGoal(new Symbol(symbol));
        int n = this.fm.stringWidth(symbol.get());
        int n2 = 0;
        int n3 = 0;
        LinkedList<BufferedImage> linkedList = new LinkedList<BufferedImage>();
        for (HTNMethod object22 : list2) {
            object = this.visualizeHTNMethod(domainDefinition, object22, list);
            linkedList.add((BufferedImage)object);
            n2 += ((BufferedImage)object).getWidth();
            n3 = Math.max(n3, ((BufferedImage)object).getHeight());
        }
        int n4 = Math.max(n + 2 * this.hpadding, n2 += list2.size() * this.hMethodPadding);
        BufferedImage bufferedImage = new BufferedImage(n4, this.fm.getHeight() + 2 * this.vpadding + this.vMethodPadding + n3, 2);
        object = bufferedImage.createGraphics();
        ((Graphics)object).setFont(this.font);
        if (DEBUG >= 1) {
            System.out.println("  visualizeHTNTask img: " + bufferedImage.getWidth() + " x " + bufferedImage.getHeight() + " (methodHeight: " + n3 + ")");
        }
        int n5 = 0;
        for (BufferedImage bufferedImage2 : linkedList) {
            ((Graphics)object).setColor(Color.BLACK);
            ((Graphics)object).drawLine(n4 / 2, this.fm.getHeight() + this.vpadding * 2, n5 + bufferedImage2.getWidth() / 2, this.fm.getHeight() + this.vpadding * 2 + this.vMethodPadding);
            ((Graphics)object).drawImage(bufferedImage2, n5, this.fm.getHeight() + this.vpadding * 2 + this.vMethodPadding, null);
            n5 += bufferedImage2.getWidth() + this.hMethodPadding;
        }
        ((Graphics)object).setColor(Color.BLACK);
        ((Graphics)object).fillRect(n4 / 2 - (n + 2 * this.hpadding) / 2, 0, n + 2 * this.hpadding, this.fm.getHeight() + this.vpadding * 2);
        ((Graphics)object).setColor(Color.WHITE);
        ((Graphics2D)object).drawString(symbol.get(), n4 / 2 - (n + 2 * this.hpadding) / 2 + this.hpadding, this.vpadding + this.fm.getHeight());
        return bufferedImage;
    }

    public BufferedImage visualizeHTNMethod(DomainDefinition domainDefinition, HTNMethod hTNMethod, List<Symbol> list) throws Exception {
        Object object;
        LinkedList<Symbol> linkedList = new LinkedList<Symbol>();
        LinkedList<BufferedImage> linkedList2 = new LinkedList<BufferedImage>();
        if (DEBUG >= 1) {
            System.out.println("visualizeHTNMethod: " + hTNMethod.getName());
        }
        LinkedList<MethodDecomposition> linkedList3 = new LinkedList<MethodDecomposition>();
        linkedList3.add(hTNMethod.getDecomposition());
        block6: while (!linkedList3.isEmpty()) {
            MethodDecomposition methodDecomposition = (MethodDecomposition)linkedList3.remove(0);
            switch (methodDecomposition.getType()) {
                case 1: {
                    linkedList.add(methodDecomposition.getTerm().getFunctor());
                    break;
                }
                case 2: {
                    linkedList.add(methodDecomposition.getTerm().getFunctor());
                    break;
                }
                case 3: {
                    for (MethodDecomposition methodDecomposition2 : methodDecomposition.getSubparts()) {
                        linkedList3.add(methodDecomposition2);
                    }
                    continue block6;
                }
                case 4: {
                    for (MethodDecomposition methodDecomposition3 : methodDecomposition.getSubparts()) {
                        linkedList3.add(methodDecomposition3);
                    }
                    continue block6;
                }
            }
        }
        int n = this.fm.stringWidth(hTNMethod.getName());
        int n2 = 0;
        int n3 = 0;
        for (Symbol symbol : linkedList) {
            if (symbol.get().startsWith("!")) {
                object = this.visualizeHTNOperator(symbol);
                linkedList2.add((BufferedImage)object);
                n2 += ((BufferedImage)object).getWidth();
                n3 = Math.max(n3, ((BufferedImage)object).getHeight());
                continue;
            }
            object = this.visualizeHTNTask(domainDefinition, symbol, list);
            linkedList2.add((BufferedImage)object);
            n2 += ((BufferedImage)object).getWidth();
            n3 = Math.max(n3, ((BufferedImage)object).getHeight());
        }
        int n4 = Math.max(n + 2 * this.hpadding, n2 += linkedList.size() * this.hMethodPadding);
        BufferedImage bufferedImage = new BufferedImage(n4, this.fm.getHeight() + this.vpadding * 2 + this.vMethodPadding + n3, 2);
        object = bufferedImage.createGraphics();
        ((Graphics)object).setFont(this.font);
        if (DEBUG >= 1) {
            System.out.println("  visualizeHTNMethod img: " + bufferedImage.getWidth() + " x " + bufferedImage.getHeight());
        }
        int n5 = 0;
        for (BufferedImage bufferedImage2 : linkedList2) {
            ((Graphics)object).setColor(Color.BLACK);
            ((Graphics)object).drawLine(n4 / 2, this.fm.getHeight() + this.vpadding * 2, n5 + bufferedImage2.getWidth() / 2, this.fm.getHeight() + this.vpadding * 2 + this.vMethodPadding);
            ((Graphics)object).drawImage(bufferedImage2, n5, this.fm.getHeight() + this.vpadding * 2 + this.vMethodPadding, null);
            n5 += bufferedImage2.getWidth() + this.hMethodPadding;
        }
        ((Graphics)object).setColor(Color.GRAY);
        ((Graphics)object).fillRect(n4 / 2 - (n + 2 * this.hpadding) / 2, 0, n + 2 * this.hpadding, this.fm.getHeight() + this.vpadding * 2);
        ((Graphics)object).setColor(Color.BLACK);
        ((Graphics2D)object).drawString(hTNMethod.getName(), n4 / 2 - (n + 2 * this.hpadding) / 2 + this.hpadding, this.vpadding + this.fm.getHeight());
        return bufferedImage;
    }

    public BufferedImage visualizeHTNPlan(HTNMethod hTNMethod) throws Exception {
        Object object;
        LinkedList<Object> linkedList = new LinkedList<Object>();
        String string = hTNMethod.getHead().toString();
        String string2 = hTNMethod.getName();
        int n = Math.max(this.fm.stringWidth(string2), this.fm.stringWidth(string));
        int n2 = 0;
        int n3 = 0;
        if (DEBUG >= 1) {
            System.out.println("visualizeHTNPlan: " + string2);
        }
        LinkedList<Object> linkedList2 = new LinkedList<Object>();
        if (hTNMethod.getDecomposition() != null) {
            linkedList2.add(hTNMethod.getDecomposition());
        }
        block6: while (!linkedList2.isEmpty()) {
            MethodDecomposition methodDecomposition = (MethodDecomposition)linkedList2.remove(0);
            switch (methodDecomposition.getType()) {
                case 1: {
                    object = this.visualizeHTNOperator(methodDecomposition.getTerm());
                    linkedList.add(object);
                    n2 += ((BufferedImage)object).getWidth();
                    n3 = Math.max(n3, ((BufferedImage)object).getHeight());
                    break;
                }
                case 2: {
                    object = this.visualizeHTNPlan(methodDecomposition);
                    linkedList.add(object);
                    n2 += ((BufferedImage)object).getWidth();
                    n3 = Math.max(n3, ((BufferedImage)object).getHeight());
                    break;
                }
                case 3: {
                    for (MethodDecomposition methodDecomposition2 : methodDecomposition.getSubparts()) {
                        linkedList2.add(methodDecomposition2);
                    }
                    continue block6;
                }
                case 4: {
                    for (MethodDecomposition methodDecomposition3 : methodDecomposition.getSubparts()) {
                        linkedList2.add(methodDecomposition3);
                    }
                    continue block6;
                }
            }
        }
        int n4 = Math.max(n + 2 * this.hpadding, n2 += linkedList.size() * this.hMethodPadding);
        object = new BufferedImage(n4, (this.fm.getHeight() + this.vpadding * 2) * 2 + this.vMethodPadding + n3, 2);
        Graphics2D graphics2D = ((BufferedImage)object).createGraphics();
        graphics2D.setFont(this.font);
        if (DEBUG >= 1) {
            System.out.println("  visualizeHTNMethod img: " + ((BufferedImage)object).getWidth() + " x " + ((BufferedImage)object).getHeight());
        }
        int n5 = 0;
        for (BufferedImage bufferedImage : linkedList) {
            graphics2D.setColor(Color.BLACK);
            graphics2D.drawLine(n4 / 2, (this.fm.getHeight() + this.vpadding * 2) * 2, n5 + bufferedImage.getWidth() / 2, (this.fm.getHeight() + this.vpadding * 2) * 2 + this.vMethodPadding);
            graphics2D.drawImage((Image)bufferedImage, n5, (this.fm.getHeight() + this.vpadding * 2) * 2 + this.vMethodPadding, null);
            n5 += bufferedImage.getWidth() + this.hMethodPadding;
        }
        graphics2D.setColor(Color.GRAY);
        graphics2D.fillRect(n4 / 2 - (n + 2 * this.hpadding) / 2, 0, n + 2 * this.hpadding, this.fm.getHeight() + this.vpadding * 2);
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawString(string, n4 / 2 - (n + 2 * this.hpadding) / 2 + this.hpadding, this.vpadding + this.fm.getHeight());
        graphics2D.setColor(Color.BLACK);
        graphics2D.fillRect(n4 / 2 - (n + 2 * this.hpadding) / 2, this.fm.getHeight() + this.vpadding * 2, n + 2 * this.hpadding, this.fm.getHeight() + this.vpadding * 2);
        graphics2D.setColor(Color.WHITE);
        graphics2D.drawString(string2, n4 / 2 - (n + 2 * this.hpadding) / 2 + this.hpadding, this.fm.getHeight() + this.vpadding * 2 + this.vpadding + this.fm.getHeight());
        return object;
    }

    public BufferedImage visualizeHTNPlan(MethodDecomposition methodDecomposition) throws Exception {
        Object object;
        if (methodDecomposition.getType() == 2 && methodDecomposition.getMethod() != null) {
            return this.visualizeHTNPlan(methodDecomposition.getMethod());
        }
        LinkedList<Object> linkedList = new LinkedList<Object>();
        String string = "-";
        if (methodDecomposition.getTerm() != null) {
            string = methodDecomposition.getTerm().toString();
        }
        int n = this.fm.stringWidth(string);
        int n2 = 0;
        int n3 = 0;
        if (DEBUG >= 1) {
            System.out.println("visualizeHTNPlan: " + string);
        }
        LinkedList<Object> linkedList2 = new LinkedList<Object>();
        linkedList2.add(methodDecomposition);
        block6: while (!linkedList2.isEmpty()) {
            MethodDecomposition methodDecomposition2 = (MethodDecomposition)linkedList2.remove(0);
            switch (methodDecomposition2.getType()) {
                case 1: {
                    object = this.visualizeHTNOperator(methodDecomposition2.getTerm());
                    linkedList.add(object);
                    n2 += ((BufferedImage)object).getWidth();
                    n3 = Math.max(n3, ((BufferedImage)object).getHeight());
                    break;
                }
                case 2: {
                    if (methodDecomposition2.getMethod() != null) {
                        object = this.visualizeHTNPlan(methodDecomposition2.getMethod());
                        linkedList.add(object);
                        n2 += ((BufferedImage)object).getWidth();
                        n3 = Math.max(n3, ((BufferedImage)object).getHeight());
                        break;
                    }
                    if (methodDecomposition2 == methodDecomposition) break;
                    object = this.visualizeHTNPlan(methodDecomposition2);
                    linkedList.add(object);
                    n2 += ((BufferedImage)object).getWidth();
                    n3 = Math.max(n3, ((BufferedImage)object).getHeight());
                    break;
                }
                case 3: {
                    for (MethodDecomposition methodDecomposition3 : methodDecomposition2.getSubparts()) {
                        linkedList2.add(methodDecomposition3);
                    }
                    continue block6;
                }
                case 4: {
                    for (MethodDecomposition methodDecomposition4 : methodDecomposition2.getSubparts()) {
                        linkedList2.add(methodDecomposition4);
                    }
                    continue block6;
                }
            }
        }
        int n4 = Math.max(n + 2 * this.hpadding, n2 += linkedList.size() * this.hMethodPadding);
        object = new BufferedImage(n4, this.fm.getHeight() + this.vpadding * 2 + this.vMethodPadding + n3, 2);
        Graphics2D graphics2D = ((BufferedImage)object).createGraphics();
        graphics2D.setFont(this.font);
        if (DEBUG >= 1) {
            System.out.println("  visualizeHTNMethod img: " + ((BufferedImage)object).getWidth() + " x " + ((BufferedImage)object).getHeight());
        }
        int n5 = 0;
        for (BufferedImage bufferedImage : linkedList) {
            graphics2D.setColor(Color.BLACK);
            graphics2D.drawLine(n4 / 2, this.fm.getHeight() + this.vpadding * 2, n5 + bufferedImage.getWidth() / 2, this.fm.getHeight() + this.vpadding * 2 + this.vMethodPadding);
            graphics2D.drawImage((Image)bufferedImage, n5, this.fm.getHeight() + this.vpadding * 2 + this.vMethodPadding, null);
            n5 += bufferedImage.getWidth() + this.hMethodPadding;
        }
        graphics2D.setColor(Color.GRAY);
        graphics2D.fillRect(n4 / 2 - (n + 2 * this.hpadding) / 2, 0, n + 2 * this.hpadding, this.fm.getHeight() + this.vpadding * 2);
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawString(string, n4 / 2 - (n + 2 * this.hpadding) / 2 + this.hpadding, this.vpadding + this.fm.getHeight());
        return object;
    }
}

