/*
 * Decompiled with CFR 0.152.
 */
package ai.ahtn.visualization;

import ai.ahtn.domain.DomainDefinition;
import ai.ahtn.domain.HTNMethod;
import ai.ahtn.domain.MethodDecomposition;
import ai.ahtn.domain.Symbol;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import javax.imageio.ImageIO;

public class HTNDomainVisualizerVertical {
    int hpadding = 8;
    int vpadding = 4;
    int hMethodPadding = 32;
    int vMethodPadding = 8;
    Font font = new Font("Arial", 0, 16);
    FontMetrics fm = null;

    public static void main(String[] stringArray) throws Exception {
        DomainDefinition domainDefinition = DomainDefinition.fromLispFile("ahtn/microrts-ahtn-definition-lowest-level.lisp");
        HTNDomainVisualizerVertical hTNDomainVisualizerVertical = new HTNDomainVisualizerVertical();
        BufferedImage bufferedImage = hTNDomainVisualizerVertical.visualizeHTNDomain(domainDefinition, new Symbol("destroy-player"));
        ImageIO.write((RenderedImage)bufferedImage, "png", new File("HTN-domain-lowest-level.png"));
        domainDefinition = DomainDefinition.fromLispFile("ahtn/microrts-ahtn-definition-low-level.lisp");
        hTNDomainVisualizerVertical = new HTNDomainVisualizerVertical();
        bufferedImage = hTNDomainVisualizerVertical.visualizeHTNDomain(domainDefinition, new Symbol("destroy-player"));
        ImageIO.write((RenderedImage)bufferedImage, "png", new File("HTN-domain-low-level.png"));
        domainDefinition = DomainDefinition.fromLispFile("ahtn/microrts-ahtn-definition-portfolio.lisp");
        hTNDomainVisualizerVertical = new HTNDomainVisualizerVertical();
        bufferedImage = hTNDomainVisualizerVertical.visualizeHTNDomain(domainDefinition, new Symbol("destroy-player"));
        ImageIO.write((RenderedImage)bufferedImage, "png", new File("HTN-domain-portfolio.png"));
        domainDefinition = DomainDefinition.fromLispFile("ahtn/microrts-ahtn-definition-flexible-portfolio.lisp");
        hTNDomainVisualizerVertical = new HTNDomainVisualizerVertical();
        bufferedImage = hTNDomainVisualizerVertical.visualizeHTNDomain(domainDefinition, new Symbol("destroy-player"));
        ImageIO.write((RenderedImage)bufferedImage, "png", new File("HTN-domain-flexible-portfolio.png"));
        domainDefinition = DomainDefinition.fromLispFile("ahtn/microrts-ahtn-definition-flexible-single-target-portfolio.lisp");
        hTNDomainVisualizerVertical = new HTNDomainVisualizerVertical();
        bufferedImage = hTNDomainVisualizerVertical.visualizeHTNDomain(domainDefinition, new Symbol("destroy-player"));
        ImageIO.write((RenderedImage)bufferedImage, "png", new File("HTN-domain-flexible-single-target-portfolio.png"));
    }

    public HTNDomainVisualizerVertical() {
        Canvas canvas = new Canvas();
        this.fm = canvas.getFontMetrics(this.font);
    }

    public BufferedImage visualizeHTNDomain(DomainDefinition domainDefinition, Symbol symbol) throws Exception {
        LinkedList<Symbol> linkedList = new LinkedList<Symbol>();
        return this.visualizeHTNTask(domainDefinition, symbol, linkedList);
    }

    public BufferedImage visualizeHTNOperator(Symbol symbol) throws Exception {
        int n = this.fm.stringWidth(symbol.get());
        BufferedImage bufferedImage = new BufferedImage(this.hpadding * 2 + n, this.vpadding * 2 + this.fm.getHeight(), 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setFont(this.font);
        graphics2D.setColor(new Color(0, 127, 0));
        graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics2D.setColor(Color.WHITE);
        graphics2D.drawString(symbol.get(), this.hpadding, this.vpadding + this.fm.getHeight() - 2);
        return bufferedImage;
    }

    public BufferedImage visualizeHTNTask(DomainDefinition domainDefinition, Symbol symbol, List<Symbol> list) throws Exception {
        BufferedImage bufferedImage;
        if (list.contains(symbol)) {
            System.out.println("visualizeHTNTask (already processed): " + symbol);
            int n = this.fm.stringWidth(symbol.get());
            BufferedImage bufferedImage2 = new BufferedImage(this.hpadding * 2 + n, this.vpadding * 2 + this.fm.getHeight(), 2);
            Graphics2D graphics2D = bufferedImage2.createGraphics();
            graphics2D.setFont(this.font);
            graphics2D.setColor(Color.RED);
            graphics2D.fillRect(0, 0, bufferedImage2.getWidth(), bufferedImage2.getHeight());
            graphics2D.setColor(Color.WHITE);
            graphics2D.drawString(symbol.get(), this.hpadding, this.vpadding + this.fm.getHeight() - 2);
            return bufferedImage2;
        }
        System.out.println("visualizeHTNTask: " + symbol);
        list.add(symbol);
        List<HTNMethod> list2 = domainDefinition.getMethodsForGoal(new Symbol(symbol));
        int n = this.fm.stringWidth(symbol.get());
        int n2 = 0;
        int n3 = 0;
        LinkedList<BufferedImage> linkedList = new LinkedList<BufferedImage>();
        for (HTNMethod hTNMethod : list2) {
            bufferedImage = this.visualizeHTNMethod(domainDefinition, hTNMethod, list);
            linkedList.add(bufferedImage);
            n2 = Math.max(n2, bufferedImage.getWidth());
            n3 += bufferedImage.getHeight();
        }
        int n4 = n + 2 * this.hpadding + this.hMethodPadding + n2;
        int n5 = Math.max(this.fm.getHeight() + 2 * this.vpadding, n3 += (list2.size() - 1) * this.vMethodPadding);
        bufferedImage = new BufferedImage(n4, n5, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setFont(this.font);
        System.out.println("  visualizeHTNTask img: " + bufferedImage.getWidth() + " x " + bufferedImage.getHeight() + " (methodHeight: " + n3 + ")");
        int n6 = 0;
        for (BufferedImage bufferedImage3 : linkedList) {
            graphics2D.setColor(Color.BLACK);
            graphics2D.drawLine(n + 2 * this.hpadding, n5 / 2, n + 2 * this.hpadding + this.hMethodPadding, n6 + bufferedImage3.getHeight() / 2);
            System.out.println("  drawing image at: " + (n + 2 * this.hpadding + this.hMethodPadding) + ", " + n6);
            graphics2D.drawImage((Image)bufferedImage3, n + 2 * this.hpadding + this.hMethodPadding, n6, null);
            n6 += bufferedImage3.getHeight() + this.vMethodPadding;
        }
        graphics2D.setColor(Color.BLACK);
        graphics2D.fillRect(0, n5 / 2 - (this.fm.getHeight() + 2 * this.vpadding) / 2, n + 2 * this.hpadding, this.fm.getHeight() + this.vpadding * 2);
        graphics2D.setColor(Color.WHITE);
        graphics2D.drawString(symbol.get(), this.hpadding, n5 / 2 - (this.fm.getHeight() + 2 * this.vpadding) / 2 + this.fm.getHeight() + this.vpadding - 2);
        return bufferedImage;
    }

    public BufferedImage visualizeHTNMethod(DomainDefinition domainDefinition, HTNMethod hTNMethod, List<Symbol> list) throws Exception {
        BufferedImage bufferedImage;
        LinkedList<Symbol> linkedList = new LinkedList<Symbol>();
        LinkedList<BufferedImage> linkedList2 = new LinkedList<BufferedImage>();
        System.out.println("visualizeHTNMethod: " + hTNMethod.getName());
        LinkedList<MethodDecomposition> linkedList3 = new LinkedList<MethodDecomposition>();
        linkedList3.add(hTNMethod.getDecomposition());
        block6: while (!linkedList3.isEmpty()) {
            MethodDecomposition methodDecomposition = (MethodDecomposition)linkedList3.remove(0);
            switch (methodDecomposition.getType()) {
                case 1: {
                    linkedList.add(methodDecomposition.getTerm().getFunctor());
                    break;
                }
                case 2: {
                    linkedList.add(methodDecomposition.getTerm().getFunctor());
                    break;
                }
                case 3: {
                    for (MethodDecomposition n5 : methodDecomposition.getSubparts()) {
                        linkedList3.add(n5);
                    }
                    continue block6;
                }
                case 4: {
                    for (MethodDecomposition methodDecomposition2 : methodDecomposition.getSubparts()) {
                        linkedList3.add(methodDecomposition2);
                    }
                    continue block6;
                }
            }
        }
        int n = this.fm.stringWidth(hTNMethod.getName());
        int n2 = 0;
        int n3 = 0;
        for (Symbol symbol : linkedList) {
            if (symbol.get().startsWith("!")) {
                bufferedImage = this.visualizeHTNOperator(symbol);
                linkedList2.add(bufferedImage);
                n2 = Math.max(n2, bufferedImage.getWidth());
                n3 += bufferedImage.getHeight();
                continue;
            }
            bufferedImage = this.visualizeHTNTask(domainDefinition, symbol, list);
            linkedList2.add(bufferedImage);
            n2 = Math.max(n2, bufferedImage.getWidth());
            n3 += bufferedImage.getHeight();
        }
        int n4 = n + 2 * this.hpadding + this.hMethodPadding + n2;
        int n5 = Math.max(this.fm.getHeight() + 2 * this.vpadding, n3 += (linkedList.size() - 1) * this.vMethodPadding);
        bufferedImage = new BufferedImage(n4, n5, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setFont(this.font);
        System.out.println("  visualizeHTNMethod img: " + bufferedImage.getWidth() + " x " + bufferedImage.getHeight());
        int n6 = 0;
        for (BufferedImage bufferedImage2 : linkedList2) {
            graphics2D.setColor(Color.BLACK);
            graphics2D.drawLine(n + 2 * this.hpadding, n5 / 2, n + 2 * this.hpadding + this.hMethodPadding, n6 + bufferedImage2.getHeight() / 2);
            graphics2D.drawImage((Image)bufferedImage2, n + 2 * this.hpadding + this.hMethodPadding, n6, null);
            n6 += bufferedImage2.getHeight() + this.vMethodPadding;
        }
        graphics2D.setColor(Color.LIGHT_GRAY);
        graphics2D.fillRect(0, n5 / 2 - (this.fm.getHeight() + 2 * this.vpadding) / 2, n + 2 * this.hpadding, this.fm.getHeight() + this.vpadding * 2);
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawString(hTNMethod.getName(), this.hpadding, n5 / 2 - (this.fm.getHeight() + 2 * this.vpadding) / 2 + this.fm.getHeight() + this.vpadding - 2);
        return bufferedImage;
    }

    /*
     * WARNING - void declaration
     */
    public BufferedImage visualizeHTNPlan(HTNMethod hTNMethod) throws Exception {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        String string = hTNMethod.getName();
        int n = this.fm.stringWidth(string);
        int n2 = 0;
        int n3 = 0;
        System.out.println("visualizeHTNPlan: " + string);
        LinkedList<Object> linkedList2 = new LinkedList<Object>();
        linkedList2.add(hTNMethod.getDecomposition());
        block6: while (!linkedList2.isEmpty()) {
            MethodDecomposition methodDecomposition = (MethodDecomposition)linkedList2.remove(0);
            switch (methodDecomposition.getType()) {
                case 1: {
                    Object object = this.visualizeHTNOperator(methodDecomposition.getTerm().getFunctor());
                    linkedList.add(object);
                    n2 = Math.max(n2, ((BufferedImage)object).getWidth());
                    n3 += ((BufferedImage)object).getHeight();
                    break;
                }
                case 2: {
                    if (methodDecomposition.getMethod() == null) break;
                    Object object = this.visualizeHTNPlan(methodDecomposition.getMethod());
                    linkedList.add(object);
                    n2 = Math.max(n2, ((BufferedImage)object).getWidth());
                    n3 += ((BufferedImage)object).getHeight();
                    break;
                }
                case 3: {
                    for (MethodDecomposition n6 : methodDecomposition.getSubparts()) {
                        linkedList2.add(n6);
                    }
                    continue block6;
                }
                case 4: {
                    for (MethodDecomposition methodDecomposition2 : methodDecomposition.getSubparts()) {
                        linkedList2.add(methodDecomposition2);
                    }
                    continue block6;
                }
            }
        }
        int n4 = n + 2 * this.hpadding + this.hMethodPadding + n2;
        int n5 = Math.max(this.fm.getHeight() + 2 * this.vpadding, n3 += (linkedList.size() - 1) * this.vMethodPadding);
        BufferedImage bufferedImage = new BufferedImage(n4, n5, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setFont(this.font);
        System.out.println("  visualizeHTNPlan img: " + bufferedImage.getWidth() + " x " + bufferedImage.getHeight());
        boolean bl = false;
        for (BufferedImage bufferedImage2 : linkedList) {
            void var12_20;
            graphics2D.setColor(Color.BLACK);
            graphics2D.drawLine(n + 2 * this.hpadding, n5 / 2, n + 2 * this.hpadding + this.hMethodPadding, (int)(var12_20 + bufferedImage2.getHeight() / 2));
            graphics2D.drawImage((Image)bufferedImage2, n + 2 * this.hpadding + this.hMethodPadding, (int)var12_20, null);
            var12_20 += bufferedImage2.getHeight() + this.vMethodPadding;
        }
        graphics2D.setColor(Color.LIGHT_GRAY);
        graphics2D.fillRect(0, n5 / 2 - (this.fm.getHeight() + 2 * this.vpadding) / 2, n + 2 * this.hpadding, this.fm.getHeight() + this.vpadding * 2);
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawString(string, this.hpadding, n5 / 2 - (this.fm.getHeight() + 2 * this.vpadding) / 2 + this.fm.getHeight() + this.vpadding - 2);
        return bufferedImage;
    }

    /*
     * WARNING - void declaration
     */
    public BufferedImage visualizeHTNPlan(MethodDecomposition methodDecomposition) throws Exception {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        String string = "-";
        if (methodDecomposition.getTerm() != null) {
            string = methodDecomposition.getTerm().toString();
        }
        int n = this.fm.stringWidth(string);
        int n2 = 0;
        int n3 = 0;
        System.out.println("visualizeHTNPlan: " + string);
        LinkedList<Object> linkedList2 = new LinkedList<Object>();
        linkedList2.add(methodDecomposition);
        block6: while (!linkedList2.isEmpty()) {
            MethodDecomposition methodDecomposition2 = (MethodDecomposition)linkedList2.remove(0);
            switch (methodDecomposition2.getType()) {
                case 1: {
                    Object object = this.visualizeHTNOperator(methodDecomposition2.getTerm().getFunctor());
                    linkedList.add(object);
                    n2 = Math.max(n2, ((BufferedImage)object).getWidth());
                    n3 += ((BufferedImage)object).getHeight();
                    break;
                }
                case 2: {
                    if (methodDecomposition2.getMethod() == null) break;
                    Object object = this.visualizeHTNPlan(methodDecomposition2.getMethod());
                    linkedList.add(object);
                    n2 = Math.max(n2, ((BufferedImage)object).getWidth());
                    n3 += ((BufferedImage)object).getHeight();
                    break;
                }
                case 3: {
                    for (MethodDecomposition n6 : methodDecomposition2.getSubparts()) {
                        linkedList2.add(n6);
                    }
                    continue block6;
                }
                case 4: {
                    for (MethodDecomposition methodDecomposition3 : methodDecomposition2.getSubparts()) {
                        linkedList2.add(methodDecomposition3);
                    }
                    continue block6;
                }
            }
        }
        int n4 = n + 2 * this.hpadding + this.hMethodPadding + n2;
        int n5 = Math.max(this.fm.getHeight() + 2 * this.vpadding, n3 += (linkedList.size() - 1) * this.vMethodPadding);
        BufferedImage bufferedImage = new BufferedImage(n4, n5, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setFont(this.font);
        System.out.println("  visualizeHTNPlan img: " + bufferedImage.getWidth() + " x " + bufferedImage.getHeight());
        boolean bl = false;
        for (BufferedImage bufferedImage2 : linkedList) {
            void var12_20;
            graphics2D.setColor(Color.BLACK);
            graphics2D.drawLine(n + 2 * this.hpadding, n5 / 2, n + 2 * this.hpadding + this.hMethodPadding, (int)(var12_20 + bufferedImage2.getHeight() / 2));
            graphics2D.drawImage((Image)bufferedImage2, n + 2 * this.hpadding + this.hMethodPadding, (int)var12_20, null);
            var12_20 += bufferedImage2.getHeight() + this.vMethodPadding;
        }
        graphics2D.setColor(Color.LIGHT_GRAY);
        graphics2D.fillRect(0, n5 / 2 - (this.fm.getHeight() + 2 * this.vpadding) / 2, n + 2 * this.hpadding, this.fm.getHeight() + this.vpadding * 2);
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawString(string, this.hpadding, n5 / 2 - (this.fm.getHeight() + 2 * this.vpadding) / 2 + this.fm.getHeight() + this.vpadding - 2);
        return bufferedImage;
    }
}

